/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui;

import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBasePanel;
import hgb.lib.HGBaseSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class ProgressPanel
extends HGBasePanel {
    private static final long serialVersionUID = 424781078L;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_WAITING = 1;
    public static final int STATE_FINISHED = 2;
    protected Color colorFinish;
    protected Color colorNormal;
    protected ImageIcon imgProgress = null;
    private int numWaiting = -1;
    private int actState = 0;

    public ProgressPanel() {
        this(150);
    }

    protected ProgressPanel(int progressTimer) {
        super(new BorderLayout());
        this.loadColorsAndImages();
        if (progressTimer > 0) {
            Timer timer = new Timer(progressTimer, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (ProgressPanel.this.actState == 1) {
                        ProgressPanel progressPanel = ProgressPanel.this;
                        progressPanel.numWaiting = progressPanel.numWaiting + 1;
                        if (ProgressPanel.this.numWaiting > 100000) {
                            ProgressPanel.this.numWaiting = 0;
                        }
                    }
                    ProgressPanel.this.repaint();
                }
            });
            timer.start();
        }
    }

    protected void loadColorsAndImages() {
        int colF = HGBaseSettings.getInt("progressColorFinished");
        int colN = HGBaseSettings.getInt("progressColorNormal");
        this.colorFinish = colF == -2147483631 ? new Color(100, 250, 100) : new Color(colF);
        this.colorNormal = colN == -2147483631 ? new JTextField().getBackground() : new Color(colN);
        this.setBackground(this.colorNormal);
        this.imgProgress = HGBaseGuiTools.loadImage(HGBaseSettings.get("progressImage"));
    }

    public void setState(int connState) {
        if (connState != this.actState) {
            this.actState = connState;
            this.repaint();
        }
    }

    public void actualizeLaf(String laf) {
        try {
            UIManager.setLookAndFeel(laf);
            SwingUtilities.updateComponentTreeUI(this);
            this.colorNormal = new JTextField().getBackground();
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getState() {
        return this.actState;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.actState == 2) {
            this.setBackground(this.colorFinish);
        } else {
            this.setBackground(this.colorNormal);
        }
        if (this.actState == 1) {
            int pnW = this.getWidth();
            int pnH = this.getHeight();
            if (this.numWaiting >= 0) {
                int imgW = this.imgProgress != null ? this.imgProgress.getIconWidth() : this.getWidth() / 3;
                int imgMove = imgW / 3;
                int num = Math.max((pnW + imgMove) / imgMove, 1);
                int xPos = this.numWaiting % num;
                if (this.imgProgress != null) {
                    g.drawImage(this.imgProgress.getImage(), 1 + imgMove * xPos, 1, imgW, pnH - 2, this.imgProgress.getImageObserver());
                } else {
                    g.setColor(this.colorFinish);
                    g.fillRect(1 + imgMove * xPos, 1, imgW, pnH - 2);
                }
            }
        }
    }
}

