/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.config;

import hgb.gui.config.HGBaseConfigItem;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class HGBaseConfigColorChooser
extends JPanel
implements HGBaseConfigItem {
    private static final long serialVersionUID = 7048983930527785426L;
    private JButton btColor;
    private JLabel lbColor;
    private String configOption;
    private Color defaultColor;
    private Color lastColor;
    private List<ActionListener> actionListeners = new LinkedList<ActionListener>();

    public HGBaseConfigColorChooser(String option, Color color) {
        this(option, color, "...");
    }

    public HGBaseConfigColorChooser(String option, Color color, int colorFieldPreferredWith) {
        this(option, color, "...", null, colorFieldPreferredWith);
    }

    public HGBaseConfigColorChooser(String option, Color color, String btLabel) {
        this(option, color, btLabel, null);
    }

    public HGBaseConfigColorChooser(String option, Color color, Icon btIcon) {
        this(option, color, null, btIcon);
    }

    private HGBaseConfigColorChooser(String option, Color color, String btLabel, Icon btIcon) {
        this(option, color, btLabel, btIcon, -1);
    }

    private HGBaseConfigColorChooser(String option, Color color, String btLabel, Icon btIcon, int colorFieldPreferredWith) {
        super(new BorderLayout());
        this.btColor = btLabel != null ? new JButton(btLabel) : new JButton(btIcon);
        this.lbColor = new JLabel("");
        Color borderColor = this.getBackground().darker();
        this.lbColor.setBorder(new LineBorder(borderColor, 1));
        this.lbColor.setOpaque(true);
        if (colorFieldPreferredWith >= 0) {
            this.lbColor.setPreferredSize(new Dimension(colorFieldPreferredWith, this.lbColor.getPreferredSize().height));
        }
        JPanel pnDummy = new JPanel(new BorderLayout());
        pnDummy.add((Component)this.lbColor, "Center");
        pnDummy.add((Component)new JLabel(" "), "East");
        this.add((Component)pnDummy, "Center");
        this.add((Component)this.btColor, "East");
        this.initConfigColorChooser(option, color);
    }

    private void initConfigColorChooser(String option, Color color) {
        this.configOption = option;
        this.defaultColor = color;
        this.setValue(HGBaseConfig.get(this.getOption()));
        if (this.lastColor == null) {
            this.setColor(this.defaultColor);
        }
        this.btColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Color initColor = HGBaseConfigColorChooser.this.defaultColor == null ? HGBaseConfigColorChooser.this.getColor() : HGBaseConfigColorChooser.this.defaultColor;
                String title = HGBaseText.existsText("dlg.choosecolor") ? HGBaseText.getText("dlg.choosecolor", new String[0]) : HGBaseSettings.get("appName");
                Color color = JColorChooser.showDialog(HGBaseConfigColorChooser.this.getParent(), title, initColor);
                if (color != null) {
                    HGBaseConfigColorChooser.this.setColor(color);
                    for (ActionListener al : HGBaseConfigColorChooser.this.actionListeners) {
                        ev.setSource(HGBaseConfigColorChooser.this);
                        al.actionPerformed(ev);
                    }
                }
            }
        });
    }

    @Override
    public String getOption() {
        return this.configOption;
    }

    @Override
    public String getValue() {
        Color c = this.getColor();
        return String.valueOf(c.getRGB());
    }

    protected Color getDefaultColor() {
        return this.defaultColor == null ? Color.BLACK : this.defaultColor;
    }

    public Color getColor() {
        return this.getColor(true);
    }

    public Color getColor(boolean useDefaultColor) {
        return !useDefaultColor ? this.lastColor : (this.lastColor == null ? this.getDefaultColor() : this.lastColor);
    }

    @Override
    public void setValue(String value) {
        int rgb = HGBaseTools.toInt(value);
        if (rgb != -2147483631) {
            this.setColor(new Color(rgb));
        }
    }

    public void setColor(Color c) {
        if (this.lbColor != null) {
            this.lbColor.setBackground(c);
        }
        this.lastColor = c;
    }

    @Override
    public void saveOption() {
        if (this.isEnabled()) {
            HGBaseConfig.set(this.getOption(), this.getValue());
        }
    }

    public JButton getButton() {
        return this.btColor;
    }

    public JLabel getLabel() {
        return this.lbColor;
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (this.btColor != null) {
            this.btColor.setEnabled(enable);
        }
        if (this.lbColor != null) {
            this.lbColor.setEnabled(enable);
        }
    }
}

