/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.config;

import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBaseItem;
import hgb.gui.config.HGBaseConfigItem;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import java.awt.Dimension;
import javax.swing.JComboBox;

public class HGBaseConfigComboBox<T>
extends JComboBox<T>
implements HGBaseConfigItem {
    private static final long serialVersionUID = 424781080L;
    private String itemId;
    private String itemOption;

    public HGBaseConfigComboBox(String option, JComboBox<T> box) {
        this(option, box, "");
    }

    public HGBaseConfigComboBox(String option, JComboBox<T> box, String defaultValue) {
        this("", option, box, defaultValue);
    }

    public HGBaseConfigComboBox(String id, String option, JComboBox<T> box) {
        this(id, option, box, "");
    }

    public HGBaseConfigComboBox(String id, String option, JComboBox<T> box, String defaultValue) {
        this.itemId = id;
        this.itemOption = option;
        int i = 0;
        while (i < box.getItemCount()) {
            T value = box.getItemAt(i);
            this.addItem(value);
            ++i;
        }
        int height = (int)box.getPreferredSize().getHeight();
        if (height == 25) {
            height = HGBaseGuiTools.getFieldHeight();
        }
        int width = (int)box.getPreferredSize().getWidth();
        this.setPreferredSize(new Dimension(width, height));
        this.setMaximumSize(new Dimension(width, height));
        this.setValue(HGBaseConfig.get(this.getOption(), defaultValue));
    }

    public String getId() {
        return this.itemId;
    }

    @Override
    public String getOption() {
        return this.itemOption;
    }

    @Override
    public String getValue() {
        Object select = this.getItemAt(this.getSelectedIndex());
        if (select instanceof HGBaseItem) {
            return ((HGBaseItem)select).getId();
        }
        return HGBaseTools.toString(select);
    }

    @Override
    public void setValue(String value) {
        try {
            String valueToSet = value;
            boolean found = false;
            int i = 0;
            while (i < this.getItemCount() && !found) {
                String comboValue = this.getItemAt(i).toString();
                if (this.getItemAt(i) instanceof HGBaseItem && HGBaseText.existsText(value)) {
                    valueToSet = HGBaseText.getText(value, new String[0]);
                }
                if (comboValue.equals(valueToSet)) {
                    this.setSelectedIndex(i);
                    found = true;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void saveOption() {
        if (this.isEnabled()) {
            HGBaseConfig.set(this.getOption(), this.getValue());
        }
    }
}

