/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.config;

import hgb.gui.config.HGBaseConfigItem;
import hgb.lib.HGBaseConfig;
import javax.swing.DefaultListModel;
import javax.swing.JList;

public class HGBaseConfigList
extends JList
implements HGBaseConfigItem {
    private static final long serialVersionUID = 8376197805463503824L;
    public static final String RECORD_SEPARATOR = Character.toString('\u001e');
    private String itemOption;

    public HGBaseConfigList(String option) {
        super(new DefaultListModel());
        this.setSelectionMode(0);
        this.itemOption = option;
        this.loadOption();
    }

    @Override
    public String getOption() {
        return this.itemOption;
    }

    @Override
    public String getValue() {
        DefaultListModel model = this.getListModel();
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        while (index < model.getSize()) {
            if (!buffer.toString().isEmpty()) {
                buffer.append(RECORD_SEPARATOR);
            }
            buffer.append(model.get(index));
            ++index;
        }
        return buffer.toString();
    }

    @Override
    public void setValue(String value) {
        DefaultListModel model = this.getListModel();
        model.clear();
        if (value != null) {
            String[] records = value.split(RECORD_SEPARATOR);
            int index = 0;
            while (index < records.length) {
                model.addElement(records[index]);
                ++index;
            }
        }
    }

    @Override
    public void saveOption() {
        if (this.isEnabled()) {
            DefaultListModel model = this.getListModel();
            String option = this.getOption();
            int records = model.getSize();
            HGBaseConfig.set(option, records);
            int index = 0;
            while (index < records) {
                HGBaseConfig.set(option + index, model.get(index).toString());
                ++index;
            }
        }
    }

    protected void loadOption() {
        DefaultListModel model = this.getListModel();
        String option = this.getOption();
        int records = HGBaseConfig.getInt(option, 0);
        model.clear();
        int index = 0;
        while (index < records) {
            model.addElement(HGBaseConfig.get(option + index));
            ++index;
        }
    }

    protected DefaultListModel getListModel() {
        return (DefaultListModel)this.getModel();
    }
}

