/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.config;

import hgb.gui.HGBaseItem;
import hgb.gui.config.HGBaseConfigItem;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseTools;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;

public class HGBaseConfigRadioGroup
extends ButtonGroup
implements HGBaseConfigItem {
    private static final long serialVersionUID = 424781082L;
    private String menuOption;

    public HGBaseConfigRadioGroup(String option, AbstractButton[] radioButtonList) {
        this(option, radioButtonList, null);
    }

    public HGBaseConfigRadioGroup(String option, AbstractButton[] radioButtonList, String defaultValue) {
        this.menuOption = option;
        if (radioButtonList != null) {
            int i = 0;
            while (i < radioButtonList.length) {
                this.add(radioButtonList[i]);
                if (i == 0) {
                    radioButtonList[i].setSelected(true);
                    radioButtonList[i].putClientProperty("HGBaseConfigItem", this);
                }
                ++i;
            }
        }
        this.setValue(HGBaseConfig.get(this.getOption(), defaultValue));
    }

    @Override
    public String getOption() {
        return this.menuOption;
    }

    @Override
    public String getValue() {
        Enumeration<AbstractButton> e = this.getElements();
        int i = 0;
        while (e.hasMoreElements()) {
            AbstractButton m = e.nextElement();
            if (m.isSelected()) {
                if (m instanceof HGBaseItem) {
                    return ((HGBaseItem)((Object)m)).getId();
                }
                return String.valueOf(i);
            }
            ++i;
        }
        return "";
    }

    @Override
    public void setValue(String value) {
        boolean isSet = false;
        if (value != null) {
            Enumeration<AbstractButton> e = this.getElements();
            int i = 0;
            int v = HGBaseTools.toInt(value);
            while (e.hasMoreElements() && !isSet) {
                AbstractButton m = e.nextElement();
                if (v != -2147483631) {
                    if (i == v) {
                        isSet = true;
                    }
                } else if (m instanceof HGBaseItem && value.equals(((HGBaseItem)((Object)m)).getId())) {
                    isSet = true;
                }
                if (isSet) {
                    m.setSelected(true);
                }
                ++i;
            }
        }
    }

    @Override
    public void saveOption() {
        if (this.getSelection().isEnabled()) {
            HGBaseConfig.set(this.getOption(), this.getValue());
        }
    }
}

