/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.config;

import hgb.gui.NumberSelector;
import hgb.gui.config.HGBaseConfigItem;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseTools;
import javax.swing.JSlider;

public class HGBaseConfigSlider
extends NumberSelector
implements HGBaseConfigItem {
    private static final long serialVersionUID = -1997080866650800275L;
    private String itemOption;

    public HGBaseConfigSlider(String option) {
        this(option, null);
    }

    public HGBaseConfigSlider(String option, int min, int max) {
        this(option, min, max, -2147483631);
    }

    public HGBaseConfigSlider(String option, int min, int max, int defaultValue) {
        this(option, null, min, max, defaultValue);
    }

    public HGBaseConfigSlider(String option, JSlider slider) {
        this(option, slider, -2147483631);
    }

    public HGBaseConfigSlider(String option, JSlider slider, int defaultValue) {
        this(option, slider, 0, 0, defaultValue);
    }

    private HGBaseConfigSlider(String option, JSlider slider, int min, int max, int defaultValue) {
        super(slider);
        this.itemOption = option;
        if (slider == null) {
            this.getSlider().setMinimum(min);
            this.getSlider().setMaximum(max);
            this.updateLabelSizeByMaximum();
        }
        String defaultString = HGBaseTools.isValid(defaultValue) ? String.valueOf(defaultValue) : "";
        this.setValue(HGBaseConfig.get(this.getOption(), defaultString));
    }

    @Override
    public String getOption() {
        return this.itemOption;
    }

    @Override
    public String getValue() {
        return String.valueOf(this.getSelectedValue());
    }

    public int intValue() {
        return this.getSelectedValue();
    }

    @Override
    public void setValue(String value) {
        this.setValue(HGBaseTools.toInt(value));
    }

    public void setValue(int value) {
        JSlider slider = this.getSlider();
        if (value >= slider.getMinimum() && value <= slider.getMaximum()) {
            slider.setValue(value);
        }
    }

    @Override
    public void saveOption() {
        if (this.isEnabled()) {
            HGBaseConfig.set(this.getOption(), this.getValue());
        }
    }
}

