/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.config;

import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.config.HGBaseConfigDialog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseTools;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class HGBaseConfigStateDialog
extends HGBaseConfigDialog
implements CaretListener,
ActionListener,
ListSelectionListener,
TableModelListener,
PropertyChangeListener {
    public static final int MSG_NONE = 1;
    public static final int MSG_INFO = 1;
    public static final int MSG_WARN = 2;
    public static final int MSG_ERROR = 3;

    public HGBaseConfigStateDialog(HGBaseFrame mainFrame, String title) {
        this(mainFrame, title, null);
    }

    public HGBaseConfigStateDialog(HGBaseFrame mainFrame, String title, String askToSave) {
        super(mainFrame, title, askToSave);
        this.lbState.setPreferredSize(new Dimension(100, HGBaseGuiTools.getFieldHeight()));
    }

    public void checkState() {
        JButton btOk = this.getOkButton();
        if (btOk != null) {
            btOk.setEnabled(this.canLeave());
        }
    }

    @Override
    protected void onDisplaying() {
        super.onDisplaying();
        this.checkState();
    }

    @Override
    public void caretUpdate(CaretEvent ev) {
        this.checkState();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.checkState();
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        this.checkState();
    }

    @Override
    public void tableChanged(TableModelEvent arg0) {
        this.checkState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        this.checkState();
    }

    public void setMessage(String messageText, int messageType) {
        if (HGBaseTools.hasContent(messageText)) {
            this.lbState.setText(messageText);
            this.lbState.setToolTipText(messageText);
            ImageIcon img = null;
            if (messageType == 1) {
                img = HGBaseGuiTools.loadImage(HGBaseSettings.get("infoImage"));
            } else if (messageType == 2) {
                img = HGBaseGuiTools.loadImage(HGBaseSettings.get("warnImage"));
            } else if (messageType == 3) {
                img = HGBaseGuiTools.loadImage(HGBaseSettings.get("errorImage"));
            }
            this.lbState.setIcon(img);
        } else {
            this.lbState.setText("");
            this.lbState.setIcon(null);
            this.lbState.setToolTipText(null);
        }
    }

    public void setErrorMessage(String messageText) {
        this.setMessage(messageText, 3);
    }

    public void setWarnMessage(String messageText) {
        this.setMessage(messageText, 2);
    }

    public void setInfoMessage(String messageText) {
        this.setMessage(messageText, 1);
    }

    protected abstract boolean canLeave();
}

