/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.menu;

import hgb.gui.HGBaseFrame;
import hgb.gui.menu.HGBaseMenuItem;
import hgb.gui.menu.HGBaseMenuItemPerformer;
import java.awt.Color;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;

public final class HGBaseMenuTools {
    private static final Color DEFAULT_COLOR = new JButton().getBackground();
    private static final Color ACTIVATE_COLOR = DEFAULT_COLOR.darker();

    private HGBaseMenuTools() {
    }

    public static void setMenuItemVisible(HGBaseFrame mainFrame, String id, final boolean visible) {
        HGBaseMenuItemPerformer.run(new HGBaseMenuItemPerformer(mainFrame, id){

            @Override
            protected void performMenuItem(JComponent menuItem) {
                menuItem.setVisible(visible);
            }
        });
    }

    public static void setMenuItemEnabled(HGBaseFrame mainFrame, String id, final boolean enable) {
        HGBaseMenuItemPerformer.run(new HGBaseMenuItemPerformer(mainFrame, id){

            @Override
            protected void performMenuItem(JComponent menuItem) {
                menuItem.setEnabled(enable);
            }
        });
    }

    public static void setMenuItemIcon(HGBaseFrame mainFrame, String id, final Icon newIcon) {
        HGBaseMenuItemPerformer.run(new HGBaseMenuItemPerformer(mainFrame, id){

            @Override
            protected void performMenuItem(JComponent menuItem) {
                if (menuItem instanceof AbstractButton) {
                    ((AbstractButton)menuItem).setIcon(newIcon);
                }
            }
        });
    }

    public static void setMenuItemSelected(HGBaseFrame mainFrame, String id, final boolean selected) {
        HGBaseMenuItemPerformer.run(new HGBaseMenuItemPerformer(mainFrame, id){

            @Override
            protected void performMenuItem(JComponent menuItem) {
                if (menuItem instanceof AbstractButton) {
                    AbstractButton ab = (AbstractButton)menuItem;
                    ab.setSelected(selected);
                    if (ab instanceof JButton) {
                        JButton b = (JButton)ab;
                        b.setContentAreaFilled(selected);
                        b.setBackground(HGBaseMenuTools.getButtonActivationColor(selected));
                    }
                }
                if (menuItem instanceof HGBaseMenuItem) {
                    HGBaseMenuItem mi = (HGBaseMenuItem)menuItem;
                    mi.setSelected(selected);
                    mi.setBackground(HGBaseMenuTools.getButtonActivationColor(selected));
                }
            }
        });
    }

    private static Color getButtonActivationColor(boolean active) {
        return active ? ACTIVATE_COLOR : DEFAULT_COLOR;
    }
}

