/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.menu;

import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBaseItem;
import hgb.gui.config.HGBaseConfigCheckBox;
import hgb.gui.config.HGBaseConfigComboBox;
import hgb.gui.config.HGBaseConfigItem;
import hgb.gui.config.HGBaseConfigMenuCheckBox;
import hgb.gui.config.HGBaseConfigRadioGroup;
import hgb.gui.menu.HGBaseMenu;
import hgb.gui.menu.HGBaseMenuItem;
import hgb.gui.menu.HGBaseMenuRadioButton;
import hgb.gui.menu.HGBaseSeparator;
import hgb.gui.menu.HGBaseSubMenu;
import hgb.gui.menu.HGBaseToolbarButton;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MenuBuilder {
    private HGBaseMenu baseMenu;

    public MenuBuilder(HGBaseMenu menu) {
        this.baseMenu = menu;
    }

    public HGBaseConfigRadioGroup buildRadioGroup(JMenu menu, String id, String option, String shortcut) {
        StringTokenizer st = new StringTokenizer(id, ";");
        String menuId = menu instanceof HGBaseSubMenu ? ((HGBaseSubMenu)menu).getId() : option;
        MenuRadioButtonActionListener radioListener = new MenuRadioButtonActionListener(menuId);
        if (st.countTokens() > 0) {
            boolean first = true;
            int menuKey = this.baseMenu.getNextMenuKey();
            ArrayList<HGBaseMenuRadioButton> listButtons = new ArrayList<HGBaseMenuRadioButton>();
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                HGBaseMenuRadioButton m = new HGBaseMenuRadioButton(t);
                m.setFocusable(false);
                this.baseMenu.menuItems.put(t, m);
                this.baseMenu.menuIndex.put(m, menuKey);
                listButtons.add(m);
                menu.add(m);
                m.addActionListener(this.baseMenu);
                m.addActionListener(radioListener);
                if (first) {
                    m.setSelected(true);
                    first = false;
                }
                if (option.equals("laf")) {
                    String laf = HGBaseSettings.getLaf(t);
                    if (laf == null) continue;
                    m.setEnabled(this.baseMenu.isPossibleLaf(laf));
                    continue;
                }
                if (!"language".equals(option)) continue;
                HGBaseText.addAvailableLanguage(t);
            }
            AbstractButton[] buttonsArray = listButtons.toArray(new HGBaseMenuRadioButton[listButtons.size()]);
            String[] shortcuts = shortcut.split(";");
            if (shortcuts.length > 0) {
                int i = 0;
                while (i < Math.min(shortcuts.length, buttonsArray.length)) {
                    this.setShortcut((JMenuItem)buttonsArray[i], shortcuts[i]);
                    ++i;
                }
            }
            HGBaseConfigRadioGroup rGroup = new HGBaseConfigRadioGroup(option, buttonsArray);
            this.baseMenu.addConfigItem(rGroup);
            this.baseMenu.addRadioGroupMenu(menuId, rGroup);
            return rGroup;
        }
        return null;
    }

    void buildMenu(Element root) {
        if (root != null) {
            ChildNodeIterator.run(new ChildNodeIterator(root, "menuconfig", null){

                @Override
                public void performNode(Node node, int index, Object obj) {
                    MenuBuilder.this.addMenuElements(MenuBuilder.this.baseMenu, node, MenuBuilder.this.baseMenu.getNextMenuKey());
                }
            });
        }
    }

    private void addMenuElements(JComponent menu, Node start, int menuKey) {
        if (start != null && start.getNodeName().equals("menu")) {
            String id = HGBaseXMLTools.getAttributeValue(start, "id");
            String menuType = HGBaseXMLTools.getAttributeValue(start, "type");
            String shortcut = HGBaseXMLTools.getAttributeValue(start, "shortcut");
            if (id != null && id.length() > 0) {
                final HGBaseSubMenu subMenu = new HGBaseSubMenu(id);
                subMenu.setFocusable(false);
                this.baseMenu.menuItems.put(id, subMenu);
                this.baseMenu.menuIndex.put(subMenu, menuKey);
                final int nextMenuKey = this.baseMenu.getNextMenuKey();
                menu.add(subMenu);
                subMenu.addActionListener(this.baseMenu);
                if (!this.baseMenu.handleSpecialMenu(menuType, subMenu, shortcut)) {
                    ChildNodeIterator.run(new ChildNodeIterator(start, "menu", null){

                        @Override
                        public void performNode(Node node, int index, Object obj) {
                            if (node.getNodeName().equals("menu")) {
                                MenuBuilder.this.addMenuElements(subMenu, node, MenuBuilder.this.baseMenu.getNextMenuKey());
                            } else if (node.getNodeName().equals("item")) {
                                String id = HGBaseXMLTools.getAttributeValue(node, "id");
                                String option = HGBaseXMLTools.getAttributeValue(node, "option");
                                String type = HGBaseXMLTools.getAttributeValue(node, "type");
                                String values = HGBaseXMLTools.getAttributeValue(node, "values");
                                String shortcut = HGBaseXMLTools.getAttributeValue(node, "shortcut");
                                if (id == null || id.length() == 0 || id.length() > 0 && (type == null || type.length() == 0)) {
                                    boolean hasId = id != null && id.length() > 0;
                                    JSeparator s = hasId ? new HGBaseSeparator(id) : new JSeparator();
                                    subMenu.add(s);
                                    if (hasId) {
                                        ((MenuBuilder)MenuBuilder.this).baseMenu.menuItems.put(id, s);
                                    }
                                } else if (id.length() > 0 && type != null && type.length() > 0) {
                                    if (type.equals("radio")) {
                                        if (option != null && option.length() > 0) {
                                            MenuBuilder.this.buildRadioGroup(subMenu, id, option, shortcut);
                                        }
                                    } else if (type.equals("combobox")) {
                                        if (option != null && option.length() > 0 && values != null && values.length() > 0) {
                                            JComboBox cb = MenuBuilder.this.buildCombobox(values);
                                            HGBaseConfigComboBox tc = new HGBaseConfigComboBox(id, option, cb);
                                            tc.setFocusable(false);
                                            ((MenuBuilder)MenuBuilder.this).baseMenu.menuItems.put(id, tc);
                                        }
                                    } else {
                                        JMenuItem m = null;
                                        if (type.equals("checkbox") && option != null && option.length() > 0) {
                                            m = new HGBaseConfigMenuCheckBox(id, option);
                                            MenuBuilder.this.baseMenu.addConfigItem((HGBaseConfigItem)((Object)m));
                                        } else if ("file.recent".equals(id)) {
                                            ((MenuBuilder)MenuBuilder.this).baseMenu.recentFileMenu = new HGBaseSubMenu(id);
                                            m = ((MenuBuilder)MenuBuilder.this).baseMenu.recentFileMenu;
                                        } else {
                                            m = new HGBaseMenuItem(id);
                                            if (type.equals("link")) {
                                                MenuBuilder.this.baseMenu.addLinkItem(id);
                                            }
                                        }
                                        m.setFocusable(false);
                                        ((MenuBuilder)MenuBuilder.this).baseMenu.menuItems.put(id, m);
                                        ((MenuBuilder)MenuBuilder.this).baseMenu.menuIndex.put(m, nextMenuKey);
                                        MenuBuilder.this.setShortcut(m, shortcut);
                                        subMenu.add(m);
                                        m.addActionListener(MenuBuilder.this.baseMenu);
                                    }
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    private void setShortcut(JMenuItem menu, String shortcut) {
        if (shortcut != null && shortcut.length() > 0 && menu != null) {
            StringTokenizer sc = new StringTokenizer(shortcut, ";");
            while (sc.hasMoreTokens()) {
                String tsc = sc.nextToken();
                int modifiers = 0;
                StringTokenizer st = new StringTokenizer(tsc, "+");
                while (st.hasMoreTokens()) {
                    String t = st.nextToken();
                    if (t.equalsIgnoreCase("Ctrl") || t.equalsIgnoreCase("Strg")) {
                        modifiers = 2;
                        continue;
                    }
                    if (t.equalsIgnoreCase("Alt")) {
                        modifiers = 8;
                        continue;
                    }
                    if (t.equalsIgnoreCase("Shift")) {
                        modifiers = 1;
                        continue;
                    }
                    int ch = 36;
                    if (t.length() == 1) {
                        ch = t.charAt(0);
                    } else if (t.equalsIgnoreCase("f1")) {
                        ch = 112;
                    } else if (t.equalsIgnoreCase("f2")) {
                        ch = 113;
                    } else if (t.equalsIgnoreCase("f3")) {
                        ch = 114;
                    } else if (t.equalsIgnoreCase("f4")) {
                        ch = 115;
                    } else if (t.equalsIgnoreCase("f5")) {
                        ch = 116;
                    } else if (t.equalsIgnoreCase("f6")) {
                        ch = 117;
                    } else if (t.equalsIgnoreCase("f7")) {
                        ch = 118;
                    } else if (t.equalsIgnoreCase("f8")) {
                        ch = 119;
                    } else if (t.equalsIgnoreCase("f9")) {
                        ch = 120;
                    } else if (t.equalsIgnoreCase("f10")) {
                        ch = 121;
                    } else if (t.equalsIgnoreCase("f11")) {
                        ch = 122;
                    } else if (t.equalsIgnoreCase("f12")) {
                        ch = 123;
                    } else if (t.equalsIgnoreCase("enter")) {
                        ch = 10;
                    } else if (t.equalsIgnoreCase("space")) {
                        ch = 32;
                    } else if (t.equalsIgnoreCase("esc")) {
                        ch = 27;
                    } else if (t.equalsIgnoreCase("tab")) {
                        ch = 9;
                    } else if (t.equalsIgnoreCase("plus")) {
                        ch = 521;
                    } else if (t.equalsIgnoreCase("minus")) {
                        ch = 45;
                    } else if (t.equalsIgnoreCase("entf")) {
                        ch = 127;
                    } else if (t.equalsIgnoreCase("del")) {
                        ch = 127;
                    } else if (t.equalsIgnoreCase("einf")) {
                        ch = 155;
                    } else if (t.equalsIgnoreCase("ins")) {
                        ch = 155;
                    } else if (t.equalsIgnoreCase("ende")) {
                        ch = 35;
                    } else if (t.equalsIgnoreCase("end")) {
                        ch = 35;
                    }
                    if (ch == 36) continue;
                    menu.setAccelerator(KeyStroke.getKeyStroke(ch, modifiers));
                }
            }
        }
    }

    private JComboBox<String> buildCombobox(String values) {
        JComboBox<String> cb = new JComboBox<String>();
        StringTokenizer st = new StringTokenizer(values, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int iValue = HGBaseTools.toInt(token);
            if (iValue != -2147483631) {
                cb.addItem(String.valueOf(iValue));
                continue;
            }
            try {
                String t = token;
                int step = 1;
                int pos = t.indexOf(58);
                if (pos >= 0) {
                    step = HGBaseTools.toInt(t.substring(pos + 1));
                    t = t.substring(0, pos);
                }
                if (step == -2147483631) {
                    cb.addItem(token);
                    continue;
                }
                pos = t.indexOf(45);
                int start = HGBaseTools.toInt(t.substring(0, pos));
                int end = HGBaseTools.toInt(t.substring(pos + 1));
                if (start == -2147483631 || end == -2147483631) {
                    cb.addItem(token);
                    continue;
                }
                int i = start;
                while (i <= end) {
                    cb.addItem(String.valueOf(i));
                    i += step;
                }
            }
            catch (Exception e) {
                cb.addItem(token);
            }
        }
        return cb;
    }

    void buildToolbar(Element root) {
        this.baseMenu.toolbar.addSeparator(new Dimension(5, 0));
        this.baseMenu.addSeparatorToToolbar = true;
        if (root != null) {
            ChildNodeIterator.run(new ChildNodeIterator(root, "menuconfig", null){

                @Override
                public void performNode(Node node, int index, Object obj) {
                    ChildNodeIterator.run(new ChildNodeIterator(node, "toolbar", null){

                        @Override
                        public void performNode(Node node, int index, Object obj) {
                            if (node != null && node.getNodeName().equals("item")) {
                                String id = HGBaseXMLTools.getAttributeValue(node, "id");
                                if (id == null || id.length() == 0) {
                                    JSeparator s = new JSeparator(1);
                                    ((MenuBuilder)(this).MenuBuilder.this).baseMenu.toolbar.add(s);
                                    ((MenuBuilder)(this).MenuBuilder.this).baseMenu.addSeparatorToToolbar = true;
                                } else {
                                    ((MenuBuilder)(this).MenuBuilder.this).baseMenu.addSeparatorToToolbar = false;
                                    JComponent o = ((MenuBuilder)(this).MenuBuilder.this).baseMenu.menuItems.get(id);
                                    JComponent b = null;
                                    if (o instanceof HGBaseMenuItem) {
                                        b = new HGBaseToolbarButton(id);
                                        ((AbstractButton)b).addActionListener(MenuBuilder.this.baseMenu);
                                    } else if (o instanceof HGBaseConfigMenuCheckBox) {
                                        String option = ((HGBaseConfigMenuCheckBox)o).getOption();
                                        b = new HGBaseConfigCheckBox(id, option);
                                        ((HGBaseConfigCheckBox)b).addActionListener(MenuBuilder.this.baseMenu);
                                        MenuBuilder.this.baseMenu.addConfigItem((HGBaseConfigItem)((Object)b));
                                    } else if (o instanceof HGBaseConfigComboBox) {
                                        b = (HGBaseConfigComboBox)o;
                                        ((HGBaseConfigComboBox)b).addActionListener(MenuBuilder.this.baseMenu);
                                        MenuBuilder.this.baseMenu.addConfigItem((HGBaseConfigItem)((Object)b));
                                    } else if (o instanceof HGBaseSubMenu) {
                                        b = MenuBuilder.this.createToolbarSubmenu(id, (HGBaseSubMenu)o);
                                    } else if (o instanceof JSeparator || o == null) {
                                        b = new HGBaseSeparator(id, 1);
                                        ((MenuBuilder)(this).MenuBuilder.this).baseMenu.addSeparatorToToolbar = true;
                                    }
                                    if (b != null) {
                                        b.setFocusable(false);
                                        if (HGBaseText.existsText(id)) {
                                            b.setToolTipText(HGBaseText.getText(id, new String[0]));
                                        }
                                        ((MenuBuilder)(this).MenuBuilder.this).baseMenu.toolbar.add(b);
                                        ((MenuBuilder)(this).MenuBuilder.this).baseMenu.toolbarItems.put(id, b);
                                    }
                                }
                            }
                        }
                    });
                }
            });
        }
        boolean showToolbar = HGBaseConfig.getBoolean("toolbar");
        this.baseMenu.toolbar.setVisible(showToolbar);
        if (!this.baseMenu.addSeparatorToToolbar) {
            this.baseMenu.toolbar.add(new JSeparator(1));
        }
        JLabel emptyPanel = new JLabel();
        emptyPanel.setPreferredSize(new Dimension(9999, 0));
        this.baseMenu.toolbar.add(emptyPanel);
    }

    void buildImages(Element root) {
        if (root != null) {
            ChildNodeIterator.run(new ChildNodeIterator(root, "menuconfig", null){

                @Override
                public void performNode(Node node, int index, Object obj) {
                    Object path;
                    if (node.getNodeName().equals("images") && (path = HGBaseXMLTools.getAttributeValue(node, "path")) != null && ((String)path).length() > 0) {
                        if (!((String)path).endsWith("/")) {
                            path = (String)path + "/";
                        }
                        final String filePath = path;
                        ChildNodeIterator.run(new ChildNodeIterator(node, "images", null){

                            @Override
                            public void performNode(Node node, int index, Object obj) {
                                if (node.getNodeName().equals("image")) {
                                    String id = HGBaseXMLTools.getAttributeValue(node, "id");
                                    String file = HGBaseXMLTools.getAttributeValue(node, "file");
                                    if (id != null && id.length() > 0 && file != null && file.length() > 0) {
                                        ImageIcon img = HGBaseGuiTools.loadImage(filePath + file);
                                        MenuBuilder.this.baseMenu.setItemImage(id, img);
                                    }
                                }
                            }
                        });
                    }
                }
            });
        }
        this.setImages();
    }

    void setImages() {
        if (HGBaseConfig.getBoolean("menuicons")) {
            this.baseMenu.setMenuIcons();
        }
        this.baseMenu.setToolbarIcons();
    }

    private HGBaseToolbarButton createToolbarSubmenu(String id, final HGBaseSubMenu subMenu) {
        final HGBaseToolbarButton button = new HGBaseToolbarButton(id);
        final MenuRadioButtonActionListener radiolistener = new MenuRadioButtonActionListener(id);
        final ActionListener checkListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object source = ev.getSource();
                if (source instanceof HGBaseConfigMenuCheckBox) {
                    HGBaseConfigMenuCheckBox check = (HGBaseConfigMenuCheckBox)source;
                    JComponent menuComponent = MenuBuilder.this.baseMenu.getMenuItem(check.getId());
                    ((HGBaseConfigMenuCheckBox)menuComponent).setSelected(check.isSelected());
                }
            }
        };
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                JPopupMenu popupMenu = new JPopupMenu();
                ButtonGroup possibleGroup = new ButtonGroup();
                Component[] componentArray = subMenu.getPopupMenu().getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof Cloneable) {
                        try {
                            Object clone = c.getClass().getMethod("clone", new Class[0]).invoke((Object)c, new Object[0]);
                            if (clone instanceof JMenuItem) {
                                popupMenu.add((JMenuItem)clone);
                                if (clone instanceof HGBaseItem) {
                                    String id = ((HGBaseItem)clone).getId();
                                    MenuBuilder.this.baseMenu.setMenuIcon((JMenuItem)clone, id);
                                    if (clone instanceof HGBaseMenuRadioButton) {
                                        HGBaseMenuRadioButton radio = (HGBaseMenuRadioButton)clone;
                                        radio.addActionListener(radiolistener);
                                        possibleGroup.add(radio);
                                    } else if (clone instanceof HGBaseConfigMenuCheckBox) {
                                        HGBaseConfigMenuCheckBox check = (HGBaseConfigMenuCheckBox)clone;
                                        check.addActionListener(checkListener);
                                    }
                                }
                            }
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                            HGBaseLog.logError("Exception when cloning object: " + e.getMessage());
                        }
                    }
                    ++n2;
                }
                popupMenu.show(button, 0, button.getBounds().y + button.getBounds().height);
            }
        });
        return button;
    }

    private class MenuRadioButtonActionListener
    implements ActionListener {
        private String menuId;

        public MenuRadioButtonActionListener(String menuId) {
            this.menuId = menuId;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Object source = ev.getSource();
            if (source instanceof HGBaseMenuRadioButton) {
                HGBaseMenuRadioButton radio = (HGBaseMenuRadioButton)source;
                String id = radio.getId();
                JComponent menuComponent = MenuBuilder.this.baseMenu.getMenuItem(id);
                if (menuComponent != radio) {
                    HGBaseMenuRadioButton menuRadio = (HGBaseMenuRadioButton)menuComponent;
                    menuRadio.setSelected(radio.isSelected());
                    MenuBuilder.this.baseMenu.actionPerformed(ev);
                }
                this.updateMenuIconsFromRadioButton(id);
            }
        }

        private void updateMenuIconsFromRadioButton(String id) {
            if (MenuBuilder.this.baseMenu.getItemImage(this.menuId) == null) {
                JComponent toolbarMenu;
                JComponent menuMenu;
                if (HGBaseConfig.getBoolean("menuicons") && (menuMenu = MenuBuilder.this.baseMenu.getMenuItem(this.menuId)) instanceof JMenuItem) {
                    MenuBuilder.this.baseMenu.setMenuIcon((JMenuItem)menuMenu, id);
                }
                if ((toolbarMenu = MenuBuilder.this.baseMenu.getToolbarItem(this.menuId)) instanceof JButton) {
                    MenuBuilder.this.baseMenu.setToolbarIcon((JButton)toolbarMenu, id);
                }
            }
        }
    }
}

