/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.util;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.function.Supplier;

public class StringSizeSupplier
implements Supplier<Dimension> {
    private final String text;
    private final Graphics graphics;

    public StringSizeSupplier(String text, Graphics graphics) {
        this.text = text;
        this.graphics = graphics;
    }

    @Override
    public Dimension get() {
        return this.getFontMetrics();
    }

    public Dimension get(float fontSize) {
        Font currentFont = this.graphics.getFont();
        this.graphics.setFont(currentFont.deriveFont(fontSize));
        Dimension metrics = this.getFontMetrics();
        this.graphics.setFont(currentFont);
        return metrics;
    }

    private Dimension getFontMetrics() {
        FontMetrics fontMetrics = this.graphics.getFontMetrics();
        return new Dimension(fontMetrics.stringWidth(this.text), fontMetrics.getHeight());
    }
}

