/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.util.waittask;

import hgb.gui.HGBaseFrame;
import hgb.gui.ProgressPanel;
import hgb.gui.util.AbstractDialog;
import hgb.gui.util.waittask.WaitTask;
import hgb.gui.util.waittask.WaitTaskEvent;
import hgb.gui.util.waittask.WaitTaskListener;
import hgb.lib.HGBaseText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WaitTaskDialog
extends AbstractDialog
implements WaitTaskListener {
    private static final long DEFAULT_EXECUTION_DELAY = 200L;
    private static final TimeUnit DEFAULT_EXECUTION_DELAY_UNIT = TimeUnit.MILLISECONDS;
    private String informationMsgKey;
    private WaitTask task;
    private FutureTask<Boolean> futuretask;
    private ScheduledExecutorService executor;
    private long executionDelay;
    private TimeUnit executionDelayUnit;
    private ProgressPanel progressBar;
    private HGBaseFrame mainFrame;

    public WaitTaskDialog(HGBaseFrame mainFrame, String titleMsgKey, String informationMsgKey, WaitTask task, boolean resizable) {
        super(mainFrame, titleMsgKey, resizable);
        this.mainFrame = mainFrame;
        this.futuretask = new FutureTask<Boolean>(task);
        this.setInformationMsgKey(informationMsgKey);
        task.addWaitTaskListener(this);
        this.setTask(task);
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.setExecutionDelay(200L, DEFAULT_EXECUTION_DELAY_UNIT);
    }

    protected HGBaseFrame getMainFrame() {
        return this.mainFrame;
    }

    protected String getInformationMsgKey() {
        return this.informationMsgKey;
    }

    protected void setInformationMsgKey(String informationMsgKey) {
        this.informationMsgKey = informationMsgKey;
    }

    protected WaitTask getTask() {
        return this.task;
    }

    protected void setTask(WaitTask task) {
        this.task = task;
    }

    protected long getExecutionDelay() {
        return this.executionDelay;
    }

    protected TimeUnit getExecutionDelayUnit() {
        return this.executionDelayUnit;
    }

    protected void setExecutionDelay(long delay, TimeUnit unit) {
        this.executionDelay = delay;
        this.executionDelayUnit = unit;
    }

    @Override
    public void taskCompleted(WaitTaskEvent ev) {
        this.closeDialog(true);
    }

    @Override
    public void taskCanceled(WaitTaskEvent ev) {
        this.onCancel();
    }

    @Override
    protected JPanel createContentPanel() {
        JPanel pnProgress;
        JPanel pnContent = new JPanel();
        pnContent.setLayout(new BoxLayout(pnContent, 1));
        JPanel pnInformation = this.createContentInformationPanel();
        if (pnInformation != null) {
            pnContent.add(pnInformation);
        }
        if ((pnProgress = this.createContentProgressPanel()) != null) {
            pnContent.add(pnProgress);
        }
        return pnContent;
    }

    protected JPanel createContentInformationPanel() {
        JPanel pnInformation = new JPanel(new FlowLayout(0));
        pnInformation.add(new JLabel(HGBaseText.getText(this.getInformationMsgKey(), new String[0])));
        return pnInformation;
    }

    protected JPanel createContentProgressPanel() {
        this.progressBar = new ProgressPanel();
        this.progressBar.setPreferredSize(new Dimension(250, 20));
        JPanel pnProgress = new JPanel(new BorderLayout());
        pnProgress.add((Component)this.progressBar, "North");
        return pnProgress;
    }

    protected void setProgressBarState(int state) {
        this.progressBar.setState(state);
        this.getMainFrame().setStatusProgress(state);
    }

    @Override
    protected Object[] getOptionButtons() {
        Object[] options = new Object[]{super.getCancelButton()};
        return options;
    }

    @Override
    protected Object getDefaultButton() {
        return super.getCancelButton();
    }

    @Override
    protected boolean isOkAllowed() {
        return false;
    }

    @Override
    protected boolean isCancelAllowed() {
        return true;
    }

    @Override
    protected void additionalInit() {
        super.additionalInit();
        this.executor.schedule(this.futuretask, this.getExecutionDelay(), this.getExecutionDelayUnit());
        this.setProgressBarState(1);
    }

    @Override
    protected void additionalDeinit() {
        this.setProgressBarState(0);
        super.additionalDeinit();
    }

    @Override
    protected void onCancel() {
        if (!this.futuretask.isDone()) {
            this.futuretask.cancel(true);
        }
        super.onCancel();
    }
}

