/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib;

import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseTools;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class HGBaseFileTools {
    public static final String JAR_EXTENSION = "jar";
    public static final String ZIP_EXTENSION = "zip";
    private static final int MAX_SHORT_FILE_NAME_LENGTH = 32;
    private static final int BUFFER_SIZE = 1024;
    private static final String[] HOME_VARS = new String[]{"HOME", "USERPROFILE"};
    private static String strCurrentDir = "";
    public static final String MIME_TYPE_IMGAGE_JPEG = "image/jpeg";
    public static final String MIME_TYPE_MOVIE_MP4 = "video/mp4";
    public static final String MIME_TYPE_MOVIE_QTIME = "video/quicktime";
    public static final String MIME_TYPE_APP_XML = "application/xml";
    public static final String MIME_TYPE_TEXT_XML = "text/xml";
    public static final String MIME_TYPE_TEXT_HTML = "text/html";
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    private HGBaseFileTools() {
    }

    public static String getExecutionDir(Object o) {
        Object execDir = "";
        try {
            String thisClassName = o.getClass().getName().replace('.', '/');
            String thisClassNameLong = thisClassName + ".class";
            Object thisClassNameShort = o.getClass().getName();
            thisClassNameShort = ((String)thisClassNameShort).substring(((String)thisClassNameShort).lastIndexOf(46) + 1, ((String)thisClassNameShort).length());
            thisClassNameShort = (String)thisClassNameShort + ".class";
            URL myURL = o.getClass().getResource((String)thisClassNameShort);
            execDir = myURL.getPath();
            execDir = ((String)execDir).substring(0, ((String)execDir).lastIndexOf("/" + thisClassNameLong));
            if (((String)execDir).indexOf(".jar!") > 0) {
                execDir = ((String)execDir).substring(0, ((String)execDir).lastIndexOf(47));
            }
            if (((String)execDir).indexOf("file:") == 0) {
                execDir = ((String)execDir).substring(5, ((String)execDir).length());
            }
            int idx = ((String)execDir).indexOf("%20");
            while (idx >= 0) {
                execDir = ((String)execDir).substring(0, idx) + " " + ((String)execDir).substring(idx + 3, ((String)execDir).length());
                idx = ((String)execDir).indexOf("%20");
            }
        }
        catch (Exception e) {
            execDir = "";
        }
        return execDir;
    }

    public static File getExecutionFile(Object o) {
        try {
            File file = new File(o.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            return file;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static String getCurrentDir() {
        if (strCurrentDir == null || strCurrentDir.isEmpty()) {
            File newDir;
            String jarName;
            File jarFile;
            File currentDir;
            File dir1 = new File(".");
            try {
                strCurrentDir = dir1.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String homeDir = HGBaseFileTools.getHomeDir();
            if (homeDir != null && !homeDir.isEmpty() && ((currentDir = new File(strCurrentDir)).equals(new File(homeDir)) || HGBaseFileTools.isWriteProtected(currentDir)) && JAR_EXTENSION.equalsIgnoreCase(HGBaseFileTools.getFileExtension(jarFile = HGBaseFileTools.getExecutionFile(new HGBaseFileTools()))) && (jarName = HGBaseFileTools.getFileName(jarFile.getAbsolutePath(), false)) != null && !jarName.isEmpty() && ((newDir = new File(homeDir, "." + jarName)).isDirectory() || newDir.mkdir())) {
                try {
                    strCurrentDir = newDir.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return strCurrentDir;
    }

    private static String getHomeDir() {
        String homeDir = null;
        int i = 0;
        while (i < HOME_VARS.length && (homeDir == null || homeDir.isEmpty())) {
            homeDir = System.getenv(HOME_VARS[i]);
            ++i;
        }
        return homeDir;
    }

    private static boolean isWriteProtected(File testDir) {
        return !testDir.canWrite();
    }

    public static String getFileExtension(File f) {
        return f != null ? HGBaseFileTools.getFileExtension(f.getName()) : "";
    }

    public static String getFileExtension(String filename) {
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return "";
    }

    public static String getBaseName(String filename) {
        if (filename == null) {
            return null;
        }
        int length = filename.length();
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        int lastSepIndex = Math.max(lastUnixPos, lastWindowsPos);
        int extPos = filename.lastIndexOf(46);
        return filename.substring(lastSepIndex > -1 && lastSepIndex < length - 1 ? lastSepIndex + 1 : 0, extPos > 0 && extPos <= length ? extPos : length);
    }

    public static String getBaseName(Path path) {
        if (path == null) {
            return null;
        }
        return HGBaseFileTools.getBaseName(path.toString());
    }

    public static File checkExtension(File f) {
        return HGBaseFileTools.checkExtension(f, null);
    }

    public static File checkExtension(File f, String defaultExtension) {
        String extension;
        StringTokenizer st;
        if (f == null) {
            return f;
        }
        String name = f.getName();
        if (!f.exists() && name.indexOf(46) == -1 && (st = new StringTokenizer(extension = defaultExtension == null ? HGBaseSettings.get("fileExtensions") : defaultExtension, ";")).hasMoreTokens()) {
            String ext = st.nextToken();
            return new File(f.getPath() + "." + ext);
        }
        return f;
    }

    public static String getFileName(String path, boolean withExtension) {
        int ie;
        String name = new File(path).getName();
        if (!withExtension && (ie = name.lastIndexOf(46)) >= 0) {
            name = name.substring(0, ie);
        }
        return name;
    }

    public static String getAbsolutePath(String file) {
        if (file != null && file.length() > 0 && file.charAt(0) != '/' && file.indexOf(58) < 0) {
            return HGBaseFileTools.getCurrentDir() + File.separator + file;
        }
        return file;
    }

    public static String shortenFileName(String fileName) {
        if (fileName.length() > 32) {
            StringBuffer nameStart = new StringBuffer();
            StringBuffer nameEnd = new StringBuffer();
            String[] nameParts = HGBaseTools.split(fileName, File.separator);
            if (nameParts.length < 2) {
                return fileName;
            }
            int startIndex = 1;
            int endIndex = nameParts.length - 1;
            boolean complete = false;
            nameStart.append(HGBaseTools.getStringWithIndex(nameParts, 0));
            nameEnd.insert(0, HGBaseTools.getStringWithIndex(nameParts, endIndex));
            int i = startIndex;
            while (i < nameParts.length - 1 && nameStart.length() + nameEnd.length() < 32) {
                if (i % 2 == 0) {
                    nameEnd.insert(0, HGBaseTools.getStringWithIndex(nameParts, --endIndex) + File.separator);
                } else {
                    nameStart.append(File.separator);
                    nameStart.append(HGBaseTools.getStringWithIndex(nameParts, i));
                }
                if (i == nameParts.length - 1) {
                    complete = true;
                }
                ++i;
            }
            if (!complete) {
                nameStart.append(File.separator);
                nameStart.append("...");
                nameStart.append(File.separator);
            }
            return nameStart.toString() + nameEnd.toString();
        }
        return fileName;
    }

    public static void copyStream(InputStream in, OutputStream out, boolean withClose) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            if (withClose) {
                HGBaseFileTools.closeStream(in, true);
                HGBaseFileTools.closeStream(out, true);
            }
        }
    }

    public static void copyStream(InputStream in, FileOutputStream out, long position, long count, boolean withClose) throws IOException {
        try {
            ReadableByteChannel rbc = Channels.newChannel(in);
            out.getChannel().transferFrom(rbc, position, count);
        }
        finally {
            if (withClose) {
                HGBaseFileTools.closeStream(in, true);
                HGBaseFileTools.closeStream(out, true);
            }
        }
    }

    public static String getString(InputStream in) {
        try {
            byte[] b = new byte[in.available()];
            if (in.read(b) != -1) {
                return new String(b, Charset.defaultCharset());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    public static void closeStream(Closeable stream, boolean withLogging) {
        block3: {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    if (!withLogging) break block3;
                    HGBaseLog.logError(e.getMessage());
                }
            }
        }
    }

    public static void closeStream(Closeable stream) {
        HGBaseFileTools.closeStream(stream, false);
    }

    public static void closeZipFile(ZipFile file, boolean withLogging) {
        block3: {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {
                    if (!withLogging) break block3;
                    HGBaseLog.logError(e.getMessage());
                }
            }
        }
    }

    public static int extractZipFile(ZipFile zipFile, File targetFolder, FileFilter filter) throws IOException {
        int count = 0;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            File targetFile = new File(targetFolder, entryName);
            if (entry.isDirectory()) {
                if (targetFile.exists() || targetFile.mkdir()) continue;
                throw new IOException(String.format("Could not create folder '%s'!", targetFile.toString()));
            }
            if (filter != null && !filter.accept(targetFile)) continue;
            HGBaseFileTools.extractFileFromZip(zipFile, entry, targetFile);
            ++count;
        }
        HGBaseFileTools.closeZipFile(zipFile, false);
        return count;
    }

    public static void extractFileFromZip(ZipFile zipFile, ZipEntry entry, File targetFile) throws IOException {
        File folder = targetFile.getParentFile();
        if (!folder.isDirectory() && !folder.mkdirs()) {
            throw new IOException(String.format("Could not create folder '%s'!", folder.toString()));
        }
        InputStream in = zipFile.getInputStream(entry);
        FileOutputStream out = new FileOutputStream(targetFile);
        HGBaseFileTools.copyStream(in, out, 0L, entry.getSize(), true);
    }

    public static InputStream openApplicationFileStream(String fileName, Object activeClass) {
        BufferedInputStream in = null;
        try {
            if (fileName.charAt(0) == '/') {
                URL u = activeClass.getClass().getResource(fileName);
                in = u == null ? new BufferedInputStream(new FileInputStream(fileName)) : new BufferedInputStream(u.openStream());
            } else if (fileName.indexOf(58) >= 0) {
                in = new BufferedInputStream(new FileInputStream(fileName));
            } else {
                File readFile = new File(HGBaseFileTools.getCurrentDir(), fileName);
                if (!readFile.isFile()) {
                    readFile = new File(HGBaseFileTools.getExecutionDir(activeClass), fileName);
                }
                in = new BufferedInputStream(new FileInputStream(readFile));
            }
        }
        catch (IOException e) {
            HGBaseLog.logError("File '" + fileName + "' could not be read: " + e.getMessage());
        }
        return in;
    }

    public static InputStream openUrlStream(String url) throws MalformedURLException, IOException {
        return new URL(url).openStream();
    }

    public static void downloadFile(String url, String destFile) throws MalformedURLException, IOException {
        FileOutputStream output = new FileOutputStream(destFile);
        InputStream input = HGBaseFileTools.openUrlStream(url);
        HGBaseFileTools.copyStream(input, output, 0L, Long.MAX_VALUE, true);
    }

    public static boolean downloadFileFromZip(String url, File destFolder, String fileName) throws MalformedURLException, IOException {
        boolean success = false;
        ZipInputStream input = null;
        FileOutputStream output = null;
        try {
            ZipEntry entry;
            input = new ZipInputStream(HGBaseFileTools.openUrlStream(url));
            while (!success && (entry = input.getNextEntry()) != null) {
                String filename;
                if (entry.isDirectory() || !(filename = new File(destFolder, entry.getName()).getName()).equalsIgnoreCase(fileName)) continue;
                output = new FileOutputStream(new File(destFolder, fileName));
                HGBaseFileTools.copyStream(input, output, 0L, entry.getSize(), false);
                success = true;
            }
        }
        catch (Throwable throwable) {
            HGBaseFileTools.closeStream(input, true);
            HGBaseFileTools.closeStream(output, true);
            throw throwable;
        }
        HGBaseFileTools.closeStream(input, true);
        HGBaseFileTools.closeStream(output, true);
        return success;
    }

    /*
     * Loose catch block
     */
    public static boolean copyFile(File sourceFile, File destFile) {
        if (destFile.isDirectory()) {
            destFile = new File(destFile, sourceFile.getName());
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(sourceFile);
            os = new FileOutputStream(destFile);
            HGBaseFileTools.copyStream(is, os, 0L, Long.MAX_VALUE, true);
        }
        catch (IOException e) {
            HGBaseFileTools.closeStream(is);
            HGBaseFileTools.closeStream(os);
            return false;
            catch (Throwable throwable) {
                HGBaseFileTools.closeStream(is);
                HGBaseFileTools.closeStream(os);
                throw throwable;
            }
        }
        HGBaseFileTools.closeStream(is);
        HGBaseFileTools.closeStream(os);
        return true;
    }

    public static int copyFiles(File sourceFolder, File destFolder, FileFilter filter) {
        if (!sourceFolder.isDirectory() || !destFolder.isDirectory() || sourceFolder.equals(destFolder)) {
            return 0;
        }
        int count = 0;
        File[] fileArray = sourceFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && (filter == null || filter.accept(file))) {
                HGBaseFileTools.copyFile(file, destFolder);
            }
            ++n2;
        }
        return count;
    }

    public static String searchFile(File startFolder, String filename, boolean recursive) {
        if (startFolder != null && startFolder.isDirectory()) {
            HashSet<File> folders = new HashSet<File>();
            File[] fileArray = startFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    if (file.getName().equalsIgnoreCase(filename)) {
                        return file.getAbsolutePath();
                    }
                } else {
                    folders.add(file);
                }
                ++n2;
            }
            if (recursive) {
                for (File folder : folders) {
                    String found = HGBaseFileTools.searchFile(folder, filename, recursive);
                    if (!HGBaseTools.hasContent(found)) continue;
                    return found;
                }
            }
        }
        return null;
    }

    public static void deleteFileNowOrOnExit(File file) {
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public static boolean deleteFolder(File folder) {
        if (folder.isDirectory()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory() && !HGBaseFileTools.deleteFolder(f) || f.isFile() && !f.delete()) {
                    return false;
                }
                ++n2;
            }
            return folder.delete();
        }
        return false;
    }

    public static boolean isFolder(Path path) {
        return path != null && HGBaseTools.hasContent(path.toString()) && Files.isDirectory(path, new LinkOption[0]);
    }

    public static Vector<Path> getFolderEntries(Path path, FilenameFilter filter, boolean ordered) {
        if (!HGBaseFileTools.isFolder(path)) {
            return null;
        }
        String[] folderList = path.toFile().list(filter);
        Vector<String> folderEntries = new Vector<String>();
        String[] stringArray = folderList;
        int n = folderList.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            folderEntries.add(fileName);
            ++n2;
        }
        if (ordered) {
            Collections.sort(folderEntries, String.CASE_INSENSITIVE_ORDER);
        }
        Vector<Path> folderEntryPaths = new Vector<Path>();
        for (String fileName : folderEntries) {
            folderEntryPaths.add(path.resolve(fileName));
        }
        return folderEntryPaths;
    }

    public static String getContentType(File file) {
        try {
            return Files.probeContentType(file.toPath());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean hasContentType(File file, String first, String ... more) {
        if (file == null || first == null) {
            return false;
        }
        String contentType = HGBaseFileTools.getContentType(file);
        if (first.equalsIgnoreCase(contentType)) {
            return true;
        }
        if (more == null) {
            return false;
        }
        String[] stringArray = more;
        int n = more.length;
        int n2 = 0;
        while (n2 < n) {
            String furtherContentType = stringArray[n2];
            if (furtherContentType != null && furtherContentType.equalsIgnoreCase(contentType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

