/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib;

import hgb.lib.HGBaseSettings;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class HGBaseLog {
    public static final int LOG_NONE = 0;
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARN = 2;
    public static final int LOG_INFO = 4;
    public static final int LOG_DEBUG = 8;
    public static final int LOG_ALL = Integer.MAX_VALUE;
    private static int logMode = Integer.MAX_VALUE;
    private static String logFile = HGBaseSettings.get("fileLog");
    private static boolean logError = false;

    private HGBaseLog() {
    }

    public static void setLogMode(int mode) {
        logMode = mode;
    }

    public static int getLogMode() {
        return logMode;
    }

    public static boolean isLogMode(int mode) {
        if (mode == 0) {
            return HGBaseLog.getLogMode() == mode;
        }
        return (HGBaseLog.getLogMode() & mode) == mode;
    }

    public static String getLogFile() {
        return logFile;
    }

    public static void setLogFile(String logFile) {
        HGBaseLog.logFile = logFile;
    }

    public static void log(String msg) {
        HGBaseLog.log(Integer.MAX_VALUE, msg);
    }

    public static void log(int mode, String msg) {
        block5: {
            if (mode != 0 && HGBaseLog.isLogMode(mode)) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String date = formatter.format(new Date());
                String text = date + "\t" + HGBaseLog.getLogModeText(mode) + "\t" + msg + "\r\n";
                String fileName = HGBaseLog.getLogFile();
                if (fileName == null || fileName.length() == 0) {
                    System.out.print(text);
                } else {
                    try {
                        FileOutputStream fout = new FileOutputStream(fileName, true);
                        fout.write(text.getBytes(Charset.defaultCharset()));
                        fout.close();
                        logError = false;
                    }
                    catch (IOException e) {
                        if (logError) break block5;
                        System.out.println("Error writting into log file '" + fileName + "'!");
                        logError = true;
                    }
                }
            }
        }
    }

    private static String getLogModeText(int mode) {
        switch (mode) {
            case 1: {
                return "ERROR";
            }
            case 2: {
                return "WARN ";
            }
            case 4: {
                return "INFO ";
            }
            case 8: {
                return "DEBUG";
            }
            case 0x7FFFFFFF: {
                return "     ";
            }
        }
        return String.valueOf(mode);
    }

    public static void logError(String msg) {
        HGBaseLog.log(1, msg);
    }

    public static void logWarn(String msg) {
        HGBaseLog.log(2, msg);
    }

    public static void logInfo(String msg) {
        HGBaseLog.log(4, msg);
    }

    public static void logDebug(String msg) {
        HGBaseLog.log(8, msg);
    }
}

