/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib;

import hgb.lib.HGBaseTools;
import hgb.lib.internal.IntBooleanStringMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.UIManager;

public final class HGBaseSettings {
    private static final UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
    private static final IntBooleanStringMap settings = new IntBooleanStringMap();

    private HGBaseSettings() {
    }

    public static int fromFile(String file) {
        if (settings.fromFile(file, "settings", "set", "name", "value") == 0) {
            return 0;
        }
        return -10701;
    }

    public static List<UIManager.LookAndFeelInfo> getLafInfo() {
        return Collections.unmodifiableList(Arrays.asList(lafInfo));
    }

    public static String get(String set) {
        return settings.get(set);
    }

    public static String get(String set, String defaultValue) {
        return settings.get(set, defaultValue);
    }

    public static int getInt(String set) {
        return settings.getInt(set);
    }

    public static int getInt(String set, int defaultValue) {
        return settings.getInt(set, defaultValue);
    }

    public static boolean getBoolean(String set) {
        return settings.getBoolean(set);
    }

    public static boolean getBoolean(String set, boolean defaultValue) {
        return settings.getBoolean(set, defaultValue);
    }

    public static String getLaf(String lafId) {
        int lafIndex = HGBaseTools.toInt(lafId.replaceFirst("laf.", ""));
        if (lafIndex >= 0) {
            return lafIndex < lafInfo.length ? lafInfo[lafIndex].getClassName() : lafInfo[0].getClassName();
        }
        return HGBaseSettings.get(lafId);
    }
}

