/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib;

import hgb.gui.HGBaseDialog;
import hgb.gui.HGBaseFrame;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseText;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.Timer;

public final class HGBaseSound {
    private static final String ERROR_SOUND = "error.sound";
    private static final String CONFIG_NOSOUND = "nosound";
    public static final int NONE = 0;
    public static final int ONCE = 1;
    public static final int ALWAYS = 2;
    public static int timeOut = 5;
    private static int errorMode = 0;
    private static boolean loadSoundError = false;
    private static boolean playSoundError = false;
    private static List<Clip> listClips = null;

    private HGBaseSound() {
    }

    private static void initSoundTimer() {
        listClips = new ArrayList<Clip>();
        Timer t = new Timer(100, ev -> {
            if (listClips.size() > timeOut) {
                int i = listClips.size() - 1;
                while (i >= 0) {
                    Clip ac = listClips.get(i);
                    if (!ac.isActive()) {
                        ac.stop();
                        ac.close();
                        listClips.remove(ac);
                    }
                    --i;
                }
            }
        });
        t.start();
    }

    protected static AudioInputStream loadAudio(String path) {
        AudioInputStream ais;
        block4: {
            ais = null;
            try {
                URL audioUrl = HGBaseFrame.getInstance().getClass().getResource(path);
                if (audioUrl == null) {
                    HGBaseLog.logWarn("Could not find audio file '" + path + "'.");
                } else {
                    ais = AudioSystem.getAudioInputStream(audioUrl);
                    loadSoundError = false;
                }
            }
            catch (IOException | UnsupportedAudioFileException e) {
                if ((HGBaseSound.getErrorMode() != 1 || loadSoundError) && HGBaseSound.getErrorMode() != 2) break block4;
                loadSoundError = true;
                String[] ph = new String[]{e.getMessage()};
                HGBaseDialog.printError(ERROR_SOUND, ph, HGBaseFrame.getInstance());
            }
        }
        return ais;
    }

    public static boolean playAudio(String path) {
        if (!HGBaseConfig.getBoolean(CONFIG_NOSOUND)) {
            String file = HGBaseSettings.get(path);
            if (file == null) {
                file = path;
            }
            return HGBaseSound.playAudio(HGBaseSound.loadAudio(file));
        }
        return false;
    }

    protected static boolean playAudio(AudioInputStream asPlay) {
        block4: {
            if (asPlay != null) {
                if (listClips == null) {
                    HGBaseSound.initSoundTimer();
                }
                try {
                    AudioInputStream stream = asPlay;
                    AudioFormat format = stream.getFormat();
                    DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * format.getFrameSize());
                    Clip actualClip = (Clip)AudioSystem.getLine(info);
                    actualClip.open(stream);
                    actualClip.start();
                    listClips.add(actualClip);
                    playSoundError = false;
                    return true;
                }
                catch (Exception e) {
                    HGBaseLog.logWarn("erroMode: " + HGBaseSound.getErrorMode());
                    if ((HGBaseSound.getErrorMode() != 1 || playSoundError) && HGBaseSound.getErrorMode() != 2) break block4;
                    playSoundError = true;
                    String[] ph = new String[]{e.getMessage()};
                    HGBaseLog.logError("error: " + HGBaseText.getText(ERROR_SOUND, ph));
                    HGBaseDialog.printError(ERROR_SOUND, ph, HGBaseFrame.getInstance());
                }
            }
        }
        return false;
    }

    public static int getErrorMode() {
        return errorMode;
    }

    public static void setErrorMode(int errorMode) {
        if (errorMode == 1 || errorMode == 2 || errorMode == 0) {
            HGBaseSound.errorMode = errorMode;
        }
    }

    public static boolean isValidAudioFile(String path) {
        URL audioUrl = HGBaseFrame.getInstance().getClass().getResource(path);
        if (audioUrl == null) {
            return false;
        }
        try {
            AudioSystem.getAudioFileFormat(audioUrl);
        }
        catch (IOException | UnsupportedAudioFileException e) {
            return false;
        }
        return true;
    }
}

