/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib;

import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseTools;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class HGBaseText {
    private static final String KEY_LANGUAGE = "language";
    private static final String DEFAULT_LANGUAGE = "lan.en";
    private static final String KEY_MESSAGES = "messages";
    private static final String KEY_MSG = "msg";
    private static final String KEY_CODE = "code";
    private static final String KEY_STRING = "string";
    private static final String KEY_NAME = "name";
    private static final String KEY_FILE = "file";
    private static final String KEY_INCLUDE = "include";
    private static final String KEY_FILE_MESSAGES = "fileMessages";
    private static Map<String, String> messages = new HashMap<String, String>();
    private static String actLanguage = null;
    private static Map<String, String> keysToReplace = new HashMap<String, String>();
    private static ArrayList<String> availableLanguages = new ArrayList();

    private HGBaseText() {
    }

    public static int setLanguage() {
        actLanguage = null;
        String language = HGBaseConfig.get(KEY_LANGUAGE, DEFAULT_LANGUAGE);
        messages.clear();
        HGBaseText.readMessageFile(HGBaseSettings.get(KEY_FILE_MESSAGES), language);
        return actLanguage == null ? -10707 : 0;
    }

    public static void addAvailableLanguage(String language) {
        if (!availableLanguages.contains(language)) {
            availableLanguages.add(language);
        }
    }

    private static void readMessageFile(String fileName, final String language) {
        Element root = HGBaseXMLTools.readXML(fileName);
        if (root != null) {
            ChildNodeIterator.run(new ChildNodeIterator(root, KEY_MESSAGES, null){

                @Override
                public void performNode(Node node, int index, Object obj) {
                    String code;
                    String includeFile;
                    String nodeName = node.getNodeName();
                    if (HGBaseText.KEY_INCLUDE.equals(nodeName) && HGBaseTools.hasContent(includeFile = HGBaseXMLTools.getAttributeValue(node, HGBaseText.KEY_FILE))) {
                        HGBaseText.readMessageFile(includeFile, language);
                    }
                    if (HGBaseText.KEY_LANGUAGE.equals(nodeName) && language.equals(code = HGBaseXMLTools.getAttributeValue(node, HGBaseText.KEY_CODE))) {
                        actLanguage = language;
                        ChildNodeIterator.run(new ChildNodeIterator(node, HGBaseText.KEY_LANGUAGE, null){

                            @Override
                            public void performNode(Node node, int index, Object obj) {
                                String text;
                                if (HGBaseText.KEY_MSG.equals(node.getNodeName())) {
                                    String code = HGBaseXMLTools.getAttributeValue(node, HGBaseText.KEY_CODE);
                                    text = HGBaseXMLTools.getNodeValue(node);
                                    if (HGBaseTools.hasContent(code)) {
                                        messages.put(code, text);
                                    }
                                }
                                if (HGBaseText.KEY_STRING.equals(node.getNodeName())) {
                                    String name = HGBaseXMLTools.getAttributeValue(node, HGBaseText.KEY_NAME);
                                    text = HGBaseXMLTools.getNodeValue(node);
                                    if (HGBaseTools.hasContent(name)) {
                                        messages.put(name, text);
                                    }
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    public static String getLanguage() {
        return actLanguage;
    }

    public static String[] getAvailableLanguages() {
        return availableLanguages.toArray(new String[0]);
    }

    public static String getText(int code, String ... placeHolder) {
        return HGBaseText.getText(String.valueOf(code), placeHolder);
    }

    public static String getText(String code, String ... placeHolder) {
        String language;
        String string = language = actLanguage == null ? HGBaseConfig.get(KEY_LANGUAGE) : actLanguage;
        if (HGBaseTools.hasContent(language)) {
            String s = HGBaseText.getMessageForCode(code);
            if (s != null) {
                if (placeHolder != null) {
                    int i = 0;
                    while (i < placeHolder.length) {
                        String replace = placeHolder[i] != null ? placeHolder[i] : "";
                        s = s.replaceFirst("%s", replace);
                        ++i;
                    }
                }
                return s;
            }
            if (code != null && code.startsWith("laf.")) {
                int lafIndex = HGBaseTools.toInt(code.replaceFirst("laf.", ""));
                List<UIManager.LookAndFeelInfo> lafInfo = HGBaseSettings.getLafInfo();
                if (lafIndex >= 0 && lafIndex < lafInfo.size()) {
                    return lafInfo.get(lafIndex).getName();
                }
            }
            return "?: \"" + code + "\"";
        }
        return "?!?: \"" + code + "\"";
    }

    private static String getMessageForCode(String code) {
        String replacementCode = keysToReplace.get(code);
        String codeToUse = replacementCode == null ? code : replacementCode;
        return messages.get(codeToUse);
    }

    public static boolean existsText(String code) {
        return actLanguage != null && messages.containsKey(code);
    }

    public static void replaceCode(String originalCode, String replacementCode) {
        if (replacementCode == null) {
            HGBaseText.clearCodeReplacement(originalCode);
        } else {
            keysToReplace.put(originalCode, replacementCode);
        }
    }

    public static void clearCodeReplacement(String originalCode) {
        keysToReplace.remove(originalCode);
    }
}

