/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib;

import java.util.ArrayList;

public class UndoStack<T extends Undoable<T>> {
    private ArrayList<T> undoStack = new ArrayList();
    private int currentStateIndex;
    private T currentState;

    public UndoStack() {
        this.resetIndex();
    }

    private void resetIndex() {
        this.currentStateIndex = -1;
    }

    private T cloneState(T state) {
        if (state == null) {
            return null;
        }
        return (T)((Undoable)state.getClone());
    }

    public void addState(T state) {
        if (state == null) {
            throw new IllegalArgumentException("state must not be null");
        }
        if (this.currentStateIndex > -1) {
            int stackSize = this.undoStack.size();
            int index = stackSize - 1;
            while (index > this.currentStateIndex) {
                this.undoStack.remove(index);
                --index;
            }
            this.resetIndex();
            this.currentState = null;
        } else {
            this.undoStack.add(this.cloneState(state));
        }
    }

    public boolean isUndoAvailable() {
        return this.undoStack.size() > 0 && (this.currentStateIndex == -1 || this.currentStateIndex > 0);
    }

    public boolean isRedoAvailable() {
        return this.currentStateIndex >= 0;
    }

    public T performUndo(T currentState) throws IllegalStateException, IllegalArgumentException {
        if (!this.isUndoAvailable()) {
            throw new IllegalStateException("undo is currently not available");
        }
        if (currentState == null && this.currentState == null) {
            throw new IllegalArgumentException("currentState must not be null");
        }
        if (this.currentState == null) {
            this.currentState = this.cloneState(currentState);
        }
        this.currentStateIndex = this.currentStateIndex == -1 ? this.undoStack.size() - 1 : --this.currentStateIndex;
        return (T)this.cloneState((Undoable)this.undoStack.get(this.currentStateIndex));
    }

    public T performRedo() throws IllegalStateException {
        Object redoState;
        if (!this.isRedoAvailable()) {
            throw new IllegalStateException("redo is currently not available");
        }
        if (this.currentStateIndex == this.undoStack.size() - 1) {
            redoState = this.cloneState(this.currentState);
            this.currentState = null;
            this.resetIndex();
        } else {
            ++this.currentStateIndex;
            redoState = this.cloneState((Undoable)this.undoStack.get(this.currentStateIndex));
        }
        return redoState;
    }

    public void clear() {
        this.undoStack.clear();
        this.resetIndex();
    }

    public static interface Undoable<T> {
        public T getClone();
    }
}

