/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib.internal;

import hgb.lib.HGBaseLog;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ClassFactory {
    private ClassFactory() {
    }

    public static <T> T createClass(String classPath, Class<T> classType, String errorName) {
        return ClassFactory.createClass(classPath, classType, errorName, null, null);
    }

    public static <T> T createClass(String classPath, Class<T> classType, String errorName, Class<?>[] classes, Object[] params) {
        StringBuilder errorConstr = new StringBuilder();
        try {
            Class<?> c = ClassLoader.getSystemClassLoader().loadClass(classPath);
            T o = null;
            if (params != null && params.length > 0 && classes != null && classes.length == params.length) {
                int i = 0;
                while (i < classes.length) {
                    if (i > 0) {
                        errorConstr.append(", ");
                    }
                    errorConstr.append(classes[i].getName());
                    ++i;
                }
                Constructor<?> constr = c.getConstructor(classes);
                o = (T)constr.newInstance(params);
            } else {
                o = (T)c.newInstance();
            }
            if (classType.isInstance(o)) {
                return o;
            }
            HGBaseLog.logWarn("The " + errorName + " class " + classPath + " has wrong type (need " + classType.getName() + ")!");
        }
        catch (ClassNotFoundException e) {
            HGBaseLog.logWarn("The " + errorName + " class " + classPath + " was not found!");
        }
        catch (NoSuchMethodException | SecurityException e) {
            HGBaseLog.logWarn("The " + errorName + " class " + classPath + " does not implement the demanded constructor (" + errorConstr.toString() + ")!");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            HGBaseLog.logWarn("Could not create " + errorName + " class " + classPath + "!");
        }
        return null;
    }
}

