/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib.xml;

import hgb.lib.HGBaseFileTools;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseTools;
import hgb.lib.Pair;
import hgb.lib.TriConsumer;
import hgb.lib.xml.ChildNodeIterator;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class HGBaseXMLTools {
    private static final String MAP_ENTRY_NODE_KEY = "mapentry";
    private static final String KEY_NODE_KEY = "key";
    private static final String VALUE_NODE_KEY = "value";

    private HGBaseXMLTools() {
    }

    public static Element readXML(String file) {
        InputStream in = HGBaseFileTools.openApplicationFileStream(file, new HGBaseXMLTools());
        try {
            DocumentBuilder build = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = build.parse(in);
            Element element = doc.getDocumentElement();
            return element;
        }
        catch (IOException | IllegalArgumentException | ParserConfigurationException | SAXException e) {
            HGBaseLog.logError("Error when reading xml file '" + file + "': " + e.getMessage());
        }
        finally {
            HGBaseFileTools.closeStream(in);
        }
        return null;
    }

    public static Element readXML(InputStream stream) {
        try {
            DocumentBuilder build = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = build.parse(stream);
            if (doc != null) {
                return doc.getDocumentElement();
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            HGBaseLog.logWarn(e.getMessage());
        }
        return null;
    }

    public static boolean writeXML(Document doc, String file) {
        if (doc != null && file != null) {
            try {
                String fileToWrite = HGBaseXMLTools.prepareFileToWrite(file);
                String content = HGBaseXMLTools.transformDocument(doc, true);
                FileOutputStream fout = new FileOutputStream(fileToWrite);
                fout.write(content.getBytes(HGBaseXMLTools.getEncoding()));
                fout.close();
                return true;
            }
            catch (IOException | TransformerException | TransformerFactoryConfigurationError throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static String prepareFileToWrite(String fileName) {
        try {
            File f = null;
            f = fileName.startsWith("/") || fileName.startsWith("\\") || fileName.contains(":") ? new File(fileName).getAbsoluteFile() : new File(HGBaseFileTools.getCurrentDir(), fileName);
            File parentDir = f.getParentFile();
            if (!parentDir.isDirectory() && !f.getParentFile().mkdirs()) {
                HGBaseLog.logError("Could not create directory: " + String.valueOf(parentDir));
            }
            return f.getAbsolutePath();
        }
        catch (SecurityException securityException) {
            return fileName;
        }
    }

    public static String getAttributeValue(Node node, String attribute) {
        Node name;
        if (node != null && node.getAttributes() != null && (name = node.getAttributes().getNamedItem(attribute)) != null) {
            return name.getNodeValue();
        }
        return "";
    }

    public static int getAttributeIntValue(Node node, String attribute) {
        return HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, attribute));
    }

    public static int getAttributeIntValue(Node node, String attribute, int defaultValue) {
        return HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, attribute), defaultValue);
    }

    public static long getAttributeLongValue(Node node, String attribute) {
        return HGBaseTools.toLong(HGBaseXMLTools.getAttributeValue(node, attribute));
    }

    public static long getAttributeLongValue(Node node, String attribute, long defaultValue) {
        return HGBaseTools.toLong(HGBaseXMLTools.getAttributeValue(node, attribute), defaultValue);
    }

    public static boolean getAttributeBooleanValue(Node node, String attribute) {
        return HGBaseTools.toBoolean(HGBaseXMLTools.getAttributeValue(node, attribute));
    }

    public static boolean getAttributeBooleanValue(Node node, String attribute, boolean defaultValue) {
        String value = HGBaseXMLTools.getAttributeValue(node, attribute);
        return HGBaseTools.hasContent(value) ? HGBaseTools.toBoolean(value) : defaultValue;
    }

    public static Color getAttributeRGBColorValue(Node node, String attribute) {
        String value = HGBaseXMLTools.getAttributeValue(node, attribute);
        try {
            int r = Integer.parseInt(value.substring(0, 2), 16);
            int g = Integer.parseInt(value.substring(2, 4), 16);
            int b = Integer.parseInt(value.substring(4, 6), 16);
            return new Color(r, g, b);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return null;
        }
    }

    public static Color getAttributeRGBColorValue(Node node, String attribute, Color defaultValue) {
        Color color = HGBaseXMLTools.getAttributeRGBColorValue(node, attribute);
        if (color == null) {
            color = defaultValue;
        }
        return color;
    }

    public static String getNodeValue(Node node) {
        Node text = node.getFirstChild();
        if (text != null) {
            return text.getNodeValue();
        }
        return "";
    }

    public static void setNodeValue(Element node, String value) {
        node.setTextContent(value);
    }

    public static String transformDocument(Document newDoc, boolean indent) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        transformer.setOutputProperty("indent", indent ? "yes" : "no");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", HGBaseXMLTools.getEncoding());
        transformer.transform(new DOMSource(newDoc), new StreamResult(output));
        try {
            return output.toString(HGBaseXMLTools.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            HGBaseLog.logWarn("The character set '" + HGBaseXMLTools.getEncoding() + "' is not supported!");
            return output.toString();
        }
    }

    public static Document createDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (FactoryConfigurationError | ParserConfigurationException throwable) {
            return null;
        }
    }

    public static Element createElement(Document doc, Element parent, String name) {
        Element node = doc.createElement(name);
        if (parent == null) {
            doc.appendChild(node);
        } else {
            parent.appendChild(node);
        }
        return node;
    }

    public static String getEncoding() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("windows") >= 0) {
            return "ISO-8859-1";
        }
        if (os.indexOf("linux") >= 0) {
            return "UTF-8";
        }
        return System.getProperty("file.encoding");
    }

    public static <T> void writeCollection(Document doc, Element parent, String collectionName, String elementName, Collection<T> collection, BiConsumer<Element, T> elementWriter) {
        if (!HGBaseTools.hasContent(collectionName)) {
            throw new IllegalArgumentException("The specified collection name must not be empty!");
        }
        Element collectionNode = HGBaseXMLTools.createElement(doc, parent, collectionName);
        if (collection == null || collection.isEmpty()) {
            return;
        }
        if (!HGBaseTools.hasContent(elementName)) {
            throw new IllegalArgumentException("The specified element name must not be empty!");
        }
        collection.forEach(element2 -> elementWriter.accept(HGBaseXMLTools.createElement(doc, collectionNode, elementName), element2));
    }

    public static <T> Collection<T> readCollection(Node parent, final String collectionName, final String elementName, Supplier<Collection<T>> collectionSupplier, final Function<Node, T> elementReader) {
        if (!HGBaseTools.hasContent(collectionName)) {
            throw new IllegalArgumentException("The specified collection name must not be empty!");
        }
        if (!HGBaseTools.hasContent(elementName)) {
            throw new IllegalArgumentException("The specified element name must not be empty!");
        }
        final Collection<T> collection = collectionSupplier.get();
        ChildNodeIterator.run(new ChildNodeIterator(parent, null, collection){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (!collectionName.equals(node.getNodeName())) {
                    return;
                }
                ChildNodeIterator.run(new ChildNodeIterator(node, null, obj){

                    @Override
                    public void performNode(Node node, int index, Object obj) {
                        if (!elementName.equals(node.getNodeName())) {
                            return;
                        }
                        collection.add(elementReader.apply(node));
                    }
                });
            }
        });
        return collection;
    }

    public static <K, V> void writeMap(Document doc, Element parent, String mapName, Map<K, V> map, TriConsumer<Element, K, V> entryWriter) {
        Element mapNode = HGBaseXMLTools.createElement(doc, parent, mapName);
        if (map == null || map.isEmpty()) {
            return;
        }
        map.forEach((key, value) -> entryWriter.accept(mapNode, key, value));
    }

    public static <K, V> void writeMap(Document doc, Element parent, String mapName, Map<K, V> map, BiConsumer<Element, K> keyWriter, BiConsumer<Element, V> valueWriter) {
        HGBaseXMLTools.writeMap(doc, parent, mapName, map, (mapNode, key, value) -> {
            Element entryNode = HGBaseXMLTools.createElement(doc, mapNode, MAP_ENTRY_NODE_KEY);
            keyWriter.accept(HGBaseXMLTools.createElement(doc, entryNode, KEY_NODE_KEY), key);
            valueWriter.accept(HGBaseXMLTools.createElement(doc, entryNode, VALUE_NODE_KEY), value);
        });
    }

    public static <K, V> Map<K, V> readMap(Node parent, final String mapName, Supplier<Map<K, V>> mapSupplier, final Function<Node, Set<Pair<K, V>>> elementReader) {
        if (!HGBaseTools.hasContent(mapName)) {
            throw new IllegalArgumentException("The specified map name must not be empty!");
        }
        final Map<K, V> map = mapSupplier.get();
        ChildNodeIterator.run(new ChildNodeIterator(parent, null, map){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (!mapName.equals(node.getNodeName())) {
                    return;
                }
                ((Set)elementReader.apply(node)).forEach(entry -> {
                    Object s = map.put(entry.getFirst(), entry.getSecond());
                });
            }
        });
        return map;
    }

    public static <K, V> Map<K, V> readMap(Node parent, final String mapName, Supplier<Map<K, V>> mapSupplier, final Function<Node, K> keyReader, final Function<Node, V> valueReader) {
        if (!HGBaseTools.hasContent(mapName)) {
            throw new IllegalArgumentException("The specified map name must not be empty!");
        }
        final Map<K, V> map = mapSupplier.get();
        ChildNodeIterator.run(new ChildNodeIterator(parent, null, map){

            @Override
            public void performNode(Node mapNode, int index, Object obj) {
                if (!mapName.equals(mapNode.getNodeName())) {
                    return;
                }
                ChildNodeIterator.run(new ChildNodeIterator(mapNode, null, obj){

                    @Override
                    public void performNode(Node entryNode, int index, Object obj) {
                        if (!HGBaseXMLTools.MAP_ENTRY_NODE_KEY.equals(entryNode.getNodeName())) {
                            return;
                        }
                        final Pair pair = new Pair();
                        ChildNodeIterator.run(new ChildNodeIterator(entryNode, null, obj){

                            @Override
                            public void performNode(Node node, int index, Object obj) {
                                switch (node.getNodeName()) {
                                    case "key": {
                                        pair.setFirst(keyReader.apply(node));
                                        break;
                                    }
                                    case "value": {
                                        pair.setSecond(valueReader.apply(node));
                                        break;
                                    }
                                }
                            }
                        });
                        map.put(pair.getFirst(), pair.getSecond());
                    }
                });
            }
        });
        return map;
    }
}

