/*
 * Decompiled with CFR 0.152.
 */
package tjger;

import hgb.gui.HGBaseFrame;
import hgb.gui.HGBasePanel;
import hgb.gui.HGBaseWelcome;
import hgb.gui.menu.HGBaseMenu;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseSound;
import hgb.lib.HGBaseTools;
import hgb.lib.xml.HGBaseXMLTools;
import java.io.File;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tjger.MainMenu;
import tjger.MainPanel;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;
import tjger.gui.GameDialogs;
import tjger.gui.GamePanel;
import tjger.gui.internal.GameDialogFactory;
import tjger.gui.internal.TjgerWelcome;
import tjger.lib.GameConfigurationException;

public abstract class MainFrame
extends HGBaseFrame {
    private static final long serialVersionUID = -6001461502596300390L;
    private MainPanel mainPanel;
    private final GameManager gameManager;
    private final TjgerWelcome welcomePanel;
    private final long startTime = new Date().getTime();

    public MainFrame(String settingsFile) throws GameConfigurationException {
        this(settingsFile, false);
    }

    protected MainFrame(String settingsFile, boolean ignoreGameConfigErrors) throws GameConfigurationException {
        super(settingsFile, true);
        this.setVisible(false);
        int logMode = HGBaseLog.getLogMode();
        if (ignoreGameConfigErrors) {
            HGBaseLog.setLogMode(0);
        }
        HGBaseSound.setErrorMode(1);
        this.welcomePanel = TjgerWelcome.getInstance();
        this.gameManager = GameManager.createInstance(this);
        HGBaseWelcome.getInstance().removeWelcomeScreen();
        HGBaseLog.setLogMode(logMode);
        if (this.gameManager.getGameConfig().hasErrors() && !ignoreGameConfigErrors) {
            this.welcomePanel.setVisible(false);
            throw new GameConfigurationException();
        }
    }

    public GameManager getGameManager() {
        return this.gameManager;
    }

    @Override
    @Deprecated
    public void setPanel(HGBasePanel p) {
        this.fadeOutWelcomePanel();
        super.setPanel(p);
        if (p instanceof MainPanel) {
            this.mainPanel = (MainPanel)p;
        }
    }

    public void setPanels(MainPanel mainPanel, GamePanel gamePanel) {
        this.fadeOutWelcomePanel();
        this.mainPanel = mainPanel;
        this.mainPanel.setGamePanel(gamePanel);
        super.setPanel(this.mainPanel);
        this.blockMenuActions(true);
        this.showHintsDialog("application");
        this.blockMenuActions(false);
    }

    protected void blockMenuActions(boolean block) {
        MainMenu m = this.getMainMenu();
        if (m != null) {
            m.setBlockActions(block);
        }
    }

    private void fadeOutWelcomePanel() {
        if (this.welcomePanel.isValid()) {
            int welcomeTimeout = this.gameManager.getGameConfig().getWelcomeImageTimeOut();
            long diff = (long)welcomeTimeout - (new Date().getTime() - this.startTime);
            try {
                if (diff > 0L) {
                    Thread.sleep(diff);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.welcomePanel.setVisible(false);
    }

    public void showHintsDialog(String hintType) {
        GameConfig config = this.getGameManager().getGameConfig();
        if (!HGBaseConfig.getBoolean("hint.dontshow") && HGBaseTools.hasContent(config.getHintsSetting(hintType))) {
            GameDialogs dlg = GameDialogFactory.getInstance().createGameDialogs();
            GameEngine engine = this.getGameManager().getGameEngine();
            dlg.showGameHintsDialog(this, hintType, engine, config);
        }
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    public GamePanel getGamePanel() {
        if (this.mainPanel != null) {
            return this.mainPanel.getGamePanel();
        }
        return null;
    }

    public MainMenu getMainMenu() {
        HGBaseMenu menu = this.getMenu();
        return menu instanceof MainMenu ? (MainMenu)menu : null;
    }

    @Override
    public int onFileNew() {
        int numPlayers = this.getGameManager().getNewGameInformationInt("gameinfo.numplayers");
        if (numPlayers < 0) {
            numPlayers = 0;
        }
        int ret = this.getGameManager().getGameEngine().startGame(numPlayers);
        this.getGamePanel().repaint();
        return ret;
    }

    @Override
    public int onFileClose() {
        this.getGameManager().getGameEngine().stopGame();
        return super.onFileClose();
    }

    @Override
    public int onFileOpen(File file) {
        Element root = HGBaseXMLTools.readXML(file.getPath());
        return root == null ? -10706 : this.getGameManager().loadGame(root);
    }

    @Override
    public int onFileSave(File file) {
        Document doc = HGBaseXMLTools.createDocument();
        if (doc == null) {
            return -10705;
        }
        int ret = this.getGameManager().saveGame(doc);
        if (ret == 0 && !HGBaseXMLTools.writeXML(doc, file.getPath())) {
            ret = -10705;
        }
        return ret;
    }

    public void playAudio(String sound) {
        if (!HGBaseConfig.getBoolean("nosound")) {
            HGBaseSound.playAudio(sound);
        }
    }

    @Override
    public void actualizeText() {
        super.actualizeText();
        GamePanel panel = this.getGamePanel();
        if (panel != null) {
            panel.actualizeText();
        }
    }

    @Override
    public void actualizeLaf() {
        super.actualizeLaf();
        GamePanel panel = this.getGamePanel();
        if (panel != null) {
            panel.actualizeLaf();
        }
    }
}

