/*
 * Decompiled with CFR 0.152.
 */
package tjger;

import hgb.gui.HGBaseDialog;
import hgb.gui.HGBaseStatusBar;
import hgb.gui.config.HGBaseConfigMenuCheckBox;
import hgb.gui.config.HGBaseConfigRadioGroup;
import hgb.gui.menu.HGBaseMenu;
import hgb.gui.menu.HGBaseMenuItem;
import hgb.gui.menu.HGBaseMenuRadioButton;
import hgb.gui.menu.HGBaseMenuTools;
import hgb.gui.menu.HGBaseSeparator;
import hgb.gui.menu.HGBaseSubMenu;
import hgb.gui.menu.MenuBuilder;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import tjger.MainFrame;
import tjger.MainPanel;
import tjger.MainStatusBar;
import tjger.game.GamePlayer;
import tjger.game.GameState;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;
import tjger.game.internal.GameStatistics;
import tjger.game.internal.PlayerProfiles;
import tjger.gui.GameDialogs;
import tjger.gui.NewGameDialog;
import tjger.gui.actions.RefreshPanelAction;
import tjger.gui.actions.ShowGameHintsDlgAction;
import tjger.gui.actions.ShowGameInfoDlgAction;
import tjger.gui.actions.ShowGameInstructionsDlgAction;
import tjger.gui.actions.ShowNetworkDlgAction;
import tjger.gui.actions.ShowPartsDlgAction;
import tjger.gui.actions.ShowProfilesDlgAction;
import tjger.gui.actions.ShowSoundSettingsDlgAction;
import tjger.gui.actions.ShowTjgerDlgAction;
import tjger.gui.actions.TjgerFileExitAction;
import tjger.gui.actions.TjgerFileNewAction;
import tjger.gui.actions.TjgerFileNextAction;
import tjger.gui.internal.GameDialogFactory;
import tjger.gui.internal.NetworkDlg;
import tjger.gui.internal.SpecialRadioMenu;
import tjger.gui.internal.ZoomMenu;

public class MainMenu
extends HGBaseMenu {
    public static final String MENU_ID_FILE_NEXT = "file.next";
    public static final String MENU_ID_FILE_GAMEINFO = "file.gameinfo";
    public static final String MENU_ID_FILE_PROFILES = "file.profiles";
    public static final String MENU_ID_HELP_TJGER = "help.tjger";
    public static final String MENU_ID_HELP_INSTRUCTIONS = "help.instructions";
    public static final String MENU_ID_HELP_GAMEHINTS = "help.gamehints";
    public static final String MENU_ID_SETTINGS_NETWORK = "settings.network";
    public static final String MENU_ID_SETTINGS_PARTS = "settings.parts";
    public static final String MENU_ID_SETTINGS_DRAWREFLECTIONS = "settings.drawreflections";
    public static final String MENU_ID_SETTINGS_DRAWSHADOWS = "settings.drawshadows";
    public static final String MENU_ID_SETTINGS_SOUNDS = "settings.sounds";
    private static final long serialVersionUID = 854371071L;
    static final StatePanelMenu STATEPANEL_MENU = new StatePanelMenu();
    static final GameSpeedMenu GAMESPEED_MENU = new GameSpeedMenu();
    private final ZoomMenu zoomMenu = new ZoomMenu(this);
    protected boolean blockActions = false;

    public MainMenu(MainFrame frame) {
        super(frame);
        this.registerAction(MENU_ID_SETTINGS_DRAWSHADOWS, new RefreshPanelAction(this));
        this.registerAction(MENU_ID_SETTINGS_DRAWREFLECTIONS, new RefreshPanelAction(this));
        this.registerAction(MENU_ID_SETTINGS_PARTS, new ShowPartsDlgAction(this));
        this.registerAction(MENU_ID_SETTINGS_NETWORK, new ShowNetworkDlgAction(this));
        this.registerAction(MENU_ID_SETTINGS_SOUNDS, new ShowSoundSettingsDlgAction(this));
        this.registerAction(MENU_ID_HELP_TJGER, new ShowTjgerDlgAction(this));
        this.registerAction("file.exit", new TjgerFileExitAction(this));
        this.registerAction("file.new", new TjgerFileNewAction(this));
        this.registerAction(MENU_ID_FILE_NEXT, new TjgerFileNextAction(this));
        this.registerAction(MENU_ID_FILE_GAMEINFO, new ShowGameInfoDlgAction(this));
        this.registerAction(MENU_ID_FILE_PROFILES, new ShowProfilesDlgAction(this));
        this.registerAction(MENU_ID_HELP_INSTRUCTIONS, new ShowGameInstructionsDlgAction(this));
        this.registerAction(MENU_ID_HELP_GAMEHINTS, new ShowGameHintsDlgAction(this));
    }

    public MainFrame getTjgerMainFrame() {
        return (MainFrame)this.getMainFrame();
    }

    public GameManager getGameManager() {
        return ((MainFrame)this.getMainFrame()).getGameManager();
    }

    @Override
    protected boolean handleSpecialMenu(String menuType, HGBaseSubMenu subMenu, String shortcut) {
        if (super.handleSpecialMenu(menuType, subMenu, shortcut)) {
            return true;
        }
        if (STATEPANEL_MENU.getMenuType().equals(menuType)) {
            this.createSpecialRadioMenu(subMenu, STATEPANEL_MENU);
            return true;
        }
        if (GAMESPEED_MENU.getMenuType().equals(menuType)) {
            this.createSpecialRadioMenu(subMenu, GAMESPEED_MENU);
            this.setGameSpeed();
            return true;
        }
        return false;
    }

    public void createSpecialRadioMenu(HGBaseSubMenu subMenu, SpecialRadioMenu<?> radioMenu) {
        String options = HGBaseTools.toStringText(radioMenu.getOptions(), ";");
        HGBaseConfigRadioGroup rbGroup = new MenuBuilder(this).buildRadioGroup(subMenu, options, radioMenu.getMenuType(), radioMenu.getShortcuts());
        if (rbGroup != null) {
            rbGroup.setValue(HGBaseConfig.get(radioMenu.getMenuType(), radioMenu.getDefaultOption()));
        }
    }

    @Override
    public void setFileMenuStates() {
        super.setFileMenuStates();
        if (this.isNetworkGame()) {
            HGBaseMenuTools.setMenuItemEnabled(this.getMainFrame(), "file.save", false);
            HGBaseMenuTools.setMenuItemEnabled(this.getMainFrame(), "file.saveas", false);
        }
    }

    @Override
    public void onAction(String id, ActionEvent e) {
        if (!this.blockActions) {
            if (id.startsWith("zoom.")) {
                this.zoomMenu.onAction(id, e);
            } else if (id.startsWith(STATEPANEL_MENU.getMenuType())) {
                MainPanel panel = (MainPanel)this.getMainFrame().getPanel();
                panel.repositionStatePanel();
            } else if (id.startsWith(GAMESPEED_MENU.getMenuType())) {
                this.setGameSpeed();
            } else {
                super.onAction(id, e);
            }
        }
    }

    public boolean onFileNext() {
        if (this.getGameManager().getGameEngine().isClientGame()) {
            HGBaseDialog.printError("err.networkclientnot", (JFrame)this.getMainFrame());
            return false;
        }
        if (this.getGameManager().getGameEngine().isServerGame()) {
            int ret = this.getGameManager().getGameEngine().nextNetworkGame();
            if (ret == 0) {
                return true;
            }
            if (ret != -2147483631) {
                HGBaseDialog.printError(ret, (JFrame)this.getMainFrame());
            }
            return false;
        }
        GamePlayer[] active = this.getGameManager().getGameEngine().getActivePlayers();
        if (active != null) {
            GamePlayer[] newPlayer = (GamePlayer[])active.clone();
            if (this.onFileClose()) {
                this.getMainFrame().setFile(new File(""));
                this.getGameManager().getGameEngine().setActivePlayers(newPlayer);
                if (this.getGameManager().getGameEngine().newGame() == 0) {
                    return true;
                }
            }
        }
        return false;
    }

    public void showNetworkSettings() {
        GameConfig config = this.getGameManager().getGameConfig();
        if (config.getNetworkPort() > 0) {
            NetworkDlg dlg = new NetworkDlg(this.getMainFrame());
            dlg.show();
        } else {
            HGBaseLog.logError("No valid network port defined!");
        }
    }

    public void showGameInstructionsDialog() {
        GameDialogs dlg = GameDialogFactory.getInstance().createGameDialogs();
        dlg.showGameInstructionsDialog((MainFrame)this.getMainFrame());
    }

    public void showGameHintsDialog() {
        GameDialogs dlg = GameDialogFactory.getInstance().createGameDialogs();
        GameConfig config = this.getGameManager().getGameConfig();
        GameEngine engine = this.getGameManager().getGameEngine();
        dlg.showGameHintsDialog((MainFrame)this.getMainFrame(), null, engine, config);
    }

    public void showProfilesDialog() {
        GameDialogs dlg = GameDialogFactory.getInstance().createGameDialogs();
        PlayerProfiles profiles = PlayerProfiles.getInstance();
        if (profiles.isRememberProfiles()) {
            dlg.showPlayerProfilesDialog((MainFrame)this.getMainFrame(), profiles);
        } else {
            HGBaseLog.logError("No valid path at fileProfile setting!");
        }
    }

    public void showGameInfoDialog() {
        GameDialogs dlg = GameDialogFactory.getInstance().createGameDialogs();
        GameConfig config = this.getGameManager().getGameConfig();
        GameEngine engine = this.getGameManager().getGameEngine();
        GameState state = engine.getGameState();
        GameStatistics statistics = this.getGameManager().getGameStatistics();
        PlayerProfiles playerProfiles = this.getGameManager().getPlayerProfiles();
        dlg.showGameInfoDialog((MainFrame)this.getMainFrame(), config, engine, state, statistics, playerProfiles);
    }

    public boolean showNewGameDialog() {
        if (!this.onFileClose()) {
            return false;
        }
        this.setFileMenuStates();
        NewGameDialog dlg = GameDialogFactory.getInstance().createNewDialog(this.getMainFrame());
        if (dlg != null && dlg.show()) {
            PlayerProfiles profiles = this.getGameManager().getPlayerProfiles();
            GamePlayer[] remove = dlg.getProfilesToRemove();
            int i = 0;
            while (remove != null && i < remove.length) {
                profiles.removeProfile(remove[i]);
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onFileOpen() {
        if (!this.onFileClose()) {
            return false;
        }
        return super.onFileOpen();
    }

    @Override
    public boolean askForSaving() {
        return this.askForSaving(0);
    }

    @Override
    protected boolean askForSaving(int initial) {
        if (this.isNetworkGame()) {
            if (this.getGameManager().getGameEngine().isActiveGame()) {
                int result = HGBaseDialog.showConfirmDialog(this.getMainFrame(), (Object)HGBaseText.getText("dlg.fileclose", new String[0]), HGBaseSettings.get("appName"), 2);
                return result == 0;
            }
            return true;
        }
        return super.askForSaving(initial);
    }

    @Override
    public boolean onFileSave() {
        if (this.isNetworkGame()) {
            HGBaseDialog.printError("err.networksave", (JFrame)this.getMainFrame());
            return false;
        }
        return super.onFileSave();
    }

    @Override
    public boolean onFileSaveAs() {
        if (this.isNetworkGame()) {
            HGBaseDialog.printError("err.networksave", (JFrame)this.getMainFrame());
            return false;
        }
        return super.onFileSaveAs();
    }

    protected boolean isNetworkGame() {
        return this.getGameManager().getGameEngine().isNetworkGame();
    }

    public void refreshMainPanel() {
        MainPanel panel = this.getTjgerMainFrame().getMainPanel();
        if (panel != null) {
            panel.refresh();
        }
        if (HGBaseConfig.getBoolean("zoom.fitwindow")) {
            this.setZoomFitToWindow();
        }
    }

    public void onZoomChanged() {
        HGBaseStatusBar status = this.getMainFrame().getStatusBar();
        if (status instanceof MainStatusBar) {
            ((MainStatusBar)status).actualizeZoomValue();
        }
    }

    public int getZoom() {
        return this.zoomMenu.getZoom();
    }

    public void setZoom(int newZoom) {
        this.zoomMenu.setZoom(newZoom);
    }

    public void setZoomFitToWindow() {
        this.zoomMenu.onFitWindow();
    }

    public HGBaseSubMenu getZoomMenu() {
        return this.zoomMenu.getMenu();
    }

    public JPopupMenu getZoomPopupMenu() {
        HGBaseSubMenu menu = this.cloneMenu(this.getZoomMenu());
        if (menu != null) {
            return menu.getPopupMenu();
        }
        return null;
    }

    private HGBaseSubMenu cloneMenu(HGBaseSubMenu zoomMenu) {
        if (zoomMenu != null) {
            Component[] entries;
            HGBaseSubMenu menu = (HGBaseSubMenu)zoomMenu.clone();
            Component[] componentArray = entries = zoomMenu.getMenuComponents();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                Component entry = componentArray[n2];
                Component newItem = this.getMenuEntryComponent(entry);
                if (newItem != null) {
                    if (newItem instanceof JMenuItem) {
                        ((JMenuItem)newItem).addActionListener(this);
                    }
                    menu.add(newItem);
                }
                ++n2;
            }
            return menu;
        }
        return null;
    }

    private Component getMenuEntryComponent(Component entry) {
        if (entry instanceof HGBaseSubMenu) {
            return (Component)((HGBaseSubMenu)entry).clone();
        }
        if (entry instanceof HGBaseSeparator) {
            return (Component)((HGBaseSeparator)entry).clone();
        }
        if (entry instanceof HGBaseMenuRadioButton) {
            return (Component)((HGBaseMenuRadioButton)entry).clone();
        }
        if (entry instanceof HGBaseConfigMenuCheckBox) {
            return (Component)((HGBaseConfigMenuCheckBox)entry).clone();
        }
        if (entry instanceof HGBaseMenuItem) {
            return (Component)((HGBaseMenuItem)entry).clone();
        }
        if (entry instanceof JSeparator) {
            return new JSeparator(((JSeparator)entry).getOrientation());
        }
        return null;
    }

    protected boolean isBlockActions() {
        return this.blockActions;
    }

    protected void setBlockActions(boolean blockActions) {
        this.blockActions = blockActions;
    }

    private void setGameSpeed() {
        String option = HGBaseConfig.get(GAMESPEED_MENU.getMenuType(), GAMESPEED_MENU.getDefaultOption());
        GameConfig.getInstance().setGameSpeedFactor(GAMESPEED_MENU.getValue(option));
    }

    static class GameSpeedMenu
    implements SpecialRadioMenu<Double> {
        private static final String GAMESPEED_CONFIG = "gamespeed";
        private static final String GAMESPEED_SLOW = "gamespeed.slow";
        private static final String GAMESPEED_NORMAL = "gamespeed.normal";
        private static final String GAMESPEED_FAST = "gamespeed.fast";
        private static final Map<String, Double> GAMESPEED_OPTIONS = new LinkedHashMap<String, Double>();
        private static final String GAMESPEED_SHORTCUTS = "Alt+1;Alt+2;Alt+3";
        private static final String GAMESPEED_DEFAULT = "gamespeed.normal";

        static {
            GAMESPEED_OPTIONS.put(GAMESPEED_SLOW, 2.0);
            GAMESPEED_OPTIONS.put("gamespeed.normal", 1.0);
            GAMESPEED_OPTIONS.put(GAMESPEED_FAST, 0.5);
        }

        GameSpeedMenu() {
        }

        @Override
        public String getMenuType() {
            return GAMESPEED_CONFIG;
        }

        @Override
        public String[] getOptions() {
            return GAMESPEED_OPTIONS.keySet().toArray(new String[GAMESPEED_OPTIONS.size()]);
        }

        @Override
        public Double getValue(String option) {
            return GAMESPEED_OPTIONS.get(option);
        }

        @Override
        public String getDefaultOption() {
            return "gamespeed.normal";
        }

        @Override
        public String getShortcuts() {
            return GAMESPEED_SHORTCUTS;
        }
    }

    static class StatePanelMenu
    implements SpecialRadioMenu<String> {
        private static final String STATEPANEL_CONFIG = "statepanel";
        private static final String STATEPANEL_BOTTOM = "statepanel.bottom";
        private static final String STATEPANEL_TOP = "statepanel.top";
        private static final String STATEPANEL_LEFT = "statepanel.left";
        private static final String STATEPANEL_RIGHT = "statepanel.right";
        private static final String STATEPANEL_NONE = "statepanel.none";
        private static final Map<String, String> STATEPANEL_OPTIONS = new LinkedHashMap<String, String>();
        private static final String STATEPANEL_SHORTCUTS = "Ctrl+1;Ctrl+2;Ctrl+3;Ctrl+4;Ctrl+5";
        private static final String STATEPANEL_DEFAULT = "statepanel.bottom";

        static {
            STATEPANEL_OPTIONS.put("statepanel.bottom", "South");
            STATEPANEL_OPTIONS.put(STATEPANEL_TOP, "North");
            STATEPANEL_OPTIONS.put(STATEPANEL_LEFT, "West");
            STATEPANEL_OPTIONS.put(STATEPANEL_RIGHT, "East");
            STATEPANEL_OPTIONS.put(STATEPANEL_NONE, null);
        }

        StatePanelMenu() {
        }

        @Override
        public String getMenuType() {
            return STATEPANEL_CONFIG;
        }

        @Override
        public String[] getOptions() {
            return STATEPANEL_OPTIONS.keySet().toArray(new String[STATEPANEL_OPTIONS.size()]);
        }

        @Override
        public String getValue(String option) {
            return STATEPANEL_OPTIONS.get(option);
        }

        @Override
        public String getDefaultOption() {
            return "statepanel.bottom";
        }

        @Override
        public String getShortcuts() {
            return STATEPANEL_SHORTCUTS;
        }
    }
}

