/*
 * Decompiled with CFR 0.152.
 */
package tjger;

import hgb.gui.HGBasePanel;
import hgb.gui.HGBaseStatusBar;
import hgb.gui.menu.HGBaseSubMenu;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import tjger.MainFrame;
import tjger.MainMenu;
import tjger.game.completed.GameConfig;

public class MainStatusBar
extends HGBaseStatusBar {
    private static final long serialVersionUID = 854371073L;
    private final MainFrame mainFrame;
    private int zoomIndex;

    public MainStatusBar(int[] panelWidth, MainFrame frame) {
        super(panelWidth);
        this.mainFrame = frame;
        this.zoomIndex = -1;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void actualizeZoomValue() {
        if (this.zoomIndex != -1) {
            MainMenu menu = this.mainFrame.getMainMenu();
            int zoom = menu != null ? menu.getZoom() : GameConfig.getInstance().getActiveZoom();
            this.setText(this.zoomIndex, zoom + "%");
        }
    }

    public void setZoomPanel(int index) {
        JLabel lbZoom = this.getLabel(index);
        if (lbZoom != null) {
            this.zoomIndex = index;
            lbZoom.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent ev) {
                    if (ev.getButton() == 1 && ev.getClickCount() == 2) {
                        MainStatusBar.this.mainFrame.getMainMenu().onAction("zoom.variable", null);
                    } else if (ev.getButton() == 3) {
                        HGBaseSubMenu zoomMenu = MainStatusBar.this.mainFrame.getMainMenu().getZoomMenu();
                        JPopupMenu popup = MainStatusBar.this.mainFrame.getMainMenu().getZoomPopupMenu();
                        if (zoomMenu != null && popup != null) {
                            int xPos = ev.getX() - zoomMenu.getWidth();
                            int yPos = ev.getY() - zoomMenu.getHeight() * zoomMenu.getMenuComponentCount() - 10;
                            popup.show(ev.getComponent(), xPos, yPos);
                        }
                    }
                }
            });
            this.actualizeZoomValue();
        }
    }

    public void setZoomPanel(int index, JLabel zoomPanel) {
        HGBasePanel pn = this.getPanel(index);
        if (pn != null) {
            this.zoomIndex = index;
            pn.remove(this.getLabel(index));
            pn.add(zoomPanel);
            this.actualizeZoomValue();
        }
    }
}

