/*
 * Decompiled with CFR 0.152.
 */
package tjger.game;

import tjger.game.GamePlayer;
import tjger.game.GameState;
import tjger.game.MoveInformation;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;
import tjger.lib.ScoreUtil;

public abstract class GameRules {
    protected GameManager getGameManager() {
        return GameManager.getInstance();
    }

    protected GameConfig getGameConfig() {
        return GameManager.getInstance().getGameConfig();
    }

    protected GameEngine getGameEngine() {
        return GameManager.getInstance().getGameEngine();
    }

    public GamePlayer getGameStartPlayer(GameState gameState) {
        return this.getGameEngine().getCyclingFirstGamePlayer();
    }

    public abstract GamePlayer getStartPlayer(GameState var1);

    public abstract GamePlayer getNextPlayer(GamePlayer var1, GameState var2);

    public abstract boolean isTurnFinished(GameState var1);

    public abstract boolean isRoundFinished(GameState var1);

    public abstract boolean isGameFinished(GameState var1);

    public abstract void doScoring(GamePlayer[] var1, GameState var2);

    public int[] getTurnRanking(GamePlayer[] playerToRank) {
        return ScoreUtil.getScoreRanking(playerToRank, 1);
    }

    public int[] getRoundRanking(GamePlayer[] playerToRank) {
        return ScoreUtil.getScoreRanking(playerToRank, 2);
    }

    public int[] getGameRanking(GamePlayer[] playerToRank) {
        return ScoreUtil.getScoreRanking(playerToRank, 4);
    }

    public abstract boolean isValidMove(MoveInformation var1, GameState var2);
}

