/*
 * Decompiled with CFR 0.152.
 */
package tjger.game;

import hgb.gui.HGBaseDialog;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import tjger.game.GamePlayer;
import tjger.game.MoveInformation;
import tjger.game.completed.GameEngine;
import tjger.net.NetworkClientConnection;
import tjger.net.NetworkServerConnection;

public class NetworkPlayer
extends GamePlayer {
    Thread playThread;

    public NetworkPlayer(String playerType, String playerName, ImageIcon playerImage, String pieceColor) {
        super(playerType, playerName, playerImage, pieceColor);
    }

    @Override
    public void considerMove() {
        this.playThread = new Thread(){

            @Override
            public void run() {
                if (NetworkPlayer.this.getGameEngine().isServerGame()) {
                    NetworkPlayer.this.doServerAction();
                } else if (NetworkPlayer.this.getGameEngine().isClientGame()) {
                    NetworkPlayer.this.doClientAction();
                }
            }
        };
        this.playThread.start();
    }

    protected void doServerAction() {
        StringBuffer msg;
        MoveInformation move = null;
        NetworkServerConnection netServer = this.getGameEngine().getNetworkServer();
        if (netServer != null && netServer.waitForClientMoveInformation(msg = new StringBuffer(""), this)) {
            move = this.getGameState().fromNetworkStringMove(msg.toString());
        }
        this.doNetworkMove(move);
    }

    protected void doClientAction() {
        MoveInformation move = null;
        NetworkClientConnection netClient = this.getGameEngine().getNetworkClient();
        if (netClient != null) {
            StringBuffer msg = new StringBuffer("");
            if (netClient.waitForServerGameInformation("TJxMI", msg, this)) {
                move = this.getGameState().fromNetworkStringMove(msg.toString());
            } else if (netClient.messageServerNextGame()) {
                return;
            }
        }
        this.doNetworkMove(move);
    }

    protected void doNetworkMove(MoveInformation move) {
        if (move != null && this.getGameRules().isValidMove(move, this.getGameState())) {
            this.performMove(move);
        } else {
            GameEngine engine = this.getGameEngine();
            if (move != null || engine.isNetworkGame() && !engine.isStopGameProcessing() && !engine.isNextGameProcessing()) {
                engine.closeNetworkGame();
                HGBaseDialog.printError(-30307, (JFrame)this.getGameManager().getMainFrame());
            }
        }
    }
}

