/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed;

import hgb.gui.HGBaseGuiTools;
import hgb.lib.HGBaseFileTools;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseSound;
import hgb.lib.HGBaseTools;
import hgb.lib.internal.ClassFactory;
import hgb.lib.internal.IntBooleanStringMap;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import java.awt.Color;
import java.awt.Insets;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.game.completed.GameConfig;
import tjger.game.completed.PartSetConstructor;
import tjger.game.completed.SoundSetConstructor;
import tjger.game.completed.imagereader.AbstractImageEffectReader;
import tjger.game.completed.imagereader.ImageReflectionReader;
import tjger.game.completed.imagereader.ImageShodawReader;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.PlayingFieldFileOperator;
import tjger.game.completed.playingfield.PlayingFieldManager;
import tjger.game.internal.PlayerFactory;
import tjger.game.internal.RulesFactory;
import tjger.game.internal.StateFactory;
import tjger.gui.completed.Arrangement;
import tjger.gui.completed.Background;
import tjger.gui.completed.Board;
import tjger.gui.completed.Card;
import tjger.gui.completed.CardSet;
import tjger.gui.completed.ColorValuePart;
import tjger.gui.completed.Cover;
import tjger.gui.completed.GameElement;
import tjger.gui.completed.ImageEffect;
import tjger.gui.completed.Part;
import tjger.gui.completed.PartSet;
import tjger.gui.completed.Piece;
import tjger.gui.completed.PieceSet;
import tjger.gui.completed.Sound;
import tjger.gui.completed.SoundArrangement;
import tjger.gui.completed.SoundSet;
import tjger.gui.completed.configurablelayout.layoutelement.AreaLayout;
import tjger.gui.completed.configurablelayout.layoutelement.CardsetLayout;
import tjger.gui.completed.configurablelayout.layoutelement.LayoutElement;
import tjger.gui.completed.configurablelayout.layoutelement.PartLayout;
import tjger.gui.completed.configurablelayout.layoutelement.PartsetLayout;
import tjger.gui.completed.configurablelayout.layoutelement.PiecesetLayout;
import tjger.gui.completed.configurablelayout.layoutelement.PlayerInfoLayout;
import tjger.gui.internal.GameDialogFactory;
import tjger.gui.internal.TjgerWelcome;
import tjger.lib.ConstantValue;

class GameConfigFileReader {
    private static final String CONFIG_TJGER = "tjger";
    private static final String CONFIG_WELCOME = "welcome";
    private static final String CONFIG_WELCOME_TIMEOUT = "timeout";
    static final String CONFIG_NAME = "name";
    static final String CONFIG_IMAGE = "image";
    private static final String CONFIG_CLASS = "class";
    private static final String CONFIG_SETTINGS = "settings";
    private static final String CONFIG_RULES = "rules";
    private static final String CONFIG_HINTS = "hints";
    private static final String CONFIG_NETWORK = "network";
    private static final String CONFIG_PORT = "port";
    private static final String CONFIG_LOCAL = "local";
    private static final String CONFIG_GAMESTATE = "gamestate";
    private static final String CONFIG_XML_ROOT = "xmlroot";
    private static final String CONFIG_GAMES = "games";
    private static final String CONFIG_GAME = "game";
    private static final String CONFIG_ROUND = "round";
    private static final String CONFIG_TURN = "turn";
    private static final String CONFIG_MOVE = "move";
    private static final String CONFIG_NEWGAME = "newgame";
    private static final String CONFIG_NEWROUND = "newround";
    private static final String CONFIG_NEWTURN = "newturn";
    private static final String CONFIG_AFTERMOVE = "aftermove";
    private static final String CONFIG_GAMEDIALOGS = "gamedialogs";
    private static final String CONFIG_INFODIALOGS = "infodialogs";
    private static final String CONFIG_NEWGAMEDIALOG = "newgamedialog";
    private static final String CONFIG_ASKTOSAVE = "asktosave";
    private static final String CONFIG_CHANGED = "changed";
    private static final String CONFIG_RECORD = "record";
    private static final String CONFIG_STATISTICS = "statistics";
    private static final String CONFIG_SCORES = "scores";
    private static final String CONFIG_HIGHSCORE = "highscore";
    private static final String CONFIG_ONLYFIRST = "onlyfirst";
    private static final String CONFIG_LOWERSCOREISBETTER = "lowerscoreisbetter";
    private static final String CONFIG_SCROLLWHEN = "scrollwhen";
    private static final String CONFIG_ZOOM = "zoom";
    private static final String CONFIG_IGNOREZOOM = "ignorezoom";
    private static final String CONFIG_PATH = "path";
    static final String CONFIG_TYPE = "type";
    static final String CONFIG_VALUE = "value";
    private static final String CONFIG_FALSE = "false";
    private static final String CONFIG_TRUE = "true";
    private static final String CONFIG_DEFAULT = "default";
    private static final String CONFIG_DELAY = "delay";
    private static final String CONFIG_INTERRUPT = "interrupt";
    private static final String CONFIG_HIDDEN = "hidden";
    private static final String CONFIG_ORDERBY = "orderby";
    private static final String CONFIG_MIN = "min";
    private static final String CONFIG_MAX = "max";
    private static final String CONFIG_ORDER = "order";
    private static final String CONFIG_CLOCKWISE = "clockwise";
    private static final String CONFIG_COUNTERCLOCKWISE = "counterclockwise";
    private static final String CONFIG_ANTICLOCKWISE = "anticlockwise";
    private static final String CONFIG_EXTENSION = "extension";
    private static final String CONFIG_COMPLETE = "complete";
    private static final String CONFIG_PLAYERS = "players";
    private static final String CONFIG_ONEHUMAN = "onehuman";
    private static final String CONFIG_WITHOUTHUMAN = "withouthuman";
    private static final String CONFIG_PLAYER = "player";
    private static final String CONFIG_PLAYERIMAGE = "playerimage";
    private static final String CONFIG_GAMEFIELD = "gamefield";
    private static final String CONFIG_HEIGHT = "height";
    private static final String CONFIG_WIDTH = "width";
    private static final String CONFIG_HORIZONTAL_ALIGNMENT = "halign";
    private static final String CONFIG_VERTICAL_ALIGNMENT = "valign";
    private static final String CONFIG_BACKGROUNDS = "backgrounds";
    private static final String CONFIG_BACKGROUND = "background";
    private static final String CONFIG_FIXED = "fixed";
    private static final String CONFIG_REPEAT = "repeat";
    private static final String CONFIG_YPOS = "ypos";
    private static final String CONFIG_XPOS = "xpos";
    private static final String CONFIG_BOARDS = "boards";
    private static final String CONFIG_BOARD = "board";
    private static final String CONFIG_PIECESET = "pieceset";
    private static final String CONFIG_PIECES = "pieces";
    private static final String CONFIG_PIECE = "piece";
    private static final String CONFIG_PIECECOLOR = "piececolor";
    static final String CONFIG_CARDSET = "cardset";
    private static final String CONFIG_CARDS = "cards";
    private static final String CONFIG_CARD = "card";
    private static final String CONFIG_COVERS = "covers";
    private static final String CONFIG_COVER = "cover";
    private static final String CONFIG_PARTSET = "partset";
    private static final String CONFIG_PARTS = "parts";
    private static final String CONFIG_PART = "part";
    private static final String CONFIG_EXT_PART = ".part";
    private static final String CONFIG_EXTEND = "extend";
    private static final String CONFIG_PARTCLASS = "partclass";
    private static final String CONFIG_SETCLASS = "setclass";
    private static final String CONFIG_CVPCLASS = "cvpclass";
    private static final String CONFIG_COLORS = "colors";
    static final String CONFIG_COLOR = "color";
    private static final String CONFIG_ARRANGEMENTS = "arrangements";
    private static final String CONFIG_ARRANGEMENT = "arrangement";
    private static final String CONFIG_PLAYING_FIELDS = "playingfields";
    private static final String CONFIG_PLAYING_FIELD = "playingfield";
    public static final String CONFIG_FILE = "file";
    private static final String CONFIG_GAMEFIELDLAYOUT = "gamefieldlayout";
    private static final String CONFIG_AREAS = "areas";
    private static final String CONFIG_AREA = "area";
    private static final String CONFIG_ELEMENTS = "elements";
    private static final String CONFIG_PERCENTSIZE = "percentsize";
    private static final String CONFIG_XSPACING = "xspacing";
    private static final String CONFIG_YSPACING = "yspacing";
    private static final String CONFIG_ORIENTATION = "orientation";
    private static final String CONFIG_WRAPTHRESHOLD = "wrapthreshold";
    private static final String CONFIG_MARGIN_TOP = "margintop";
    private static final String CONFIG_MARGIN_BOTTOM = "marginbottom";
    private static final String CONFIG_MARGIN_LEFT = "marginleft";
    private static final String CONFIG_MARGIN_RIGHT = "marginright";
    private static final String CONFIG_PLAYER_INDEX = "playerindex";
    private static final String CONFIG_ANGLE = "angle";
    private static final String CONFIG_PLAYER_INFO = "playerinfo";
    private static final String CONFIG_FONTSIZE = "fontsize";
    private static final String CONFIG_COVERED = "covered";
    public static final String CONFIG_SOUNDSET = "soundset";
    public static final String CONFIG_SOUNDS = "sounds";
    public static final String CONFIG_SOUND = "sound";
    private static final String CONFIG_SOUND_ARRANGEMENTS = "soundarrangements";
    private static final String CONFIG_SOUND_ARRANGEMENT = "soundarrangement";
    public static final String CONFIG_SEQUENCE = "sequence";
    public static final String CONFIG_SEQUENCE_START = "sequencestart";
    public static final String CONFIG_SEQUENCE_END = "sequenceend";
    private static List<Background> backgroundList = new ArrayList<Background>();
    private static List<Board> boardList = new ArrayList<Board>();
    private static List<Cover> coverList = new ArrayList<Cover>();
    private static List<PieceSet> pieceSetList = new ArrayList<PieceSet>();
    private static List<Arrangement> arrangementList = new ArrayList<Arrangement>();
    private static List<SoundArrangement> soundArrangementList = new ArrayList<SoundArrangement>();
    private static Map<String, AbstractImageEffectReader<? extends ImageEffect>> effectReaders = new HashMap<String, AbstractImageEffectReader<? extends ImageEffect>>();

    static {
        effectReaders.put("shadow", new ImageShodawReader());
        effectReaders.put("reflection", new ImageReflectionReader());
    }

    GameConfigFileReader() {
    }

    public static void read(GameConfig config) {
        GameConfigFileReader.initConfigValues(config);
        String fileName = HGBaseSettings.get("fileTjger");
        Element root = HGBaseXMLTools.readXML(fileName);
        if (root == null) {
            config.hasErrors = true;
            HGBaseLog.logError("The game configuration file '" + fileName + "' was not found or is not xml conform!");
        } else {
            ChildNodeIterator.run(new ChildNodeIterator(root, CONFIG_TJGER, config){

                @Override
                public void performNode(Node node, int index, Object obj) {
                    GameConfig config = (GameConfig)obj;
                    switch (node.getNodeName()) {
                        case "settings": {
                            GameConfigFileReader.readSettings(node, config);
                            config.loadTjgerImage();
                            TjgerWelcome.getInstance().setGameConfig(config);
                            break;
                        }
                        case "players": {
                            GameConfigFileReader.readPlayers(node, config);
                            break;
                        }
                        case "backgrounds": {
                            GameConfigFileReader.readBackgrounds(node, config);
                            break;
                        }
                        case "boards": {
                            GameConfigFileReader.readBoards(node, config);
                            break;
                        }
                        case "covers": {
                            GameConfigFileReader.readCovers(node, config);
                            break;
                        }
                        case "cards": {
                            GameConfigFileReader.readCardSets(node, config);
                            break;
                        }
                        case "pieces": {
                            GameConfigFileReader.readPieceSets(node, config);
                            break;
                        }
                        case "parts": {
                            GameConfigFileReader.readParts(node, config);
                            break;
                        }
                        case "colors": {
                            GameConfigFileReader.readColors(node, config);
                            break;
                        }
                        case "arrangements": {
                            GameConfigFileReader.readArrangements(node, config);
                            break;
                        }
                        case "sounds": {
                            GameConfigFileReader.readSounds(node, config);
                            break;
                        }
                        case "soundarrangements": {
                            GameConfigFileReader.readSoundArrangements(node, config);
                            break;
                        }
                        case "playingfields": {
                            GameConfigFileReader.readPlayingFields(node);
                            break;
                        }
                        case "gamefieldlayout": {
                            GameConfigFileReader.readGameFieldLayout(node, config);
                        }
                    }
                }
            });
            config.backgrounds = backgroundList.toArray(new Background[backgroundList.size()]);
            config.boards = boardList.toArray(new Board[boardList.size()]);
            config.covers = coverList.toArray(new Cover[coverList.size()]);
            config.pieceSets = pieceSetList.toArray(new PieceSet[pieceSetList.size()]);
            config.arrangements = arrangementList.toArray(new Arrangement[arrangementList.size()]);
            config.soundArrangements = soundArrangementList.toArray(new SoundArrangement[0]);
            GameConfigFileReader.testForErrors(config);
        }
    }

    private static void fillElementInformation(String elementType, Node node, GameConfig config) {
        config.extensionMap.put(elementType, HGBaseXMLTools.getAttributeValue(node, CONFIG_EXTENSION));
        config.pathMap.put(elementType, HGBaseXMLTools.getAttributeValue(node, CONFIG_PATH));
    }

    protected static void readPlayingFields(Node node) {
        final PlayingFieldManager manager = PlayingFieldManager.getInstance();
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_PLAYING_FIELDS, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                String fileName;
                if (GameConfigFileReader.CONFIG_PLAYING_FIELD.equals(node.getNodeName()) && HGBaseTools.hasContent(fileName = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_FILE))) {
                    InputStream in = HGBaseFileTools.openApplicationFileStream(fileName, this);
                    PlayingField field = PlayingFieldFileOperator.fromStream(in);
                    if (field != null) {
                        String name = HGBaseFileTools.getFileName(fileName, false);
                        manager.addField(name, field);
                    }
                    HGBaseFileTools.closeStream(in);
                }
            }
        });
    }

    protected static void readArrangements(Node node, GameConfig config) {
        config.completeArrangement = HGBaseXMLTools.getAttributeValue(node, CONFIG_COMPLETE).equals(CONFIG_TRUE);
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_ARRANGEMENTS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (GameConfigFileReader.CONFIG_ARRANGEMENT.equals(node.getNodeName())) {
                    GameConfigFileReader.readArrangement(node);
                }
            }
        });
    }

    protected static void readArrangement(Node node) {
        String name = HGBaseXMLTools.getAttributeValue(node, CONFIG_NAME);
        String back = HGBaseXMLTools.getAttributeValue(node, CONFIG_BACKGROUND);
        String board = HGBaseXMLTools.getAttributeValue(node, CONFIG_BOARD);
        String pieceset = HGBaseXMLTools.getAttributeValue(node, CONFIG_PIECESET);
        String cover = HGBaseXMLTools.getAttributeValue(node, CONFIG_COVER);
        String cardset = HGBaseXMLTools.getAttributeValue(node, CONFIG_CARDSET);
        Arrangement newArrangement = new Arrangement(name, back, board, pieceset, cover, cardset);
        arrangementList.add(newArrangement);
        GameConfigFileReader.readArrangementParts(node, newArrangement);
    }

    protected static void readArrangementParts(Node node, Arrangement arrangement) {
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_ARRANGEMENT, arrangement){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfigFileReader.readArrangementPart(node, (Arrangement)obj);
            }
        });
    }

    protected static void readArrangementPart(Node node, Arrangement arrangement) {
        String type = HGBaseXMLTools.getAttributeValue(node, CONFIG_TYPE);
        String value = HGBaseXMLTools.getAttributeValue(node, CONFIG_VALUE);
        if (HGBaseTools.hasContent(type) && HGBaseTools.hasContent(value)) {
            int rgb;
            String nodeName = node.getNodeName();
            if (CONFIG_PART.equals(nodeName)) {
                arrangement.setPart(type, value);
            }
            if (CONFIG_PARTSET.equals(nodeName)) {
                arrangement.setPartSet(type, value);
            }
            if (CONFIG_CARDSET.equals(nodeName)) {
                arrangement.setCardSet(type, value);
            }
            if (CONFIG_COLOR.equals(nodeName) && (rgb = HGBaseTools.toInt(value)) != -2147483631) {
                arrangement.setColor(type, new Color(rgb));
            }
        }
    }

    protected static void readSounds(Node node, GameConfig config) {
        GameConfigFileReader.fillElementInformation(CONFIG_SOUND, node, config);
        GameConfigFileReader.fillElementInformation(CONFIG_SOUNDSET, node, config);
        config.helpHidden = GameConfigFileReader.isHiddenEntry(node);
        GameConfigFileReader.readUserDefinesSounds(node, config);
        GameConfigFileReader.readUserDefinesSoundSets(node, config);
    }

    protected static void readUserDefinesSounds(Node node, GameConfig config) {
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_SOUNDS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config = (GameConfig)obj;
                if (GameConfigFileReader.CONFIG_SOUND.equals(node.getNodeName())) {
                    GameConfigFileReader.readUserDefinedSound(node, config);
                }
            }
        });
    }

    protected static void readUserDefinedSound(Node node, GameConfig config) {
        String name = HGBaseXMLTools.getAttributeValue(node, CONFIG_NAME);
        String type = HGBaseXMLTools.getAttributeValue(node, CONFIG_TYPE);
        if (!HGBaseTools.hasContent(type)) {
            HGBaseLog.logWarn("No type defined for sound '" + name + "'!");
            return;
        }
        String soundFilename = HGBaseXMLTools.getAttributeValue(node, CONFIG_FILE);
        if (!HGBaseTools.hasContent(soundFilename)) {
            soundFilename = GameConfigFileReader.calculateElementFilename(CONFIG_SOUND, name, config);
        }
        boolean hidden = GameConfigFileReader.isHiddenPart(node, config);
        if (!HGBaseSound.isValidAudioFile(soundFilename)) {
            HGBaseLog.logWarn("File " + soundFilename + " is not a valid audio file!");
            return;
        }
        List listSound = GameConfigFileReader.getListFromMap(config.soundMap, type);
        listSound.add(new Sound(type, name, soundFilename, hidden));
    }

    protected static void readUserDefinesSoundSets(Node node, GameConfig config) {
        SoundSetConstructor.construct(node, config);
    }

    protected static void readSoundArrangements(Node node, GameConfig config) {
        config.completeSoundArrangement = HGBaseXMLTools.getAttributeBooleanValue(node, CONFIG_COMPLETE, false);
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_SOUND_ARRANGEMENTS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (GameConfigFileReader.CONFIG_SOUND_ARRANGEMENT.equals(node.getNodeName())) {
                    GameConfigFileReader.readSoundArrangement(node);
                }
            }
        });
    }

    protected static void readSoundArrangement(Node node) {
        String name = HGBaseXMLTools.getAttributeValue(node, CONFIG_NAME);
        SoundArrangement newSoundArrangement = new SoundArrangement(name);
        soundArrangementList.add(newSoundArrangement);
        GameConfigFileReader.readSoundArrangementSounds(node, newSoundArrangement);
    }

    protected static void readSoundArrangementSounds(Node node, SoundArrangement soundArrangement) {
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_SOUND_ARRANGEMENT, soundArrangement){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfigFileReader.readSoundArrangementSound(node, (SoundArrangement)obj);
            }
        });
    }

    protected static void readSoundArrangementSound(Node node, SoundArrangement soundArrangement) {
        String type = HGBaseXMLTools.getAttributeValue(node, CONFIG_TYPE);
        String value = HGBaseXMLTools.getAttributeValue(node, CONFIG_VALUE);
        if (!HGBaseTools.hasContent(type) || !HGBaseTools.hasContent(value)) {
            return;
        }
        String nodeName = node.getNodeName();
        if (CONFIG_SOUND.equals(nodeName)) {
            soundArrangement.setSound(type, value);
        } else if (CONFIG_SOUNDSET.equals(nodeName)) {
            soundArrangement.setSoundSet(type, value);
        }
    }

    protected static void readGameFieldLayout(Node node, final GameConfig config) {
        int marginTop = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_MARGIN_TOP, 0);
        int marginBottom = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_MARGIN_BOTTOM, 0);
        int marginLeft = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_MARGIN_LEFT, 0);
        int marginRight = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_MARGIN_RIGHT, 0);
        config.setGamefieldLayoutMargin(new Insets(marginTop, marginLeft, marginBottom, marginRight));
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_GAMEFIELDLAYOUT, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                switch (node.getNodeName()) {
                    case "areas": {
                        GameConfigFileReader.readGameFieldLayoutAreas(node, config);
                        break;
                    }
                    case "elements": {
                        GameConfigFileReader.readGameFieldLayoutElements(node, config);
                        break;
                    }
                }
            }
        });
    }

    protected static void readGameFieldLayoutAreas(Node node, final GameConfig config) {
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_AREAS, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                AreaLayout layoutArea;
                if (GameConfigFileReader.CONFIG_AREA.equals(node.getNodeName()) && (layoutArea = GameConfigFileReader.readGameFieldLayoutArea(node)) != null) {
                    config.addLayoutElement(AreaLayout.class, layoutArea.getElementKey(), layoutArea);
                }
            }
        });
    }

    protected static AreaLayout readGameFieldLayoutArea(Node node) {
        String name = HGBaseXMLTools.getAttributeValue(node, CONFIG_NAME);
        if (!HGBaseTools.hasContent(name)) {
            return null;
        }
        String xpos = HGBaseXMLTools.getAttributeValue(node, CONFIG_XPOS);
        String ypos = HGBaseXMLTools.getAttributeValue(node, CONFIG_YPOS);
        String width = HGBaseXMLTools.getAttributeValue(node, CONFIG_WIDTH);
        String height = HGBaseXMLTools.getAttributeValue(node, CONFIG_HEIGHT);
        String marginTop = HGBaseXMLTools.getAttributeValue(node, CONFIG_MARGIN_TOP);
        String marginBottom = HGBaseXMLTools.getAttributeValue(node, CONFIG_MARGIN_BOTTOM);
        String marginLeft = HGBaseXMLTools.getAttributeValue(node, CONFIG_MARGIN_LEFT);
        String marginRight = HGBaseXMLTools.getAttributeValue(node, CONFIG_MARGIN_RIGHT);
        boolean hidden = HGBaseXMLTools.getAttributeBooleanValue(node, CONFIG_HIDDEN, true);
        return new AreaLayout(name, xpos, ypos, width, height, marginTop, marginBottom, marginLeft, marginRight, hidden);
    }

    protected static void readGameFieldLayoutElements(Node node, final GameConfig config) {
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_ELEMENTS, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                switch (node.getNodeName()) {
                    case "part": {
                        PartLayout layoutPart = GameConfigFileReader.readGameFieldLayoutPart(node, config);
                        config.addLayoutElement(PartLayout.class, layoutPart.getElementKey(), layoutPart);
                        break;
                    }
                    case "partset": {
                        PartsetLayout layoutPartset = GameConfigFileReader.readGameFieldLayoutPartset(node, config);
                        config.addLayoutElement(PartsetLayout.class, layoutPartset.getElementKey(), layoutPartset);
                        break;
                    }
                    case "cardset": {
                        CardsetLayout layoutCardset = GameConfigFileReader.readGameFieldLayoutCardset(node, config);
                        config.addLayoutElement(CardsetLayout.class, layoutCardset.getElementKey(), layoutCardset);
                        break;
                    }
                    case "pieceset": {
                        PiecesetLayout layoutPieceset = GameConfigFileReader.readGameFieldLayoutPieceset(node, config);
                        config.addLayoutElement(PiecesetLayout.class, layoutPieceset.getElementKey(), layoutPieceset);
                        break;
                    }
                    case "playerinfo": {
                        PlayerInfoLayout layoutPlayerInfo = GameConfigFileReader.readGameFieldLayoutPlayerInfo(node, config);
                        config.addLayoutElement(PlayerInfoLayout.class, layoutPlayerInfo.getElementKey(), layoutPlayerInfo);
                        break;
                    }
                }
            }
        });
    }

    protected static PartLayout readGameFieldLayoutPart(Node node, GameConfig config) {
        String type = HGBaseXMLTools.getAttributeValue(node, CONFIG_TYPE);
        String xpos = HGBaseXMLTools.getAttributeValue(node, CONFIG_XPOS);
        String ypos = HGBaseXMLTools.getAttributeValue(node, CONFIG_YPOS);
        String percentSize = HGBaseXMLTools.getAttributeValue(node, CONFIG_PERCENTSIZE);
        int angle = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_ANGLE, 0);
        AreaLayout area = config.getLayoutArea(HGBaseXMLTools.getAttributeValue(node, CONFIG_AREA));
        return new PartLayout(type, xpos, ypos, percentSize, angle, area);
    }

    protected static PartsetLayout readGameFieldLayoutPartset(Node node, GameConfig config) {
        String type = HGBaseXMLTools.getAttributeValue(node, CONFIG_TYPE);
        String xpos = HGBaseXMLTools.getAttributeValue(node, CONFIG_XPOS);
        String ypos = HGBaseXMLTools.getAttributeValue(node, CONFIG_YPOS);
        String percentSize = HGBaseXMLTools.getAttributeValue(node, CONFIG_PERCENTSIZE);
        int angle = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_ANGLE, 0);
        AreaLayout area = config.getLayoutArea(HGBaseXMLTools.getAttributeValue(node, CONFIG_AREA));
        int xSpacing = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_XSPACING, 0);
        int ySpacing = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_YSPACING, 0);
        String orientation = HGBaseXMLTools.getAttributeValue(node, CONFIG_ORIENTATION);
        int wrapThreshold = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_WRAPTHRESHOLD, 0);
        return new PartsetLayout(type, xpos, ypos, percentSize, angle, area, xSpacing, ySpacing, orientation, wrapThreshold);
    }

    protected static CardsetLayout readGameFieldLayoutCardset(Node node, GameConfig config) {
        String type = HGBaseXMLTools.getAttributeValue(node, CONFIG_TYPE);
        int playerIndex = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_PLAYER_INDEX, -1);
        String xpos = HGBaseXMLTools.getAttributeValue(node, CONFIG_XPOS);
        String ypos = HGBaseXMLTools.getAttributeValue(node, CONFIG_YPOS);
        String percentSize = HGBaseXMLTools.getAttributeValue(node, CONFIG_PERCENTSIZE);
        int angle = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_ANGLE, 0);
        AreaLayout area = config.getLayoutArea(HGBaseXMLTools.getAttributeValue(node, CONFIG_AREA));
        int xSpacing = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_XSPACING, 0);
        int ySpacing = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_YSPACING, 0);
        String orientation = HGBaseXMLTools.getAttributeValue(node, CONFIG_ORIENTATION);
        int wrapThreshold = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_WRAPTHRESHOLD, 0);
        boolean covered = HGBaseXMLTools.getAttributeBooleanValue(node, CONFIG_COVERED, false);
        return new CardsetLayout(HGBaseTools.hasContent(type) ? type : "game.cardset", playerIndex, xpos, ypos, percentSize, angle, area, xSpacing, ySpacing, orientation, wrapThreshold, covered);
    }

    protected static PiecesetLayout readGameFieldLayoutPieceset(Node node, GameConfig config) {
        String xpos = HGBaseXMLTools.getAttributeValue(node, CONFIG_XPOS);
        String ypos = HGBaseXMLTools.getAttributeValue(node, CONFIG_YPOS);
        String percentSize = HGBaseXMLTools.getAttributeValue(node, CONFIG_PERCENTSIZE);
        int angle = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_ANGLE, 0);
        AreaLayout area = config.getLayoutArea(HGBaseXMLTools.getAttributeValue(node, CONFIG_AREA));
        int xSpacing = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_XSPACING, 0);
        int ySpacing = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_YSPACING, 0);
        String orientation = HGBaseXMLTools.getAttributeValue(node, CONFIG_ORIENTATION);
        int wrapThreshold = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_WRAPTHRESHOLD, 0);
        return new PiecesetLayout(xpos, ypos, percentSize, angle, area, xSpacing, ySpacing, orientation, wrapThreshold);
    }

    protected static PlayerInfoLayout readGameFieldLayoutPlayerInfo(Node node, GameConfig config) {
        String type = HGBaseXMLTools.getAttributeValue(node, CONFIG_TYPE);
        int playerIndex = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_PLAYER_INDEX, -1);
        String xpos = HGBaseXMLTools.getAttributeValue(node, CONFIG_XPOS);
        String ypos = HGBaseXMLTools.getAttributeValue(node, CONFIG_YPOS);
        String fontSize = HGBaseXMLTools.getAttributeValue(node, CONFIG_FONTSIZE);
        Color color = HGBaseXMLTools.getAttributeRGBColorValue(node, CONFIG_COLOR);
        int angle = HGBaseXMLTools.getAttributeIntValue(node, CONFIG_ANGLE, 0);
        AreaLayout area = config.getLayoutArea(HGBaseXMLTools.getAttributeValue(node, CONFIG_AREA));
        return new PlayerInfoLayout(type, playerIndex, xpos, ypos, fontSize, color, angle, area);
    }

    protected static boolean isHiddenEntry(Node node) {
        return HGBaseXMLTools.getAttributeValue(node, CONFIG_HIDDEN).equals(CONFIG_TRUE);
    }

    protected static boolean isVisibleEntry(Node node) {
        return HGBaseXMLTools.getAttributeValue(node, CONFIG_HIDDEN).equals(CONFIG_FALSE);
    }

    protected static boolean isHiddenPart(Node node, GameConfig config) {
        return config.helpHidden && !GameConfigFileReader.isVisibleEntry(node) || GameConfigFileReader.isHiddenEntry(node);
    }

    static <T extends GameElement> List<T> getListFromMap(Map<String, List<T>> map, String type) {
        List<T> list = map.get(type);
        if (list != null) {
            return list;
        }
        ArrayList newList = new ArrayList();
        map.put(type, newList);
        return newList;
    }

    protected static void readParts(Node node, final GameConfig config) {
        GameConfigFileReader.fillElementInformation(CONFIG_PART, node, config);
        GameConfigFileReader.fillElementInformation(CONFIG_PARTSET, node, config);
        final Map<String, ImageEffect> topLevelEffects = GameConfigFileReader.readEffectsFromNode(node);
        config.helpHidden = GameConfigFileReader.isHiddenEntry(node);
        GameConfigFileReader.readExtendedParts(node, config);
        GameConfigFileReader.readNormalParts(node, config, topLevelEffects);
        new PartSetConstructor<PartSet>(CONFIG_PARTS, CONFIG_PARTSET, CONFIG_PART, config.partSetMap){

            @Override
            protected PartSet createPartSet(String type, String name, boolean hidden, Node node) {
                String setClass = config.extendPartSetMap.get(type);
                PartSet newPartSet = null;
                if (setClass != null) {
                    Class[] classes = new Class[]{String.class, String.class, Boolean.TYPE};
                    Object[] params = new Object[]{type, name, hidden};
                    newPartSet = ClassFactory.createClass(setClass, PartSet.class, GameConfigFileReader.CONFIG_SETCLASS, classes, params);
                }
                if (newPartSet == null) {
                    newPartSet = new PartSet(type, name, hidden);
                }
                GameConfigFileReader.setEffectsForPart(newPartSet, node, topLevelEffects);
                return newPartSet;
            }

            @Override
            protected ColorValuePart createColorValuePart(PartSet set, String color, int sequence, int value, ImageIcon image, Node node) {
                String partType = set.getType() + GameConfigFileReader.CONFIG_EXT_PART;
                String cvpClass = config.extendCvpMap.get(set.getType());
                ColorValuePart newCVP = null;
                if (cvpClass != null) {
                    Class[] classes = new Class[]{PartSet.class, String.class, String.class, Integer.TYPE, Integer.TYPE, ImageIcon.class};
                    Object[] params = new Object[]{set, partType, color, sequence, value, image};
                    newCVP = ClassFactory.createClass(cvpClass, ColorValuePart.class, GameConfigFileReader.CONFIG_CVPCLASS, classes, params);
                }
                if (newCVP == null) {
                    newCVP = new ColorValuePart(set, partType, color, sequence, value, image);
                }
                GameConfigFileReader.setEffectsForPart(newCVP, node, set);
                return newCVP;
            }
        }.run(node, config);
    }

    protected static void readExtendedParts(Node node, GameConfig config) {
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_PARTS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config = (GameConfig)obj;
                if (GameConfigFileReader.CONFIG_EXTEND.equals(node.getNodeName())) {
                    String type = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_TYPE);
                    String partClass = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_PARTCLASS);
                    String setClass = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_SETCLASS);
                    String cvpClass = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_CVPCLASS);
                    if (!partClass.isEmpty()) {
                        config.extendPartMap.put(type, partClass);
                    }
                    if (!setClass.isEmpty()) {
                        config.extendPartSetMap.put(type, setClass);
                    }
                    if (!cvpClass.isEmpty()) {
                        config.extendCvpMap.put(type, cvpClass);
                    }
                }
            }
        });
    }

    protected static void readNormalParts(Node node, GameConfig config, final Map<String, ImageEffect> topLevelEffects) {
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_PARTS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config = (GameConfig)obj;
                if (GameConfigFileReader.CONFIG_PART.equals(node.getNodeName())) {
                    GameConfigFileReader.readNormalPart(node, config, topLevelEffects);
                }
            }
        });
    }

    protected static void readNormalPart(Node node, GameConfig config, Map<String, ImageEffect> topLevelEffects) {
        String name = HGBaseXMLTools.getAttributeValue(node, CONFIG_NAME);
        String type = HGBaseXMLTools.getAttributeValue(node, CONFIG_TYPE);
        if (HGBaseTools.hasContent(type)) {
            String image = HGBaseXMLTools.getAttributeValue(node, CONFIG_IMAGE);
            if (!HGBaseTools.hasContent(image)) {
                image = GameConfigFileReader.calculateElementFilename(CONFIG_PART, name, config);
            }
            ImageIcon imgPart = HGBaseGuiTools.loadImage(image);
            boolean hidden = GameConfigFileReader.isHiddenPart(node, config);
            if (imgPart != null) {
                List listPart = GameConfigFileReader.getListFromMap(config.partMap, type);
                String partClass = config.extendPartMap.get(type);
                Part newPart = null;
                if (partClass != null) {
                    Class[] classes = new Class[]{String.class, String.class, ImageIcon.class, Boolean.TYPE};
                    Object[] params = new Object[]{type, name, imgPart, hidden};
                    newPart = ClassFactory.createClass(partClass, Part.class, CONFIG_PARTCLASS, classes, params);
                }
                if (newPart == null) {
                    newPart = new Part(type, name, imgPart, hidden);
                }
                GameConfigFileReader.setEffectsForPart(newPart, node, topLevelEffects);
                listPart.add(newPart);
            } else {
                HGBaseLog.logWarn("Part image " + image + " not found!");
            }
        } else {
            HGBaseLog.logWarn("No type defined for part '" + name + "'!");
        }
    }

    protected static void readColors(Node node, GameConfig config) {
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_COLORS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                String colorType;
                GameConfig config = (GameConfig)obj;
                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_COLOR) && HGBaseTools.hasContent(colorType = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_TYPE))) {
                    String defaultText = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_DEFAULT);
                    int rgb = HGBaseTools.toInt(defaultText);
                    Color defaultColor = rgb == -2147483631 ? null : new Color(rgb);
                    config.colors.put(colorType, defaultColor);
                }
            }
        });
    }

    protected static void readPieceSets(Node node, GameConfig config) {
        GameConfigFileReader.setOrderBy(config, "game.pieceset", node);
        GameConfigFileReader.fillElementInformation(CONFIG_PIECE, node, config);
        final Map<String, ImageEffect> topLevelEffects = GameConfigFileReader.readEffectsFromNode(node);
        config.helpHidden = GameConfigFileReader.isHiddenEntry(node);
        new PartSetConstructor<PieceSet>(CONFIG_PIECES, CONFIG_PIECESET, CONFIG_PIECE, pieceSetList){

            @Override
            protected PieceSet createPartSet(String type, String name, boolean hidden, Node node) {
                PieceSet pieceSetPart = new PieceSet(name, hidden);
                GameConfigFileReader.setEffectsForPart(pieceSetPart, node, topLevelEffects);
                return pieceSetPart;
            }

            @Override
            protected ColorValuePart createColorValuePart(PieceSet set, String color, int sequence, int value, ImageIcon image, Node node) {
                Piece piecePart = new Piece(set, color, sequence, value, image);
                GameConfigFileReader.setEffectsForPart(piecePart, node, set);
                return piecePart;
            }
        }.run(node, config);
    }

    static void setOrderBy(GameConfig config, String setType, Node node) {
        int currentOrder = config.getOrderby(setType);
        if (currentOrder < 0 || currentOrder == 0) {
            String modeText = HGBaseXMLTools.getAttributeValue(node, CONFIG_ORDERBY);
            int modeInt = 0;
            if (modeText.equals(CONFIG_VALUE)) {
                modeInt = 2;
            } else if (modeText.equals(CONFIG_COLOR)) {
                modeInt = 1;
            }
            config.setOrderBy.set(setType, modeInt);
        }
    }

    protected static void readCardSets(Node node, GameConfig config) {
        GameConfigFileReader.setOrderBy(config, "game.cardset", node);
        GameConfigFileReader.fillElementInformation(CONFIG_CARD, node, config);
        final Map<String, ImageEffect> topLevelEffects = GameConfigFileReader.readEffectsFromNode(node);
        config.helpHidden = GameConfigFileReader.isHiddenEntry(node);
        new PartSetConstructor<CardSet>(CONFIG_CARDS, CONFIG_CARDSET, CONFIG_CARD, config.cardSetsMap){

            @Override
            protected CardSet createPartSet(String type, String name, boolean hidden, Node node) {
                CardSet cardSetPart = new CardSet(type, name, hidden);
                GameConfigFileReader.setEffectsForPart(cardSetPart, node, topLevelEffects);
                return cardSetPart;
            }

            @Override
            protected ColorValuePart createColorValuePart(CardSet set, String color, int sequence, int value, ImageIcon image, Node node) {
                Card cardPart = new Card(set, color, sequence, value, image);
                GameConfigFileReader.setEffectsForPart(cardPart, node, set);
                return cardPart;
            }
        }.run(node, config);
        int defaultOrder = config.getOrderby("game.cardset");
        if (GameConfigFileReader.isDefinedOrder(defaultOrder)) {
            String[] cardTypes = config.getCardSetTypes();
            int i = 0;
            while (i < cardTypes.length) {
                int testOrder = config.getOrderby(cardTypes[i]);
                if (!GameConfigFileReader.isDefinedOrder(testOrder)) {
                    config.setOrderBy.set(cardTypes[i], defaultOrder);
                }
                ++i;
            }
        }
    }

    private static boolean isDefinedOrder(int defaultOrder) {
        return defaultOrder >= 0 && defaultOrder != 0;
    }

    protected static void readCovers(Node node, GameConfig config) {
        GameConfigFileReader.fillElementInformation(CONFIG_COVER, node, config);
        final Map<String, ImageEffect> topLevelEffects = GameConfigFileReader.readEffectsFromNode(node);
        config.helpHidden = GameConfigFileReader.isHiddenEntry(node);
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_COVERS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config = (GameConfig)obj;
                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_COVER)) {
                    String name = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_NAME);
                    String image = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_IMAGE);
                    if (!HGBaseTools.hasContent(image)) {
                        image = GameConfigFileReader.calculateElementFilename(GameConfigFileReader.CONFIG_COVER, name, config);
                    }
                    ImageIcon imgCover = HGBaseGuiTools.loadImage(image);
                    boolean hidden = GameConfigFileReader.isHiddenPart(node, config);
                    if (imgCover != null) {
                        Cover coverPart = new Cover(name, imgCover, hidden);
                        GameConfigFileReader.setEffectsForPart(coverPart, node, topLevelEffects);
                        coverList.add(coverPart);
                    } else {
                        HGBaseLog.logWarn("Cover image " + image + " not found!");
                    }
                }
            }
        });
    }

    protected static void readBoards(Node node, GameConfig config) {
        GameConfigFileReader.fillElementInformation(CONFIG_BOARD, node, config);
        final Map<String, ImageEffect> topLevelEffects = GameConfigFileReader.readEffectsFromNode(node);
        config.helpHidden = GameConfigFileReader.isHiddenEntry(node);
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_BOARDS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config = (GameConfig)obj;
                if (GameConfigFileReader.CONFIG_BOARD.equals(node.getNodeName())) {
                    GameConfigFileReader.readBoard(node, config, topLevelEffects);
                }
            }
        });
    }

    protected static void readBoard(Node node, GameConfig config, Map<String, ImageEffect> topLevelEffects) {
        int zoom;
        int yPos;
        String name = HGBaseXMLTools.getAttributeValue(node, CONFIG_NAME);
        String image = HGBaseXMLTools.getAttributeValue(node, CONFIG_IMAGE);
        if (!HGBaseTools.hasContent(image)) {
            image = GameConfigFileReader.calculateElementFilename(CONFIG_BOARD, name, config);
        }
        ImageIcon imgBoard = HGBaseGuiTools.loadImage(image);
        int xPos = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_XPOS));
        if (xPos == -2147483631) {
            xPos = 0;
        }
        if ((yPos = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_YPOS))) == -2147483631) {
            yPos = 0;
        }
        if ((zoom = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_ZOOM))) == -2147483631) {
            zoom = 100;
        }
        boolean hidden = GameConfigFileReader.isHiddenPart(node, config);
        if (imgBoard != null) {
            Board boardPart = new Board(name, imgBoard, xPos, yPos, hidden, zoom);
            GameConfigFileReader.setEffectsForPart((Part)boardPart, node, topLevelEffects);
            boardList.add(boardPart);
        } else {
            HGBaseLog.logWarn("Board image " + image + " not found!");
        }
    }

    protected static void readBackgrounds(Node node, GameConfig config) {
        GameConfigFileReader.fillElementInformation(CONFIG_BACKGROUND, node, config);
        final Map<String, ImageEffect> topLevelEffects = GameConfigFileReader.readEffectsFromNode(node);
        config.helpHidden = GameConfigFileReader.isHiddenEntry(node);
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_BACKGROUNDS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config = (GameConfig)obj;
                if (GameConfigFileReader.CONFIG_BACKGROUND.equals(node.getNodeName())) {
                    GameConfigFileReader.readBackground(node, config, topLevelEffects);
                }
            }
        });
    }

    protected static void readBackground(Node node, GameConfig config, Map<String, ImageEffect> topLevelEffects) {
        String name = HGBaseXMLTools.getAttributeValue(node, CONFIG_NAME);
        String image = HGBaseXMLTools.getAttributeValue(node, CONFIG_IMAGE);
        String color = HGBaseXMLTools.getAttributeValue(node, CONFIG_COLOR);
        if (HGBaseTools.hasContent(image) && HGBaseTools.hasContent(color)) {
            HGBaseLog.logWarn("Ambigous background " + name + ": defines image and color!");
            return;
        }
        boolean hidden = GameConfigFileReader.isHiddenPart(node, config);
        if (HGBaseTools.hasContent(color)) {
            GameConfigFileReader.readBackgroundColor(node, name, color, hidden);
        } else {
            GameConfigFileReader.readBackgroundImage(node, config, topLevelEffects, name, image, hidden);
        }
    }

    protected static void readBackgroundColor(Node node, String name, String color, boolean hidden) {
        boolean fixed = HGBaseXMLTools.getAttributeValue(node, CONFIG_FIXED).equals(CONFIG_TRUE);
        int rgb = HGBaseTools.toInt(color);
        if (rgb != -2147483631) {
            backgroundList.add(new Background(name, new Color(rgb), fixed, hidden));
        } else {
            HGBaseLog.logWarn("Invalid color for background " + name + "!");
        }
    }

    protected static void readBackgroundImage(Node node, GameConfig config, Map<String, ImageEffect> topLevelEffects, String name, String image, boolean hidden) {
        ImageIcon imgBack;
        if (!HGBaseTools.hasContent(image)) {
            image = GameConfigFileReader.calculateElementFilename(CONFIG_BACKGROUND, name, config);
        }
        if ((imgBack = HGBaseGuiTools.loadImage(image)) != null) {
            boolean repeat = HGBaseXMLTools.getAttributeValue(node, CONFIG_REPEAT).equals(CONFIG_TRUE);
            boolean ignoreZoom = HGBaseXMLTools.getAttributeValue(node, CONFIG_IGNOREZOOM).equals(CONFIG_TRUE);
            int zoom = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_ZOOM));
            if (zoom == -2147483631) {
                zoom = 100;
            }
            Background backPart = new Background(name, imgBack, repeat, ignoreZoom, hidden, zoom);
            if (!repeat) {
                GameConfigFileReader.setEffectsForPart((Part)backPart, node, topLevelEffects);
            }
            backgroundList.add(backPart);
        } else {
            HGBaseLog.logWarn("Background image " + image + " not found!");
        }
    }

    protected static String calculateElementFilename(String elementType, String name, GameConfig config) {
        return config.getElementPath(elementType) + "/" + name + "." + config.getElementExtension(elementType);
    }

    private static Map<String, ImageEffect> readEffectsFromNode(Node node) {
        HashMap<String, ImageEffect> availableEffects = new HashMap<String, ImageEffect>();
        for (Map.Entry<String, AbstractImageEffectReader<? extends ImageEffect>> reader : effectReaders.entrySet()) {
            ImageEffect effect = reader.getValue().getEffectDefinition(node);
            if (effect == null) continue;
            availableEffects.put(reader.getKey(), effect);
        }
        return availableEffects;
    }

    private static void setEffectsForPart(Part part, Node node, Map<String, ImageEffect> higherLevelEffects) {
        for (Map.Entry<String, AbstractImageEffectReader<? extends ImageEffect>> reader : effectReaders.entrySet()) {
            ImageEffect higherLevelEffect = higherLevelEffects.get(reader.getKey());
            reader.getValue().setEffectForPart(part, node, higherLevelEffect);
        }
    }

    private static void setEffectsForPart(Part part, Node node, Part higherLevelPart) {
        for (Map.Entry<String, AbstractImageEffectReader<? extends ImageEffect>> reader : effectReaders.entrySet()) {
            ImageEffect higherLevelEffect = reader.getValue().getEffectFromPart(higherLevelPart);
            reader.getValue().setEffectForPart(part, node, higherLevelEffect);
        }
    }

    protected static void readPlayers(Node node, GameConfig config) {
        GameConfigFileReader.fillElementInformation(CONFIG_PLAYER, node, config);
        config.playerImageName = HGBaseXMLTools.getAttributeValue(node, CONFIG_PLAYERIMAGE);
        config.playerPieceColor = HGBaseXMLTools.getAttributeValue(node, CONFIG_PIECECOLOR);
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_PLAYERS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config = (GameConfig)obj;
                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_PLAYER)) {
                    String playerType = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_TYPE);
                    String classPath = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_CLASS);
                    String image = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_IMAGE);
                    if (!HGBaseTools.hasContent(image)) {
                        image = GameConfigFileReader.calculateElementFilename(GameConfigFileReader.CONFIG_PLAYER, playerType, config);
                    }
                    ImageIcon typeImage = HGBaseGuiTools.loadImage(image);
                    if (PlayerFactory.getInstance().addPlayerType(playerType, classPath, typeImage) && typeImage == null) {
                        HGBaseLog.logWarn("Player type image " + image + " not found!");
                    }
                }
            }
        });
    }

    private static void readRulesSettings(Node node, GameConfig config) {
        if (node.getNodeName().equals(CONFIG_RULES)) {
            String classPath = HGBaseXMLTools.getAttributeValue(node, CONFIG_CLASS);
            if (!RulesFactory.getInstance().setRulesClass(classPath)) {
                config.hasErrors = true;
            }
        }
    }

    private static void readGameStateSettings(Node node, GameConfig config) {
        if (node.getNodeName().equals(CONFIG_GAMESTATE)) {
            String classPath = HGBaseXMLTools.getAttributeValue(node, CONFIG_CLASS);
            if (!StateFactory.getInstance().setGameStateClass(classPath)) {
                config.hasErrors = true;
            } else {
                String recordConf = HGBaseXMLTools.getAttributeValue(node, CONFIG_RECORD).toLowerCase();
                config.recordOnNewGame = CONFIG_GAME.equals(recordConf);
                config.recordOnNewRound = CONFIG_ROUND.equals(recordConf);
                config.recordOnNewTurn = CONFIG_TURN.equals(recordConf);
                config.gameStateXmlRoot = HGBaseXMLTools.getAttributeValue(node, CONFIG_XML_ROOT);
            }
        }
    }

    private static void readNewGameDialogSettings(Node node) {
        if (node.getNodeName().equals(CONFIG_NEWGAMEDIALOG)) {
            String classPath = HGBaseXMLTools.getAttributeValue(node, CONFIG_CLASS);
            String askToSave = HGBaseXMLTools.getAttributeValue(node, CONFIG_ASKTOSAVE);
            GameDialogFactory.getInstance().setNewGameDialogClass(classPath, askToSave);
        }
    }

    private static void readGameDialogSettings(Node node) {
        if (node.getNodeName().equals(CONFIG_GAMEDIALOGS)) {
            String classPath = HGBaseXMLTools.getAttributeValue(node, CONFIG_CLASS);
            GameDialogFactory.getInstance().setGameDialogsClass(classPath);
        }
    }

    private static void readStateChangedSettings(Node node, GameConfig config) {
        if (node.getNodeName().equals(CONFIG_CHANGED)) {
            config.changedOnNewGame = HGBaseXMLTools.getAttributeValue(node, CONFIG_NEWGAME).equals(CONFIG_TRUE);
            config.changedOnNewRound = HGBaseXMLTools.getAttributeValue(node, CONFIG_NEWROUND).equals(CONFIG_TRUE);
            config.changedOnNewTurn = HGBaseXMLTools.getAttributeValue(node, CONFIG_NEWTURN).equals(CONFIG_TRUE);
            config.changedAfterMove = HGBaseXMLTools.getAttributeValue(node, CONFIG_AFTERMOVE).equals(CONFIG_TRUE);
        }
    }

    private static void readPlayersSettings(Node node, GameConfig config) {
        if (node.getNodeName().equals(CONFIG_PLAYERS)) {
            String order;
            config.oneHumanPlayer = HGBaseXMLTools.getAttributeValue(node, CONFIG_ONEHUMAN).equals(CONFIG_TRUE);
            config.withoutHumanPlayer = HGBaseXMLTools.getAttributeValue(node, CONFIG_WITHOUTHUMAN).equals(CONFIG_TRUE);
            int min = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_MIN));
            int max = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_MAX));
            if (min != -2147483631 && max != -2147483631 && min <= max) {
                config.minPlayers = min;
                config.maxPlayers = max;
                int defaultPlayers = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_DEFAULT));
                config.defaultPlayers = defaultPlayers >= min && defaultPlayers <= max ? defaultPlayers : config.minPlayers;
            }
            config.playersOrder = CONFIG_CLOCKWISE.equals(order = HGBaseXMLTools.getAttributeValue(node, CONFIG_ORDER)) ? 1 : (CONFIG_COUNTERCLOCKWISE.equals(order) || CONFIG_ANTICLOCKWISE.equals(order) ? 2 : 0);
        }
    }

    private static void readStatisticsSettings(Node node, GameConfig config) {
        if (node.getNodeName().equals(CONFIG_STATISTICS)) {
            int scrollWhen;
            config.rememberGames = HGBaseXMLTools.getAttributeValue(node, CONFIG_GAMES).equals(CONFIG_TRUE);
            config.rememberScores = HGBaseXMLTools.getAttributeValue(node, CONFIG_SCORES).equals(CONFIG_TRUE);
            int hiScore = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_HIGHSCORE));
            if (hiScore > 0) {
                config.highScoreLength = hiScore;
                config.onlyFirstHighScore = HGBaseXMLTools.getAttributeValue(node, CONFIG_ONLYFIRST).equals(CONFIG_TRUE);
            }
            if ((scrollWhen = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_SCROLLWHEN))) > 0) {
                config.statisticsScrollWhen = scrollWhen;
            }
            config.isLowerScoreBetter = HGBaseXMLTools.getAttributeValue(node, CONFIG_LOWERSCOREISBETTER).equals(CONFIG_TRUE);
        }
    }

    private static void readZoomSettings(Node node, GameConfig config) {
        if (node.getNodeName().equals(CONFIG_ZOOM)) {
            int min = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_MIN));
            int max = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_MAX));
            if (min != -2147483631) {
                config.minZoom = min;
            }
            if (max != -2147483631) {
                config.maxZoom = max;
            }
            if (config.minZoom > config.maxZoom) {
                config.minZoom = 100;
                config.maxZoom = 100;
            }
        }
    }

    private static void readNetworkSettings(Node node, GameConfig config) {
        if (node.getNodeName().equals(CONFIG_NETWORK)) {
            int port = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_PORT));
            if (port != -2147483631) {
                config.networkPort = port;
            }
            config.localGameStateMove = CONFIG_LOCAL.equals(HGBaseXMLTools.getAttributeValue(node, CONFIG_MOVE));
            config.localGameStateTurn = CONFIG_LOCAL.equals(HGBaseXMLTools.getAttributeValue(node, CONFIG_TURN));
            config.localGameStateRound = CONFIG_LOCAL.equals(HGBaseXMLTools.getAttributeValue(node, CONFIG_ROUND));
            config.localGameStateGame = CONFIG_LOCAL.equals(HGBaseXMLTools.getAttributeValue(node, CONFIG_GAME));
        }
    }

    private static void readImageSettings(Node node, GameConfig config) {
        if (node.getNodeName().equals(CONFIG_IMAGE)) {
            String welcome = HGBaseXMLTools.getAttributeValue(node, CONFIG_WELCOME);
            config.welcomeImage = HGBaseGuiTools.loadImage(welcome);
            int timeout = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_WELCOME_TIMEOUT));
            if (timeout >= 0) {
                config.welcomeImageTimeout = timeout;
            }
        }
    }

    private static void readGameFieldSettings(Node node, GameConfig config) {
        block21: {
            if (!node.getNodeName().equals(CONFIG_GAMEFIELD)) break block21;
            int w = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_WIDTH));
            int h = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_HEIGHT));
            if (w != -2147483631 && h != -2147483631) {
                config.fieldWidth = w;
                config.fieldHeight = h;
            }
            switch (HGBaseXMLTools.getAttributeValue(node, CONFIG_HORIZONTAL_ALIGNMENT).toUpperCase()) {
                case "CENTER": {
                    config.fieldHorizontalAlignment = 0;
                    break;
                }
                case "RIGHT": {
                    config.fieldHorizontalAlignment = -1;
                    break;
                }
                default: {
                    config.fieldHorizontalAlignment = 1;
                }
            }
            switch (HGBaseXMLTools.getAttributeValue(node, CONFIG_VERTICAL_ALIGNMENT).toUpperCase()) {
                case "MIDDLE": {
                    config.fieldVerticalAlignment = 0;
                    break;
                }
                case "BOTTOM": {
                    config.fieldVerticalAlignment = -1;
                    break;
                }
                default: {
                    config.fieldVerticalAlignment = 1;
                }
            }
        }
    }

    private static void readInfoDialogSettings(Node node, GameConfig config) {
        if (node.getNodeName().equals(CONFIG_INFODIALOGS)) {
            config.dialogAfterTurn = HGBaseXMLTools.getAttributeValue(node, CONFIG_TURN).equals(CONFIG_TRUE);
            config.dialogAfterRound = HGBaseXMLTools.getAttributeValue(node, CONFIG_ROUND).equals(CONFIG_TRUE);
            config.dialogAfterGame = HGBaseXMLTools.getAttributeValue(node, CONFIG_GAME).equals(CONFIG_TRUE);
        }
    }

    private static void readInterruptionsSettings(Node node, GameConfig config) {
        if (node.getNodeName().equals(CONFIG_INTERRUPT)) {
            config.interruptAfterRound = HGBaseXMLTools.getAttributeValue(node, CONFIG_ROUND).equals(CONFIG_TRUE);
        }
    }

    private static void readHintsSettings(Node node, GameConfig config) {
        if (node.getNodeName().equals(CONFIG_HINTS)) {
            GameConfigFileReader.putIntoMap(node, CONFIG_PATH, config.hintsMap);
            GameConfigFileReader.putIntoMap(node, CONFIG_EXTENSION, config.hintsMap);
            for (String hintType : ConstantValue.getHintTypes()) {
                GameConfigFileReader.putIntoMap(node, hintType, config.hintsMap);
            }
        }
    }

    private static void readDelaySettings(Node node, GameConfig config) {
        if (node.getNodeName().equals(CONFIG_DELAY)) {
            int player;
            int move;
            int turn;
            int round = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_ROUND));
            if (round > 0) {
                config.delayRound = round;
            }
            if ((turn = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_TURN))) > 0) {
                config.delayTurn = turn;
            }
            if ((move = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_MOVE))) > 0) {
                config.delayMove = move;
            }
            if ((player = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, CONFIG_PLAYER))) > 0) {
                config.delayPlayer = player;
            }
        }
    }

    protected static void readSettings(Node node, GameConfig config) {
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_SETTINGS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config = (GameConfig)obj;
                GameConfigFileReader.readRulesSettings(node, config);
                GameConfigFileReader.readGameStateSettings(node, config);
                GameConfigFileReader.readNewGameDialogSettings(node);
                GameConfigFileReader.readGameDialogSettings(node);
                GameConfigFileReader.readStateChangedSettings(node, config);
                GameConfigFileReader.readPlayersSettings(node, config);
                GameConfigFileReader.readStatisticsSettings(node, config);
                GameConfigFileReader.readZoomSettings(node, config);
                GameConfigFileReader.readNetworkSettings(node, config);
                GameConfigFileReader.readImageSettings(node, config);
                GameConfigFileReader.readGameFieldSettings(node, config);
                GameConfigFileReader.readInfoDialogSettings(node, config);
                GameConfigFileReader.readInterruptionsSettings(node, config);
                GameConfigFileReader.readHintsSettings(node, config);
                GameConfigFileReader.readDelaySettings(node, config);
            }
        });
    }

    private static void putIntoMap(Node node, String attribute, Map<String, String> map) {
        String value = HGBaseXMLTools.getAttributeValue(node, attribute);
        if (HGBaseTools.hasContent(value)) {
            map.put(attribute, value);
        }
    }

    private static void testForErrors(GameConfig config) {
        if (config.getMinPlayers() == 0 || config.getMaxPlayers() == 0 || config.getMaxPlayers() < config.getMinPlayers()) {
            config.hasErrors = true;
            HGBaseLog.logError("Number of players are defined ambiguous!");
        } else {
            PlayerFactory f = PlayerFactory.getInstance();
            if (f.getSupportedPlayerTypes().length - f.getNetworkPlayerTypes().length <= 0) {
                config.hasErrors = true;
                HGBaseLog.logError("There aren't enough valid player types defined!");
            }
            if (config.networkPort > 0 && f.getNetworkPlayerTypes().length > 0) {
                config.networkPossible = true;
            }
        }
    }

    private static void initConfigValues(GameConfig config) {
        config.welcomeImageTimeout = 1700;
        config.completeArrangement = false;
        config.minZoom = 100;
        config.maxZoom = 100;
        config.extensionMap = new LinkedHashMap<String, String>();
        config.pathMap = new LinkedHashMap<String, String>();
        config.colors = new LinkedHashMap<String, Color>();
        config.playerImageName = "";
        config.playerPieceColor = "";
        config.networkPossible = false;
        config.networkPort = 0;
        config.minPlayers = 0;
        config.maxPlayers = 0;
        config.defaultPlayers = 0;
        config.fieldWidth = 0;
        config.fieldHeight = 0;
        config.oneHumanPlayer = false;
        config.withoutHumanPlayer = false;
        config.rememberScores = false;
        config.rememberGames = false;
        config.highScoreLength = 0;
        config.onlyFirstHighScore = false;
        config.isLowerScoreBetter = false;
        config.statisticsScrollWhen = 0;
        config.changedOnNewGame = false;
        config.changedOnNewRound = false;
        config.changedOnNewTurn = false;
        config.changedAfterMove = false;
        config.dialogAfterTurn = false;
        config.dialogAfterRound = false;
        config.dialogAfterGame = false;
        config.interruptAfterRound = false;
        config.hasErrors = false;
        config.cardSetsMap = new LinkedHashMap<String, List<CardSet>>();
        config.partMap = new LinkedHashMap<String, List<Part>>();
        config.partSetMap = new LinkedHashMap<String, List<PartSet>>();
        config.extendPartMap = new HashMap<String, String>();
        config.extendPartSetMap = new HashMap<String, String>();
        config.extendCvpMap = new HashMap<String, String>();
        config.setOrderBy = new IntBooleanStringMap();
        config.soundMap = new LinkedHashMap<String, List<Sound>>();
        config.soundSetMap = new LinkedHashMap<String, List<SoundSet>>();
        config.localGameStateTurn = false;
        config.localGameStateRound = false;
        config.localGameStateGame = false;
        config.hintsMap = new LinkedHashMap();
        config.delayRound = 0;
        config.delayTurn = 0;
        config.delayMove = 0;
        config.delayPlayer = 0;
        config.gameSpeed = 1.0;
        config.playersOrder = 0;
        config.recordOnNewGame = false;
        config.recordOnNewRound = false;
        config.recordOnNewTurn = false;
        config.layoutElements = new HashMap<Class<? extends LayoutElement>, Map<String, LayoutElement>>();
        config.gamefieldLayoutMargin = new Insets(0, 0, 0, 0);
    }
}

