/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed;

import hgb.lib.HGBaseTools;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import org.w3c.dom.Node;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameConfigFileReader;
import tjger.gui.completed.GameElement;
import tjger.gui.completed.GameElementSet;

abstract class GameElementSetConstructor<S extends GameElementSet, E extends GameElement> {
    protected final String typeConfigKey;
    protected final String setConfigKey;
    protected final String elementConfigKey;
    protected final String fileConfigKey;

    protected GameElementSetConstructor(String typeConfigKey, String setConfigKey, String elementConfigKey, String fileConfigKey) {
        this.typeConfigKey = typeConfigKey;
        this.setConfigKey = setConfigKey;
        this.elementConfigKey = elementConfigKey;
        this.fileConfigKey = fileConfigKey;
    }

    protected abstract String getAlternativeSetType(Node var1);

    protected abstract void logTypeMissing(String var1);

    protected abstract S createSet(String var1, String var2, boolean var3, Node var4, GameConfig var5);

    protected abstract E createElement(S var1, Node var2, int var3, GameConfig var4);

    public void run(Node root, GameConfig config) {
        this.readSets(root, config);
    }

    private void readSets(Node root, GameConfig config) {
        ChildNodeIterator.run(new ChildNodeIterator(root, this.typeConfigKey, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config = (GameConfig)obj;
                if (GameElementSetConstructor.this.setConfigKey.equals(node.getNodeName())) {
                    GameElementSetConstructor.this.readSet(node, config);
                }
            }
        });
    }

    private void readSet(Node node, GameConfig config) {
        String type = HGBaseXMLTools.getAttributeValue(node, "type");
        if (!HGBaseTools.hasContent(type)) {
            type = this.getAlternativeSetType(node);
        }
        String name = HGBaseXMLTools.getAttributeValue(node, "name");
        if (this.isTypeNeeded() && !HGBaseTools.hasContent(type)) {
            this.logTypeMissing(name);
            return;
        }
        boolean hidden = GameConfigFileReader.isHiddenPart(node, config);
        S newSet = this.createSet(type, name, hidden, node, config);
        this.readSetElements(node, config, newSet);
        if (!((GameElementSet)newSet).isEmpty()) {
            this.addSetToCollection(newSet, type);
        }
    }

    protected abstract boolean isTypeNeeded();

    protected abstract void addSetToCollection(S var1, String var2);

    private void readSetElements(Node node, final GameConfig config, S set) {
        ChildNodeIterator.run(new ChildNodeIterator(node, this.setConfigKey, set, (GameElementSet)set){
            private final /* synthetic */ GameElementSet val$set;
            {
                this.val$set = gameElementSet;
                super($anonymous0, $anonymous1, $anonymous2);
            }

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (GameElementSetConstructor.this.elementConfigKey.equals(node.getNodeName())) {
                    GameElementSetConstructor.this.readElement(node, config, this.val$set);
                }
            }
        });
    }

    private void readElement(Node node, GameConfig config, S set) {
        int sequence = HGBaseXMLTools.getAttributeIntValue(node, "sequence");
        if (sequence != -2147483631) {
            this.readElementSingleSequence(node, sequence, set, config);
        } else {
            this.readElementSequence(node, set, config);
        }
    }

    private void readElementSequence(Node node, S set, GameConfig config) {
        int seqStart = HGBaseXMLTools.getAttributeIntValue(node, "sequencestart");
        int seqEnd = HGBaseXMLTools.getAttributeIntValue(node, "sequenceend");
        if (seqStart != -2147483631 && seqEnd != -2147483631 && seqStart <= seqEnd) {
            int sequence = seqStart;
            while (sequence <= seqEnd) {
                this.readElementSingleSequence(node, sequence, set, config);
                ++sequence;
            }
        }
    }

    private void readElementSingleSequence(Node node, int sequence, S set, GameConfig config) {
        E element = this.createElement(set, node, sequence, config);
        if (element != null) {
            ((GameElementSet)set).addElement((GameElement)element);
        }
    }

    protected String getElementFilePath(Node node, int sequence, S set, GameConfig config) {
        String filePath = HGBaseXMLTools.getAttributeValue(node, this.fileConfigKey);
        return HGBaseTools.hasContent(filePath) ? filePath : this.calculateElementFilePath(node, sequence, set, config);
    }

    protected String calculateElementFilePath(Node node, int sequence, S set, GameConfig config) {
        return config.getElementPath(this.elementConfigKey) + "/" + ((GameElement)set).getName() + "/" + this.getElementFileName(node, set) + "-" + sequence + "." + config.getElementExtension(this.elementConfigKey);
    }

    protected abstract String getElementFileName(Node var1, S var2);
}

