/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed;

import hgb.gui.HGBaseDialog;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.MainFrame;
import tjger.game.GamePlayer;
import tjger.game.GameRules;
import tjger.game.GameState;
import tjger.game.GameStateListener;
import tjger.game.MoveInformation;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngineFileOperator;
import tjger.game.completed.GameManager;
import tjger.game.completed.PlayerManager;
import tjger.game.completed.PlayerOrderComparator;
import tjger.game.completed.PlayerType;
import tjger.game.internal.GameRecorder;
import tjger.game.internal.GameStatistics;
import tjger.game.internal.PlayerFactory;
import tjger.game.internal.PlayerProfiles;
import tjger.game.internal.StateFactory;
import tjger.gui.GameDialogs;
import tjger.gui.internal.GameDialogFactory;
import tjger.lib.MoveUtil;
import tjger.lib.TimeAction;
import tjger.net.NetworkClient;
import tjger.net.NetworkClientConnection;
import tjger.net.NetworkConnection;
import tjger.net.NetworkDialogAction;
import tjger.net.NetworkMessage;
import tjger.net.NetworkServerConnection;

public final class GameEngine {
    public static final int ACTION_NEWGAME = 1;
    public static final int ACTION_NEWROUND = 2;
    public static final int ACTION_NEWTURN = 3;
    public static final int ACTION_GAMEFINISHED = 4;
    public static final int ACTION_GAMESTOPPED = 5;
    public static final int ACTION_BEFOREMOVE = 6;
    public static final int ACTION_AFTERMOVE = 7;
    public static final int RESET_CONTINUED_MOVE = -1;
    public static final int RESET_MOVE = 0;
    public static final int RESET_TURN = 1;
    public static final int RESET_ROUND = 2;
    public static final int RESET_GAME = 3;
    public static final int AFTER_TURN = 1;
    public static final int AFTER_ROUND = 2;
    public static final int AFTER_GAME = 3;
    private static GameEngine engine = new GameEngine();
    int numberPlayers;
    GamePlayer[] activePlayers;
    int playerStartRound;
    int cyclingPlayerStartGame = 0;
    int currentPlayer;
    int currentRound;
    int currentTurn;
    AtomicInteger currentMove = new AtomicInteger(0);
    boolean activeGame;
    boolean activeRound;
    private final List<GameStateListener> gameStateListeners = new ArrayList<GameStateListener>();
    private final GameState gameState;
    private final List<TimeAction> timeActionList = new ArrayList<TimeAction>();
    private final NetworkServerConnection netServer = NetworkServerConnection.getInstance();
    private final NetworkClientConnection netClient = NetworkClientConnection.getInstance();
    private boolean serverGame = false;
    private boolean clientGame = false;
    private boolean stopGameProcessing = false;
    private boolean nextGameProcessing = false;
    boolean stoppedGame = true;

    private GameEngine() {
        this.initGame();
        this.gameState = StateFactory.getInstance().createGameState();
    }

    private void initGame() {
        this.numberPlayers = 0;
        this.playerStartRound = -1;
        this.currentPlayer = -1;
        this.currentTurn = 0;
        this.currentRound = 0;
        this.currentMove.set(0);
        this.activeGame = false;
        this.activeRound = false;
        this.activePlayers = null;
    }

    public static GameEngine getInstance() {
        return engine;
    }

    public GameManager getGameManager() {
        return GameManager.getInstance();
    }

    public MainFrame getMainFrame() {
        return this.getGameManager().getMainFrame();
    }

    private GameConfig getGameConfig() {
        return this.getGameManager().getGameConfig();
    }

    private PlayerManager getPlayerManager() {
        return this.getGameManager().getPlayerManager();
    }

    private GameRules getGameRules() {
        return this.getGameManager().getGameRules();
    }

    public GameState getGameState() {
        return this.gameState;
    }

    private GameStatistics getGameStatistics() {
        return this.getGameManager().getGameStatistics();
    }

    public void addGameStateListener(GameStateListener listener) {
        if (listener != null && !this.gameStateListeners.contains(listener)) {
            this.gameStateListeners.add(listener);
        }
    }

    public void removeGameStateListener(GameStateListener listener) {
        this.gameStateListeners.remove(listener);
    }

    void contributeGameState(int action) {
        this.testForRecordingAction(action);
        GameState state = this.getGameState();
        for (GameStateListener gsListener : this.gameStateListeners) {
            switch (action) {
                case 1: {
                    gsListener.newGameStarted(state, this);
                    break;
                }
                case 2: {
                    gsListener.newRoundStarted(state, this);
                    break;
                }
                case 3: {
                    gsListener.newTurnStarted(state, this);
                    break;
                }
                case 4: {
                    gsListener.gameFinished(true);
                    break;
                }
                case 5: {
                    gsListener.gameFinished(false);
                    break;
                }
                case 6: {
                    gsListener.gameStateBeforeMove(state, this);
                    break;
                }
                case 7: {
                    gsListener.gameStateAfterMove(state, this);
                    break;
                }
            }
        }
        this.updateGamePanel();
    }

    private void testForRecordingAction(int action) {
        if (action == 1) {
            this.testToStartRecording();
        }
        if (action == 1 || action == 2 || action == 3) {
            this.testToRecordGameState(action);
        }
        if (action == 4) {
            GameRecorder.getInstance().stopRecording();
        }
    }

    private void updateGamePanel() {
        this.getMainFrame().getGamePanel().repaint();
    }

    public int getNumberPlayers() {
        return this.numberPlayers;
    }

    public int getNumberPlayers(boolean withoutDropOut) {
        GamePlayer[] active = this.getActivePlayers(withoutDropOut);
        if (active == null) {
            return 0;
        }
        return active.length;
    }

    public GamePlayer[] getActivePlayers() {
        return this.getActivePlayers(false);
    }

    public GamePlayer[] getActivePlayers(boolean withoutDropOut) {
        if (this.activePlayers == null) {
            return null;
        }
        if (withoutDropOut) {
            ArrayList<GamePlayer> listPlayer = new ArrayList<GamePlayer>();
            GamePlayer[] gamePlayerArray = this.activePlayers;
            int n = this.activePlayers.length;
            int n2 = 0;
            while (n2 < n) {
                GamePlayer activePlayer = gamePlayerArray[n2];
                if (!activePlayer.isDropOut()) {
                    listPlayer.add(activePlayer);
                }
                ++n2;
            }
            return listPlayer.toArray(new GamePlayer[0]);
        }
        return (GamePlayer[])this.activePlayers.clone();
    }

    public void setActivePlayers(GamePlayer[] player) {
        this.activePlayers = HGBaseTools.clone(player);
        this.numberPlayers = player.length;
    }

    public GamePlayer getCurrentPlayer() {
        if (this.currentPlayer < 0) {
            return null;
        }
        return this.getActivePlayers()[this.currentPlayer];
    }

    public int getCurrentPlayerIndex() {
        return this.currentPlayer;
    }

    int getPlayerStartRound() {
        return this.playerStartRound;
    }

    public GamePlayer getFirstPlayer() {
        if (this.playerStartRound < 0) {
            return null;
        }
        return this.getActivePlayers()[this.playerStartRound];
    }

    public GamePlayer getCyclingFirstGamePlayer() {
        return this.getActivePlayers(true)[this.getCyclingFirstGamePlayerIndex()];
    }

    public int getCyclingFirstGamePlayerIndex() {
        return this.cyclingPlayerStartGame % this.numberPlayers;
    }

    public GamePlayer getPrevPlayer(GamePlayer player, boolean withoutDropOut) {
        GamePlayer prev = null;
        int index = this.getIndexOfPlayer(player, withoutDropOut);
        if (index != -1 && (prev = this.getActivePlayers()[this.getPrevPlayerIndex(index)]).isDropOut() && withoutDropOut && this.getNumberPlayers(true) > 0) {
            return this.getPrevPlayer(prev, true);
        }
        return prev;
    }

    public GamePlayer getPrevPlayer(GamePlayer player) {
        return this.getPrevPlayer(player, false);
    }

    public GamePlayer getNextPlayer(GamePlayer player, boolean withoutDropOut) {
        GamePlayer[] players;
        GamePlayer next = null;
        int index = this.getIndexOfPlayer(player);
        if (index != -1 && (players = this.getActivePlayers()) != null && (next = players[this.getNextPlayerIndex(index)]).isDropOut() && withoutDropOut && this.getNumberPlayers(withoutDropOut) > 0) {
            return this.getNextPlayer(next, true);
        }
        return next;
    }

    public GamePlayer getNextPlayer(GamePlayer player) {
        return this.getNextPlayer(player, false);
    }

    public int getIndexOfPlayer(GamePlayer player) {
        return this.getIndexOfPlayer(player, false);
    }

    public int getIndexOfPlayer(GamePlayer player, boolean withoutDropOut) {
        int index = -1;
        GamePlayer[] active = this.getActivePlayers(withoutDropOut);
        int i = 0;
        while (active != null && i < active.length && index == -1) {
            if (active[i].equals(player)) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public GamePlayer getPlayerWithIndex(int index) {
        return this.getPlayerWithIndex(index, false);
    }

    public GamePlayer getPlayerWithIndex(int index, boolean withoutDropOut) {
        GamePlayer[] active = this.getActivePlayers(withoutDropOut);
        if (active != null && index >= 0 && index < active.length) {
            return active[index];
        }
        return null;
    }

    public GamePlayer getPlayerWithColor(String pieceColor) {
        return this.getPlayerWithColor(pieceColor, false);
    }

    public GamePlayer getPlayerWithColor(String pieceColor, boolean withoutDropOut) {
        GamePlayer[] gamePlayerArray = this.getActivePlayers(withoutDropOut);
        int n = gamePlayerArray.length;
        int n2 = 0;
        while (n2 < n) {
            GamePlayer player = gamePlayerArray[n2];
            if (pieceColor.equals(player.getPieceColor())) {
                return player;
            }
            ++n2;
        }
        return null;
    }

    public int getCurrentRound() {
        return this.currentRound;
    }

    public int getCurrentTurn() {
        return this.currentTurn;
    }

    public int getCurrentMove() {
        return this.currentMove.get();
    }

    public int startGame(int numberPlayers) {
        this.serverGame = this.netServer != null && this.netServer.isStarted();
        this.clientGame = this.netClient != null && this.netClient.isConnected();
        this.getMainFrame().setCursorWait();
        this.getMainFrame().setStatusProgress(1);
        int ret = this.initActivePlayers(numberPlayers);
        this.getMainFrame().setStatusProgress(0);
        if (ret == 0) {
            this.cyclingPlayerStartGame = 0;
            ret = this.newGame();
        }
        if (ret != 0) {
            this.stopGame();
        }
        return ret;
    }

    public int newGame() {
        if (this.numberPlayers > 0) {
            int ret;
            this.resetDelayActions();
            this.resetScore(4);
            if (this.getGameStatistics() != null) {
                this.getGameStatistics().resetRanking();
            }
            if ((ret = this.resetGameState(3)) != 0) {
                return ret;
            }
            this.activeGame = true;
            this.stoppedGame = false;
            this.currentRound = 0;
            this.currentTurn = 0;
            this.contributeGameState(1);
            if (this.getGameConfig().isChangedOnNewGame()) {
                this.setGameStateChanged();
            }
            this.getMainFrame().setCursorDefault();
            this.getMainFrame().showHintsDialog("game");
            this.delayNewRound(0);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized int nextNetworkGame() {
        this.nextGameProcessing = true;
        if (this.isNetworkGame() && this.getNumberPlayers() > 0) {
            GamePlayer[] active = this.getGameManager().getGameEngine().getActivePlayers();
            GamePlayer[] newPlayer = (GamePlayer[])active.clone();
            if (this.isServerGame() && this.netServer != null) {
                if (!this.getMainFrame().getMainMenu().askForSaving()) {
                    this.nextGameProcessing = false;
                    return -2147483631;
                }
                this.stopGame(false);
                NetworkDialogAction action = new NetworkDialogAction(this.getMainFrame(), "network.waitplayers"){

                    @Override
                    protected int doAction() {
                        String msg = NetworkMessage.msgNextGameS();
                        GameEngine.this.netServer.putMessageAll(msg);
                        msg = NetworkMessage.msgError("err.nextgame");
                        if (!GameEngine.this.netServer.putMessageAllAndWait(msg, "TJxGE")) {
                            GameEngine.this.nextGameProcessing = false;
                            return -30303;
                        }
                        GameEngine.this.nextGameProcessing = false;
                        return 0;
                    }
                };
                NetworkDialogAction.run(action);
                if (action.getReturnValue() != 0) {
                    this.stopNetwork();
                    this.nextGameProcessing = false;
                    return action.getReturnValue();
                }
            } else if (this.isClientGame() && this.netClient != null) {
                this.stopGame(false);
                HGBaseDialog.printInfo("err.nextgame", (JFrame)this.getMainFrame());
                if (this.netClient.putMessage(NetworkMessage.msgClientGameOkC("TJxGE")) != 0) {
                    this.stopNetwork();
                    this.nextGameProcessing = false;
                    return -30303;
                }
            }
            this.getMainFrame().setFile(new File(""));
            this.getGameManager().getGameEngine().setActivePlayers(newPlayer);
            this.nextGameProcessing = false;
            return this.getGameManager().getGameEngine().newGame();
        }
        this.nextGameProcessing = false;
        return 0;
    }

    public int resetGameState(int reset) {
        if (this.isClientGame() && this.netClient != null && !this.isLocalGameStateReset(reset)) {
            NetworkDialogAction action = new NetworkDialogAction(this.getMainFrame()){

                @Override
                protected int doAction() {
                    StringBuffer msg = new StringBuffer("");
                    if (GameEngine.this.netClient.waitForServerGameInformation("TJxGS", msg, null)) {
                        if (GameEngine.this.getGameState().fromNetworkString(msg.toString())) {
                            return 0;
                        }
                    } else if (GameEngine.this.netClient.messageServerNextGame()) {
                        return -2147483631;
                    }
                    return -30305;
                }
            };
            NetworkDialogAction.run(action);
            return action.getReturnValue();
        }
        if (this.getGameState() != null) {
            switch (reset) {
                case -1: 
                case 0: {
                    this.getGameState().resetMove(this, reset == -1);
                    break;
                }
                case 1: {
                    this.getGameState().resetTurn(this);
                    break;
                }
                case 2: {
                    this.getGameState().resetRound(this);
                    break;
                }
                case 3: {
                    this.getGameState().resetGame(this);
                    GameRecorder.getInstance().stopDebugging();
                    break;
                }
            }
            this.updateGamePanel();
            if (this.isServerGame() && this.netServer != null && !this.isLocalGameStateReset(reset)) {
                NetworkDialogAction action = new NetworkDialogAction(this.getMainFrame()){

                    @Override
                    protected int doAction() {
                        String msg = NetworkMessage.msgGameStateS(GameEngine.this.getGameState());
                        if (!GameEngine.this.netServer.putMessageAllAndWait(msg, "TJxGS")) {
                            return -30305;
                        }
                        return 0;
                    }
                };
                NetworkDialogAction.run(action);
                return action.getReturnValue();
            }
        }
        return 0;
    }

    private void testToStartRecording() {
        GameRecorder rec;
        File currentFile;
        if (!(this.currentRound != 0 || this.currentTurn != 0 || this.currentMove.get() != 0 || (currentFile = this.getMainFrame().getFile()) != null && currentFile.length() != 0L || (rec = GameRecorder.getInstance()).isDebugging())) {
            GameRecorder.getInstance().startRecording();
        }
    }

    private void testToRecordGameState(int action) {
        boolean shallRecord;
        GameConfig cfg = this.getGameConfig();
        boolean bl = shallRecord = action == 1 && cfg.isRecordedOnNewGame() || action == 2 && cfg.isRecordedOnNewRound() || action == 3 && cfg.isRecordedOnNewTurn();
        if (shallRecord) {
            GameRecorder.getInstance().recordGameState(this.getGameState());
        }
    }

    private boolean isLocalGameStateReset(int state) {
        if (this.isNetworkGame()) {
            switch (state) {
                case 0: {
                    return this.getGameConfig().isLocalGameStateMove();
                }
                case 1: {
                    return this.getGameConfig().isLocalGameStateTurn();
                }
                case 2: {
                    return this.getGameConfig().isLocalGameStateRound();
                }
                case 3: {
                    return this.getGameConfig().isLocalGameStateGame();
                }
            }
        }
        return true;
    }

    public void stopGame(boolean stopNetwork) {
        if (this.stopGameProcessing) {
            return;
        }
        this.stopGameProcessing = true;
        this.stoppedGame = true;
        GameRecorder gr = GameRecorder.getInstance();
        gr.stopRecording();
        gr.stopDebugging();
        Thread t = new Thread(() -> {
            this.resetDelayActions();
            this.getMainFrame().setFile(null);
            this.getMainFrame().setStatusProgress(0);
            GamePlayer player = this.getCurrentPlayer();
            if (player != null) {
                player.stopPlaying();
            }
            if (stopNetwork) {
                this.stopNetwork();
            }
            this.initGame();
            if (this.getGameState() != null) {
                this.getGameState().stopGame();
            }
            if (this.getGameStatistics() != null) {
                this.getGameStatistics().resetRanking();
            }
            this.contributeGameState(5);
            this.getMainFrame().setCursorDefault();
        });
        t.start();
        try {
            while (t.isAlive()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.stopGameProcessing = false;
    }

    public boolean isStopGameProcessing() {
        return this.stopGameProcessing;
    }

    public boolean isNextGameProcessing() {
        return this.nextGameProcessing;
    }

    public void stopGame() {
        this.stopGame(true);
    }

    public void closeNetworkGame() {
        this.getMainFrame().setChanged(false);
        this.getMainFrame().onFileClose();
        this.getMainFrame().getMainMenu().setFileMenuStates();
    }

    public void newRound() {
        this.currentTurn = 0;
        this.getMainFrame().setCursorWait();
        this.resetScore(2);
        int ret = this.resetGameState(2);
        if (ret == 0) {
            ++this.currentRound;
            this.currentTurn = 1;
            this.currentMove.set(0);
            this.activeRound = true;
            this.currentPlayer = this.playerStartRound = this.getIndexOfPlayer(this.getGameRules().getStartPlayer(this.getGameState()));
            this.cyclingPlayerStartGame = (this.playerStartRound + 1) % this.numberPlayers;
            this.contributeGameState(2);
            if (this.getGameConfig().isChangedOnNewRound()) {
                this.setGameStateChanged();
            }
            this.getMainFrame().setCursorDefault();
            this.getMainFrame().showHintsDialog("round");
            this.delayNewTurn(0);
        } else {
            this.closeNetworkGame();
            HGBaseDialog.printError(ret, (JFrame)this.getMainFrame());
        }
    }

    synchronized void newTurn(boolean performResetMove) {
        this.getMainFrame().setCursorWait();
        this.resetScore(1);
        int ret = this.resetGameState(1);
        if (ret == 0) {
            this.currentMove.set(1);
            this.contributeGameState(3);
            if (this.getGameConfig().isChangedOnNewTurn()) {
                this.setGameStateChanged();
            }
            this.getMainFrame().setCursorDefault();
            this.getMainFrame().showHintsDialog("turn");
            this.delayDoPlayerMove(0, false, performResetMove);
        } else {
            this.closeNetworkGame();
            HGBaseDialog.printError(ret, (JFrame)this.getMainFrame());
        }
    }

    public synchronized void performMove(MoveInformation move) {
        GameRecorder.getInstance().recordNextMove(this.getGameState(), move);
        this.getGameManager().getMainFrame().setStatusProgress(0);
        GameState state = this.getGameState();
        state.changeState(this.getCurrentPlayer(), move, this);
        boolean isMoveComplete = this.testMoveComplete(move);
        this.updateGamePanel();
        GameRules rules = this.getGameRules();
        GameStatistics stats = this.getGameStatistics();
        GamePlayer[] active = this.getActivePlayers();
        if (active != null) {
            boolean turnFinished = false;
            if (isMoveComplete) {
                int[] ranks;
                this.getGameManager().getMainFrame().setCursorWait();
                rules.doScoring(active, this.getGameState());
                turnFinished = rules.isTurnFinished(this.getGameState());
                if (rules.isRoundFinished(this.getGameState())) {
                    ranks = rules.getRoundRanking(active);
                    stats.doRoundRanking(this.getActivePlayers(), ranks);
                    this.activeRound = false;
                }
                if (rules.isGameFinished(this.getGameState())) {
                    ranks = rules.getGameRanking(active);
                    stats.doGameRanking(this.getActivePlayers(), ranks);
                    this.activeGame = false;
                }
                this.getGameManager().getMainFrame().setCursorDefault();
            }
            this.contributeGameState(7);
            if (this.getGameConfig().isChangedAfterMove()) {
                this.setGameStateChanged();
            }
            if (!this.contributeNetworkMoves(move)) {
                new Thread(){

                    @Override
                    public void run() {
                        GameEngine.this.closeNetworkGame();
                    }
                }.start();
                return;
            }
            if (isMoveComplete) {
                if (!this.isActiveGame()) {
                    this.contributeGameState(4);
                }
                this.showDialogs(isMoveComplete, turnFinished, rules);
            } else {
                this.proceedGameAfterMove(isMoveComplete, turnFinished, rules);
            }
        }
    }

    public void proceedGameAfterMove(boolean isMoveComplete, boolean turnFinished, GameRules rules) {
        if (this.isActiveRound() && this.isActiveGame()) {
            if (isMoveComplete) {
                this.currentPlayer = this.getIndexOfPlayer(rules.getNextPlayer(this.getCurrentPlayer(), this.getGameState()));
            }
            if (turnFinished) {
                ++this.currentTurn;
                this.currentMove.set(0);
            }
            if (this.currentMove.get() == 0) {
                this.delayNewTurn(this.getGameConfig().getDelayTurnWithSpeedFactor());
            } else {
                if (isMoveComplete) {
                    this.currentMove.incrementAndGet();
                }
                this.delayDoPlayerMove(this.getGameConfig().getDelayMoveWithSpeedFactor(), !isMoveComplete, true);
            }
        } else if (this.isActiveGame() && !this.getGameConfig().isInterruptAfterRound()) {
            this.delayNewRound(this.getGameConfig().getDelayRoundWithSpeedFactor());
        }
    }

    private boolean testMoveComplete(MoveInformation move) {
        return MoveUtil.isMoveComplete(move);
    }

    private boolean contributeNetworkMoves(final MoveInformation move) {
        String msg;
        final GamePlayer player = this.getCurrentPlayer();
        if (this.isServerGame() && this.netServer != null && player != null) {
            NetworkDialogAction action = new NetworkDialogAction(this.getMainFrame()){

                @Override
                protected int doAction() {
                    int except = -1;
                    if (player.getType().isNetwork()) {
                        int clientNr = GameEngine.this.getIndexOfPlayer(player);
                        except = GameEngine.this.netServer.getIndexOfNr(clientNr);
                    }
                    String msg = NetworkMessage.msgMoveInformationS(GameEngine.this.getGameState(), move);
                    if (!GameEngine.this.netServer.putMessageAllAndWait(msg, "TJxMI", except)) {
                        HGBaseDialog.printError(-30307, (JFrame)GameEngine.this.getMainFrame());
                        return -30307;
                    }
                    return 0;
                }
            };
            NetworkDialogAction.run(action);
            return action.getReturnValue() == 0;
        }
        if (this.isClientGame() && this.netClient != null && player != null && !player.getType().isNetwork() && this.netClient.putMessage(msg = NetworkMessage.msgMoveInformationS(this.getGameState(), move)) != 0) {
            HGBaseDialog.printError(-30307, (JFrame)this.getMainFrame());
            return false;
        }
        return true;
    }

    private void showDialogs(boolean isMoveComplete, boolean turnFinished, GameRules rules) {
        if (this.getGameConfig().showDialogAfterTurn() && rules.isTurnFinished(this.getGameState())) {
            this.showDialog(1, isMoveComplete, turnFinished, rules);
        }
        if (this.getGameConfig().showDialogAfterRound() && rules.isRoundFinished(this.getGameState())) {
            this.showDialog(2, isMoveComplete, turnFinished, rules);
        }
        if (this.getGameConfig().showDialogAfterGame() && rules.isGameFinished(this.getGameState())) {
            this.showDialog(3, isMoveComplete, turnFinished, rules);
        }
        this.proceedGameAfterMove(isMoveComplete, turnFinished, rules);
    }

    private void showDialog(int dialogMode, boolean isMoveComplete, boolean turnFinished, GameRules rules) {
        GameDialogs dlg = GameDialogFactory.getInstance().createGameDialogs();
        dlg.showGameStateInfoPanel(this.getMainFrame(), dialogMode, isMoveComplete, turnFinished, this.getGameState(), this, rules);
        this.updateGamePanel();
    }

    public void doPlayerMove(boolean continued, boolean performResetMove) {
        int ret;
        if (performResetMove && (ret = this.resetGameState(continued ? -1 : 0)) != 0) {
            this.closeNetworkGame();
            HGBaseDialog.printError(ret, (JFrame)this.getMainFrame());
            return;
        }
        this.contributeGameState(6);
        GamePlayer player = this.getCurrentPlayer();
        if (player != null) {
            if (player.isHuman()) {
                this.getMainFrame().showHintsDialog("move");
            }
            player.startMove();
        }
    }

    private void delayNewRound(int delay) {
        if (delay < 0) {
            delay = 0;
        }
        TimeAction t = new TimeAction(delay){

            @Override
            public void doAction() {
                GameEngine.this.getMainFrame().setCursorWait();
            }

            @Override
            public void afterAction() {
                GameEngine.this.newRound();
                GameEngine.this.getMainFrame().setCursorDefault();
            }

            @Override
            public String toString() {
                return super.toString() + ": delayNewRound";
            }
        };
        TimeAction.run(t);
    }

    private void delayNewTurn(int delay) {
        if (delay > 0) {
            TimeAction t = new TimeAction(delay){

                @Override
                public void doAction() {
                    GameEngine.this.getMainFrame().setCursorWait();
                }

                @Override
                public void afterAction() {
                    GameEngine.this.newTurn(true);
                    GameEngine.this.getMainFrame().setCursorDefault();
                }

                @Override
                public String toString() {
                    return super.toString() + ": delayNewTurn";
                }
            };
            TimeAction.run(t);
        } else {
            this.newTurn(true);
        }
    }

    private void delayDoPlayerMove(int delay, final boolean continued, final boolean performResetMove) {
        if (delay > 0) {
            TimeAction t = new TimeAction(delay){

                @Override
                public void doAction() {
                    GameEngine.this.getMainFrame().setCursorWait();
                }

                @Override
                public void afterAction() {
                    GameEngine.this.doPlayerMove(continued, performResetMove);
                    GameEngine.this.getMainFrame().setCursorDefault();
                }

                @Override
                public String toString() {
                    return super.toString() + ": delayDoPlayerMove";
                }
            };
            TimeAction.run(t);
        } else {
            this.doPlayerMove(continued, performResetMove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDelayActions() {
        this.getMainFrame().setCursorWait();
        List<TimeAction> list = this.timeActionList;
        synchronized (list) {
            boolean notCancel;
            do {
                notCancel = false;
                for (TimeAction t : this.timeActionList) {
                    if (t.isAlive() && !t.isCancelAble()) {
                        notCancel = true;
                        continue;
                    }
                    t.interrupt();
                }
                if (!notCancel) continue;
                HGBaseTools.sleep(50L);
            } while (notCancel);
            this.timeActionList.clear();
        }
        this.getMainFrame().setCursorDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimeAction(TimeAction ta) {
        List<TimeAction> list = this.timeActionList;
        synchronized (list) {
            this.timeActionList.add(ta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimeAction(TimeAction ta) {
        List<TimeAction> list = this.timeActionList;
        synchronized (list) {
            this.timeActionList.remove(ta);
        }
    }

    private void setGameStateChanged() {
        this.getMainFrame().setChanged(true);
    }

    public boolean isActiveGame() {
        return this.activeGame;
    }

    public boolean isActiveRound() {
        return this.activeRound;
    }

    public boolean isStoppedGame() {
        return this.stoppedGame;
    }

    private int getNextPlayerIndex(int index) {
        int numPlayers = this.getNumberPlayers();
        return numPlayers == 0 ? 0 : (index + 1) % numPlayers;
    }

    private int getPrevPlayerIndex(int index) {
        int numPlayers = this.getNumberPlayers();
        return numPlayers == 0 ? 0 : (index + numPlayers - 1) % numPlayers;
    }

    private int initActivePlayers(int numberPlayers) {
        int ret = 0;
        if (this.isClientGame()) {
            ret = this.initNetworkGame();
            if (ret == 0) {
                this.resetScore(4);
                this.adjustPlayerProfiles(true);
            }
        } else {
            if (numberPlayers < this.getPlayerManager().getMinPlayers() || numberPlayers > this.getPlayerManager().getMaxPlayers()) {
                numberPlayers = this.getPlayerManager().getMinPlayers();
            }
            this.numberPlayers = numberPlayers;
            this.activePlayers = new GamePlayer[this.numberPlayers];
            GamePlayer[] allPlayers = this.getPlayerManager().getPlayers();
            Integer[] playerIndex = this.createPlayerIndexArray(this.numberPlayers);
            int playersOrder = this.getGameConfig().getPlayersOrder();
            Arrays.sort(playerIndex, new PlayerOrderComparator(playersOrder));
            int i = 0;
            while (i < this.activePlayers.length) {
                int allPlayerIndex = playerIndex[i];
                this.activePlayers[i] = allPlayers[allPlayerIndex];
                this.getGameStatistics().resetScore(this.activePlayers[i], 4);
                ++i;
            }
            this.adjustPlayerProfiles(true);
            if (this.isServerGame()) {
                ret = this.initNetworkGame();
            }
        }
        return ret;
    }

    private Integer[] createPlayerIndexArray(int numPlayers) {
        Integer[] indexList = new Integer[numPlayers];
        int i = 0;
        while (i < indexList.length) {
            indexList[i] = i;
            ++i;
        }
        return indexList;
    }

    private void adjustPlayerProfiles(boolean update) {
        PlayerProfiles profiles = this.getGameManager().getPlayerProfiles();
        int i = 0;
        while (i < this.activePlayers.length) {
            if (!profiles.existsPlayer(this.activePlayers[i])) {
                profiles.createProfile(this.activePlayers[i]);
            } else if (update) {
                profiles.updateProfile(this.activePlayers[i]);
            }
            ++i;
        }
    }

    private void resetScore(int scoreType) {
        GamePlayer[] player = this.getActivePlayers();
        int i = 0;
        while (player != null && i < player.length) {
            this.getGameStatistics().resetScore(player[i], scoreType);
            if (scoreType == 4) {
                player[i].setDropOut(false);
            }
            ++i;
        }
    }

    public void resetGamePlayersDropOut() {
        GamePlayer[] players;
        GamePlayer[] gamePlayerArray = players = engine.getActivePlayers();
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            GamePlayer player = gamePlayerArray[n2];
            player.setDropOut(false);
            ++n2;
        }
    }

    private int initNetworkGame() {
        if (this.isServerGame()) {
            NetworkDialogAction newGameServer = new NetworkDialogAction(this.getMainFrame(), "network.waitplayers"){

                @Override
                protected int doAction() {
                    GamePlayer[] player = GameEngine.this.getActivePlayers();
                    String msgNames = NetworkMessage.msgPlayerNamesS(player);
                    int numClient = 0;
                    int i = 0;
                    while (i < player.length) {
                        if (player[i].isNetwork()) {
                            NetworkClient client = GameEngine.this.netServer.getClient(numClient);
                            if (client != null) {
                                client.setClientNr(i);
                                if (GameEngine.this.netServer.putMessage(numClient, NetworkMessage.msgNewGameInfoS(i, GameEngine.this.getGameManager())) != 0) {
                                    return -30303;
                                }
                                if (GameEngine.this.netServer.putMessage(numClient, msgNames) != 0) {
                                    return -30301;
                                }
                            }
                            ++numClient;
                        }
                        ++i;
                    }
                    if (GameEngine.this.netServer.waitForClientsGameOk("TJxGE")) {
                        return 0;
                    }
                    return -30303;
                }
            };
            NetworkDialogAction.run(newGameServer);
            return newGameServer.getReturnValue();
        }
        if (this.isClientGame()) {
            NetworkDialogAction newGameClient = new NetworkDialogAction(this.getMainFrame(), "network.waitplayers"){

                @Override
                protected int doAction() {
                    ArrayList<String> listPlayerNames = new ArrayList<String>();
                    ArrayList<String> listPlayerColors = new ArrayList<String>();
                    HashMap<String, String> mapInfo = new HashMap<String, String>();
                    int[] clientNr = new int[1];
                    int[] cyclicStartPlayer = new int[1];
                    boolean names = false;
                    boolean info = false;
                    while (!(GameEngine.this.netClient.messageServerAbort() || names && info)) {
                        if (!names) {
                            names = GameEngine.this.netClient.messageServerPlayerNames(listPlayerNames, listPlayerColors);
                        }
                        if (!info) {
                            info = GameEngine.this.netClient.messageServerNewGameInfo(clientNr, cyclicStartPlayer, mapInfo);
                        }
                        NetworkConnection.netWait();
                    }
                    if (!info) {
                        return -30303;
                    }
                    if (!names) {
                        return -30301;
                    }
                    GameEngine.this.netClient.setClientNr(clientNr[0]);
                    GameEngine.this.cyclingPlayerStartGame = cyclicStartPlayer[0];
                    GameEngine.this.getGameManager().resetNewGameInformation();
                    String[] keys = mapInfo.keySet().toArray(new String[0]);
                    int i = 0;
                    while (i < keys.length) {
                        GameEngine.this.getGameManager().setNewGameInformation(keys[i], ((String)mapInfo.get(keys[i])).toString());
                        ++i;
                    }
                    GameEngine.this.numberPlayers = listPlayerNames.size();
                    GameEngine.this.activePlayers = new GamePlayer[GameEngine.this.numberPlayers];
                    GamePlayer[] allPlayers = GameEngine.this.getPlayerManager().getPlayers();
                    PlayerType[] pt = PlayerFactory.getInstance().getNetworkPlayerTypes();
                    if (pt != null && pt.length > 0) {
                        int i2 = 0;
                        while (i2 < GameEngine.this.activePlayers.length) {
                            String pieceColor = (String)listPlayerColors.get(i2);
                            if (!HGBaseTools.hasContent(pieceColor)) {
                                pieceColor = allPlayers[i2].getPieceColor();
                            }
                            if (i2 == GameEngine.this.netClient.getClientNr()) {
                                GameEngine.this.activePlayers[i2] = allPlayers[0].clone();
                                GameEngine.this.activePlayers[i2].setPieceColor(pieceColor);
                            } else {
                                int help = i2 == 0 ? GameEngine.this.netClient.getClientNr() : i2;
                                ImageIcon imgPlayer = allPlayers[help].getImage();
                                GameEngine.this.activePlayers[i2] = PlayerFactory.getInstance().createPlayer(pt[0].getId(), (String)listPlayerNames.get(i2), imgPlayer, pieceColor);
                            }
                            ++i2;
                        }
                        GameEngine.this.netClient.putMessage(NetworkMessage.msgClientGameOkC("TJxGE"));
                        return 0;
                    }
                    return -30301;
                }
            };
            NetworkDialogAction.run(newGameClient);
            return newGameClient.getReturnValue();
        }
        return 0;
    }

    public boolean isNetworkGame() {
        return this.isServerGame() || this.isClientGame();
    }

    public boolean isServerGame() {
        return this.serverGame;
    }

    public boolean isClientGame() {
        return this.clientGame;
    }

    public void stopNetwork() {
        if (this.netServer != null) {
            this.netServer.close();
        }
        if (this.netClient != null) {
            this.netClient.close();
        }
        this.clientGame = false;
        this.serverGame = false;
    }

    public NetworkServerConnection getNetworkServer() {
        return this.netServer;
    }

    public NetworkClientConnection getNetworkClient() {
        return this.netClient;
    }

    public int saveEngine(Document doc, Element root) {
        GameEngineFileOperator.write(doc, root, this);
        return 0;
    }

    public int loadEngine(Node root) {
        if (!GameEngineFileOperator.read(root, this)) {
            return -10706;
        }
        int ret = this.askUserForAbort();
        if (ret == 0) {
            this.adjustPlayerProfiles(false);
        }
        return ret;
    }

    private int askUserForAbort() {
        if (this.getGameConfig().isRememberGames() || this.getGameConfig().isRememberScores()) {
            ArrayList<String> listExist = new ArrayList<String>();
            PlayerProfiles profiles = this.getGameManager().getPlayerProfiles();
            int i = 0;
            while (i < this.activePlayers.length) {
                if (profiles.existsPlayer(this.activePlayers[i])) {
                    listExist.add(this.activePlayers[i].getName());
                }
                ++i;
            }
            if (!listExist.isEmpty()) {
                String title = HGBaseText.getText("dlg.profileexists", new String[0]);
                String message = HGBaseText.getText("dlg.warnprofileoverwrite", new String[0]);
                message = this.createPlayerNameList(listExist, message);
                Object[] options = new String[]{HGBaseText.getText("dlg.loadgame", new String[0]), HGBaseText.getText("dlg.cancel", new String[0])};
                int ret = HGBaseDialog.showOptionDialog(this.getMainFrame(), (Object)message, title, 0, 2, null, options, 1);
                if (ret == 1) {
                    return -2147483631;
                }
            }
        }
        return 0;
    }

    private String createPlayerNameList(List<String> listExist, String msg) {
        StringBuffer message = new StringBuffer(msg);
        message.append("\n(");
        int listExistSize = listExist.size();
        int i = 0;
        while (i < listExistSize) {
            if (i > 0) {
                message.append(", ");
            }
            message.append(listExist.get(i));
            ++i;
        }
        message.append(')');
        return message.toString();
    }
}

