/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed;

import hgb.lib.HGBaseTools;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.game.GamePlayer;
import tjger.game.completed.GameEngine;
import tjger.lib.XmlUtil;

class GameEngineFileOperator {
    private static boolean loadPlayers;
    private static int loadNumPlayers;
    private static boolean loadMtrg;

    GameEngineFileOperator() {
    }

    public static void write(Document doc, Element root, GameEngine engine) {
        Element players = doc.createElement("players");
        GamePlayer[] player = engine.getActivePlayers();
        if (player != null) {
            players.setAttribute("number", String.valueOf(player.length));
            players.setAttribute("start", String.valueOf(engine.getPlayerStartRound()));
            players.setAttribute("current", String.valueOf(engine.getCurrentPlayerIndex()));
            players.setAttribute("cyclic", String.valueOf(engine.getCyclingFirstGamePlayerIndex()));
            int i = 0;
            while (i < player.length) {
                Element pi = XmlUtil.savePlayer(doc, "p" + i, player[i]);
                players.appendChild(pi);
                ++i;
            }
            root.appendChild(players);
            Element mtrg = doc.createElement("mtrg");
            mtrg.setAttribute("move", String.valueOf(engine.getCurrentMove()));
            mtrg.setAttribute("turn", String.valueOf(engine.getCurrentTurn()));
            mtrg.setAttribute("round", String.valueOf(engine.getCurrentRound()));
            mtrg.setAttribute("activeround", String.valueOf(engine.isActiveRound()));
            mtrg.setAttribute("activegame", String.valueOf(engine.isActiveGame()));
            root.appendChild(mtrg);
        }
    }

    public static boolean read(Node root, final GameEngine engine) {
        loadPlayers = false;
        loadNumPlayers = 0;
        loadMtrg = false;
        ChildNodeIterator.run(new ChildNodeIterator(root, "gameengine", engine){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (node.getNodeName().equals("players")) {
                    int number = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "number"));
                    int start = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "start"));
                    int current = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "current"));
                    int cyclic = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "cyclic"));
                    if (number > 0 && start >= -1 && current >= -1) {
                        loadPlayers = true;
                        engine.numberPlayers = number;
                        engine.playerStartRound = start;
                        engine.currentPlayer = current;
                        engine.cyclingPlayerStartGame = Math.max(cyclic, 0);
                        engine.activePlayers = new GamePlayer[engine.numberPlayers];
                        ChildNodeIterator.run(new ChildNodeIterator(node, "players", engine){

                            @Override
                            public void performNode(Node node, int index, Object obj) {
                                GamePlayer player;
                                int i;
                                if (node.getNodeName().startsWith("p") && (i = HGBaseTools.toInt(node.getNodeName().replaceFirst("p", ""))) >= 0 && (player = XmlUtil.loadPlayer(node)) != null) {
                                    engine.activePlayers[loadNumPlayers] = player;
                                    loadNumPlayers = loadNumPlayers + 1;
                                }
                            }
                        });
                    }
                }
                if (node.getNodeName().equals("mtrg")) {
                    int move = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "move"));
                    int turn = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "turn"));
                    int round = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "round"));
                    if (move >= 0 && turn >= 0 && round >= 0) {
                        loadMtrg = true;
                        engine.currentMove.set(move);
                        engine.currentTurn = turn;
                        engine.currentRound = round;
                        engine.activeRound = HGBaseXMLTools.getAttributeValue(node, "activeround").equals("true");
                        engine.activeGame = HGBaseXMLTools.getAttributeValue(node, "activegame").equals("true");
                        engine.stoppedGame = false;
                    }
                }
            }
        });
        return loadMtrg && loadPlayers && loadNumPlayers > 0 && loadNumPlayers == engine.getNumberPlayers();
    }
}

