/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed;

import hgb.lib.HGBaseTools;
import hgb.lib.internal.IntBooleanStringMap;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.MainFrame;
import tjger.game.GameRules;
import tjger.game.GameState;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngine;
import tjger.game.completed.PlayerManager;
import tjger.game.internal.GameRecorder;
import tjger.game.internal.GameStatistics;
import tjger.game.internal.PlayerProfiles;
import tjger.game.internal.RulesFactory;
import tjger.gui.PartSorter;

public final class GameManager {
    private static GameManager manager;
    private final MainFrame main;
    private GameEngine gameEngine;
    private GameConfig gameConfig;
    private PlayerManager playerManager;
    private GameRules gameRules;
    private IntBooleanStringMap gameInfoMap;
    private Map<String, PartSorter> sorterMap;
    private int loadError;

    private GameManager(MainFrame main) {
        this.main = main;
        this.sorterMap = new HashMap<String, PartSorter>();
        this.readGameConfiguration();
        this.resetNewGameInformation();
    }

    private void readGameConfiguration() {
        this.gameConfig = GameConfig.getInstance();
        this.gameEngine = GameEngine.getInstance();
        this.gameRules = RulesFactory.getInstance().createGameRules();
        this.playerManager = PlayerManager.getInstance();
    }

    public static GameManager createInstance(MainFrame main) {
        if (manager == null) {
            manager = new GameManager(main);
        }
        return manager;
    }

    public static GameManager getInstance() {
        return manager;
    }

    public MainFrame getMainFrame() {
        return this.main;
    }

    public GameConfig getGameConfig() {
        return this.gameConfig;
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public GameRules getGameRules() {
        return this.gameRules;
    }

    public GameState getGameState() {
        return this.getGameEngine().getGameState();
    }

    public GameEngine getGameEngine() {
        return this.gameEngine;
    }

    public GameStatistics getGameStatistics() {
        return GameStatistics.getInstance();
    }

    public PlayerProfiles getPlayerProfiles() {
        return PlayerProfiles.getInstance();
    }

    public void resetNewGameInformation() {
        this.gameInfoMap = new IntBooleanStringMap();
    }

    public void setNewGameInformation(String infoKey, String information) {
        this.gameInfoMap.set(infoKey, information);
    }

    public void setNewGameInformation(String infoKey, int information) {
        this.gameInfoMap.set(infoKey, information);
    }

    public void setNewGameInformation(String infoKey, boolean information) {
        this.gameInfoMap.set(infoKey, information);
    }

    private String getNewGameInformation(String infoKey) {
        return this.gameInfoMap.get(infoKey);
    }

    public String getNewGameInformationText(String infoKey) {
        return this.getNewGameInformationText(infoKey, "");
    }

    public String getNewGameInformationText(String infoKey, String defaultValue) {
        return this.gameInfoMap.get(infoKey, defaultValue);
    }

    public int getNewGameInformationInt(String infoKey) {
        return this.getNewGameInformationInt(infoKey, -2147483631);
    }

    public int getNewGameInformationInt(String infoKey, int defaultValue) {
        return this.gameInfoMap.getInt(infoKey, defaultValue);
    }

    public boolean getNewGameInformationBoolean(String infoKey) {
        return this.getNewGameInformationBoolean(infoKey, false);
    }

    public boolean getNewGameInformationBoolean(String infoKey, boolean defaultValue) {
        return this.gameInfoMap.getBoolean(infoKey, defaultValue);
    }

    public String[] getNewGameInformationKeys() {
        return this.gameInfoMap.getKeys();
    }

    public void setPartSorter(String partType, PartSorter partSorter) {
        this.sorterMap.put(partType, partSorter);
    }

    public PartSorter getPartSorter(String partType) {
        return this.sorterMap.get(partType);
    }

    public int saveGame(Document doc) {
        if (doc == null) {
            return -10705;
        }
        String gameStateXmlRoot = GameConfig.getInstance().getGameStateXmlRoot();
        if (HGBaseTools.hasContent(gameStateXmlRoot)) {
            Element root = doc.createElement(gameStateXmlRoot);
            doc.appendChild(root);
            return this.getGameState().save(doc, root);
        }
        Element root = doc.createElement("tjgergame");
        doc.appendChild(root);
        int ret = 0;
        this.saveNewGameInformation(doc, root);
        Element gameEngine = doc.createElement("gameengine");
        ret = this.getGameEngine().saveEngine(doc, gameEngine);
        if (ret != 0) {
            return ret;
        }
        root.appendChild(gameEngine);
        Element gameStats = doc.createElement("gamestatistics");
        ret = this.getGameStatistics().saveStatistics(doc, gameStats);
        if (ret != 0) {
            return ret;
        }
        root.appendChild(gameStats);
        Element gameState = doc.createElement("gamestate");
        ret = this.getGameState().save(doc, gameState);
        if (ret != 0) {
            return ret;
        }
        root.appendChild(gameState);
        return 0;
    }

    public int loadGame(Node root) {
        GameEngine engine = this.getGameEngine();
        this.loadError = 0;
        this.resetNewGameInformation();
        String gameStateXmlRoot = GameConfig.getInstance().getGameStateXmlRoot();
        if (HGBaseTools.hasContent(gameStateXmlRoot)) {
            this.loadError = this.getGameState().load(root);
        } else {
            ChildNodeIterator.run(new ChildNodeIterator(root, "tjgergame", this){

                @Override
                public void performNode(Node node, int index, Object obj) {
                    GameManager manager = (GameManager)obj;
                    if (node.getNodeName().equals("newgameinfo")) {
                        GameManager.this.loadNewGameInformation(node);
                    }
                    if (node.getNodeName().equals("gameengine") && manager.loadError == 0) {
                        manager.loadError = manager.getGameEngine().loadEngine(node);
                    }
                    if (node.getNodeName().equals("gamestatistics") && manager.loadError == 0) {
                        manager.loadError = manager.getGameStatistics().loadStatistics(node);
                    }
                    if (node.getNodeName().equals("gamestate") && manager.loadError == 0) {
                        manager.loadError = manager.getGameState().load(node);
                    }
                }
            });
        }
        if (this.loadError == 0) {
            this.testForPlayingRecordedGame(root);
            engine.contributeGameState(1);
            engine.contributeGameState(2);
            engine.contributeGameState(3);
            this.getGameStatistics().saveScoreAndGames();
            if (engine.isActiveRound()) {
                if (this.getGameRules().isTurnFinished(this.getGameState()) || engine.getCurrentMove() == 0) {
                    engine.newTurn(false);
                } else {
                    engine.doPlayerMove(false, false);
                }
            } else if (engine.isActiveGame()) {
                engine.contributeGameState(7);
                if (!this.getGameConfig().isInterruptAfterRound() || engine.getCurrentRound() == 0) {
                    engine.newRound();
                }
            } else {
                engine.contributeGameState(4);
            }
        } else {
            engine.stopGame();
        }
        return this.loadError;
    }

    private boolean testForPlayingRecordedGame(Node root) {
        return GameRecorder.getInstance().initRecordedGame(root);
    }

    private void saveNewGameInformation(Document doc, Element root) {
        Element ngi = doc.createElement("newgameinfo");
        String[] keys = this.getNewGameInformationKeys();
        int i = 0;
        while (i < keys.length) {
            Element info = doc.createElement("info");
            info.setAttribute("key", keys[i]);
            String value = this.getNewGameInformation(keys[i]);
            info.setAttribute("value", value.toString());
            ngi.appendChild(info);
            ++i;
        }
        root.appendChild(ngi);
    }

    private void loadNewGameInformation(Node node) {
        ChildNodeIterator.run(new ChildNodeIterator(node, "newgameinfo", this){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (node.getNodeName().equals("info")) {
                    String key = HGBaseXMLTools.getAttributeValue(node, "key");
                    String value = HGBaseXMLTools.getAttributeValue(node, "value");
                    GameManager.this.setNewGameInformation(key, value);
                }
            }
        });
    }
}

