/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed;

import hgb.gui.HGBaseGuiTools;
import hgb.lib.HGBaseLog;
import hgb.lib.xml.HGBaseXMLTools;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.w3c.dom.Node;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameConfigFileReader;
import tjger.game.completed.GameElementSetConstructor;
import tjger.game.completed.PartSetWrapper;
import tjger.gui.completed.ColorValuePart;
import tjger.gui.completed.PartSet;

abstract class PartSetConstructor<T extends PartSet>
extends GameElementSetConstructor<PartSetWrapper<T>, ColorValuePart> {
    protected final List<T> setList;
    protected final Map<String, List<T>> setMap;

    protected PartSetConstructor(String typeConfigKey, String setConfigKey, String elementConfigKey, List<T> setList) {
        super(typeConfigKey, setConfigKey, elementConfigKey, "image");
        this.setList = setList;
        this.setMap = null;
    }

    protected PartSetConstructor(String typeConfigKey, String setConfigKey, String elementConfigKey, Map<String, List<T>> setMap) {
        super(typeConfigKey, setConfigKey, elementConfigKey, "image");
        this.setList = null;
        this.setMap = setMap;
    }

    @Override
    protected String getAlternativeSetType(Node node) {
        if ("cardset".equals(node.getNodeName())) {
            return "game.cardset";
        }
        return "";
    }

    @Override
    protected void logTypeMissing(String setName) {
        HGBaseLog.logWarn("No type defined for part set '" + setName + "'!");
    }

    @Override
    protected final PartSetWrapper<T> createSet(String type, String name, boolean hidden, Node node, GameConfig config) {
        return new PartSetWrapper<T>(this.createPartSet(type, name, hidden, node));
    }

    @Override
    protected boolean isTypeNeeded() {
        return this.setMap != null;
    }

    @Override
    protected void addSetToCollection(PartSetWrapper<T> set, String type) {
        if (this.setList != null) {
            this.setList.add(set.getPartSet());
        }
        if (this.setMap != null) {
            GameConfigFileReader.getListFromMap(this.setMap, type).add(set.getPartSet());
        }
    }

    protected abstract T createPartSet(String var1, String var2, boolean var3, Node var4);

    @Override
    protected final ColorValuePart createElement(PartSetWrapper<T> set, Node node, int sequence, GameConfig config) {
        String color = HGBaseXMLTools.getAttributeValue(node, "color");
        int value = HGBaseXMLTools.getAttributeIntValue(node, "value");
        String imagePath = this.getElementFilePath(node, sequence, set, config);
        ImageIcon image = HGBaseGuiTools.loadImage(imagePath);
        if (image == null) {
            HGBaseLog.logWarn("The " + this.elementConfigKey + "'s image file " + imagePath + " was not found!");
            return null;
        }
        return this.createColorValuePart(set.getPartSet(), color, sequence, this.getPartValue(value, sequence), image, node);
    }

    @Override
    protected String getElementFileName(Node node, PartSetWrapper<T> set) {
        return HGBaseXMLTools.getAttributeValue(node, "color");
    }

    protected String calculateImagePath(String partSetName, String color, int sequence, GameConfig config) {
        return config.getElementPath(this.elementConfigKey) + "/" + partSetName + "/" + color + "-" + sequence + "." + config.getElementExtension(this.elementConfigKey);
    }

    protected abstract ColorValuePart createColorValuePart(T var1, String var2, int var3, int var4, ImageIcon var5, Node var6);

    private int getPartValue(int value, int sequence) {
        return value == -2147483631 ? sequence : value;
    }
}

