/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed;

import hgb.gui.HGBaseGuiTools;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseTools;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.ImageIcon;
import tjger.game.GamePlayer;
import tjger.game.completed.GameConfig;
import tjger.game.internal.PlayerFactory;
import tjger.lib.ArrayUtil;

public final class PlayerManager {
    private static PlayerManager manager = new PlayerManager();
    private final GameConfig gameConfig = GameConfig.getInstance();
    private GamePlayer[] playerList;

    private PlayerManager() {
        this.initPlayers();
    }

    public static PlayerManager getInstance() {
        return manager;
    }

    private void initPlayers() {
        this.playerList = new GamePlayer[this.getMaxPlayers()];
        String imagePath = this.gameConfig.getElementPath("player");
        String imageExtension = this.gameConfig.getElementExtension("player");
        int i = 0;
        while (i < this.playerList.length) {
            String playerType = this.getPlayerType(i);
            String playerName = this.getStandardPlayerName(i);
            ImageIcon playerImage = this.getPlayerImage(i, imagePath, imageExtension);
            String pieceColor = this.getPieceColor(i);
            this.playerList[i] = PlayerFactory.getInstance().createPlayer(playerType, playerName, playerImage, pieceColor);
            ++i;
        }
    }

    private ImageIcon getPlayerImage(int i, String imagePath, String imageExtension) {
        Object imageName = HGBaseConfig.get("player.image" + i);
        if (!HGBaseTools.hasContent((String)imageName)) {
            imageName = this.gameConfig.getPlayerImageName() + i;
        }
        return HGBaseGuiTools.loadImage(imagePath + "/" + (String)imageName + "." + imageExtension);
    }

    private String getPieceColor(int i) {
        Object pieceColor = HGBaseConfig.get("player.piececolor" + i);
        if (!HGBaseTools.hasContent((String)pieceColor) && HGBaseTools.hasContent(this.gameConfig.getPlayerPieceColor())) {
            pieceColor = this.gameConfig.getPlayerPieceColor() + i;
        }
        return pieceColor;
    }

    public String getStandardPlayerName(int i) {
        Object playerName = HGBaseConfig.get("player.name" + i);
        if (!HGBaseTools.hasContent((String)playerName)) {
            playerName = HGBaseSettings.get("appName") + " " + (i + 1);
        }
        return playerName;
    }

    private String getPlayerType(int index) {
        String playerType = HGBaseConfig.get("player.type" + index);
        Object[] supportedPlayerTypes = ArrayUtil.toPlayerTypeIds(PlayerFactory.getInstance().getSupportedPlayerTypes());
        if (HGBaseTools.getIndexOf(supportedPlayerTypes, playerType) >= 0 || supportedPlayerTypes.length == 0) {
            return playerType;
        }
        String[] humanPlayerTypes = ArrayUtil.toPlayerTypeIds(PlayerFactory.getInstance().getHumanPlayerTypes());
        String[] networkPlayerTypes = ArrayUtil.toPlayerTypeIds(PlayerFactory.getInstance().getNetworkPlayerTypes());
        Optional<String> optPlayerType1 = Arrays.stream(supportedPlayerTypes).filter(type -> HGBaseTools.getIndexOf(networkPlayerTypes, type) == -1).filter(type -> HGBaseTools.getIndexOf(humanPlayerTypes, type) == -1 || !this.gameConfig.isOneHumanPlayer() || index == 0).findFirst();
        if (optPlayerType1.isPresent()) {
            return optPlayerType1.get();
        }
        Optional<String> optPlayerType2 = Arrays.stream(supportedPlayerTypes).filter(type -> HGBaseTools.getIndexOf(humanPlayerTypes, type) == -1 || !this.gameConfig.isOneHumanPlayer() || index == 0).findFirst();
        return optPlayerType2.orElse((String)supportedPlayerTypes[0]);
    }

    public int getMinPlayers() {
        return this.gameConfig.getMinPlayers();
    }

    public int getMaxPlayers() {
        return this.gameConfig.getMaxPlayers();
    }

    public GamePlayer[] getPlayers() {
        if (this.playerList == null) {
            return null;
        }
        return (GamePlayer[])this.playerList.clone();
    }

    public GamePlayer getPlayer(int index) {
        if (index >= 0 && index < this.playerList.length) {
            return this.playerList[index];
        }
        return null;
    }

    public int getIndexOfPlayer(GamePlayer player) {
        int index = -1;
        int i = 0;
        while (i < this.playerList.length && index == -1) {
            if (this.playerList[i].equals(player)) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public void setPlayer(int index, GamePlayer player) {
        if (index >= 0 && index < this.playerList.length && player != null && this.getIndexOfPlayer(player) == -1) {
            this.playerList[index] = player;
        }
    }
}

