/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed;

import hgb.gui.HGBaseItem;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import javax.swing.ImageIcon;
import tjger.game.internal.PlayerFactory;
import tjger.lib.ArrayUtil;

public class PlayerType
implements HGBaseItem {
    private final String playerType;
    private final ImageIcon typeImage;

    public PlayerType(String playerType, ImageIcon typeImage) {
        this.playerType = playerType;
        this.typeImage = typeImage;
    }

    @Override
    public String getId() {
        return this.playerType;
    }

    public ImageIcon getImage() {
        return this.typeImage;
    }

    public String toString() {
        return HGBaseText.getText(this.getId(), new String[0]);
    }

    public boolean isHuman() {
        Object[] hp = ArrayUtil.toPlayerTypeIds(PlayerFactory.getInstance().getHumanPlayerTypes());
        return HGBaseTools.getIndexOf(hp, this.getId()) >= 0;
    }

    public boolean isNetwork() {
        Object[] np = ArrayUtil.toPlayerTypeIds(PlayerFactory.getInstance().getNetworkPlayerTypes());
        return HGBaseTools.getIndexOf(np, this.getId()) >= 0;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof PlayerType) {
            return this.getId().equals(((PlayerType)o2).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

