/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed;

import hgb.lib.HGBaseLog;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameConfigFileReader;
import tjger.game.completed.GameElementSetConstructor;
import tjger.gui.completed.Sound;
import tjger.gui.completed.SoundSet;

abstract class SoundSetConstructor
extends GameElementSetConstructor<SoundSet, Sound> {
    protected final Map<String, List<SoundSet>> setMap;

    protected SoundSetConstructor(String typeConfigKey, String setConfigKey, String elementConfigKey, String fileConfigKey, Map<String, List<SoundSet>> setMap) {
        super(typeConfigKey, setConfigKey, elementConfigKey, fileConfigKey);
        this.setMap = setMap;
    }

    @Override
    protected String getAlternativeSetType(Node node) {
        return null;
    }

    @Override
    protected void logTypeMissing(String setName) {
        HGBaseLog.logWarn("No type defined for sound set '" + setName + "'!");
    }

    @Override
    protected SoundSet createSet(String type, String name, boolean hidden, Node node, GameConfig config) {
        return new SoundSet(type, name, hidden);
    }

    @Override
    protected Sound createElement(SoundSet set, Node node, int sequence, GameConfig config) {
        return new Sound(set.getType(), set.getName(), sequence, this.getElementFilePath(node, sequence, set, config), false);
    }

    @Override
    protected String getElementFileName(Node node, SoundSet set) {
        return set.getType();
    }

    @Override
    protected boolean isTypeNeeded() {
        return this.setMap != null;
    }

    @Override
    protected void addSetToCollection(SoundSet set, String type) {
        if (this.setMap != null) {
            GameConfigFileReader.getListFromMap(this.setMap, type).add(set);
        }
    }

    public static void construct(Node node, GameConfig config) {
        new SoundSetConstructor("sounds", "soundset", "sound", "file", (Map)config.soundSetMap){}.run(node, config);
    }
}

