/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed;

import hgb.lib.HGBaseSound;
import java.util.List;
import java.util.Random;
import tjger.game.completed.GameConfig;
import tjger.gui.completed.Sound;
import tjger.gui.completed.SoundSet;

public class SoundUtil {
    private static final Random random = new Random();

    private SoundUtil() {
    }

    public static void playSound(Sound sound) {
        if (sound == null) {
            return;
        }
        HGBaseSound.playAudio(sound.getFilename());
    }

    public static void playSound(String type, String name) {
        SoundUtil.playSound(GameConfig.getInstance().getSound(type, name));
    }

    public static void playActiveSound(String type) {
        SoundUtil.playSound(GameConfig.getInstance().getActiveSound(type));
    }

    public static void playSoundSetSound(SoundSet soundSet, int sequence) {
        if (soundSet == null) {
            return;
        }
        SoundUtil.playSound(soundSet.getSound(sequence));
    }

    public static void playSoundSetRandomSound(SoundSet soundSet) {
        if (soundSet == null) {
            return;
        }
        List<Sound> sounds = soundSet.getSounds();
        if (sounds == null || sounds.isEmpty()) {
            return;
        }
        SoundUtil.playSound(sounds.get(random.nextInt(sounds.size())));
    }

    public static void playActiveSoundSetSound(String type, int sequence) {
        SoundUtil.playSoundSetSound(GameConfig.getInstance().getActiveSoundSet(type), sequence);
    }

    public static void playActiveSoundSetRandomSound(String type) {
        SoundUtil.playSoundSetRandomSound(GameConfig.getInstance().getActiveSoundSet(type));
    }
}

