/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed.imagereader;

import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseTools;
import tjger.game.completed.imagereader.AbstractImageEffectReader;
import tjger.gui.completed.ImageReflection;
import tjger.gui.completed.Part;

public class ImageReflectionReader
extends AbstractImageEffectReader<ImageReflection> {
    public ImageReflectionReader() {
        super("reflection");
    }

    @Override
    protected ImageReflection readEffectDefinition(String effectValue) {
        if (!effectValue.isEmpty()) {
            int gap = HGBaseTools.toInt(effectValue);
            if (HGBaseTools.isValid(gap)) {
                return new ImageReflection(gap);
            }
            if (HGBaseTools.toBoolean(effectValue)) {
                return new ImageReflection();
            }
            String[] data = effectValue.split(";");
            if (data.length == 3) {
                int g = HGBaseTools.toInt(data[0]);
                float h = HGBaseTools.toFloat(data[1]);
                float a = HGBaseTools.toFloat(data[2]);
                if (HGBaseTools.isValid(g) && HGBaseTools.isValid(h) && HGBaseTools.isValid(a)) {
                    return new ImageReflection(g, h, a);
                }
            }
            HGBaseLog.logWarn("Invalid reflection detected for node " + this.getCurrentNode().getNodeName() + "!");
        }
        return null;
    }

    @Override
    protected void setEffectForPart(Part part, ImageReflection effect) {
        part.setReflection(effect);
    }

    @Override
    public ImageReflection getEffectFromPart(Part part) {
        return part.getReflection();
    }
}

