/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed.playingfield;

import hgb.gui.HGBaseGuiTools;
import hgb.lib.HGBaseTools;
import hgb.lib.Pair;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import tjger.game.completed.playingfield.GridType;
import tjger.game.completed.playingfield.PlayingFieldShortestPathMethods;
import tjger.game.completed.playingfield.ShapeType;
import tjger.game.completed.playingfield.SingleField;
import tjger.game.completed.playingfield.SingleFieldConnection;
import tjger.lib.ShortestPath;
import tjger.lib.ShortestPathFinder;

public class PlayingField {
    private Dimension size;
    private GridType gridType;
    private Dimension grid;
    private Dimension gridSize;
    private Dimension gridSpan;
    private final Map<String, SingleField> fields = new HashMap<String, SingleField>();
    private final Map<SingleField, Map<SingleField, Integer>> connections = new HashMap<SingleField, Map<SingleField, Integer>>();
    private final Map<SingleField, Map<SingleField, Map<String, String>>> connectionProperties = new HashMap<SingleField, Map<SingleField, Map<String, String>>>();
    private int idCounter = 0;

    public PlayingField(int width, int height) {
        this.size = new Dimension(width, height);
        this.gridType = GridType.NO;
    }

    public PlayingField(Dimension grid, Dimension gridSize, Dimension gridSpan) {
        this.grid = Objects.requireNonNull(grid, "The grid object must not be null!");
        this.gridSize = Objects.requireNonNull(gridSize, "The grid size must not be null!");
        this.gridSpan = Objects.requireNonNull(gridSpan, "The grid span must not be null!");
        this.gridType = GridType.YES;
        this.calculateSizeByGrid();
    }

    private void calculateSizeByGrid() {
        if (this.grid != null) {
            Point edgeBottomRight = this.getPositionOnGrid(this.grid.width, this.grid.height);
            this.size = new Dimension(edgeBottomRight.x, edgeBottomRight.y);
        }
    }

    public Dimension getSize() {
        return this.size;
    }

    public Dimension getGrid() {
        return this.grid;
    }

    public void setGrid(Dimension grid) {
        if (grid == null) {
            if (this.gridType == GridType.YES) {
                for (SingleField field : this.fields.values()) {
                    Point gridPosition = field.getGridPosition();
                    Point point1 = this.getPositionOnGrid(gridPosition.x, gridPosition.y);
                    Point point2 = new Point(point1.x + this.gridSize.width - 1, point1.y + this.gridSize.height - 1);
                    Point[] pixelPositions = new Point[]{point1, point2};
                    field.setPixelPositions(pixelPositions);
                }
            }
            this.gridType = GridType.NO;
        } else {
            if (this.gridType == GridType.NO) {
                this.gridType = GridType.MIXED;
            }
            this.calculateSizeByGrid();
        }
        this.grid = grid;
    }

    public GridType getGridType() {
        return this.gridType;
    }

    public Dimension getGridSpan() {
        return this.gridSpan;
    }

    public void setGridSpan(Dimension gridSpan) {
        this.gridSpan = this.grid == null ? gridSpan : Objects.requireNonNull(gridSpan, "The grid span must not be null!");
        this.calculateSizeByGrid();
    }

    public Dimension getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(Dimension gridSize) {
        this.gridSize = this.grid == null ? gridSize : Objects.requireNonNull(gridSize, "The grid size must not be null!");
        this.calculateSizeByGrid();
    }

    public Point getGridForPosition(int x, int y) {
        if (this.grid != null) {
            int gridX = x / (this.gridSpan.width + this.gridSize.width);
            int gridY = y / (this.gridSpan.height + this.gridSize.height);
            if (gridX < this.grid.width && gridY < this.grid.height && x % (this.gridSpan.width + this.gridSize.width) >= this.gridSpan.width && y % (this.gridSpan.height + this.gridSize.height) >= this.gridSpan.height) {
                return new Point(gridX, gridY);
            }
        }
        return null;
    }

    private Point getPositionOnGrid(int column, int row) {
        int x = column * this.gridSize.width + (column + 1) * this.gridSpan.width;
        int y = row * this.gridSize.height + (row + 1) * this.gridSpan.height;
        return new Point(x, y);
    }

    public Point[] getPixelPositions(SingleField field) {
        Point gridPosition = field.getGridPosition();
        if (gridPosition != null) {
            Point[] positions;
            positions = new Point[]{this.getPositionOnGrid(gridPosition.x, gridPosition.y), new Point(positions[0].x + this.gridSize.width - 1, positions[0].y + this.gridSize.height - 1)};
            return positions;
        }
        return field.getPixelPositions();
    }

    public Rectangle getFieldRectangle(SingleField field) {
        Point[] pos = this.getPixelPositions(field);
        return new Rectangle(pos[0].x, pos[0].y, pos[1].x - pos[0].x, pos[1].y - pos[0].y);
    }

    public SingleField getFieldAtPosition(int x, int y) {
        ArrayList<SingleField> sortedFields = new ArrayList<SingleField>(this.getFields());
        int i = sortedFields.size() - 1;
        while (i >= 0) {
            Point[] positions;
            SingleField field = (SingleField)sortedFields.get(i);
            if (ShapeType.POLYGON.equals((Object)field.getShape()) ? HGBaseGuiTools.isPointInPolygon(new Point(x, y), this.getPixelPositions(field)) : (positions = this.getPixelPositions(field)) != null && positions.length == 2 && x >= positions[0].x && x <= positions[1].x && y >= positions[0].y && y <= positions[1].y) {
                return field;
            }
            --i;
        }
        return null;
    }

    public String getFieldIdAtPosition(int x, int y) {
        SingleField sf = this.getFieldAtPosition(x, y);
        return sf == null ? null : sf.getId();
    }

    public SingleField getFieldAtGridPosition(Point gridPos) {
        if (gridPos != null && this.getGrid() != null) {
            for (SingleField field : this.getFields()) {
                if (!gridPos.equals(field.getGridPosition())) continue;
                return field;
            }
        }
        return null;
    }

    public Collection<SingleField> getFields() {
        TreeSet<SingleField> sortedFields = new TreeSet<SingleField>(this.fields.values());
        return Collections.unmodifiableCollection(sortedFields);
    }

    public SingleField getField(String id) {
        return this.fields.get(id);
    }

    public SingleField getFirstFieldWithProperty(String key, String value) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(key, value);
        return this.getFirstFieldWithProperties(properties);
    }

    public SingleField getFirstFieldWithProperties(Map<String, String> properties) {
        for (SingleField sf : this.getFields()) {
            if (!this.checkPropertiesForField(sf, properties)) continue;
            return sf;
        }
        return null;
    }

    public Collection<SingleField> getFieldsWithProperty(String key, String value) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(key, value);
        return this.getFieldsWithProperties(properties);
    }

    public Collection<SingleField> getFieldsWithProperties(Map<String, String> properties) {
        ArrayList<SingleField> localFields = new ArrayList<SingleField>();
        for (SingleField sf : this.getFields()) {
            if (!this.checkPropertiesForField(sf, properties)) continue;
            localFields.add(sf);
        }
        return Collections.unmodifiableCollection(localFields);
    }

    private boolean checkPropertiesForField(SingleField field, Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String fieldValue = field.getProperty(property.getKey());
            if (HGBaseTools.equalObject(fieldValue, property.getValue())) continue;
            return false;
        }
        return true;
    }

    public Collection<SingleField> getFieldsWithData(Object data) {
        ArrayList<SingleField> fieldsWithData = new ArrayList<SingleField>();
        for (SingleField field : this.fields.values()) {
            if (!data.equals(field.getData())) continue;
            fieldsWithData.add(field);
        }
        return fieldsWithData;
    }

    public void addField(SingleField field) {
        this.fields.put(field.getId(), field);
    }

    public void removeField(SingleField field) {
        if (this.fields.remove(field.getId()) != null) {
            this.connections.remove(field);
            for (Map<SingleField, Integer> connection : this.connections.values()) {
                connection.remove(field);
            }
        }
    }

    public void addConnection(SingleField start, SingleField target, int weight) {
        if (weight < 1) {
            throw new IllegalArgumentException("The weight of the connection must be 1 or higher");
        }
        Map targets = HGBaseTools.getOrCreateValue(this.connections, start, new HashMap());
        targets.put(target, weight);
    }

    public void removeConnection(SingleField start, SingleField target) {
        Map<SingleField, Integer> targets = this.connections.get(start);
        if (targets != null) {
            targets.remove(target);
        }
    }

    Map<SingleField, Map<SingleField, Integer>> getConnectionsMap() {
        return Collections.unmodifiableMap(this.connections);
    }

    public Collection<SingleFieldConnection> getConnections() {
        LinkedHashSet<SingleFieldConnection> sfc = new LinkedHashSet<SingleFieldConnection>();
        for (Map.Entry<SingleField, Map<SingleField, Integer>> entry : this.connections.entrySet()) {
            SingleField f1 = entry.getKey();
            for (SingleField f2 : entry.getValue().keySet()) {
                sfc.add(new SingleFieldConnection(f1, f2));
            }
        }
        return Collections.unmodifiableCollection(sfc);
    }

    private int getWeight(SingleField start, SingleField target) {
        Integer w;
        Map<SingleField, Integer> targets = this.connections.get(start);
        int weight = 0;
        if (targets != null && (w = targets.get(target)) != null) {
            weight = w;
        }
        return weight;
    }

    public int getConnectionWeight(SingleField ... fields) {
        if (fields.length >= 2) {
            int weight = 0;
            int i = 0;
            while (i < fields.length - 1) {
                int w = this.getWeight(fields[i], fields[i + 1]);
                if (w == 0) {
                    return 0;
                }
                weight += w;
                ++i;
            }
            return weight;
        }
        return 0;
    }

    public void setConnectionProperties(SingleField from, SingleField to, Map<String, String> properties) {
        this.connectionProperties.computeIfAbsent(from, k -> new HashMap()).put(to, properties);
    }

    public void setConnectionProperty(SingleField from, SingleField to, Map.Entry<String, String> property) {
        if (property == null) {
            return;
        }
        this.connectionProperties.computeIfAbsent(from, k -> new HashMap()).computeIfAbsent(to, k -> new HashMap()).put(property.getKey(), property.getValue());
    }

    public Map<String, String> getConnectionProperties(SingleField from, SingleField to) {
        return this.connectionProperties.computeIfAbsent(from, k -> new HashMap()).computeIfAbsent(to, k -> new HashMap());
    }

    public Map<String, String> getConnectionProperties(SingleFieldConnection connection) {
        return connection == null ? new HashMap<String, String>() : this.getConnectionProperties((SingleField)connection.getFirst(), (SingleField)connection.getSecond());
    }

    public String getConnectionProperty(SingleField from, SingleField to, String key) {
        return this.getConnectionProperties(from, to).get(key);
    }

    public Collection<SingleField> getNeighbours(SingleField field) {
        return this.getNeighbours(field, (origin, target) -> true);
    }

    public Collection<SingleField> getNeighbours(SingleField field, BiPredicate<SingleField, SingleField> condition) {
        Map<SingleField, Integer> neighbours = this.connections.get(field);
        if (neighbours == null || neighbours.isEmpty()) {
            return Collections.emptySet();
        }
        return neighbours.keySet().stream().filter(target -> condition.test(field, (SingleField)target)).collect(Collectors.toUnmodifiableSet());
    }

    public ShortestPath<SingleField> getShortestPath(SingleField start, SingleField target) {
        return this.getShortestPath(start, target, 0);
    }

    public ShortestPath<SingleField> getShortestPath(SingleField start, SingleField target, int maxDepth) {
        return this.getShortestPath(start, target, maxDepth, (connectionOrigin, connectionTarget) -> true);
    }

    public ShortestPath<SingleField> getShortestPath(SingleField start, SingleField target, int maxDepth, BiPredicate<SingleField, SingleField> condition) {
        return ShortestPathFinder.find(new PlayingFieldShortestPathMethods(this, start, target, maxDepth, condition));
    }

    public Collection<SingleField> getReachableFields(SingleField start, int weight, boolean allowTurnBack) {
        return this.getReachableFields(start, weight, allowTurnBack, (SingleField origin, SingleField target) -> true);
    }

    public Collection<SingleField> getReachableFields(SingleField start, int weight, boolean allowTurnBack, BiPredicate<SingleField, SingleField> condition) {
        Set<SingleField> targets = this.getReachableFields(start, weight, condition, new HashMap<Pair<SingleField, Integer>, Set<SingleField>>());
        if (!allowTurnBack) {
            targets.removeIf(target -> this.getShortestPath(start, (SingleField)target, weight, condition).getPathWeight() < weight);
        }
        return !targets.isEmpty() ? Collections.unmodifiableCollection(targets) : Collections.emptySet();
    }

    private Set<SingleField> getReachableFields(SingleField start, int weight, BiPredicate<SingleField, SingleField> condition, Map<Pair<SingleField, Integer>, Set<SingleField>> neighbourCache) {
        Pair<SingleField, Integer> key = new Pair<SingleField, Integer>(start, weight);
        if (neighbourCache.containsKey(key)) {
            return neighbourCache.get(key);
        }
        HashSet<SingleField> targets = new HashSet<SingleField>();
        for (SingleField neighbour : this.getNeighbours(start, condition)) {
            int w = this.getWeight(start, neighbour);
            int remaining = weight - w;
            if (remaining == 0) {
                targets.add(neighbour);
                continue;
            }
            if (remaining <= 0) continue;
            targets.addAll(this.getReachableFields(neighbour, remaining, condition, neighbourCache));
        }
        neighbourCache.put(key, targets);
        return targets;
    }

    public boolean isFieldReachable(SingleField start, SingleField target, int weight, boolean allowTurnBack) {
        return this.getReachableFields(start, weight, allowTurnBack).contains(target);
    }

    public Set<String> getFieldPropertyKeys() {
        TreeSet<String> keys = new TreeSet<String>();
        for (SingleField field : this.fields.values()) {
            keys.addAll(field.getPropertyKeys());
        }
        return Collections.unmodifiableSet(keys);
    }

    public Set<String> getFieldPropertyValues(String key) {
        TreeSet<String> values = new TreeSet<String>();
        for (SingleField field : this.fields.values()) {
            String value = field.getProperty(key);
            if (!HGBaseTools.hasContent(value)) continue;
            values.add(value);
        }
        return Collections.unmodifiableSet(values);
    }

    public String getNextFieldId() {
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            ++this.idCounter;
            String newId = String.valueOf(this.idCounter);
            if (!this.fields.containsKey(newId)) {
                return newId;
            }
            ++i;
        }
        throw new IllegalStateException("It is not possible to get a new id, the maximum number of possible fields (2147483647) has been reached!");
    }

    public void clearSingleFieldData() {
        for (SingleField sf : this.fields.values()) {
            sf.clearData();
        }
    }

    public String toString() {
        return "PlayingField: gridType=" + String.valueOf((Object)this.getGridType()) + ", grid=" + String.valueOf(this.getGrid()) + ", size=" + String.valueOf(this.getSize()) + ", fields=" + this.getFields().size();
    }
}

