/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed.playingfield;

import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseTools;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.ShapeType;
import tjger.game.completed.playingfield.SingleField;
import tjger.game.completed.playingfield.XmlSingleFieldDataConverter;
import tjger.lib.XmlMapStringConverter;
import tjger.lib.XmlUtil;

public final class PlayingFieldFileOperator {
    public static final String SINGLE_FIELD_OBJECTS = "singlefieldobjects";
    private static final String PLAYING_FIELD_NODE = "playingfield";
    private static final String SINGLE_FIELDS_NODE = "fields";
    private static final String SINGLE_FIELD_NODE = "field";
    private static final String CONNECTIONS_NODE = "nodes";
    private static final String CONNECTION_NODE = "node";
    private static final String POINTS_NODE = "points";
    private static final String POINT_NODE = "point";
    private static final String PROPERTIES_NODE = "properties";
    private static final String PROPERTY_NODE = "property";
    private static final String SINGLE_FIELD_OBJECT = "object";
    private static final String SIZE_ATTRIBUTE = "size";
    private static final String GRID_ATTRIBUTE = "grid";
    private static final String GRID_SIZE_ATTRIBUTE = "gridsize";
    private static final String GRID_SPAN_ATTRIBUTE = "gridspan";
    private static final String ID_ATTRIBUTE = "id";
    private static final String SHAPE_ATTRIBUTE = "shape";
    private static final String GRID_POSITION_ATTRIBUTE = "grid";
    private static final String POINT_POSITION_ATTRIBUTE = "position";
    private static final String FROM_ATTRIBUTE = "from";
    private static final String TO_ATTRIBUTE = "to";
    private static final String WEIGHT_ATTRIBUTE = "weight";
    private static final String KEY_ATTRIBUTE = "key";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String SINGLE_FIELD_ID_ATTRIBUTE = "singlefieldid";
    private static final String DIMENSION_SEPARATOR = "x";
    private static final String POINT_SEPARATOR = "/";
    private static PlayingField fieldToLoad;

    private PlayingFieldFileOperator() {
    }

    public static PlayingField fromFile(File file) {
        try {
            return PlayingFieldFileOperator.fromStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            HGBaseLog.logError("File '" + String.valueOf(file) + "' for reading playing field not found!");
            return null;
        }
    }

    public static PlayingField fromStream(InputStream stream) {
        Element root = HGBaseXMLTools.readXML(stream);
        return PlayingFieldFileOperator.fromXml(root);
    }

    public static PlayingField fromXml(Node root) {
        fieldToLoad = null;
        if (root != null && PLAYING_FIELD_NODE.equals(root.getNodeName())) {
            PlayingFieldFileOperator.readPlayingFieldData(root);
            ChildNodeIterator.run(new ChildNodeIterator(root, PLAYING_FIELD_NODE, null){

                @Override
                public void performNode(Node node, int index, Object obj) {
                    if (fieldToLoad != null) {
                        ChildNodeIterator.run(new ChildNodeIterator(node, PlayingFieldFileOperator.SINGLE_FIELDS_NODE, null){

                            @Override
                            public void performNode(Node node, int index, Object obj) {
                                PlayingFieldFileOperator.readSingleFields(node);
                            }
                        });
                        ChildNodeIterator.run(new ChildNodeIterator(node, PlayingFieldFileOperator.CONNECTIONS_NODE, null){

                            @Override
                            public void performNode(Node node, int index, Object obj) {
                                PlayingFieldFileOperator.readConnections(node);
                            }
                        });
                    }
                }
            });
            if (fieldToLoad == null) {
                HGBaseLog.logWarn("Could not load specified playing field!");
            }
        }
        return fieldToLoad;
    }

    private static void readPlayingFieldData(Node node) {
        Dimension size = PlayingFieldFileOperator.readDimensionAttribute(node, SIZE_ATTRIBUTE);
        if (size != null) {
            fieldToLoad = new PlayingField(size.width, size.height);
        }
        Dimension grid = PlayingFieldFileOperator.readDimensionAttribute(node, "grid");
        Dimension gridSize = PlayingFieldFileOperator.readDimensionAttribute(node, GRID_SIZE_ATTRIBUTE);
        Dimension gridSpan = PlayingFieldFileOperator.readDimensionAttribute(node, GRID_SPAN_ATTRIBUTE);
        if (grid != null && gridSize != null && gridSpan != null) {
            if (fieldToLoad == null) {
                fieldToLoad = new PlayingField(grid, gridSize, gridSpan);
            } else {
                fieldToLoad.setGridSize(gridSize);
                fieldToLoad.setGridSpan(gridSpan);
                fieldToLoad.setGrid(grid);
            }
        }
    }

    private static void readSingleFields(Node node) {
        String id;
        if (SINGLE_FIELD_NODE.equals(node.getNodeName()) && HGBaseTools.hasContent(id = HGBaseXMLTools.getAttributeValue(node, ID_ATTRIBUTE))) {
            SingleField field = null;
            ShapeType shape = ShapeType.valueOf(HGBaseXMLTools.getAttributeValue(node, SHAPE_ATTRIBUTE));
            Point gridPosition = PlayingFieldFileOperator.readPointAttribute(node, "grid");
            if (gridPosition != null) {
                field = new SingleField(id, shape, gridPosition);
            } else {
                List<Point> pointList = PlayingFieldFileOperator.readSingleFieldPixelPositions(node);
                if (pointList.size() >= 2) {
                    field = new SingleField(id, shape, pointList.toArray(new Point[0]));
                }
            }
            if (field != null) {
                PlayingFieldFileOperator.readSingleFieldProperties(node, field);
                fieldToLoad.addField(field);
            }
        }
    }

    private static List<Point> readSingleFieldPixelPositions(Node node) {
        final ArrayList<Point> pointList = new ArrayList<Point>();
        ChildNodeIterator.run(new ChildNodeIterator(node, SINGLE_FIELD_NODE, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                ChildNodeIterator.run(new ChildNodeIterator(node, PlayingFieldFileOperator.POINTS_NODE, null){

                    @Override
                    public void performNode(Node node, int index, Object obj) {
                        Point p;
                        if (PlayingFieldFileOperator.POINT_NODE.equals(node.getNodeName()) && (p = PlayingFieldFileOperator.readPointAttribute(node, PlayingFieldFileOperator.POINT_POSITION_ATTRIBUTE)) != null) {
                            pointList.add(p);
                        }
                    }
                });
            }
        });
        return pointList;
    }

    private static void readSingleFieldProperties(Node node, SingleField field) {
        ChildNodeIterator.run(new ChildNodeIterator(node, SINGLE_FIELD_NODE, field){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (PlayingFieldFileOperator.PROPERTIES_NODE.equals(node.getNodeName())) {
                    SingleField field = (SingleField)obj;
                    Map<String, String> properties = XmlUtil.loadMap(node, PlayingFieldFileOperator.PROPERTY_NODE, new XmlMapStringConverter());
                    for (Map.Entry<String, String> property : properties.entrySet()) {
                        field.setProperty(property.getKey(), property.getValue());
                    }
                }
            }
        });
    }

    private static void readConnections(Node node) {
        if (CONNECTION_NODE.equals(node.getNodeName())) {
            String fromId = HGBaseXMLTools.getAttributeValue(node, FROM_ATTRIBUTE);
            String toId = HGBaseXMLTools.getAttributeValue(node, TO_ATTRIBUTE);
            int weight = HGBaseXMLTools.getAttributeIntValue(node, WEIGHT_ATTRIBUTE, HGBaseXMLTools.getAttributeIntValue(node, "weigt"));
            SingleField from = fieldToLoad.getField(fromId);
            SingleField to = fieldToLoad.getField(toId);
            if (from != null && to != null && weight != -2147483631) {
                fieldToLoad.addConnection(from, to, weight);
                PlayingFieldFileOperator.readConnectionProperties(node, from, to);
            }
        }
    }

    private static void readConnectionProperties(Node node, final SingleField from, final SingleField to) {
        ChildNodeIterator.run(new ChildNodeIterator(node, CONNECTION_NODE, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (PlayingFieldFileOperator.PROPERTIES_NODE.equals(node.getNodeName())) {
                    fieldToLoad.setConnectionProperties(from, to, XmlUtil.loadMap(node, PlayingFieldFileOperator.PROPERTY_NODE, new XmlMapStringConverter()));
                }
            }
        });
    }

    public static boolean toFile(File file, PlayingField field) {
        Document doc = HGBaseXMLTools.createDocument();
        if (PlayingFieldFileOperator.toXml(doc, null, field)) {
            return HGBaseXMLTools.writeXML(doc, file.getPath());
        }
        return false;
    }

    public static boolean toXml(Document doc, Element parent, PlayingField field) {
        if (doc != null) {
            Element root = PlayingFieldFileOperator.writePlayingFieldData(field, doc, parent);
            PlayingFieldFileOperator.writeSingleFields(field, doc, root);
            PlayingFieldFileOperator.writeConnections(field, doc, root);
            return true;
        }
        return false;
    }

    private static Element writePlayingFieldData(PlayingField field, Document doc, Element parent) {
        Element root;
        Element element = root = parent == null ? HGBaseXMLTools.createElement(doc, null, PLAYING_FIELD_NODE) : parent;
        if (!field.getGridType().isYes()) {
            PlayingFieldFileOperator.writeDimensionAttribute(root, SIZE_ATTRIBUTE, field.getSize());
        }
        PlayingFieldFileOperator.writeDimensionAttribute(root, "grid", field.getGrid());
        PlayingFieldFileOperator.writeDimensionAttribute(root, GRID_SIZE_ATTRIBUTE, field.getGridSize());
        PlayingFieldFileOperator.writeDimensionAttribute(root, GRID_SPAN_ATTRIBUTE, field.getGridSpan());
        return root;
    }

    private static void writeSingleFields(PlayingField field, Document doc, Element root) {
        Element fieldsNode = HGBaseXMLTools.createElement(doc, root, SINGLE_FIELDS_NODE);
        for (SingleField sf : field.getFields()) {
            Point grid;
            Element fieldNode = HGBaseXMLTools.createElement(doc, fieldsNode, SINGLE_FIELD_NODE);
            fieldNode.setAttribute(ID_ATTRIBUTE, sf.getId());
            fieldNode.setAttribute(SHAPE_ATTRIBUTE, sf.getShape().name());
            Map<String, String> properties = sf.getProperties();
            if (!properties.isEmpty()) {
                XmlUtil.saveMap(doc, fieldNode, PROPERTIES_NODE, PROPERTY_NODE, properties, new XmlMapStringConverter());
            }
            if ((grid = sf.getGridPosition()) != null) {
                PlayingFieldFileOperator.writePointAttribute(fieldNode, "grid", grid);
                continue;
            }
            Element pointsNode = HGBaseXMLTools.createElement(doc, fieldNode, POINTS_NODE);
            Point[] pointArray = sf.getPixelPositions();
            int n = pointArray.length;
            int n2 = 0;
            while (n2 < n) {
                Point point = pointArray[n2];
                Element pointNode = HGBaseXMLTools.createElement(doc, pointsNode, POINT_NODE);
                PlayingFieldFileOperator.writePointAttribute(pointNode, POINT_POSITION_ATTRIBUTE, point);
                ++n2;
            }
        }
    }

    private static void writeConnections(PlayingField field, Document doc, Element root) {
        Element connectionsNode = HGBaseXMLTools.createElement(doc, root, CONNECTIONS_NODE);
        for (Map.Entry<SingleField, Map<SingleField, Integer>> connection : field.getConnectionsMap().entrySet()) {
            String id = connection.getKey().getId();
            for (Map.Entry<SingleField, Integer> target : connection.getValue().entrySet()) {
                Element connectionNode = HGBaseXMLTools.createElement(doc, connectionsNode, CONNECTION_NODE);
                connectionNode.setAttribute(FROM_ATTRIBUTE, id);
                connectionNode.setAttribute(TO_ATTRIBUTE, target.getKey().getId());
                connectionNode.setAttribute(WEIGHT_ATTRIBUTE, target.getValue().toString());
                PlayingFieldFileOperator.writeConnectionProperties(field, connection.getKey(), target.getKey(), doc, connectionNode);
            }
        }
    }

    private static void writeConnectionProperties(PlayingField field, SingleField from, SingleField to, Document doc, Element connectionNode) {
        Map<String, String> properties = field.getConnectionProperties(from, to);
        if (!properties.isEmpty()) {
            XmlUtil.saveMap(doc, connectionNode, PROPERTIES_NODE, PROPERTY_NODE, properties, new XmlMapStringConverter());
        }
    }

    private static void writeDimensionAttribute(Element node, String attribute, Dimension dim) {
        if (dim != null) {
            String value = PlayingFieldFileOperator.concatenateIntegers(DIMENSION_SEPARATOR, dim.width, dim.height);
            node.setAttribute(attribute, value);
        }
    }

    private static Dimension readDimensionAttribute(Node node, String attribute) {
        String value = HGBaseXMLTools.getAttributeValue(node, attribute);
        int[] intValues = PlayingFieldFileOperator.getSeparatedIntegers(value, DIMENSION_SEPARATOR, 2);
        return intValues == null ? null : new Dimension(intValues[0], intValues[1]);
    }

    private static void writePointAttribute(Element node, String attribute, Point point) {
        if (point != null) {
            String value = PlayingFieldFileOperator.concatenateIntegers(POINT_SEPARATOR, point.x, point.y);
            node.setAttribute(attribute, value);
        }
    }

    private static Point readPointAttribute(Node node, String attribute) {
        String value = HGBaseXMLTools.getAttributeValue(node, attribute);
        int[] intValues = PlayingFieldFileOperator.getSeparatedIntegers(value, POINT_SEPARATOR, 2);
        return intValues == null ? null : new Point(intValues[0], intValues[1]);
    }

    private static String concatenateIntegers(String separator, int ... values) {
        String[] text = new String[values.length];
        int i = 0;
        while (i < values.length) {
            text[i] = String.valueOf(values[i]);
            ++i;
        }
        return HGBaseTools.toStringText(text, separator);
    }

    private static int[] getSeparatedIntegers(String value, String separator, int count) {
        String[] stringValues = value.split(separator);
        if (stringValues.length == count) {
            int[] result = new int[count];
            int i = 0;
            while (i < count) {
                int intValue = HGBaseTools.toInt(stringValues[i]);
                if (intValue == -2147483631) {
                    return null;
                }
                result[i] = intValue;
                ++i;
            }
            return result;
        }
        return null;
    }

    public Element createNodeWithAllFieldData(Document doc, Element parentNode, PlayingField field, XmlSingleFieldDataConverter converter) {
        Element dataNode = HGBaseXMLTools.createElement(doc, parentNode, SINGLE_FIELD_OBJECTS);
        for (SingleField sf : field.getFields()) {
            Object data = sf.getData();
            if (data == null) continue;
            Element singleNode = HGBaseXMLTools.createElement(doc, dataNode, SINGLE_FIELD_OBJECT);
            converter.dataToXml(doc, singleNode, data);
            singleNode.setAttribute(SINGLE_FIELD_ID_ATTRIBUTE, sf.getId());
        }
        return dataNode;
    }

    public void readAllFieldDataFromNode(Node dataNode, final PlayingField field, final XmlSingleFieldDataConverter converter) {
        if (SINGLE_FIELD_OBJECTS.equals(dataNode.getNodeName())) {
            ChildNodeIterator.run(new ChildNodeIterator(dataNode, SINGLE_FIELD_OBJECTS, null){

                @Override
                public void performNode(Node node, int index, Object obj) {
                    String fieldId;
                    SingleField sf;
                    if (PlayingFieldFileOperator.SINGLE_FIELD_OBJECT.equals(node.getNodeName()) && (sf = field.getField(fieldId = HGBaseXMLTools.getAttributeValue(node, PlayingFieldFileOperator.SINGLE_FIELD_ID_ATTRIBUTE))) != null) {
                        Object data = converter.dataFromXml(node);
                        sf.setData(data);
                    }
                }
            });
        } else {
            ChildNodeIterator.run(new ChildNodeIterator(dataNode, null){

                @Override
                public void performNode(Node node, int index, Object obj) {
                    if (PlayingFieldFileOperator.SINGLE_FIELD_OBJECTS.equals(node.getNodeName())) {
                        PlayingFieldFileOperator.this.readAllFieldDataFromNode(node, field, converter);
                    }
                }
            });
        }
    }
}

