/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed.playingfield;

import java.util.HashMap;
import java.util.Map;
import tjger.game.completed.playingfield.PlayingField;

public final class PlayingFieldManager {
    private static final PlayingFieldManager INSTANCE = new PlayingFieldManager();
    private final Map<String, PlayingField> fields = new HashMap<String, PlayingField>();

    private PlayingFieldManager() {
    }

    public static PlayingFieldManager getInstance() {
        return INSTANCE;
    }

    public void addField(String name, PlayingField field) {
        this.fields.put(name, field);
    }

    public String[] getFieldNames() {
        return this.fields.keySet().toArray(new String[this.fields.size()]);
    }

    public PlayingField getField(String name) {
        return this.fields.get(name);
    }

    public String getFieldName(PlayingField field) {
        if (field != null) {
            for (Map.Entry<String, PlayingField> entry : this.fields.entrySet()) {
                if (!field.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return null;
    }
}

