/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.internal;

import hgb.gui.HGBaseDialog;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseFileTools;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseText;
import hgb.lib.xml.HGBaseXMLTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.swing.JFrame;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tjger.MainFrame;
import tjger.game.GamePlayer;
import tjger.game.GameState;
import tjger.game.MoveInformation;
import tjger.game.completed.GameManager;

public class GameRecorder {
    public static final String FILE_NAME_RECORD_GAME = "recordgame";
    public static final String FILE_NAME_RECORD_MOVES = "recordmoves";
    public static final String FILE_NAME_RECORD_STATES = "recordstates";
    public static final String DEFAULT_RECORD_EXTENSION = "log";
    private static GameRecorder gameRec = new GameRecorder();
    private final File fileGame;
    private final File fileMoves;
    private final File fileStates;
    private OutputStream outStreamMoves;
    private boolean recording;
    private boolean debugging;
    private BufferedReader inputDebugging;
    private Document nextStatesDoc;
    private Element nextStatesRoot;
    private int nextStatesIndex;

    private GameRecorder() {
        String[] stateExtensions = HGBaseSettings.get("fileExtensions").split(";");
        String stateExtension = stateExtensions.length > 0 && stateExtensions[0].length() > 0 ? stateExtensions[0] : DEFAULT_RECORD_EXTENSION;
        this.fileGame = new File("recordgame." + stateExtension);
        this.fileMoves = new File("recordmoves.log");
        this.fileStates = new File("recordstates.log");
    }

    public static GameRecorder getInstance() {
        return gameRec;
    }

    protected void finalize() throws Throwable {
        this.stopRecording();
        this.stopDebugging();
        super.finalize();
    }

    public void stopRecording() {
        if (this.recording && this.outStreamMoves != null && this.nextStatesDoc != null) {
            HGBaseFileTools.closeStream(this.outStreamMoves, true);
            HGBaseXMLTools.writeXML(this.nextStatesDoc, this.fileStates.getPath());
        }
        this.recording = false;
        this.outStreamMoves = null;
        this.nextStatesDoc = null;
        this.nextStatesRoot = null;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void stopDebugging() {
        this.debugging = false;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void startRecording() {
        this.stopRecording();
        if (HGBaseConfig.getBoolean(FILE_NAME_RECORD_GAME)) {
            this.recording = true;
        }
    }

    public void recordGameState(GameState state) {
        if (this.recording) {
            if (this.outStreamMoves == null) {
                this.recordInitGameState(state);
            } else {
                this.recordNextGameState(state);
            }
        } else if (this.debugging) {
            if (this.nextStatesRoot == null) {
                this.debugInitNextGameStates();
            } else {
                this.debugLoadNextGameState(state);
            }
        }
    }

    private void recordInitGameState(GameState state) {
        try {
            Document doc = HGBaseXMLTools.createDocument();
            if (GameManager.getInstance().saveGame(doc) == 0) {
                this.nextStatesDoc = HGBaseXMLTools.createDocument();
                this.nextStatesRoot = this.nextStatesDoc.createElement("gamestates");
                this.nextStatesDoc.appendChild(this.nextStatesRoot);
                this.nextStatesIndex = 0;
                Element root = (Element)doc.getFirstChild();
                root.setAttribute("record", Boolean.toString(true));
                HGBaseXMLTools.writeXML(doc, this.fileGame.getPath());
                if (this.fileMoves.delete()) {
                    this.recording = this.fileMoves.createNewFile();
                    if (this.recording) {
                        this.outStreamMoves = new FileOutputStream(this.fileMoves);
                    }
                } else {
                    HGBaseLog.logError("Could not delete file: " + String.valueOf(this.fileMoves));
                }
            }
        }
        catch (IOException e) {
            HGBaseLog.logError(e.getMessage());
            this.stopRecording();
        }
    }

    private void recordNextGameState(GameState state) {
        if (this.nextStatesRoot != null) {
            Element stateRoot = this.nextStatesDoc.createElement("state" + this.nextStatesIndex);
            if (state.save(this.nextStatesDoc, stateRoot) == 0) {
                this.nextStatesRoot.appendChild(stateRoot);
                ++this.nextStatesIndex;
            } else {
                this.stopRecording();
            }
        }
    }

    private void debugInitNextGameStates() {
        this.nextStatesRoot = HGBaseXMLTools.readXML(this.fileStates.getPath());
        if (this.nextStatesRoot == null) {
            this.stopDebugging();
        } else {
            this.nextStatesIndex = 0;
        }
    }

    private void debugLoadNextGameState(GameState state) {
        NodeList list;
        if (this.nextStatesRoot != null && (list = this.nextStatesRoot.getElementsByTagName("state" + this.nextStatesIndex)).getLength() == 1) {
            Node nextState = list.item(0);
            int ret = state.load(nextState);
            if (ret == 0) {
                ++this.nextStatesIndex;
            } else {
                MainFrame frame = GameManager.getInstance().getMainFrame();
                HGBaseDialog.printError(ret, (JFrame)frame);
                this.stopDebugging();
                GameManager.getInstance().getGameEngine().stopGame();
            }
        }
    }

    public void recordNextMove(GameState state, MoveInformation move) {
        if (this.recording && this.outStreamMoves != null) {
            try {
                String data = state.toNetworkStringMove(move) + "\n";
                this.outStreamMoves.write(data.getBytes(Charset.defaultCharset()));
            }
            catch (IOException e) {
                HGBaseLog.logError(e.getMessage());
                this.stopRecording();
            }
        }
    }

    public boolean initRecordedGame(Node gameStateRoot) {
        if (Boolean.valueOf(HGBaseXMLTools.getAttributeValue(gameStateRoot, "record")).booleanValue()) {
            MainFrame frame = GameManager.getInstance().getMainFrame();
            frame.setFile(new File(""));
            frame.setTitle();
            try {
                this.inputDebugging = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileMoves), Charset.defaultCharset()));
                this.debugging = true;
                return true;
            }
            catch (FileNotFoundException e) {
                HGBaseLog.logError(e.getMessage());
                this.stopDebugging();
            }
        } else {
            this.stopDebugging();
        }
        return false;
    }

    public MoveInformation getNextRecordedMove(GameState state, GamePlayer player) {
        if (this.debugging) {
            try {
                GameManager gm = GameManager.getInstance();
                String data = this.inputDebugging.readLine();
                if (data != null && data.length() > 0) {
                    MoveInformation nextMove = state.fromNetworkStringMove(data);
                    if (gm.getGameRules().isValidMove(nextMove, state)) {
                        String title = HGBaseText.getText("dlg.debugnextmovetitle", new String[0]);
                        String[] message = new String[]{HGBaseText.getText("dlg.askdebugnextmove", new String[0]), HGBaseText.getText("dlg.debugplayer", new String[0]) + String.valueOf(player), HGBaseText.getText("dlg.debugmove", new String[0]) + String.valueOf(nextMove)};
                        if (HGBaseDialog.showConfirmDialog(gm.getMainFrame(), (Object)message, title, 0) == 0) {
                            return nextMove;
                        }
                    } else {
                        HGBaseDialog.printError("dlg.debuginvalidmove", (JFrame)gm.getMainFrame());
                    }
                }
            }
            catch (IOException e) {
                HGBaseLog.logError(e.getMessage());
            }
        }
        this.stopDebugging();
        return null;
    }
}

