/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.internal;

import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.game.GamePlayer;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameManager;
import tjger.game.internal.GameStatisticsFileOperator;
import tjger.game.internal.HighScoreElement;
import tjger.game.internal.PlayerKey;
import tjger.game.internal.PlayerProfiles;
import tjger.game.internal.ScoreRankElement;
import tjger.game.internal.WonPlayedGames;
import tjger.lib.PlayerUtil;
import tjger.lib.ScoreUtil;

public class GameStatistics {
    private static final int SCORE_TURN = 1;
    private static final int SCORE_ROUND = 2;
    private static final int SCORE_GAME = 4;
    private static GameStatistics statistics = new GameStatistics();
    private final Map<String, Integer> scoreGame = new HashMap<String, Integer>();
    private final Map<String, Integer> scoreRound = new HashMap<String, Integer>();
    private final Map<String, Integer> scoreTurn = new HashMap<String, Integer>();
    private final Map<String, WonPlayedGames> gameMap = new HashMap<String, WonPlayedGames>();
    private final List<HighScoreElement> highScoreList = new ArrayList<HighScoreElement>();
    GamePlayer[] gamePlayerList;
    int[] gameRankingList;
    List<ScoreRankElement[]> roundScoreRankingList;
    private final boolean rememberScores;
    private final boolean rememberGames;
    private final int highScoreLength;
    private final boolean onlyFirstHighScore;
    private final boolean isLowerScoreBetter;

    private GameStatistics() {
        this.resetRanking();
        GameConfig config = GameConfig.getInstance();
        this.rememberScores = config.isRememberScores();
        this.rememberGames = config.isRememberGames();
        this.highScoreLength = config.getHighScoreLength();
        this.onlyFirstHighScore = config.isOnlyFirstHighScore();
        this.isLowerScoreBetter = config.isLowerScoreBetter();
        this.loadHighScore();
        this.loadGameStatistics();
    }

    private Map<String, Integer> getScoreMap(int scoreType) {
        switch (scoreType) {
            case 1: {
                return this.scoreTurn;
            }
            case 2: {
                return this.scoreRound;
            }
            case 4: {
                return this.scoreGame;
            }
        }
        return null;
    }

    public static GameStatistics getInstance() {
        return statistics;
    }

    public void resetScore(GamePlayer player, int scoreTypes) {
        this.resetScore(player.getName(), player.getType().getId(), scoreTypes);
    }

    public void resetScore(String playerName, String playerType, int scoreTypes) {
        PlayerKey key = new PlayerKey(playerName, playerType);
        if ((scoreTypes & 4) == 4 && this.getScoreMap(4) != null) {
            if (!this.rememberScores || !this.getScoreMap(4).containsKey(key.toString())) {
                this.getScoreMap(4).put(key.toString(), 0);
            }
            this.saveScores();
        }
        if ((scoreTypes & 2) == 2 && this.getScoreMap(2) != null) {
            this.getScoreMap(2).put(key.toString(), 0);
        }
        if ((scoreTypes & 1) == 1 && this.getScoreMap(1) != null) {
            this.getScoreMap(1).put(key.toString(), 0);
        }
    }

    public void removeGameScores() {
        PlayerProfiles profiles = GameManager.getInstance().getPlayerProfiles();
        GamePlayer[] gamePlayerArray = profiles.getPlayers();
        int n = gamePlayerArray.length;
        int n2 = 0;
        while (n2 < n) {
            GamePlayer player = gamePlayerArray[n2];
            this.removeGameScore(player);
            ++n2;
        }
    }

    public void removeGameScore(GamePlayer player) {
        PlayerKey key = new PlayerKey(player);
        HGBaseConfig.remove("playerscore." + key.toString());
        if (this.getScoreMap(4) != null) {
            this.getScoreMap(4).remove(key.toString());
        }
    }

    public int getScore(GamePlayer player, int scoreType) {
        return this.getScore(player.getName(), player.getType().getId(), scoreType);
    }

    public int getScore(String playerName, String playerType, int scoreType) {
        if (this.getScoreMap(scoreType) != null) {
            PlayerKey key = new PlayerKey(playerName, playerType);
            Integer value = this.getScoreMap(scoreType).get(key.toString());
            return value == null ? 0 : value;
        }
        return 0;
    }

    public void addScore(GamePlayer player, int score, int scoreTypes) {
        this.addScore(player.getName(), player.getType().getId(), score, scoreTypes);
    }

    public void addScore(String playerName, String playerType, int score, int scoreTypes) {
        if ((scoreTypes & 4) == 4) {
            this.addScoreToMap(playerName, playerType, score, 4);
            this.saveScores();
        }
        if ((scoreTypes & 2) == 2) {
            this.addScoreToMap(playerName, playerType, score, 2);
        }
        if ((scoreTypes & 1) == 1) {
            this.addScoreToMap(playerName, playerType, score, 1);
        }
    }

    private void addScoreToMap(String playerName, String playerType, int score, int scoreType) {
        PlayerKey key = new PlayerKey(playerName, playerType);
        Map<String, Integer> scoreMap = this.getScoreMap(scoreType);
        if (scoreMap != null) {
            if (!scoreMap.containsKey(key.toString())) {
                this.resetScore(playerName, playerType, scoreType);
            }
            int newScore = scoreMap.get(key.toString()) + score;
            scoreMap.put(key.toString(), newScore);
        }
    }

    public void setScore(GamePlayer player, int score, int scoreTypes) {
        this.setScore(player.getName(), player.getType().getId(), score, scoreTypes);
    }

    public void setScore(String playerName, String playerType, int score, int scoreTypes) {
        if ((scoreTypes & 4) == 4) {
            this.setScoreToMap(playerName, playerType, score, 4);
            this.saveScores();
        }
        if ((scoreTypes & 2) == 2) {
            this.setScoreToMap(playerName, playerType, score, 2);
        }
        if ((scoreTypes & 1) == 1) {
            this.setScoreToMap(playerName, playerType, score, 1);
        }
    }

    private void setScoreToMap(String playerName, String playerType, int score, int scoreType) {
        PlayerKey key = new PlayerKey(playerName, playerType);
        Map<String, Integer> scoreMap = this.getScoreMap(scoreType);
        if (scoreMap != null) {
            if (!scoreMap.containsKey(key.toString())) {
                this.resetScore(playerName, playerType, scoreType);
            }
            scoreMap.put(key.toString(), score);
        }
    }

    public void resetRanking() {
        this.gamePlayerList = null;
        this.gameRankingList = null;
        this.roundScoreRankingList = new ArrayList<ScoreRankElement[]>();
        this.testFirstCall(GameManager.getInstance().getGameEngine().getActivePlayers());
    }

    private void testFirstCall(GamePlayer[] players) {
        if (this.gamePlayerList == null && players != null) {
            this.gamePlayerList = (GamePlayer[])players.clone();
            this.saveScoreAndGames();
        }
    }

    public void doRoundRanking(GamePlayer[] players, int[] ranking) {
        this.testFirstCall(players);
        int numPlayers = this.gamePlayerList.length;
        ScoreRankElement[] sr = new ScoreRankElement[numPlayers];
        int i = 0;
        while (i < numPlayers) {
            int score = this.gamePlayerList[i].getScore(2);
            int rank = ranking != null && ranking.length > i ? ranking[i] : 0;
            sr[i] = new ScoreRankElement(score, rank);
            ++i;
        }
        this.roundScoreRankingList.add(sr);
    }

    public void doGameRanking(GamePlayer[] players, int[] ranking) {
        this.testFirstCall(players);
        if (ranking != null) {
            int numPlayers = this.gamePlayerList.length;
            this.gameRankingList = new int[numPlayers];
            int i = 0;
            while (i < numPlayers) {
                this.gameRankingList[i] = ranking.length > i ? ranking[i] : 0;
                ++i;
            }
        }
        this.checkWonPlayedGames(ranking);
        this.checkHighScore();
    }

    private void checkWonPlayedGames(int[] ranking) {
        int numPlayers = this.gamePlayerList.length;
        int i = 0;
        while (i < numPlayers) {
            PlayerKey key = new PlayerKey(this.gamePlayerList[i]);
            int won = 0;
            int played = 0;
            if (this.gameMap.containsKey(key.toString())) {
                WonPlayedGames wp = this.gameMap.get(key.toString());
                won = wp.getWonGames();
                played = wp.getPlayedGames();
            }
            ++played;
            if (ranking != null && ranking[i] == 1 && ScoreUtil.numberOfRanks(ranking, 1) != numPlayers) {
                ++won;
            }
            this.gameMap.put(key.toString(), new WonPlayedGames(won, played));
            ++i;
        }
        this.saveScoreAndGames();
    }

    public void saveScoreAndGames() {
        this.saveScores();
        this.saveGames();
    }

    private void saveScores() {
        if (this.rememberScores && this.gamePlayerList != null) {
            int i = 0;
            while (i < this.gamePlayerList.length) {
                GamePlayer gp = this.gamePlayerList[i];
                if (gp != null && !gp.getType().isNetwork()) {
                    String key = "playerscore." + new PlayerKey(gp).toString();
                    String score = String.valueOf(this.getScore(gp, 4));
                    HGBaseConfig.set(key, score);
                }
                ++i;
            }
        }
    }

    private void saveGames() {
        if (this.rememberGames && this.gamePlayerList != null) {
            int i = 0;
            while (i < this.gamePlayerList.length) {
                GamePlayer gp = this.gamePlayerList[i];
                if (gp != null && !gp.getType().isNetwork()) {
                    String key = "gamesplayed." + new PlayerKey(gp).toString();
                    String games = gp.getGamesPlayed() + ";" + gp.getGamesWon();
                    HGBaseConfig.set(key, games);
                }
                ++i;
            }
        }
    }

    private void loadGameStatistics() {
        if (this.rememberScores || this.rememberGames) {
            PlayerProfiles profiles = GameManager.getInstance().getPlayerProfiles();
            GamePlayer[] player = profiles.getPlayers();
            int i = 0;
            while (i < player.length) {
                String[] s;
                String value;
                int score;
                PlayerKey key = new PlayerKey(player[i]);
                if (this.rememberScores && (score = HGBaseConfig.getInt("playerscore." + key.toString())) != -2147483631) {
                    this.addScore(key.getPlayerName(), key.getPlayerType(), score, 4);
                }
                if (this.rememberGames && HGBaseTools.hasContent(value = HGBaseConfig.get("gamesplayed." + key.toString())) && (s = value.split(";")).length == 2) {
                    int played = HGBaseTools.toInt(s[0]);
                    int won = HGBaseTools.toInt(s[1]);
                    if (played != -2147483631 && won != -2147483631) {
                        this.gameMap.put(key.toString(), new WonPlayedGames(won, played));
                    }
                }
                ++i;
            }
        }
    }

    public int getGamesWon(GamePlayer player) {
        return this.getGamesWon(player.getName(), player.getType().getId());
    }

    public int getGamesWon(String playerName, String playerType) {
        PlayerKey key = new PlayerKey(playerName, playerType);
        WonPlayedGames wp = this.gameMap.get(key.toString());
        return wp == null ? 0 : wp.getWonGames();
    }

    public int getGamesPlayed(GamePlayer player) {
        return this.getGamesPlayed(player.getName(), player.getType().getId());
    }

    public int getGamesPlayed(String playerName, String playerType) {
        PlayerKey key = new PlayerKey(playerName, playerType);
        WonPlayedGames wp = this.gameMap.get(key.toString());
        return wp == null ? 0 : wp.getPlayedGames();
    }

    public void setGamesPlayedWon(GamePlayer player, int played, int won) {
        PlayerKey key = new PlayerKey(player);
        this.gameMap.put(key.toString(), new WonPlayedGames(won, played));
    }

    public void removeGamesPlayedWon() {
        PlayerProfiles profiles = GameManager.getInstance().getPlayerProfiles();
        GamePlayer[] gamePlayerArray = profiles.getPlayers();
        int n = gamePlayerArray.length;
        int n2 = 0;
        while (n2 < n) {
            GamePlayer player = gamePlayerArray[n2];
            this.removeGamesPlayedWon(player);
            ++n2;
        }
    }

    public void removeGamesPlayedWon(GamePlayer player) {
        PlayerKey key = new PlayerKey(player);
        HGBaseConfig.remove("gamesplayed." + key.toString());
        this.gameMap.remove(key.toString());
    }

    private void checkHighScore() {
        if (this.highScoreLength > 0) {
            int[] scores = ScoreUtil.getScore(this.gamePlayerList, 4);
            int maxScore = ScoreUtil.getMaximumScore(scores);
            int i = 0;
            while (i < scores.length) {
                if (!(scores[i] <= 0 || scores[i] != maxScore && this.onlyFirstHighScore)) {
                    boolean found = false;
                    int insertScore = this.highScoreList.size();
                    int h = 0;
                    while (h < this.highScoreList.size() && !found) {
                        boolean scoreIsBetter;
                        HighScoreElement hi = this.highScoreList.get(h);
                        boolean bl = this.isLowerScoreBetter ? scores[i] < hi.getScore() : (scoreIsBetter = scores[i] > hi.getScore());
                        if (scoreIsBetter) {
                            insertScore = h;
                            found = true;
                        }
                        ++h;
                    }
                    if (insertScore < 0) {
                        insertScore = 0;
                    }
                    String playerName = PlayerUtil.getPlayerNameType(this.gamePlayerList[i]);
                    this.highScoreList.add(insertScore, new HighScoreElement(playerName, scores[i], new Date()));
                }
                ++i;
            }
            while (this.highScoreList.size() > this.highScoreLength) {
                this.highScoreList.remove(this.highScoreList.size() - 1);
            }
            this.saveHighScore();
        }
    }

    private void saveHighScore() {
        int i = 0;
        while (i < this.highScoreList.size()) {
            HighScoreElement hi = this.highScoreList.get(i);
            String key = "highscore" + i;
            String value = hi.getName() + ";" + hi.getScore() + ";" + HGBaseTools.convertDate2String(hi.getDay());
            HGBaseConfig.set(key, value);
            ++i;
        }
    }

    private void loadHighScore() {
        boolean found = true;
        int i = 0;
        while (i < this.highScoreLength && found) {
            String[] s;
            found = false;
            String value = HGBaseConfig.get("highscore" + i);
            if (HGBaseTools.hasContent(value) && ((s = value.split(";")).length == 2 || s.length == 3)) {
                Date day;
                String name = s[0];
                int score = HGBaseTools.toInt(s[1]);
                Date date = day = s.length == 3 ? HGBaseTools.convertString2Date(s[2]) : null;
                if (score != -2147483631) {
                    this.highScoreList.add(new HighScoreElement(name, score, day));
                    found = true;
                }
            }
            ++i;
        }
    }

    public void removeHighScore() {
        int i = 0;
        while (i < this.highScoreList.size()) {
            String key = "highscore" + i;
            HGBaseConfig.remove(key);
            ++i;
        }
        this.highScoreList.clear();
    }

    public int saveStatistics(Document doc, Element root) {
        GameStatisticsFileOperator.write(doc, root, this);
        return 0;
    }

    public int loadStatistics(Node root) {
        if (!GameStatisticsFileOperator.read(root, this)) {
            return -10706;
        }
        return 0;
    }

    public HighScoreElement[] getHighScore() {
        return this.highScoreList.toArray(new HighScoreElement[this.highScoreList.size()]);
    }

    public GamePlayer[] getGamePlayerList() {
        return HGBaseTools.clone(this.gamePlayerList);
    }

    public int[] getGameRankingList() {
        return HGBaseTools.clone(this.gameRankingList);
    }

    public List<ScoreRankElement[]> getRoundScoreRankingList() {
        return Collections.unmodifiableList(this.roundScoreRankingList);
    }

    public int[] getRoundScores(int round) {
        List<ScoreRankElement[]> listScore = GameManager.getInstance().getGameStatistics().getRoundScoreRankingList();
        int indexList = round - 1;
        if (indexList >= 0 && indexList < listScore.size()) {
            ScoreRankElement[] sre = listScore.get(indexList);
            int[] roundScore = new int[sre.length];
            int i = 0;
            while (i < roundScore.length) {
                roundScore[i] = sre[i].getScore();
                ++i;
            }
            return roundScore;
        }
        return null;
    }
}

