/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.internal;

import hgb.lib.internal.ClassFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import tjger.game.GamePlayer;
import tjger.game.HumanPlayer;
import tjger.game.NetworkPlayer;
import tjger.game.completed.PlayerType;
import tjger.lib.ArrayUtil;

public class PlayerFactory {
    private static PlayerFactory factory = new PlayerFactory();
    private final Map<String, String> mapPlayerTypes = new HashMap<String, String>();
    private final List<PlayerType> supportTypes = new ArrayList<PlayerType>();
    private final List<PlayerType> networkTypes = new ArrayList<PlayerType>();
    private final List<PlayerType> humanTypes = new ArrayList<PlayerType>();

    private PlayerFactory() {
    }

    public static PlayerFactory getInstance() {
        return factory;
    }

    public boolean addPlayerType(String playerType, String classPath, ImageIcon typeImage) {
        GamePlayer player = this.createPlayer(classPath, playerType, "", null, "");
        if (player != null) {
            this.mapPlayerTypes.put(playerType, classPath);
            PlayerType ptNew = this.createPlayerType(playerType, typeImage);
            this.supportTypes.add(ptNew);
            if (player instanceof NetworkPlayer) {
                this.networkTypes.add(ptNew);
            }
            if (player instanceof HumanPlayer) {
                this.humanTypes.add(ptNew);
            }
            return true;
        }
        return false;
    }

    private PlayerType createPlayerType(String playerType, ImageIcon typeImage) {
        return new PlayerType(playerType, typeImage);
    }

    public GamePlayer createPlayer(String playerType, String playerName, ImageIcon playerImage, String pieceColor) {
        String classPath = this.mapPlayerTypes.get(playerType);
        if (classPath != null) {
            return this.createPlayer(classPath.toString(), playerType, playerName, playerImage, pieceColor);
        }
        return null;
    }

    private GamePlayer createPlayer(String classPath, String playerType, String playerName, ImageIcon playerImage, String pieceColor) {
        Class[] classes = new Class[]{String.class, String.class, ImageIcon.class, String.class};
        Object[] params = new Object[]{playerType, playerName, playerImage, pieceColor};
        return ClassFactory.createClass(classPath, GamePlayer.class, "player", classes, params);
    }

    public PlayerType getPlayerType(String playerType) {
        PlayerType[] pt = this.getSupportedPlayerTypes();
        int i = 0;
        while (i < pt.length) {
            if (pt[i].getId().equals(playerType)) {
                return pt[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isNetworkType(String playerType) {
        PlayerType pt = this.getPlayerType(playerType);
        if (pt != null) {
            return pt.isNetwork();
        }
        return false;
    }

    public boolean isHumanType(String playerType) {
        PlayerType pt = this.getPlayerType(playerType);
        if (pt != null) {
            return pt.isHuman();
        }
        return false;
    }

    public PlayerType[] getSupportedPlayerTypes() {
        return ArrayUtil.toPlayerType(this.supportTypes);
    }

    public PlayerType[] getNetworkPlayerTypes() {
        return ArrayUtil.toPlayerType(this.networkTypes);
    }

    public PlayerType[] getHumanPlayerTypes() {
        return ArrayUtil.toPlayerType(this.humanTypes);
    }
}

