/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui;

import hgb.gui.HGBaseDialog;
import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBaseHTMLPage;
import hgb.gui.HGBaseMultiTextPanel;
import hgb.gui.HGBasePanel;
import hgb.gui.config.HGBaseConfigDialog;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import tjger.MainFrame;
import tjger.game.GamePlayer;
import tjger.game.GameRules;
import tjger.game.GameState;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;
import tjger.game.internal.GameStatistics;
import tjger.game.internal.HighScoreElement;
import tjger.game.internal.PlayerProfiles;
import tjger.game.internal.ScoreRankElement;
import tjger.gui.completed.Piece;
import tjger.gui.completed.PlayerInfoPanel;
import tjger.gui.internal.HintPanel;
import tjger.gui.internal.PartsDlg;
import tjger.gui.internal.PreviewPanel;
import tjger.lib.ConstantValue;
import tjger.lib.DiceUtil;
import tjger.lib.ImageUtil;
import tjger.lib.ScoreUtil;

public class GameDialogs {
    public static final String SPACING = "   ";
    private static final int MIN_ROWS_WHEN_ACTIVE = 5;
    private int dynamicScrollWhen = 0;

    protected JPanel createScorePanel(GameEngine engine, int scoreType, int[] ranks) {
        GamePlayer[] player = this.getPlayersInOrderForScorePanel(engine, scoreType, ranks);
        JPanel pnInfo = new JPanel(new GridLayout(player.length, 1));
        int i = 0;
        while (i < player.length) {
            GamePlayer p = player[i];
            int rank = i + 1;
            this.createPlayerScorePanel(pnInfo, rank, p, scoreType);
            ++i;
        }
        return pnInfo;
    }

    private GamePlayer[] getPlayersInOrderForScorePanel(GameEngine engine, int scoreType, int[] ranks) {
        GamePlayer[] player = engine.getActivePlayers();
        player = ScoreUtil.getPlayersInRankingOrder(player, ranks);
        return player;
    }

    protected void createPlayerScorePanel(JPanel pnInfo, int rank, GamePlayer p, int scoreType) {
        JPanel pnDummy = new JPanel(new BorderLayout());
        pnDummy.add((Component)this.createPlayerScorePanelRank(rank), "West");
        JPanel pnPlayer = new JPanel(new BorderLayout());
        pnPlayer.add((Component)this.createPlayerScorePanelName(p), "Center");
        pnPlayer.add((Component)this.createPlayerScorePanelScore(p, scoreType), "East");
        pnDummy.add((Component)pnPlayer, "Center");
        pnInfo.add(pnDummy);
    }

    protected JComponent createPlayerScorePanelRank(int rank) {
        return new JLabel(rank + ". ");
    }

    protected JComponent createPlayerScorePanelName(GamePlayer p) {
        return new JLabel(p.getName());
    }

    protected JComponent createPlayerScorePanelScore(GamePlayer p, int scoreType) {
        return new JLabel(SPACING + p.getScore(scoreType));
    }

    public void showGameStateInfoPanel(MainFrame mainFrame, int dialogMode, boolean isMoveComplete, boolean turnFinished, GameState state, GameEngine engine, GameRules rules) {
        String titleId = "";
        JPanel msg = null;
        switch (dialogMode) {
            case 1: {
                titleId = "dlg.turnfinished";
                msg = this.getTurnInfoPanel(state, engine, rules);
                break;
            }
            case 2: {
                titleId = "dlg.roundfinished";
                msg = this.getRoundInfoPanel(state, engine, rules);
                break;
            }
            case 3: {
                titleId = "dlg.gamefinished";
                msg = this.getGameInfoPanel(state, engine, rules);
            }
        }
        if (msg != null) {
            HGBaseDialog.showOkDialog(mainFrame, msg, HGBaseText.getText(titleId, new String[0]));
        }
    }

    public JPanel getTurnInfoPanel(GameState state, GameEngine engine, GameRules rules) {
        int[] ranks = rules.getTurnRanking(engine.getActivePlayers());
        return this.createScorePanel(engine, 1, ranks);
    }

    public JPanel getRoundInfoPanel(GameState state, GameEngine engine, GameRules rules) {
        int[] ranks = rules.getRoundRanking(engine.getActivePlayers());
        return this.createScorePanel(engine, 2, ranks);
    }

    public JPanel getGameInfoPanel(GameState state, GameEngine engine, GameRules rules) {
        int[] ranks = rules.getGameRanking(engine.getActivePlayers());
        return this.createScorePanel(engine, 4, ranks);
    }

    protected JPanel getWinnerOnlyPanel(GameState state, GameEngine engine, GameRules rules) {
        return this.getWinnerOnlyPanel(state, engine, rules, 4, false);
    }

    protected JPanel getWinnerOnlyPanel(GameState state, GameEngine engine, GameRules rules, int scoreType, boolean lessIsBetter) {
        String winnerText;
        GamePlayer[] players = engine.getActivePlayers();
        int[] ranks = ScoreUtil.getScoreRanking(players, scoreType, lessIsBetter);
        JPanel winnerPanel = new JPanel(new BorderLayout());
        if (ScoreUtil.numberOfRanks(ranks, ranks[0]) == players.length) {
            winnerText = this.getWinnerOnlyTextForDrawGame(state, engine);
        } else {
            players = ScoreUtil.getPlayersInRankingOrder(players, ranks);
            GamePlayer winner = players[0];
            Piece piece = engine.getGameManager().getGameConfig().getActivePieceSet().getPiece(winner.getPieceColor(), 0);
            if (piece != null) {
                JLabel lbPiece = new JLabel();
                ImageUtil.setImageOnLabel(lbPiece, piece.getImage());
                winnerPanel.add((Component)lbPiece, "West");
            }
            winnerText = this.getWinnerOnlyTextForWinGame(state, engine, winner);
        }
        JLabel lbMessage = new JLabel(winnerText);
        winnerPanel.add((Component)lbMessage, "Center");
        return winnerPanel;
    }

    protected String getWinnerOnlyTextForDrawGame(GameState state, GameEngine engine) {
        return HGBaseText.getText("dlg.drawgame", new String[0]);
    }

    protected String getWinnerOnlyTextForWinGame(GameState state, GameEngine engine, GamePlayer winner) {
        String msgCode = this.getWinnerOnlyMessageCodeForWinner(state, engine, winner);
        return HGBaseText.getText(msgCode, winner.getName());
    }

    protected String getWinnerOnlyMessageCodeForWinner(GameState state, GameEngine engine, GamePlayer winner) {
        return "dlg.iswinner";
    }

    public void showPlayerProfilesDialog(MainFrame mainFrame, PlayerProfiles profiles) {
        JPanel pnDialog = this.getPlayerProfilesPanel(profiles);
        HGBaseDialog.showOkDialog(mainFrame, pnDialog, HGBaseText.getText("file.profiles", new String[0]).replace('.', ' '));
    }

    public JPanel getPlayerProfilesPanel(PlayerProfiles profiles) {
        JCheckBox[] chkRows = this.createPlayerProfilesCheckBoxes(profiles);
        JPanel pnChk = new JPanel(null);
        this.placeProfileChkOnPanel(pnChk, chkRows);
        JPanel pnProfiles = this.createPlayerProfilesPanel(profiles);
        JPanel pnButtons = this.createPlayerProfilesButtons(pnProfiles, pnChk, chkRows, profiles);
        JPanel pnScroll = new JPanel(new BorderLayout());
        pnScroll.add((Component)pnProfiles, "Center");
        pnScroll.add((Component)pnChk, "West");
        JPanel pnScrollDummy = new JPanel(new BorderLayout());
        pnScrollDummy.add((Component)pnScroll, "North");
        JPanel pnDummy = new JPanel(new BorderLayout());
        pnDummy.add((Component)HGBaseGuiTools.createScrollPane(pnScrollDummy, 450, 350, false), "North");
        pnDummy.add((Component)pnButtons, "South");
        return pnDummy;
    }

    private void placeProfileChkOnPanel(JPanel pnChk, JCheckBox[] chkRows) {
        int num = 0;
        int i = 0;
        while (i < chkRows.length) {
            if (chkRows[i].isVisible()) {
                ++num;
            }
            ++i;
        }
        pnChk.setLayout(new GridLayout(num, 1));
        i = 0;
        while (i < num) {
            pnChk.add(chkRows[i]);
            ++i;
        }
    }

    protected JCheckBox[] createPlayerProfilesCheckBoxes(PlayerProfiles profiles) {
        boolean enabled = !GameManager.getInstance().getGameEngine().isActiveGame();
        JCheckBox[] chkRows = new JCheckBox[profiles.getPlayers().length];
        int i = 0;
        while (i < chkRows.length) {
            chkRows[i] = new JCheckBox();
            chkRows[i].setOpaque(false);
            chkRows[i].setEnabled(enabled);
            ++i;
        }
        return chkRows;
    }

    protected JPanel createPlayerProfilesPanel(PlayerProfiles profiles) {
        JPanel pnProfiles = new JPanel(null);
        this.placePlayerProfilesRows(pnProfiles, profiles);
        return pnProfiles;
    }

    private void placePlayerProfilesRows(JPanel pnProfiles, PlayerProfiles profiles) {
        GamePlayer[] players = profiles.getPlayers();
        pnProfiles.setLayout(new GridLayout(players.length, 1));
        PlayerInfoPanel[] pnRows = new PlayerInfoPanel[players.length];
        GameConfig config = GameConfig.getInstance();
        int fields = 0;
        if (HGBaseTools.hasContent(config.getPlayerImageName())) {
            fields |= 2;
        }
        if (HGBaseTools.hasContent(config.getPlayerPieceColor())) {
            fields |= 0x100;
        }
        fields |= 0x200;
        if (config.isRememberScores()) {
            fields |= 0x20;
        }
        if (config.isRememberGames()) {
            fields = fields | 0x40 | 0x80;
        }
        Color colBack2 = HGBaseGuiTools.getBackgroundColorDarker();
        int height = HGBaseGuiTools.getFieldHeight();
        int i = 0;
        while (i < players.length) {
            pnRows[i] = this.getPlayerInfoPanel(players[i], fields, height + 4);
            if (HGBaseTools.isOdd(i)) {
                pnRows[i].setBackground(colBack2);
            }
            pnProfiles.add(pnRows[i]);
            ++i;
        }
    }

    protected PlayerInfoPanel getPlayerInfoPanel(GamePlayer player, int fields, int height) {
        return new PlayerInfoPanel(player, fields, height);
    }

    protected JPanel createPlayerProfilesButtons(final JPanel pnProfiles, final JPanel pnChk, final JCheckBox[] chkRows, final PlayerProfiles profiles) {
        JPanel pnButton = new JPanel(new BorderLayout());
        final JCheckBox chkAll = new JCheckBox(HGBaseText.getText("dlg.all", new String[0]));
        chkAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int i = 0;
                while (i < chkRows.length) {
                    chkRows[i].setSelected(chkAll.isSelected());
                    ++i;
                }
            }
        });
        pnButton.add((Component)chkAll, "West");
        final JButton btRemove = new JButton(HGBaseText.getText("dlg.remove", new String[0]));
        btRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                GamePlayer[] players = profiles.getPlayers();
                int numRemove = 0;
                int i = 0;
                while (i < players.length) {
                    if (chkRows[i].isSelected()) {
                        profiles.removeProfile(players[i]);
                        chkRows[i].setSelected(false);
                        ++numRemove;
                    }
                    ++i;
                }
                int index = chkRows.length - 1;
                while (numRemove > 0 && index >= 0) {
                    if (chkRows[index].isVisible()) {
                        chkRows[index].setVisible(false);
                        --numRemove;
                    }
                    --index;
                }
                pnProfiles.removeAll();
                GameDialogs.this.placePlayerProfilesRows(pnProfiles, profiles);
                pnProfiles.updateUI();
                pnChk.removeAll();
                GameDialogs.this.placeProfileChkOnPanel(pnChk, chkRows);
                pnChk.updateUI();
                GameDialogs.this.testForProfileActionEnabled(profiles, chkAll, btRemove);
            }
        });
        pnButton.add((Component)btRemove, "East");
        this.testForProfileActionEnabled(profiles, chkAll, btRemove);
        return pnButton;
    }

    private void testForProfileActionEnabled(PlayerProfiles profiles, JCheckBox chkAll, JButton btRemove) {
        boolean enable = profiles.getPlayers().length > 0 && !GameManager.getInstance().getGameEngine().isActiveGame();
        chkAll.setEnabled(enable);
        btRemove.setEnabled(enable);
    }

    public void showGameInfoDialog(MainFrame mainFrame, GameConfig config, GameEngine engine, GameState state, GameStatistics statistics, PlayerProfiles playerProfiles) {
        JPanel highPanel;
        int highScores;
        JPanel statPanel;
        JPanel gamePanel;
        this.dynamicScrollWhen = GameConfig.getInstance().getStatisticsScrollWhen();
        JTabbedPane tabbedPane = new JTabbedPane();
        GamePlayer[] statPlayer = statistics.getGamePlayerList();
        if (statPlayer != null && statPlayer.length > 0 && (gamePanel = this.getCurrentGamePanel(statistics, engine, state)) != null) {
            tabbedPane.addTab(HGBaseText.getText("dlg.currentgame", new String[0]), gamePanel);
            this.checkForScrollWhenAfterCurrentGamePanel(gamePanel);
        }
        if ((config.isRememberGames() || config.isRememberScores()) && (statPanel = this.getGameStatisticsPanel(playerProfiles, statistics, config)) != null) {
            tabbedPane.addTab(HGBaseText.getText("dlg.gamestatistics", new String[0]), statPanel);
        }
        if ((highScores = config.getHighScoreLength()) > 0 && (highPanel = this.getHighScorePanel(statistics, highScores)) != null) {
            tabbedPane.addTab(HGBaseText.getText("dlg.highscore", new String[0]), highPanel);
        }
        HGBaseDialog.showOkDialog(mainFrame, tabbedPane, HGBaseText.getText("file.gameinfo", new String[0]).replace('.', ' '));
    }

    private void checkForScrollWhenAfterCurrentGamePanel(JPanel gamePanel) {
        int rows = (gamePanel.getPreferredSize().height - 10) / HGBaseGuiTools.getFieldHeight() - 2;
        if (GameEngine.getInstance().isActiveGame()) {
            rows = Math.max(rows, 5);
        }
        this.dynamicScrollWhen = Math.max(this.dynamicScrollWhen, rows);
    }

    protected JComponent wrapScrolling(JPanel pnOriginal, int width, int rows, int scrollWhen) {
        if (scrollWhen > 0 && scrollWhen < rows) {
            JScrollPane scroller = HGBaseGuiTools.createScrollPane(pnOriginal, width, HGBaseGuiTools.getFieldHeight() * scrollWhen + 10, true);
            scroller.setHorizontalScrollBarPolicy(31);
            scroller.setBorder(null);
            return scroller;
        }
        return pnOriginal;
    }

    public JPanel getHighScorePanel(GameStatistics statistics, int highScores) {
        JPanel pnHighScore = this.createHighScorePanel(statistics, highScores);
        JPanel pnButtons = this.createHighScoreButtons(pnHighScore, statistics, highScores);
        JPanel pnDummy = new JPanel(new BorderLayout());
        pnDummy.add((Component)this.wrapScrolling(pnHighScore, 475, highScores, this.dynamicScrollWhen), "North");
        pnDummy.add((Component)new JLabel(" "), "Center");
        pnDummy.add((Component)pnButtons, "South");
        return pnDummy;
    }

    protected JPanel createHighScorePanel(GameStatistics statistics, int highScores) {
        JPanel pnHighScore = new JPanel(new GridLayout(highScores, 1));
        this.placeHighScoreRows(pnHighScore, statistics, highScores);
        return pnHighScore;
    }

    private void placeHighScoreRows(JPanel pnHighScore, GameStatistics statistics, int highScores) {
        HighScoreElement[] hi = statistics.getHighScore();
        Color colBack2 = HGBaseGuiTools.getBackgroundColorDarker();
        pnHighScore.setPreferredSize(new Dimension(475, HGBaseGuiTools.getFieldHeight() * highScores + 10));
        int i = 0;
        while (i < highScores) {
            int[] nArray = new int[5];
            nArray[0] = 35;
            nArray[2] = 100;
            nArray[3] = 20;
            nArray[4] = 70;
            HGBaseMultiTextPanel pnRow = new HGBaseMultiTextPanel(nArray, HGBaseGuiTools.getFieldHeight(), false, false, false, true);
            if (HGBaseTools.isOdd(i)) {
                pnRow.setBackground(colBack2);
            }
            pnRow.setText(0, i + 1 + ". ");
            if (hi.length > i) {
                pnRow.setText(1, hi[i].getName());
                pnRow.setText(2, " " + HGBaseTools.convertDate2String(hi[i].getDay()));
                pnRow.getLabel(2).setHorizontalAlignment(4);
                pnRow.setText(3, " ");
                pnRow.setText(4, this.formatHighScore(hi[i].getScore()));
                pnRow.getLabel(4).setHorizontalAlignment(4);
            }
            pnHighScore.add(pnRow);
            ++i;
        }
    }

    protected String formatHighScore(int score) {
        return String.valueOf(score);
    }

    protected JPanel createHighScoreButtons(final JPanel pnHighScore, final GameStatistics statistics, final int highScores) {
        HighScoreElement[] hi = statistics.getHighScore();
        JPanel pnButton = new JPanel(new BorderLayout());
        JButton btRemove = new JButton(HGBaseText.getText("dlg.removescore", new String[0]));
        btRemove.setPreferredSize(new Dimension(150, HGBaseGuiTools.getFieldHeight()));
        btRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                statistics.removeHighScore();
                pnHighScore.removeAll();
                GameDialogs.this.placeHighScoreRows(pnHighScore, statistics, highScores);
                pnHighScore.updateUI();
            }
        });
        btRemove.setEnabled(hi != null && hi.length > 0);
        pnButton.add((Component)btRemove, "East");
        return pnButton;
    }

    public JPanel getGameStatisticsPanel(PlayerProfiles playerProfiles, GameStatistics statistics, GameConfig config) {
        JPanel pnStats = this.createGameStatisticsPanel(playerProfiles, statistics, config);
        JPanel pnButtons = this.createGameStatisticsButtons(pnStats, playerProfiles, statistics, config);
        JPanel pnDummy = new JPanel(new BorderLayout());
        pnDummy.add((Component)this.wrapScrolling(pnStats, 350, playerProfiles.getPlayers().length, this.dynamicScrollWhen), "North");
        pnDummy.add((Component)new JLabel(" "), "Center");
        pnDummy.add((Component)pnButtons, "South");
        return pnDummy;
    }

    protected JPanel createGameStatisticsButtons(final JPanel pnStats, final PlayerProfiles playerProfiles, final GameStatistics statistics, final GameConfig config) {
        JPanel pnButton = new JPanel(new BorderLayout());
        JButton btRemove = new JButton(HGBaseText.getText("dlg.removestatistics", new String[0]));
        btRemove.setPreferredSize(new Dimension(170, HGBaseGuiTools.getFieldHeight()));
        btRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                statistics.removeGamesPlayedWon();
                statistics.removeGameScores();
                pnStats.removeAll();
                GameDialogs.this.placeStatisticsRows(pnStats, playerProfiles, statistics, config);
                pnStats.updateUI();
            }
        });
        boolean enabled = playerProfiles.getPlayers().length > 0 && !GameManager.getInstance().getGameEngine().isActiveGame();
        btRemove.setEnabled(enabled);
        pnButton.add((Component)btRemove, "East");
        return pnButton;
    }

    protected JPanel createGameStatisticsPanel(PlayerProfiles playerProfiles, GameStatistics statistics, GameConfig config) {
        GamePlayer[] player = playerProfiles.getPlayers();
        JPanel pnStats = new JPanel(new GridLayout(player.length, 1));
        this.placeStatisticsRows(pnStats, playerProfiles, statistics, config);
        return pnStats;
    }

    private void placeStatisticsRows(JPanel pnStats, PlayerProfiles playerProfiles, GameStatistics statistics, GameConfig config) {
        GamePlayer[] player = playerProfiles.getPlayers();
        Color colBack2 = HGBaseGuiTools.getBackgroundColorDarker();
        pnStats.setPreferredSize(new Dimension(350, HGBaseGuiTools.getFieldHeight() * player.length + 10));
        int i = 0;
        while (i < player.length) {
            int fields = 512;
            if (config.isRememberScores()) {
                fields |= 0x20;
            }
            if (config.isRememberGames()) {
                fields = fields | 0x40 | 0x80;
            }
            PlayerInfoPanel pnInfo = this.getPlayerInfoPanel(player[i], fields, HGBaseGuiTools.getFieldHeight());
            if (HGBaseTools.isOdd(i)) {
                pnInfo.setBackground(colBack2);
            }
            pnStats.add(pnInfo);
            ++i;
        }
    }

    public JPanel getCurrentGamePanel(GameStatistics statistics, GameEngine engine, GameState gameState) {
        JPanel pnDummy = new JPanel(new BorderLayout());
        pnDummy.add((Component)this.createCurrentGamePanel(statistics, engine, gameState), "North");
        pnDummy.add((Component)this.createTransparentLabel("", 10, 2), "Center");
        pnDummy.add((Component)this.createNewGameInfoPanel(engine.getGameManager()), "South");
        return pnDummy;
    }

    protected JComponent createCurrentGamePanel(GameStatistics statistics, GameEngine engine, GameState gameState) {
        Color colBack1 = HGBaseGuiTools.getBackgroundColor();
        Color colBack2 = HGBaseGuiTools.getBackgroundColorDarker();
        Color rankColor = HGBaseGuiTools.getSelectColor();
        GamePlayer[] player = statistics.getGamePlayerList();
        int[] gameRank = statistics.getGameRankingList();
        List<ScoreRankElement[]> roundRanking = statistics.getRoundScoreRankingList();
        int numRounds = roundRanking.size();
        final int rows = 1 + numRounds + (engine.isActiveGame() ? 0 : (gameRank == null ? 1 : 2));
        final int cols = 1 + player.length;
        JPanel pnGame = new JPanel(new GridLayout(rows, cols)){
            private static final long serialVersionUID = -3369960506457782391L;

            @Override
            protected void paintChildren(Graphics g) {
                super.paintChildren(g);
                int colWidth = this.getWidth() / cols;
                int i = 0;
                while (i < cols) {
                    g.setColor(HGBaseGuiTools.getFieldBackgroundColor());
                    int x = (i + 1) * colWidth;
                    g.drawLine(x, 0, x, rows * HGBaseGuiTools.getFieldHeight() + 10);
                    ++i;
                }
            }
        };
        pnGame.add(this.createBackgroundLabel("", 30, 2, colBack1.darker()));
        int i = 0;
        while (i < player.length) {
            JLabel lbPlayer = this.createBackgroundLabel(player[i].getName() + " ", 30, 4, colBack1.darker());
            lbPlayer.setToolTipText(player[i].getName());
            pnGame.add(lbPlayer);
            ++i;
        }
        i = 0;
        while (i < roundRanking.size()) {
            Color colBack = HGBaseTools.isEven(i) ? colBack1 : colBack2;
            int round = i + 1;
            String roundNum = round == engine.getCurrentRound() && (engine.isActiveGame() || round == 1) ? " > " : " " + round;
            pnGame.add(this.createBackgroundLabel(roundNum, 30, 2, colBack));
            ScoreRankElement[] sre = roundRanking.get(i);
            int j = 0;
            while (j < sre.length) {
                JComponent lbScore = this.createCurrentGamePanelRoundScore(sre, j, rankColor, colBack);
                pnGame.add(lbScore);
                ++j;
            }
            ++i;
        }
        if (!engine.isActiveGame()) {
            JComponent lbRank;
            Color textColor = HGBaseGuiTools.getSelectTextColor();
            JLabel lbScore = this.createBackgroundLabel(HGBaseText.getText("dlg.score", new String[0]), 30, 2, rankColor);
            lbScore.setForeground(textColor);
            pnGame.add(lbScore);
            int i2 = 0;
            while (i2 < player.length) {
                lbRank = this.createCurrentGamePanelTotalScore(player[i2], textColor, rankColor);
                pnGame.add(lbRank);
                ++i2;
            }
            if (gameRank != null) {
                pnGame.add(this.createTransparentLabel("", 30, 2));
                i2 = 0;
                while (i2 < gameRank.length) {
                    lbRank = this.createCurrentGamePanelRank(gameRank[i2], rankColor);
                    pnGame.add(lbRank);
                    ++i2;
                }
            }
        }
        int rowHeight = HGBaseGuiTools.getFieldHeight();
        int colWidth = 80;
        pnGame.setPreferredSize(new Dimension(cols * 80, rows * rowHeight + 10));
        int scrollWhen = GameConfig.getInstance().getStatisticsScrollWhen() + (rows - numRounds);
        scrollWhen = Math.max(scrollWhen, this.dynamicScrollWhen);
        scrollWhen = Math.max(scrollWhen, rows);
        scrollWhen = Math.max(scrollWhen, 5);
        return this.wrapScrolling(pnGame, cols * 80, rows, scrollWhen);
    }

    protected JComponent createCurrentGamePanelRank(int rank, Color rankColor) {
        JLabel lbRank = this.createTransparentLabel(rank + ". ", 30, 4);
        if (rank == 1) {
            lbRank.setForeground(rankColor.darker());
        }
        return lbRank;
    }

    protected JComponent createCurrentGamePanelTotalScore(GamePlayer p, Color textColor, Color rankColor) {
        JLabel lbRank = this.createBackgroundLabel(p.getScore(4) + "  ", 30, 4, rankColor);
        lbRank.setForeground(textColor);
        return lbRank;
    }

    protected JComponent createCurrentGamePanelRoundScore(ScoreRankElement[] sre, int playerIndex, Color rankColor, Color colBack) {
        JLabel lbScore = this.createBackgroundLabel(sre[playerIndex].getScore() + "  ", 30, 4, colBack);
        if (sre[playerIndex].getRank() == 1) {
            lbScore.setForeground(rankColor.darker());
        }
        return lbScore;
    }

    protected JPanel createNewGameInfoPanel(GameManager manager) {
        String[] keys = manager.getNewGameInformationKeys();
        JPanel pnInfo = new JPanel(new BorderLayout());
        JPanel pnInfo1 = new JPanel(new GridLayout(keys.length, 1));
        JPanel pnInfo2 = new JPanel(new GridLayout(keys.length, 1));
        int i = 0;
        while (i < keys.length) {
            pnInfo1.add(new JLabel(SPACING + HGBaseText.getText(keys[i], new String[0])));
            pnInfo2.add(this.createTransparentLabel(SPACING + this.getNewGameInformationForKey(manager, keys[i]), 200, 2));
            ++i;
        }
        pnInfo.add((Component)pnInfo1, "West");
        pnInfo.add((Component)pnInfo2, "Center");
        return pnInfo;
    }

    protected String getNewGameInformationForKey(GameManager manager, String key) {
        String text = manager.getNewGameInformationText(key);
        return HGBaseText.existsText(text) ? HGBaseText.getText(text, new String[0]) : text;
    }

    protected void addGridBagLabel(JPanel pn, GridBagLayout gridbag, GridBagConstraints c, JLabel label) {
        if (label != null) {
            gridbag.setConstraints(label, c);
            pn.add(label);
        }
    }

    protected JLabel createTransparentLabel(String text, int width, int hAlign) {
        JLabel lbNew = new JLabel(text);
        lbNew.setPreferredSize(new Dimension(width, HGBaseGuiTools.getFieldHeight()));
        lbNew.setHorizontalAlignment(hAlign);
        lbNew.setOpaque(false);
        return lbNew;
    }

    protected JLabel createBackgroundLabel(String text, int width, int hAlign, Color backColor) {
        JLabel lbNew = new JLabel(text);
        lbNew.setPreferredSize(new Dimension(width, HGBaseGuiTools.getFieldHeight()));
        lbNew.setHorizontalAlignment(hAlign);
        lbNew.setOpaque(true);
        lbNew.setBackground(backColor);
        return lbNew;
    }

    public PreviewPanel getPreviewPanel(PartsDlg dlg, int width, int height) {
        return new PreviewPanel(dlg, width, height);
    }

    public void showGameInstructionsDialog(MainFrame mainFrame) {
        String url = HGBaseText.getText("help.instructionsurl", new String[0]);
        String title = HGBaseText.getText("help.instructions", new String[0]).replace('.', ' ');
        HGBaseDialog.showHtmlDialog((HGBaseFrame)mainFrame, url, title, this.getGameInstructionsWidth(), this.getGameInstructionsHeight());
    }

    protected int getGameInstructionsWidth() {
        return 550;
    }

    protected int getGameInstructionsHeight() {
        return 450;
    }

    public void showGameHintsDialog(MainFrame mainFrame, String hintType, GameEngine gameEngine, GameConfig config) {
        URL[] hintUrls = this.getGameHintUrls(hintType, gameEngine, config);
        if (hintUrls == null) {
            return;
        }
        if (hintUrls.length > 0) {
            final JPanel pnDlg = this.getGameHintsPanel(hintType, hintUrls, gameEngine, config);
            String title = HGBaseText.getText("help.gamehints", new String[0]).replace('.', ' ');
            HGBaseConfigDialog dlg = new HGBaseConfigDialog(mainFrame, title, true){

                @Override
                protected void createComponents(HGBasePanel pnDialog) {
                    pnDialog.add(pnDlg);
                }
            };
            HGBaseDialog.setNextDialogResizeable();
            dlg.show();
        } else {
            HGBaseLog.logError("The game hints aren't configured correctly!");
        }
    }

    protected URL[] getGameHintUrls(String hintType, GameEngine gameEngine, GameConfig config) {
        Collection<String> hintTypes = hintType == null ? ConstantValue.getHintTypes() : Arrays.asList(hintType);
        LinkedHashMap<String, URL> listFiles = new LinkedHashMap<String, URL>();
        String path = config.getHintsSetting("path");
        String extension = config.getHintsSetting("extension");
        for (String hintTypeFromList : hintTypes) {
            int hintIndex = 0;
            while (hintIndex >= 0) {
                String hintCode = config.getHintsSetting(hintTypeFromList);
                if (hintCode == null) {
                    hintIndex = -1;
                    continue;
                }
                String fileName = HGBaseText.getText(hintCode, new String[0]);
                String fullPath = path + "/" + fileName + hintIndex + "." + extension;
                URL urlPath = this.getClass().getResource(fullPath);
                if (urlPath != null) {
                    ++hintIndex;
                    listFiles.put(urlPath.toString(), urlPath);
                    continue;
                }
                if (hintIndex == 0) {
                    HGBaseLog.logWarn("Hint file '" + fullPath + "' not found!");
                }
                hintIndex = -1;
            }
        }
        return listFiles.values().toArray(new URL[listFiles.size()]);
    }

    protected JPanel getGameHintsPanel(String hintType, URL[] hintUrls, GameEngine gameEngine, GameConfig config) {
        HintPanel pnHints = new HintPanel(this, hintUrls);
        pnHints.setPreferredSize(new Dimension(500, 350));
        return pnHints;
    }

    public int getIndexOfIntialHint(int numHints) {
        return DiceUtil.throwDice(0, numHints);
    }

    public HGBaseHTMLPage createHtmlPageForHint(URL urlHint) throws IOException {
        return new HGBaseHTMLPage(urlHint);
    }

    public void showAnotherHtmlPageForHint(HGBaseHTMLPage htmlPage, URL urlHint) throws IOException {
        htmlPage.setPage(urlHint);
    }
}

