/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui;

import hgb.gui.HGBasePanel;
import hgb.gui.menu.HGBaseMenu;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseTools;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Timer;
import tjger.MainMenu;
import tjger.MainPanel;
import tjger.game.GameRules;
import tjger.game.GameState;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;
import tjger.game.completed.playingfield.PlayingField;
import tjger.gui.Orientation;
import tjger.gui.completed.Background;
import tjger.gui.completed.Board;
import tjger.gui.completed.ImageReflection;
import tjger.gui.completed.ImageShadow;
import tjger.gui.completed.Part;
import tjger.lib.PartUtil;
import tjger.lib.PlayerUtil;

public class GamePanel
extends HGBasePanel {
    private static final long serialVersionUID = 854371074L;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_RIGHT = -1;
    public static final int ALIGN_TOP = 1;
    public static final int ALIGN_MIDDLE = 0;
    public static final int ALIGN_BOTTOM = -1;
    private static final int ANIMATION_STEPS = 10;
    private static final int ANIMATION_DURATION = 100;
    private static final boolean AUTOMATIC_ANIMATION = HGBaseSettings.getBoolean("automaticAnimation");
    private final GameManager gameManager;
    private final GameConfig gameConfig;
    private final MainMenu gameMenu;
    private Point mousePoint;
    private Timer repaintTimer;
    private ImageShadow nextImageShadow;
    private ImageReflection nextImageReflection;
    private boolean noReflectionForMultipleParts;
    private Map<String, ImageIcon> blackImages = new HashMap<String, ImageIcon>();
    private Map<Part, List<AnimationData>> currentPartPositions = new LinkedHashMap<Part, List<AnimationData>>();
    private Map<Part, List<AnimationData>> lastPartPositions = new LinkedHashMap<Part, List<AnimationData>>();
    private Map<Part, List<AnimationData>> animationCanditates = new LinkedHashMap<Part, List<AnimationData>>();
    private int fieldLeftMargin = 0;
    private int fieldTopMargin = 0;
    private List<DrawData> paintedParts = new ArrayList<DrawData>();

    protected GamePanel() {
        this.gameManager = GameManager.getInstance();
        this.gameConfig = this.gameManager.getGameConfig();
        HGBaseMenu oMenu = this.gameManager.getMainFrame().getMenu();
        this.gameMenu = oMenu instanceof MainMenu ? (MainMenu)oMenu : null;
        this.mousePoint = new Point(0, 0);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent ev) {
                GamePanel.this.mousePoint = ev.getPoint();
            }

            @Override
            public void mouseDragged(MouseEvent ev) {
                GamePanel.this.mousePoint = ev.getPoint();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent ev) {
                GamePanel.this.zoomPanelOnMouseWheelMove(ev);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ev) {
                boolean fitWindow = HGBaseConfig.getBoolean("zoom.fitwindow");
                if (fitWindow && GamePanel.this.gameMenu != null) {
                    GamePanel.this.gameMenu.setZoomFitToWindow();
                }
                GamePanel.this.calcFieldMargins();
            }
        });
    }

    public GameManager getGameManager() {
        return this.gameManager;
    }

    public MainMenu getMainMenu() {
        return this.gameMenu;
    }

    public GameConfig getGameConfig() {
        return this.getGameManager().getGameConfig();
    }

    public GameEngine getGameEngine() {
        return this.getGameManager().getGameEngine();
    }

    public GameState getGameState() {
        return this.getGameManager().getGameState();
    }

    public GameRules getGameRules() {
        return this.getGameManager().getGameRules();
    }

    public double getZoomFactor() {
        if (this.gameMenu != null) {
            return (double)this.gameMenu.getZoom() / 100.0;
        }
        return 1.0;
    }

    public int transform(int value) {
        return this.transform((double)value);
    }

    public int transform(double value) {
        return (int)Math.ceil(value * this.getZoomFactor());
    }

    public Rectangle transform(Rectangle rect) {
        if (rect == null) {
            return null;
        }
        return new Rectangle(this.transform(rect.x), this.transform(rect.y), this.transform(rect.width), this.transform(rect.height));
    }

    private int transformX(int x) {
        return this.transform(x) + this.fieldLeftMargin;
    }

    private int transformY(int y) {
        return this.transform(y) + this.fieldTopMargin;
    }

    public int invertTransform(int value) {
        return this.invertTransform((double)value);
    }

    public int invertTransform(double value) {
        return (int)(value / this.getZoomFactor());
    }

    private int invertTransformX(int x) {
        return this.invertTransform(x - this.fieldLeftMargin);
    }

    private int invertTransformX(double x) {
        return this.invertTransform(x - (double)this.fieldLeftMargin);
    }

    private int invertTransformY(int y) {
        return this.invertTransform(y - this.fieldTopMargin);
    }

    private int invertTransformY(double y) {
        return this.invertTransform(y - (double)this.fieldTopMargin);
    }

    protected int getXHorizontalAlignment(int hAlignment, int x, int width) {
        return hAlignment == 0 ? x - width / 2 : (hAlignment == -1 ? x - width : x);
    }

    protected int getXAreaHorizontalAlignment(int hAlignment, Rectangle area) {
        return hAlignment == 0 ? area.x + area.width / 2 : (hAlignment == -1 ? area.x + area.width : area.x);
    }

    public int getMouseX() {
        return this.invertTransformX((int)this.mousePoint.getX());
    }

    public int getMouseY() {
        return this.invertTransformY((int)this.mousePoint.getY());
    }

    protected void zoomPanelOnMouseWheelMove(MouseWheelEvent ev) {
        int direction;
        int downMask = 128;
        int upMask = 576;
        boolean ctrlPressed = (ev.getModifiersEx() & (downMask | upMask)) == downMask;
        int n = direction = ev.getWheelRotation() < 0 ? -1 : 1;
        if (ctrlPressed && !HGBaseConfig.getBoolean("zoom.fitwindow")) {
            int currentZoom = this.gameMenu.getZoom();
            this.gameMenu.setZoom(currentZoom - direction * 2);
        } else {
            boolean isHorizontal = (ev.getModifiersEx() & 0x200) == 512 || (ev.getModifiersEx() & 0x40) == 64;
            MainPanel panel = this.gameManager.getMainFrame().getMainPanel();
            JScrollPane scrollPane = (JScrollPane)panel.getViewport().getParent();
            JScrollBar scrollBar = isHorizontal ? scrollPane.getHorizontalScrollBar() : scrollPane.getVerticalScrollBar();
            scrollBar.setValue(scrollBar.getValue() + direction * scrollBar.getBlockIncrement());
        }
    }

    protected JViewport getViewport() {
        MainPanel mainPanel = this.getGameManager().getMainFrame().getMainPanel();
        if (mainPanel != null) {
            return mainPanel.getViewport();
        }
        return null;
    }

    private void addPaintedPart(Part part, int x, int y, int width, int height) {
        if (part != null) {
            this.paintedParts.add(new DrawData(part, x, y, width, height));
        }
    }

    public List<Part> getPartsAtMousePosition() {
        return this.paintedParts.stream().filter(part -> part.rect.contains(this.mousePoint)).map(part -> part.part).collect(Collectors.toList());
    }

    public Point getPaintedPartPosition(Part part) {
        if (part == null) {
            return null;
        }
        Optional<Point> position = this.paintedParts.stream().filter(drawData -> part.equals(drawData.part)).map(drawData -> drawData.rect.getLocation()).findFirst();
        if (!position.isPresent()) {
            return null;
        }
        return new Point(this.invertTransformX(position.get().x), this.invertTransformY(position.get().y));
    }

    @Override
    public final void paintComponents(Graphics g) {
        super.paintComponents(g);
    }

    @Override
    protected final void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintedParts.clear();
        this.initAnimationData();
        this.paintBackground(g);
        this.paintBoard(g);
        this.paintParts(g);
        this.paintAnimation(g);
    }

    private void initAnimationData() {
        if (AUTOMATIC_ANIMATION) {
            this.lastPartPositions.clear();
            this.lastPartPositions.putAll(this.currentPartPositions);
            this.animationCanditates.clear();
            this.currentPartPositions.clear();
        }
    }

    private void paintAnimation(Graphics g) {
        if (AUTOMATIC_ANIMATION) {
            boolean requireRepaint = this.animationCanditates.size() > 0;
            for (Map.Entry<Part, List<AnimationData>> candiateEntry : this.animationCanditates.entrySet()) {
                Part part = candiateEntry.getKey();
                List<AnimationData> candidatesPositions = candiateEntry.getValue();
                List<AnimationData> leftPositions = this.getList(this.lastPartPositions, part);
                int numCandidates = candidatesPositions.size();
                if (numCandidates == leftPositions.size()) {
                    requireRepaint = numCandidates > 0;
                    int i = 0;
                    while (i < numCandidates) {
                        AnimationData target = candidatesPositions.get(i);
                        AnimationData current = leftPositions.get(i);
                        this.drawPartAnimated(part, current, target, g);
                        ++i;
                    }
                    continue;
                }
                for (AnimationData animationdata : candidatesPositions) {
                    this.drawPart(animationdata, part, g);
                }
            }
            this.repaintForAnimation(requireRepaint);
        }
    }

    private void drawPartAnimated(Part part, AnimationData current, AnimationData target, Graphics g) {
        if (current.animationStep >= this.getAnimationSteps()) {
            AnimationData animationData = new AnimationData(target.x, target.y, target.percentSize, target.angle);
            this.drawPart(animationData, part, g);
        } else {
            AnimationData animationData = this.calculateAnimation(current, target);
            this.drawPart(animationData, part, g);
        }
    }

    private AnimationData calculateAnimation(AnimationData current, AnimationData target) {
        int remainSteps = this.getAnimationSteps() - current.animationStep;
        int x = current.x + (target.x - current.x) / remainSteps;
        int y = current.y + (target.y - current.y) / remainSteps;
        int percentSize = current.percentSize + (target.percentSize - current.percentSize) / remainSteps;
        double angle = (current.angle + (target.angle - current.angle) / (double)remainSteps) % 360.0;
        int animationStep = current.animationStep + 1;
        return new AnimationData(x, y, percentSize, angle, animationStep);
    }

    protected void repaintForAnimation(boolean repaint) {
        if (repaint) {
            int countdown = this.getAnimationDuration() / this.getAnimationSteps();
            Timer t = new Timer(countdown, new RepaintActionListener());
            t.setRepeats(false);
            t.start();
        }
    }

    protected void paintParts(Graphics g) {
    }

    protected void paintBackground(Graphics g) {
        this.paintBackground(this.gameConfig.getActiveBackground(), g);
    }

    protected void paintBackground(Background back, Graphics g) {
        if (back != null) {
            ImageIcon backImg = back.getImage();
            if (backImg == null) {
                Color backColor = back.getColor();
                if (backColor != null) {
                    g.setColor(backColor);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            } else if (back.isRepeatMode()) {
                int backW = back.isIgnoreZoom() ? backImg.getIconWidth() : (int)((double)(backImg.getIconWidth() * back.getZoom()) / 100.0);
                int backH = back.isIgnoreZoom() ? backImg.getIconHeight() : (int)((double)(backImg.getIconHeight() * back.getZoom()) / 100.0);
                int fieldW = back.isIgnoreZoom() ? this.getWidth() : this.invertTransform(this.getWidth());
                int fieldH = back.isIgnoreZoom() ? this.getHeight() : this.invertTransform(this.getHeight());
                int x = 0;
                while (x <= fieldW / backW) {
                    int y = 0;
                    while (y <= fieldH / backH) {
                        int xPos = x * backW;
                        int yPos = y * backH;
                        if (back.isIgnoreZoom()) {
                            g.drawImage(backImg.getImage(), xPos, yPos, backImg.getImageObserver());
                        } else {
                            this.drawImage(xPos, yPos, back.getZoom(), backImg, g);
                        }
                        ++y;
                    }
                    ++x;
                }
            } else {
                this.checkShadowForPart(back);
                this.checkReflectionForPart(back);
                this.drawImage(0, 0, back.getZoom(), back.getImage(), g);
            }
        }
    }

    protected void paintBoard(Graphics g) {
        this.paintBoard(this.gameConfig.getActiveBoard(), g);
    }

    protected void paintBoard(Board board, Graphics g) {
        if (board != null) {
            this.drawPart(board.getXPos(), board.getYPos(), board.getZoom(), board, g);
        }
    }

    public void drawPart(int x, int y, Part part, Graphics g) {
        this.drawPart(x, y, 100, part, g);
    }

    public void drawPart(int x, int y, int hAlignment, int vAlignment, Part part, Graphics g) {
        this.drawPart(x, y, 100, hAlignment, vAlignment, part, g);
    }

    public void drawPart(int x, int y, int percentSize, Part part, Graphics g) {
        this.drawPart(x, y, percentSize, 0.0, part, g);
    }

    public void drawPart(int x, int y, int percentSize, int hAlignment, int vAlignment, Part part, Graphics g) {
        this.drawPart(x, y, percentSize, 0.0, hAlignment, vAlignment, part, g);
    }

    public void drawPart(int x, int y, int percentSize, double angle, Part part, Graphics g) {
        this.drawPart(x, y, percentSize, angle, 1, 1, part, g);
    }

    public void drawPart(int x, int y, int percentSize, double angle, int hAlignment, int vAlignment, Part part, Graphics g) {
        if (part == null) {
            return;
        }
        Point drawingPosition = PartUtil.getDrawingPosition(x, y, percentSize, hAlignment, vAlignment, part);
        if (AUTOMATIC_ANIMATION && this.shallAnimatePart(part, drawingPosition.x, drawingPosition.y)) {
            AnimationData currData;
            List<AnimationData> lastPoints = this.getList(this.lastPartPositions, part);
            if (lastPoints.contains(currData = new AnimationData(drawingPosition.x, drawingPosition.y, percentSize, angle))) {
                lastPoints.remove(currData);
            } else if (!lastPoints.isEmpty()) {
                this.getList(this.animationCanditates, part).add(currData);
                currData = null;
            }
            this.drawPart(currData, part, g);
        } else {
            this.checkShadowForPart(part);
            this.checkReflectionForPart(part);
            this.drawImage(drawingPosition.x, drawingPosition.y, percentSize, angle, part.getImage(), g, part);
        }
    }

    public void drawPart(PlayingField field, String positionId, Part part, Graphics g) {
        this.drawPart(field, positionId, 1, 1, part, g);
    }

    public void drawPart(PlayingField field, String positionId, int hAlignment, int vAlignment, Part part, Graphics g) {
        Rectangle rect = field.getFieldRectangle(field.getField(positionId));
        Point drawPos = PartUtil.getDrawingPosition(rect.x, rect.y, hAlignment, vAlignment, rect.width, rect.height, true);
        this.drawPart(drawPos.x, drawPos.y, hAlignment, vAlignment, part, g);
    }

    protected boolean shallAnimatePart(Part part, int x, int y) {
        return true;
    }

    private void drawPart(AnimationData animationData, Part part, Graphics g) {
        if (animationData != null) {
            this.checkShadowForPart(part);
            this.checkReflectionForPart(part);
            this.drawImage(animationData.x, animationData.y, animationData.percentSize, animationData.angle, part.getImage(), g, part);
            this.getList(this.currentPartPositions, part).add(animationData);
        }
    }

    public void drawParts(int x, int y, Part[] parts, int xSpacing, int ySpacing, Graphics g) {
        int reflectionIndex = this.checkReflectionIndex(parts, ySpacing);
        int i = 0;
        while (parts != null && i < parts.length) {
            this.noReflectionForMultipleParts = reflectionIndex != -1 && reflectionIndex != i;
            this.drawPart(x + i * xSpacing, y + i * ySpacing, parts[i], g);
            ++i;
        }
        this.noReflectionForMultipleParts = false;
    }

    public void drawParts(int x, int y, int percentSize, Part[] parts, int xSpacing, int ySpacing, Graphics g) {
        int reflectionIndex = this.checkReflectionIndex(parts, ySpacing);
        int i = 0;
        while (parts != null && i < parts.length) {
            this.noReflectionForMultipleParts = reflectionIndex != -1 && reflectionIndex != i;
            this.drawPart(x + i * xSpacing, y + i * ySpacing, percentSize, parts[i], g);
            ++i;
        }
        this.noReflectionForMultipleParts = false;
    }

    public void drawParts(int x, int y, int percentSize, int hAlignment, int vAlignment, Part[] parts, int xSpacing, int ySpacing, Graphics g) {
        int reflectionIndex = this.checkReflectionIndex(parts, ySpacing);
        Point drawPos = PartUtil.getDrawingPosition(x, y, percentSize, hAlignment, vAlignment, parts, xSpacing, ySpacing);
        int i = 0;
        while (parts != null && i < parts.length) {
            this.noReflectionForMultipleParts = reflectionIndex != -1 && reflectionIndex != i;
            this.drawPart(drawPos.x + i * xSpacing, drawPos.y + i * ySpacing, percentSize, parts[i], g);
            ++i;
        }
        this.noReflectionForMultipleParts = false;
    }

    public void drawParts(int x, int y, int percentSize, double angle, Part[] parts, int xSpacing, int ySpacing, Graphics g) {
        int reflectionIndex = this.checkReflectionIndex(parts, ySpacing);
        if (angle == 0.0 || angle == 180.0) {
            int i = 0;
            while (parts != null && i < parts.length) {
                this.noReflectionForMultipleParts = reflectionIndex != -1 && reflectionIndex != i;
                this.drawPart(x + i * xSpacing, y + i * ySpacing, percentSize, parts[i], g);
                ++i;
            }
        } else if (parts != null && parts.length > 0) {
            int len = parts.length - 1;
            int width = this.transform((double)(xSpacing * len) + Math.ceil((double)(parts[len].getImage().getIconWidth() * percentSize) * 1.0 / 100.0));
            int height = this.transform((double)(ySpacing * len) + Math.ceil((double)(parts[len].getImage().getIconHeight() * percentSize) * 1.0 / 100.0));
            BufferedImage imgBuf = new BufferedImage(width, height, 2);
            Graphics2D g2 = imgBuf.createGraphics();
            int i = 0;
            while (i < parts.length) {
                if (parts[i] != null) {
                    this.noReflectionForMultipleParts = reflectionIndex != -1 && reflectionIndex != i;
                    this.checkShadowForPart(parts[i]);
                    this.checkReflectionForPart(parts[i]);
                    this.drawImage(i * xSpacing, i * ySpacing, percentSize, 0.0, parts[i].getImage(), g2, false, true, null);
                }
                ++i;
            }
            this.drawImage(this.transform(x), this.transform(y), 100, angle, new ImageIcon(imgBuf), g, true);
        }
        this.noReflectionForMultipleParts = false;
    }

    public void drawParts(PlayingField field, String positionId, int hAlignment, int vAlignment, Part[] parts, int xSpacing, int ySpacing, Graphics g) {
        Rectangle rect = field.getFieldRectangle(field.getField(positionId));
        Point drawPos = PartUtil.getDrawingPosition(rect.x, rect.y, hAlignment, vAlignment, rect.width, rect.height, true);
        this.drawParts(drawPos.x, drawPos.y, 100, hAlignment, vAlignment, parts, xSpacing, ySpacing, g);
    }

    public void drawParts(int x, int y, int percentSize, Orientation orientation, int wrapThreshold, Part[] parts, int xSpacing, int ySpacing, Graphics g) {
        this.drawParts(x, y, percentSize, 0.0, orientation, wrapThreshold, parts, xSpacing, ySpacing, g);
    }

    public void drawParts(int x, int y, int percentSize, double angle, Orientation orientation, int wrapThreshold, Part[] parts, int xSpacing, int ySpacing, Graphics g) {
        int i = 0;
        while (parts != null && i < parts.length) {
            int rowIndex = this.getOrientationRowIndex(orientation, i, wrapThreshold);
            int colIndex = this.getOrientationColumnIndex(orientation, i, wrapThreshold);
            int offsetX = this.getOrientationXOffset(orientation, colIndex, xSpacing);
            int offsetY = this.getOrientationYOffset(orientation, rowIndex, ySpacing);
            this.drawPart(x + offsetX, y + offsetY, percentSize, angle, parts[i], g);
            ++i;
        }
    }

    private int getOrientationRowIndex(Orientation orientation, int index, int wrapThreshold) {
        switch (orientation) {
            case DOWN_LTR: 
            case UP_LTR: 
            case DOWN_RTL: 
            case UP_RTL: {
                return index % wrapThreshold;
            }
            case LTR_DOWN: 
            case LTR_UP: 
            case RTL_DOWN: 
            case RTL_UP: {
                return index / wrapThreshold;
            }
        }
        return 0;
    }

    private int getOrientationColumnIndex(Orientation orientation, int index, int wrapThreshold) {
        switch (orientation) {
            case DOWN_LTR: 
            case UP_LTR: 
            case DOWN_RTL: 
            case UP_RTL: {
                return index / wrapThreshold;
            }
            case LTR_DOWN: 
            case LTR_UP: 
            case RTL_DOWN: 
            case RTL_UP: {
                return index % wrapThreshold;
            }
        }
        return 0;
    }

    private int getOrientationXOffset(Orientation orientation, int colIndex, int xSpacing) {
        switch (orientation) {
            case LTR_DOWN: 
            case LTR_UP: 
            case DOWN_LTR: 
            case UP_LTR: {
                return colIndex * xSpacing;
            }
            case RTL_DOWN: 
            case RTL_UP: 
            case DOWN_RTL: 
            case UP_RTL: {
                return colIndex * xSpacing * -1;
            }
        }
        return 0;
    }

    private int getOrientationYOffset(Orientation orientation, int rowIndex, int ySpacing) {
        switch (orientation) {
            case LTR_DOWN: 
            case DOWN_LTR: 
            case RTL_DOWN: 
            case DOWN_RTL: {
                return rowIndex * ySpacing;
            }
            case LTR_UP: 
            case UP_LTR: 
            case RTL_UP: 
            case UP_RTL: {
                return rowIndex * ySpacing * -1;
            }
        }
        return 0;
    }

    private int checkReflectionIndex(Part[] parts, int ySpacing) {
        if (ySpacing == 0) {
            return -1;
        }
        return ySpacing < 0 ? 0 : parts.length - 1;
    }

    public void drawImage(int x, int y, ImageIcon img, Graphics g) {
        if (img != null) {
            this.drawImage(x, y, img.getIconWidth(), img.getIconHeight(), img, g);
        }
    }

    public void drawImage(int x, int y, int percentSize, ImageIcon img, Graphics g) {
        if (img != null) {
            this.drawImage(x, y, percentSize, 0.0, img, g);
        }
    }

    private void drawImage(int x, int y, int percentSize, ImageIcon img, Graphics g, Part part) {
        this.drawImage(x, y, percentSize, 0.0, img, g, false, part);
    }

    public void drawImage(int x, int y, int percentSize, double angle, ImageIcon img, Graphics g) {
        this.drawImage(x, y, percentSize, angle, img, g, false);
    }

    private void drawImage(int x, int y, int percentSize, double angle, ImageIcon img, Graphics g, Part part) {
        this.drawImage(x, y, percentSize, angle, img, g, false, part);
    }

    public void drawImage(int x, int y, int percentSize, double angle, ImageIcon img, Graphics g, boolean ignoreZoom) {
        this.drawImage(x, y, percentSize, angle, img, g, ignoreZoom, null);
    }

    private void drawImage(int x, int y, int percentSize, double angle, ImageIcon img, Graphics g, boolean ignoreZoom, Part part) {
        this.drawImage(x, y, percentSize, angle, img, g, ignoreZoom, false, part);
    }

    private void drawImage(int x, int y, int percentSize, double angle, ImageIcon img, Graphics g, boolean ignoreZoom, boolean ignoreMargin, Part part) {
        if (img != null) {
            Graphics2D g2 = (Graphics2D)g;
            Point newPos = this.calcImagePosition(x, y, ignoreZoom, ignoreMargin);
            int width = (int)(ignoreZoom ? (double)img.getIconWidth() * ((double)percentSize / 100.0) : (double)this.transform((double)img.getIconWidth() * ((double)percentSize / 100.0)));
            int height = (int)(ignoreZoom ? (double)img.getIconHeight() * ((double)percentSize / 100.0) : (double)this.transform((double)img.getIconHeight() * ((double)percentSize / 100.0)));
            int tx = newPos.x + width / 2;
            int ty = newPos.y + height / 2;
            if (angle != 0.0) {
                g2.rotate(Math.toRadians(angle), tx, ty);
            }
            if (this.nextImageShadow != null) {
                this.nextImageShadow = this.transformShadow(this.nextImageShadow, angle);
                this.drawImageShadow(img, this.nextImageShadow, newPos.x, newPos.y, width, height, g2, ignoreZoom);
                this.nextImageShadow = null;
            }
            if (this.nextImageReflection != null) {
                this.drawImageReflection(img, this.nextImageReflection, newPos.x, newPos.y, width, height, angle, g2, ignoreZoom);
                this.nextImageReflection = null;
            }
            g2.drawImage(img.getImage(), newPos.x, newPos.y, newPos.x + width, newPos.y + height, 0, 0, img.getIconWidth(), img.getIconHeight(), img.getImageObserver());
            this.addPaintedPart(part, newPos.x, newPos.y, width, height);
            if (angle != 0.0) {
                g2.rotate(Math.toRadians(-angle), tx, ty);
            }
        }
    }

    private Point calcImagePosition(int x, int y, boolean ignoreZoom, boolean ignoreMargin) {
        if (ignoreZoom && ignoreMargin) {
            return new Point(x, y);
        }
        if (ignoreZoom) {
            return new Point(x + this.fieldLeftMargin, y + this.fieldTopMargin);
        }
        if (ignoreMargin) {
            return new Point(this.transform(x), this.transform(y));
        }
        return new Point(this.transformX(x), this.transformY(y));
    }

    public void drawNextImageWithShadow(ImageShadow shadow) {
        this.nextImageShadow = shadow;
    }

    public void drawNextImageWithReflection(ImageReflection reflection) {
        this.nextImageReflection = reflection;
    }

    private void checkShadowForPart(Part part) {
        ImageShadow shadow = part.getShadow();
        if (shadow != null && HGBaseConfig.getBoolean("drawshadows", true)) {
            this.drawNextImageWithShadow(shadow);
        }
    }

    private void checkReflectionForPart(Part part) {
        ImageReflection reflection = part.getReflection();
        if (reflection != null && !this.noReflectionForMultipleParts && HGBaseConfig.getBoolean("drawreflections", true)) {
            this.drawNextImageWithReflection(reflection);
        }
    }

    private void drawImageShadow(ImageIcon img, ImageShadow shadow, int x, int y, int width, int height, Graphics g, boolean ignoreZoom) {
        ImageIcon blackImg = this.createBlackImage(img);
        Graphics gShadow = this.createTransparentGraphics(shadow.getAlpha(), g);
        int shadowX = ignoreZoom ? shadow.getShadowX() : this.transform(shadow.getShadowX());
        int shadowY = ignoreZoom ? shadow.getShadowY() : this.transform(shadow.getShadowY());
        gShadow.drawImage(blackImg.getImage(), x + shadowX, y + shadowY, x + width + shadowX, y + height + shadowY, 0, 0, img.getIconWidth(), img.getIconHeight(), blackImg.getImageObserver());
        gShadow.dispose();
    }

    private ImageShadow transformShadow(ImageShadow shadow, double angle) {
        if (angle == 0.0) {
            return shadow;
        }
        int x = shadow.getShadowX();
        int y = shadow.getShadowX();
        EffectType shadowType = this.getEffectType(angle);
        x = shadowType == EffectType.LEFT || shadowType == EffectType.TOP ? -x : x;
        y = shadowType == EffectType.RIGHT || shadowType == EffectType.TOP ? -y : y;
        return new ImageShadow(x, y, shadow.getAlpha());
    }

    private ImageIcon createBlackImage(ImageIcon img) {
        ImageIcon blackImg = this.blackImages.get(img.toString());
        if (blackImg == null) {
            int width = img.getIconWidth();
            int height = img.getIconHeight();
            BufferedImage bufferedImg = new BufferedImage(width, height, 2);
            Graphics2D gBuffered = bufferedImg.createGraphics();
            gBuffered.drawImage(img.getImage(), 0, 0, null);
            gBuffered.dispose();
            WritableRaster raster = bufferedImg.getRaster();
            int x = 0;
            while (x < width) {
                int y = 0;
                while (y < height) {
                    int[] pixels = raster.getPixel(x, y, (int[])null);
                    pixels[0] = 0;
                    pixels[1] = 0;
                    pixels[2] = 0;
                    raster.setPixel(x, y, pixels);
                    ++y;
                }
                ++x;
            }
            blackImg = new ImageIcon(bufferedImg);
            this.blackImages.put(img.toString(), blackImg);
        }
        return blackImg;
    }

    private void drawImageReflection(ImageIcon img, ImageReflection reflection, int x, int y, int width, int height, double angle, Graphics g, boolean ignoreZoom) {
        int reflectionHeight = (int)((float)height * reflection.getImageHeight());
        int reflectionX = x;
        int reflectionY = y;
        int reflectionGap = ignoreZoom ? reflection.getGap() : this.transform(reflection.getGap());
        EffectType reflectionType = this.getEffectType(angle);
        int imageWidth = reflectionType == EffectType.NORMAL || reflectionType == EffectType.TOP ? width : reflectionHeight;
        int imageHeight = reflectionType == EffectType.NORMAL || reflectionType == EffectType.TOP ? reflectionHeight : height;
        BufferedImage reflectionImg = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D rg = reflectionImg.createGraphics();
        if (reflectionType == EffectType.NORMAL) {
            rg.drawImage(img.getImage(), 0, 0, imageWidth, imageHeight, 0, (int)((float)img.getIconHeight() * (1.0f - reflection.getImageHeight())), img.getIconWidth(), img.getIconHeight(), img.getImageObserver());
            this.fillGradientTransparency(true, reflection.getAlphaStart(), reflection.getAlphaEnd(), imageWidth, imageHeight, rg);
            reflectionImg = this.flipReflectionImage(true, reflectionImg);
            reflectionY = reflectionY + height + reflectionGap;
        } else if (reflectionType == EffectType.TOP) {
            rg.drawImage(img.getImage(), 0, 0, imageWidth, imageHeight, 0, 0, img.getIconWidth(), (int)((float)img.getIconHeight() * reflection.getImageHeight()), img.getImageObserver());
            this.fillGradientTransparency(true, reflection.getAlphaEnd(), reflection.getAlphaStart(), imageWidth, imageHeight, rg);
            reflectionImg = this.flipReflectionImage(true, reflectionImg);
            reflectionY = reflectionY - reflectionHeight - reflectionGap;
        } else if (reflectionType == EffectType.LEFT) {
            rg.drawImage(img.getImage(), 0, 0, imageWidth, imageHeight, 0, 0, (int)((float)img.getIconWidth() * reflection.getImageHeight()), img.getIconHeight(), img.getImageObserver());
            this.fillGradientTransparency(false, reflection.getAlphaEnd(), reflection.getAlphaStart(), imageWidth, imageHeight, rg);
            reflectionImg = this.flipReflectionImage(false, reflectionImg);
            reflectionX = reflectionX - reflectionHeight - reflectionGap;
        } else if (reflectionType == EffectType.RIGHT) {
            rg.drawImage(img.getImage(), 0, 0, imageWidth, imageHeight, (int)((float)img.getIconWidth() * (1.0f - reflection.getImageHeight())), 0, img.getIconWidth(), img.getIconHeight(), img.getImageObserver());
            this.fillGradientTransparency(false, reflection.getAlphaStart(), reflection.getAlphaEnd(), imageWidth, imageHeight, rg);
            reflectionImg = this.flipReflectionImage(false, reflectionImg);
            reflectionX = reflectionX + width + reflectionGap;
        }
        rg.dispose();
        g.drawImage(reflectionImg, reflectionX, reflectionY, null);
    }

    private EffectType getEffectType(double angle) {
        if (angle > 135.0 && angle <= 215.0) {
            return EffectType.TOP;
        }
        if (angle > 45.0 && angle <= 135.0) {
            return EffectType.RIGHT;
        }
        if (angle > 215.0 && angle <= 315.0) {
            return EffectType.LEFT;
        }
        return EffectType.NORMAL;
    }

    private BufferedImage flipReflectionImage(boolean vertical, BufferedImage image) {
        AffineTransform tx = vertical ? AffineTransform.getScaleInstance(1.0, -1.0) : AffineTransform.getScaleInstance(-1.0, 1.0);
        int flipX = vertical ? 0 : -image.getWidth(null);
        int flipY = vertical ? -image.getHeight(null) : 0;
        tx.translate(flipX, flipY);
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(image, null);
    }

    private void fillGradientTransparency(boolean vertical, float alphaStart, float alphaEnd, int width, int height, Graphics2D g2) {
        g2.setComposite(AlphaComposite.getInstance(6));
        g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, alphaEnd), !vertical ? width : 0, vertical ? height : 0, new Color(0.0f, 0.0f, 0.0f, alphaStart)));
        g2.fillRect(0, 0, width, height);
    }

    public void drawLine(int x1, int y1, int x2, int y2, Graphics g) {
        g.drawLine(this.transformX(x1), this.transformY(y1), this.transformX(x2), this.transformY(y2));
    }

    public void drawRect(int x, int y, int width, int height, boolean filled, Graphics g) {
        if (filled) {
            g.fillRect(this.transformX(x), this.transformY(y), this.transform(width), this.transform(height));
        } else {
            g.drawRect(this.transformX(x), this.transformY(y), this.transform(width), this.transform(height));
        }
    }

    public void drawRect(Rectangle rect, boolean filled, Graphics g) {
        this.drawRect(rect.x, rect.y, rect.width, rect.height, filled, g);
    }

    public void drawOval(int x, int y, int width, int height, boolean filled, Graphics g) {
        if (filled) {
            g.fillOval(this.transformX(x), this.transformY(y), this.transform(width), this.transform(height));
        } else {
            g.drawOval(this.transformX(x), this.transformY(y), this.transform(width), this.transform(height));
        }
    }

    public void drawOval(PlayingField field, String positionId, int margin, boolean filled, Graphics g) {
        Rectangle rect = field.getFieldRectangle(field.getField(positionId));
        this.drawOval(rect.x + margin, rect.y + margin, rect.width - margin * 2, rect.height - margin * 2, filled, g);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle, boolean filled, Graphics g) {
        if (filled) {
            g.fillArc(this.transformX(x), this.transformY(y), this.transform(width), this.transform(height), startAngle, arcAngle);
        } else {
            g.drawArc(this.transformX(x), this.transformY(y), this.transform(width), this.transform(height), startAngle, arcAngle);
        }
    }

    public void drawPolygon(Polygon p, boolean filled, Graphics g) {
        if (p != null) {
            int[] x = new int[p.npoints];
            int[] y = new int[p.npoints];
            int i = 0;
            while (i < p.npoints) {
                x[i] = this.transformX(p.xpoints[i]);
                y[i] = this.transformY(p.ypoints[i]);
                ++i;
            }
            if (filled) {
                g.fillPolygon(x, y, p.npoints);
            } else {
                g.drawPolygon(x, y, p.npoints);
            }
        }
    }

    public void drawArrow(int x1, int y1, int x2, int y2, int size, Graphics g) {
        x1 = this.transformX(x1);
        y1 = this.transformY(y1);
        x2 = this.transformX(x2);
        y2 = this.transformY(y2);
        size = Math.max(this.transform(size), 1);
        Graphics2D g2 = (Graphics2D)g.create();
        double dx = (double)x2 - (double)x1;
        double dy = (double)y2 - (double)y1;
        double angle = Math.atan2(dy, dx);
        int len = (int)Math.sqrt(dx * dx + dy * dy);
        AffineTransform at = AffineTransform.getTranslateInstance(x1, y1);
        at.concatenate(AffineTransform.getRotateInstance(angle));
        g2.transform(at);
        g2.drawLine(0, 0, len, 0);
        int[] nArray = new int[4];
        nArray[1] = -size;
        nArray[2] = size;
        g2.fillPolygon(new int[]{len, len - size, len - size, len}, nArray, 4);
    }

    public void drawString(String text, int x, int y, Graphics g) {
        this.drawString(text, x, y, 0.0, 1, g);
    }

    public void drawString(String text, int x, int y, double angle, int alignment, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Font oldFont = g.getFont();
        float zoomFontSize = (float)Math.ceil((double)oldFont.getSize() * this.getZoomFactor());
        g.setFont(oldFont.deriveFont(zoomFontSize));
        int newX = this.transformX(x);
        int newY = this.transformY(y);
        int width = this.getStringWidth(text, g);
        int height = this.getStringHeight(g);
        newX = this.getXHorizontalAlignment(alignment, newX, width);
        int tx = newX + width / 2;
        int ty = newY + height / 2;
        if (angle != 0.0) {
            g2.rotate(Math.toRadians(angle), tx, ty);
        }
        g.drawString(text, newX, newY);
        if (angle != 0.0) {
            g2.rotate(Math.toRadians(-angle), tx, ty);
        }
        g.setFont(oldFont);
    }

    public void drawStringCentered(String text, int x, int y, int width, Graphics g) {
        this.drawString(text, width / 2 + x, y, 0.0, 0, g);
    }

    public void drawString(String text, PlayingField field, String positionId, int hAlignment, Graphics g) {
        Rectangle rect = field.getFieldRectangle(field.getField(positionId));
        Point drawPos = PartUtil.getDrawingPosition(rect.x, rect.y, hAlignment, -1, rect.width, rect.height, true);
        this.drawString(text, drawPos.x, drawPos.y, 0.0, hAlignment, g);
    }

    public void drawString(String text, Rectangle area, WrapStyle wrapStyle, int hAlignment, Graphics g) {
        String[] lines;
        Font oldFont = g.getFont();
        float zoomFontSize = (float)Math.ceil((double)oldFont.getSize() * this.getZoomFactor());
        g.setFont(oldFont.deriveFont(zoomFontSize));
        Rectangle newRect = this.transform(area);
        int textHeight = this.getStringHeight(g);
        int x = this.getXAreaHorizontalAlignment(hAlignment, newRect);
        int y = newRect.y + textHeight;
        String[] stringArray = lines = this.wrapText(text, newRect.width, wrapStyle, g);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            g.drawString(line, this.getXHorizontalAlignment(hAlignment, x, this.getStringWidth(line, g)), y);
            y += textHeight;
            ++n2;
        }
        g.setFont(oldFont);
    }

    private int getNextWrapIndex(String text, int fromIndex, WrapStyle wrapStyle) {
        if (wrapStyle == WrapStyle.CHARACTER) {
            return fromIndex;
        }
        if (wrapStyle == WrapStyle.WORD) {
            int nextIndex = text.indexOf(32, fromIndex);
            return nextIndex > -1 ? nextIndex + 1 : text.length();
        }
        return text.length();
    }

    private String getFittingLine(String text, int maxWidth, WrapStyle wrapStyle, Graphics g) {
        int nextWrapIndex;
        String line = null;
        int fromIndex = 0;
        int lastFittingIndex = -1;
        do {
            int width;
            if ((width = this.getStringWidth(text.substring(0, nextWrapIndex = this.getNextWrapIndex(text, fromIndex, wrapStyle)).trim(), g)) > maxWidth) {
                line = text.substring(0, lastFittingIndex >= 0 ? lastFittingIndex : nextWrapIndex);
                continue;
            }
            lastFittingIndex = nextWrapIndex;
        } while ((fromIndex = nextWrapIndex + 1) <= text.length() && line == null);
        if (line == null) {
            line = text;
        }
        return line;
    }

    private String[] wrapText(String text, int maxWidth, WrapStyle wrapStyle, Graphics g) {
        ArrayList<String> lines = new ArrayList<String>();
        String remaining = text;
        while (remaining.length() > 0) {
            String line = this.getFittingLine(remaining, maxWidth, wrapStyle, g);
            lines.add(line.trim());
            remaining = remaining.substring(line.length());
        }
        return lines.toArray(new String[0]);
    }

    public Font changeFont(float size, int style, Graphics g) {
        Font oldFont = g.getFont();
        Font newFont = oldFont.deriveFont(style, size);
        g.setFont(newFont);
        return oldFont;
    }

    public Font changeFont(float size, Graphics g) {
        return this.changeFont(size, g.getFont().getStyle(), g);
    }

    public Font changeFont(int style, Graphics g) {
        return this.changeFont(g.getFont().getSize(), style, g);
    }

    public Font changeFont(Font newFont, Graphics g) {
        Font oldFont = g.getFont();
        g.setFont(newFont);
        return oldFont;
    }

    public Color changeColor(Color newColor, Graphics g) {
        Color oldColor = g.getColor();
        g.setColor(newColor);
        return oldColor;
    }

    public Stroke changeStroke(Stroke newStroke, Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(newStroke);
        return oldStroke;
    }

    public boolean movePanel(int moveX, int moveY) {
        if (this.getViewport() != null) {
            Rectangle rect = this.getViewport().getViewRect();
            int maxW = (int)this.getViewport().getViewSize().getWidth();
            int maxH = (int)this.getViewport().getViewSize().getHeight();
            int w = this.getViewport().getWidth();
            int h = this.getViewport().getHeight();
            int x = (int)rect.getX() + this.transform(moveX);
            int y = (int)rect.getY() + this.transform(moveY);
            if (x < 0) {
                x = 0;
            }
            if (maxW - x < w) {
                x = maxW - w;
            }
            if (y < 0) {
                y = 0;
            }
            if (maxH - y < h) {
                y = maxH - h;
            }
            if (x != (int)rect.getX() || y != (int)rect.getY()) {
                Point p = new Point(x, y);
                this.getViewport().setViewPosition(p);
                return true;
            }
        }
        return false;
    }

    public void centerXY(int x, int y) {
        Point center = this.getCurrentCenter();
        if (center != null) {
            int midX = center.x;
            int midY = center.y;
            this.movePanel(x - midX, y - midY);
        }
    }

    public void centerPanel() {
        Point center = this.getCenterPos();
        this.centerXY(center.x, center.y);
    }

    protected Point getCenterPos() {
        return new Point(this.getFieldWidth() / 2, this.getFieldHeight() / 2);
    }

    public int getFieldHeight() {
        return this.gameConfig.getFieldHeight();
    }

    public int getFieldWidth() {
        return this.gameConfig.getFieldWidth();
    }

    public Dimension getFieldSize() {
        return new Dimension(this.getFieldWidth(), this.getFieldHeight());
    }

    public Point getCurrentCenter() {
        if (this.getViewport() != null) {
            Rectangle rect = this.getViewport().getViewRect();
            int midX = this.invertTransformX(rect.getX() + rect.getWidth() / 2.0);
            int midY = this.invertTransformY(rect.getY() + rect.getHeight() / 2.0);
            return new Point(midX, midY);
        }
        return null;
    }

    protected boolean isHumanPlayer() {
        return PlayerUtil.isHumanPlaying(this.getGameEngine());
    }

    protected Graphics createTransparentGraphics(float alpha, Graphics g) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("Alpha value must be between 0.0 and 1.0!");
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(AlphaComposite.getInstance(3, alpha));
        return g2;
    }

    public void setRepaintTimer(int milliSeconds) {
        if (this.repaintTimer != null) {
            this.repaintTimer.stop();
        }
        if (milliSeconds > 0) {
            this.repaintTimer = new Timer(milliSeconds, new RepaintActionListener());
            this.repaintTimer.start();
        }
    }

    private List<AnimationData> getList(Map<Part, List<AnimationData>> map, Part part) {
        List<AnimationData> list = map.get(part);
        if (list == null) {
            list = new ArrayList<AnimationData>();
            map.put(part, list);
        }
        return list;
    }

    protected int getAnimationSteps() {
        return 10;
    }

    protected int getAnimationDuration() {
        return 100;
    }

    public int getStringWidth(String string, Graphics g) {
        if (!HGBaseTools.hasContent(string)) {
            return 0;
        }
        return g.getFontMetrics().stringWidth(string);
    }

    public int getStringHeight(Graphics g) {
        return g.getFontMetrics().getHeight();
    }

    public void calcFieldMargins() {
        switch (this.gameConfig.getFieldHorizontalAlignment()) {
            case 0: {
                this.fieldLeftMargin = Math.max((this.getViewport().getWidth() - this.transform(this.gameConfig.getFieldWidth())) / 2, 0);
                break;
            }
            case -1: {
                this.fieldLeftMargin = Math.max(this.getViewport().getWidth() - this.transform(this.gameConfig.getFieldWidth()), 0);
                break;
            }
            default: {
                this.fieldLeftMargin = 0;
            }
        }
        switch (this.gameConfig.getFieldVerticalAlignment()) {
            case 0: {
                this.fieldTopMargin = Math.max((this.getViewport().getHeight() - this.transform(this.gameConfig.getFieldHeight())) / 2, 0);
                break;
            }
            case -1: {
                this.fieldTopMargin = Math.max(this.getViewport().getHeight() - this.transform(this.gameConfig.getFieldHeight()), 0);
                break;
            }
            default: {
                this.fieldTopMargin = 0;
            }
        }
    }

    private static final class AnimationData {
        public final int x;
        public final int y;
        public final int percentSize;
        public final double angle;
        public final int animationStep;

        public AnimationData(int x, int y, int percentSize, double angle) {
            this(x, y, percentSize, angle, 1);
        }

        public AnimationData(int x, int y, int percentSize, double angle, int animationStep) {
            this.x = x;
            this.y = y;
            this.percentSize = percentSize;
            this.angle = angle;
            this.animationStep = animationStep;
        }

        public boolean equals(Object o) {
            if (o instanceof AnimationData) {
                AnimationData animationData = (AnimationData)o;
                return this.x == animationData.x && this.y == animationData.y && this.percentSize == animationData.percentSize && this.angle == animationData.angle && this.animationStep == animationData.animationStep;
            }
            return false;
        }

        public int hashCode() {
            return new Point(this.x, this.y).hashCode() + 11 * this.percentSize + (int)(11011.0 * this.angle) + this.animationStep;
        }

        public String toString() {
            return "x=" + this.x + ", y=" + this.y + ", step=" + this.animationStep + ", percentSize=" + this.percentSize + ", angle=" + this.angle;
        }
    }

    private static final class DrawData {
        public final Part part;
        public final Rectangle rect;

        public DrawData(Part part, int x, int y, int width, int height) {
            this.part = part;
            this.rect = new Rectangle(x, y, width, height);
        }
    }

    private static enum EffectType {
        NORMAL,
        TOP,
        LEFT,
        RIGHT;

    }

    private class RepaintActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            GamePanel.this.repaint();
        }
    }

    public static enum WrapStyle {
        NONE,
        CHARACTER,
        WORD;

    }
}

