/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui;

import hgb.gui.HGBaseDialog;
import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBaseItem;
import hgb.gui.HGBasePanel;
import hgb.gui.ProgressPanel;
import hgb.gui.config.HGBaseConfigComboBox;
import hgb.gui.config.HGBaseConfigItem;
import hgb.gui.config.HGBaseConfigSlider;
import hgb.gui.config.HGBaseConfigStateDialog;
import hgb.gui.config.HGBaseConfigTextField;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseFileTools;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import hgb.lib.internal.SimpleHGBaseItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import tjger.game.GamePlayer;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;
import tjger.game.completed.PlayerManager;
import tjger.game.completed.PlayerType;
import tjger.game.internal.PlayerFactory;
import tjger.game.internal.PlayerKey;
import tjger.game.internal.PlayerProfiles;
import tjger.gui.completed.Card;
import tjger.gui.completed.Piece;
import tjger.gui.internal.ImageChooserDlg;
import tjger.lib.ArrayUtil;
import tjger.lib.ConstantValue;
import tjger.lib.ImageUtil;
import tjger.lib.PartUtil;
import tjger.net.NetworkClient;
import tjger.net.NetworkClientConnection;
import tjger.net.NetworkConnection;
import tjger.net.NetworkServerConnection;

public class NewGameDialog
extends HGBaseConfigStateDialog {
    protected static final String NETWORK_NONE = "network.none";
    protected static final String NETWORK_SERVER = "network.server";
    protected static final String NETWORK_CLIENT = "network.client";
    protected int cHeight = HGBaseGuiTools.getFieldHeight();
    protected HGBaseConfigSlider sliderNumPlayers;
    protected HGBaseConfigTextField[] tfNames;
    protected String[] namesCopy;
    protected boolean[] removeProfile;
    protected PlayerTypeComboBox[] cbTypes;
    protected int[] cbTypesLastSelected;
    protected PreviewImage[] pvImage;
    protected PreviewPieceColor[] pvPieceColor;
    protected HGBaseConfigComboBox<HGBaseItem> cbNetworkMode;
    protected HGBaseConfigTextField tfHostIp;
    protected JButton btConnect;
    protected JTextField tfShowIp;
    protected JPanel pnNetwork;
    protected NetworkServerConnection netServer;
    protected NetworkClientConnection netClient;
    protected ProgressPanel[] pnProgressPlayer;
    protected ProgressPanel pnProgressHostIp;
    protected boolean[] clientStarted;
    private boolean systemCommand = false;

    public NewGameDialog(HGBaseFrame mainFrame, String askToSave) {
        super(mainFrame, HGBaseText.getText("dlg.newgame", new String[0]), askToSave);
    }

    protected final boolean isNetworkClient() {
        return this.isNetworkClient(this.getNetworkMode());
    }

    protected final boolean isNetworkClient(String networkMode) {
        return NETWORK_CLIENT.equals(networkMode);
    }

    protected final boolean isNetworkServer() {
        return this.isNetworkServer(this.getNetworkMode());
    }

    protected final boolean isNetworkServer(String networkMode) {
        return NETWORK_SERVER.equals(networkMode);
    }

    @Override
    protected boolean canLeave() {
        if (this.btConnect != null) {
            this.btConnect.setEnabled(true);
        }
        this.setMessage(null, 1);
        int numPlayers = this.getNumberOfPlayers();
        boolean disableFirstName = false;
        if (this.isNetworkClient()) {
            numPlayers = 1;
            disableFirstName = this.netClient != null && this.netClient.isConnected();
        }
        int i = 0;
        while (this.tfNames != null && i < this.tfNames.length) {
            boolean enable = i < numPlayers;
            this.tfNames[i].setEnabled(enable && (i != 0 || !disableFirstName));
            this.cbTypes[i].setEnabled(enable);
            this.pvImage[i].setEnabled(enable);
            this.pvPieceColor[i].setEnabled(enable);
            ++i;
        }
        return this.validateNetworkClient() && this.validateNetworkServer() && this.validatePlayerProfiles(numPlayers) && this.validatePlayerNames(numPlayers) && this.validatePlayerTypes(numPlayers);
    }

    private boolean validateNetworkClient() {
        if (!this.isNetworkClient()) {
            return true;
        }
        if (this.tfHostIp != null && this.btConnect != null && !HGBaseTools.hasContent(this.tfHostIp.getText())) {
            this.btConnect.setEnabled(false);
            this.setErrorMessage(HGBaseText.getText("err.networknoip", new String[0]));
            return false;
        }
        if (this.netClient != null && !this.netClient.isConnected()) {
            this.setErrorMessage(HGBaseText.getText("err.networkconhost", new String[0]));
            return false;
        }
        return true;
    }

    private boolean validateNetworkServer() {
        if (!this.isNetworkServer() || this.netServer == null) {
            return true;
        }
        int numClients = this.getNumberNetworkTypes();
        if (this.netServer.getNumConnected() < numClients) {
            this.setErrorMessage(HGBaseText.getText("err.networkconclients", new String[0]));
            return false;
        }
        if (numClients == 0) {
            this.setErrorMessage(HGBaseText.getText("err.networknoclients", new String[0]));
            return false;
        }
        return true;
    }

    private boolean validatePlayerProfiles(int numPlayers) {
        if (this.tfNames == null) {
            return true;
        }
        int playerIndex = 0;
        while (playerIndex < this.tfNames.length && playerIndex < numPlayers) {
            if (this.tfNames[playerIndex].isEnabled() && this.profileAlreadyExists(playerIndex, false)) {
                this.setWarnMessage(HGBaseText.getText("err.profileexists", new String[0]));
                return false;
            }
            ++playerIndex;
        }
        return true;
    }

    private boolean validatePlayerNames(int numPlayers) {
        if (this.tfNames == null) {
            return true;
        }
        HashSet<String> nameSet = new HashSet<String>();
        int playerIndex = 0;
        while (playerIndex < this.tfNames.length && playerIndex < numPlayers) {
            if (!this.validatePlayerName(playerIndex, nameSet)) {
                return false;
            }
            ++playerIndex;
        }
        return true;
    }

    private boolean validatePlayerName(int playerIndex, Set<String> nameSet) {
        if (!this.tfNames[playerIndex].isEnabled()) {
            return true;
        }
        String name = this.tfNames[playerIndex].getText();
        if (!HGBaseTools.hasContent(name)) {
            this.setErrorMessage(HGBaseText.getText("err.neednames", new String[0]));
            if (this.btConnect != null) {
                this.btConnect.setEnabled(false);
            }
            return false;
        }
        for (String invalidChar : ConstantValue.getNetworkSpecialChars()) {
            if (!name.contains(invalidChar)) continue;
            this.setErrorMessage(HGBaseText.getText("err.namewrong", invalidChar));
            return false;
        }
        if (!nameSet.add(name)) {
            this.setErrorMessage(HGBaseText.getText("err.samenames", new String[0]));
            return false;
        }
        return true;
    }

    private boolean validatePlayerTypes(int numPlayers) {
        GameConfig config = GameConfig.getInstance();
        int numHuman = this.countHumanPlayers(numPlayers);
        if (config.isOneHumanPlayer() && numHuman > 1) {
            this.setErrorMessage(HGBaseText.getText("err.onehuman", new String[0]));
            return false;
        }
        if (!config.isNetworkPossible()) {
            int i = 0;
            while (i < numPlayers) {
                PlayerType pt = this.getSelectedPlayerType(i);
                if (pt != null && pt.isNetwork()) {
                    this.setErrorMessage(HGBaseText.getText("err.nonetwork", new String[0]));
                    return false;
                }
                ++i;
            }
        }
        if (numHuman == 0) {
            if (config.isWithoutHumanPlayer()) {
                this.setWarnMessage(HGBaseText.getText("err.nohuman", new String[0]));
            } else {
                this.setErrorMessage(HGBaseText.getText("err.nohuman", new String[0]));
                return false;
            }
        }
        return true;
    }

    private int countHumanPlayers(int numPlayers) {
        int numHuman = 0;
        int i = 0;
        while (i < numPlayers) {
            PlayerType pt = this.getSelectedPlayerType(i);
            if (pt != null && pt.isHuman()) {
                ++numHuman;
            }
            ++i;
        }
        return numHuman;
    }

    @Override
    protected void okPressed() {
        if (this.isNetworkServer() && this.netServer != null) {
            this.netServer.setNumInitialClients(this.netServer.getNumConnected());
        }
        this.refreshPlayersFromGui();
        GameManager manager = GameManager.getInstance();
        manager.resetNewGameInformation();
        manager.setNewGameInformation("gameinfo.numplayers", this.getNumberOfPlayers());
        this.stopNetwork(false);
        if (this.netClient != null && this.netClient.isConnected() && this.tfNames != null && this.tfNames.length > 0) {
            this.tfNames[0].setEnabled(true);
        }
        super.okPressed();
    }

    @Override
    protected void cancelPressed() {
        super.cancelPressed();
        this.stopNetwork(true);
    }

    private void refreshPlayersFromGui() {
        PlayerManager manager = PlayerManager.getInstance();
        GamePlayer[] player = manager.getPlayers();
        int i = 0;
        while (i < player.length) {
            String name = this.tfNames[i].getText();
            ImageIcon image = this.pvImage[i].getImage();
            String pieceColor = this.pvPieceColor[i].getValue();
            PlayerType pt = this.getSelectedPlayerType(i);
            if (player[i].getType().equals(pt)) {
                player[i].setName(name);
                player[i].setImage(image);
                player[i].setPieceColor(pieceColor);
            } else {
                GamePlayer newPlayer = PlayerFactory.getInstance().createPlayer(pt.getId(), name, image, pieceColor);
                manager.setPlayer(i, newPlayer);
            }
            ++i;
        }
    }

    protected PlayerType getSelectedPlayerType(int index) {
        Object oSel;
        if (this.cbTypes != null && index >= 0 && index < this.cbTypes.length && (oSel = this.cbTypes[index].getSelectedItem()) instanceof PlayerType) {
            return (PlayerType)oSel;
        }
        return null;
    }

    protected int getNumberOfPlayers() {
        if (this.sliderNumPlayers != null) {
            return this.sliderNumPlayers.intValue();
        }
        return GameConfig.getInstance().getMaxPlayers();
    }

    @Override
    protected void createComponents(HGBasePanel pnDialog) {
        JPanel pnNew = this.getDefaultPanel();
        pnDialog.add(pnNew);
    }

    protected JPanel getDefaultPanel() {
        JPanel pnNew = new JPanel(new BorderLayout());
        JPanel pnPlayer = this.getPlayerPanel();
        pnNew.add((Component)pnPlayer, "Center");
        if (GameConfig.getInstance().isNetworkPossible()) {
            pnNew.add((Component)this.getNetworkPanel(), "South");
        }
        return pnNew;
    }

    protected JPanel getNetworkPanel() {
        GameEngine engine = GameEngine.getInstance();
        this.netServer = engine.getNetworkServer();
        this.netClient = engine.getNetworkClient();
        this.pnNetwork = new JPanel(new FlowLayout(0));
        this.pnNetwork.setBorder(new TitledBorder(HGBaseText.getText("dlg.network", new String[0])));
        this.pnNetwork.setPreferredSize(new Dimension(580, this.cHeight + 45));
        HGBaseItem[] netItem = this.getNetworkModes();
        JComboBox<HGBaseItem> cbHelp = HGBaseGuiTools.createArrayComboBox(netItem, 220, this.cHeight);
        this.cbNetworkMode = new HGBaseConfigComboBox<HGBaseItem>("game.networkmode", cbHelp);
        this.cbNetworkMode.addActionListener(ev -> this.onNetworkModeChanged());
        this.cbNetworkMode.addActionListener(this);
        this.pnNetwork.add(this.cbNetworkMode);
        this.pnProgressHostIp = new ProgressPanel();
        this.pnProgressHostIp.setPreferredSize(new Dimension(210, this.cHeight));
        this.pnNetwork.add(this.pnProgressHostIp);
        this.tfHostIp = new HGBaseConfigTextField("game.networkhostip");
        this.tfHostIp.setPreferredSize(new Dimension(210, this.cHeight));
        this.tfHostIp.setOpaque(false);
        this.tfHostIp.addCaretListener(this);
        this.pnProgressHostIp.add(this.tfHostIp);
        this.btConnect = new JButton();
        this.btConnect.setPreferredSize(new Dimension(115, this.cHeight));
        this.btConnect.addActionListener(new ConnectClientAction());
        this.pnNetwork.add(this.btConnect);
        this.setConnectButtonText();
        this.tfShowIp = new JTextField();
        this.tfShowIp.setPreferredSize(new Dimension(210, this.cHeight));
        this.tfShowIp.setEditable(false);
        this.pnNetwork.add(this.tfShowIp);
        this.showNetworkFieldsByMode();
        return this.pnNetwork;
    }

    private void setConnectButtonText() {
        if (this.btConnect != null && this.netClient != null) {
            if (this.netClient.getState() == 0) {
                this.btConnect.setText(HGBaseText.getText("dlg.connect", new String[0]));
            } else {
                this.btConnect.setText(HGBaseText.getText("dlg.stop", new String[0]));
            }
        }
    }

    protected void onNetworkModeChanged() {
        this.showNetworkFieldsByMode();
        int i = 0;
        while (this.cbTypes != null && i < this.cbTypes.length) {
            PlayerType tp;
            this.cbTypes[i].updateUI();
            if (!this.isNetworkServer() && (tp = this.getSelectedPlayerType(i)) != null && tp.isNetwork()) {
                this.selectPreviousPlayerType(this.cbTypes[i]);
            }
            ++i;
        }
    }

    private void showNetworkFieldsByMode() {
        if (this.cbNetworkMode == null) {
            return;
        }
        String mode = this.getNetworkMode();
        if (this.pnProgressHostIp != null) {
            this.pnProgressHostIp.setVisible(false);
        }
        if (this.tfHostIp != null) {
            this.tfHostIp.setVisible(false);
        }
        if (this.btConnect != null) {
            this.btConnect.setVisible(false);
        }
        if (this.tfShowIp != null) {
            this.tfShowIp.setVisible(false);
        }
        this.stopNetwork(true);
        if (this.isNetworkServer(mode) && this.tfShowIp != null) {
            if (this.netServer.startServer() == 0) {
                this.tfShowIp.setText(this.netServer.getIp());
                this.tfShowIp.setVisible(true);
                this.setOnePlayerToNetwork();
                ConnectServerThread t = new ConnectServerThread();
                t.start();
            } else {
                this.cbNetworkMode.setSelectedIndex(0);
            }
        } else if (this.isNetworkClient(mode) && this.tfHostIp != null && this.btConnect != null) {
            this.pnProgressHostIp.setVisible(true);
            this.tfHostIp.setVisible(true);
            this.btConnect.setVisible(true);
            this.setConnectButtonText();
            this.tfHostIp.grabFocus();
        }
        this.pnNetwork.updateUI();
    }

    private void setOnePlayerToNetwork() {
        PlayerType[] netTypes;
        int numPlayer = this.getNumberOfPlayers();
        if (numPlayer >= 2 && this.cbTypes != null && this.cbTypes.length >= 2 && (netTypes = PlayerFactory.getInstance().getNetworkPlayerTypes()) != null && netTypes.length > 0) {
            PlayerType t1 = this.getSelectedPlayerType(0);
            int index = t1 != null && !t1.isHuman() ? 0 : 1;
            this.cbTypes[index].setSelectedItem(netTypes[0]);
            this.cbTypesLastSelected[index] = this.cbTypes[index].getSelectedIndex();
        }
    }

    protected void stopNetwork(boolean stopEngine) {
        if (stopEngine) {
            GameEngine.getInstance().stopNetwork();
        }
        if (this.pnProgressHostIp != null) {
            this.pnProgressHostIp.setState(0);
        }
        if (this.tfHostIp != null) {
            this.tfHostIp.setEnabled(true);
        }
        int i = 0;
        while (this.clientStarted != null && i < this.clientStarted.length) {
            if (this.clientStarted[i]) {
                this.clientStarted[i] = false;
                if (this.tfNames != null) {
                    this.tfNames[i].setText(this.namesCopy[i]);
                }
            }
            ++i;
        }
        int numPlayers = this.getNumberOfPlayers();
        int i2 = 0;
        while (this.pnProgressPlayer != null && this.tfNames != null && i2 < this.tfNames.length) {
            this.pnProgressPlayer[i2].setState(0);
            if (i2 < numPlayers) {
                this.tfNames[i2].setEnabled(true);
            }
            ++i2;
        }
        this.checkState();
    }

    private String getNetworkMode() {
        if (this.cbNetworkMode == null || !this.isDisplaying()) {
            return NETWORK_NONE;
        }
        return this.cbNetworkMode.getValue();
    }

    private HGBaseItem[] getNetworkModes() {
        String[] id = new String[]{NETWORK_NONE, NETWORK_SERVER, NETWORK_CLIENT};
        HGBaseItem[] items = new HGBaseItem[id.length];
        int i = 0;
        while (i < id.length) {
            items[i] = new SimpleHGBaseItem(id[i]);
            ++i;
        }
        return items;
    }

    protected JPanel getPlayerPanel() {
        this.systemCommand = true;
        GameConfig config = GameConfig.getInstance();
        JPanel pnPlayer = new JPanel(new BorderLayout());
        this.createNumberPlayersPanel(config, pnPlayer);
        PlayerManager manager = PlayerManager.getInstance();
        this.createPlayerNamesTypesPanel(manager, pnPlayer);
        this.systemCommand = false;
        return pnPlayer;
    }

    protected void createPlayerNamesTypesPanel(PlayerManager manager, JPanel pnPlayer) {
        GamePlayer[] player = manager.getPlayers();
        JPanel pnNames = new JPanel(new GridLayout(0, this.getNumColumnsForPlayerList()));
        JPanel[] pnSingle = new JPanel[player.length];
        this.tfNames = new HGBaseConfigTextField[player.length];
        this.pnProgressPlayer = new ProgressPanel[player.length];
        this.clientStarted = new boolean[player.length];
        this.namesCopy = new String[player.length];
        this.removeProfile = new boolean[player.length];
        this.cbTypes = new PlayerTypeComboBox[player.length];
        this.cbTypesLastSelected = new int[player.length];
        this.pvImage = new PreviewImage[player.length];
        this.pvPieceColor = new PreviewPieceColor[player.length];
        PlayerType[] supportTypes = PlayerFactory.getInstance().getSupportedPlayerTypes();
        int imgHeight = this.getMaxImageHeight(supportTypes);
        if (imgHeight + 8 > this.cHeight) {
            this.cHeight += 8;
        }
        JComboBox<PlayerType> cbSupportedTypes = HGBaseGuiTools.createArrayComboBox(supportTypes, 175, this.cHeight);
        int playerIndex = 0;
        while (playerIndex < player.length) {
            pnSingle[playerIndex] = this.createPlayerTypePanel(player[playerIndex], playerIndex, cbSupportedTypes);
            pnNames.add(pnSingle[playerIndex]);
            ++playerIndex;
        }
        pnPlayer.add((Component)pnNames, "South");
        pnPlayer.setBorder(new TitledBorder(HGBaseText.getText("dlg.players", new String[0])));
    }

    private JPanel createPlayerTypePanel(GamePlayer player, final int playerIndex, JComboBox<PlayerType> cbSupportedTypes) {
        this.tfNames[playerIndex] = new HGBaseConfigTextField("player.name" + playerIndex);
        this.pvImage[playerIndex] = new PreviewImage("player.image" + playerIndex, player.getImage());
        this.pvPieceColor[playerIndex] = new PreviewPieceColor("player.piececolor" + playerIndex, player.getPieceColor());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(0, 10, 0, 10));
        panel.add((Component)this.pvImage[playerIndex], "West");
        panel.add((Component)this.pvPieceColor[playerIndex], "East");
        JPanel pnFields = new JPanel(new GridLayout(2, 1));
        String playerName = player.getName();
        if (player.isNetwork()) {
            playerName = PlayerManager.getInstance().getStandardPlayerName(playerIndex);
        }
        this.tfNames[playerIndex].setValue(playerName);
        this.tfNames[playerIndex].setOpaque(false);
        this.namesCopy[playerIndex] = this.tfNames[playerIndex].getText();
        this.tfNames[playerIndex].setPreferredSize(new Dimension(175, this.cHeight));
        this.pnProgressPlayer[playerIndex] = new ProgressPanel();
        this.pnProgressPlayer[playerIndex].setPreferredSize(new Dimension(175, this.cHeight));
        this.pnProgressPlayer[playerIndex].add(this.tfNames[playerIndex]);
        pnFields.add(this.pnProgressPlayer[playerIndex]);
        this.cbTypes[playerIndex] = this.createPlayerTypeComboBox(playerIndex, player.getType().getId(), cbSupportedTypes);
        this.cbTypesLastSelected[playerIndex] = this.cbTypes[playerIndex].getSelectedIndex();
        if (cbSupportedTypes.getItemCount() > 1) {
            pnFields.add(this.cbTypes[playerIndex]);
        }
        JPanel pnDummy = new JPanel(new BorderLayout());
        pnDummy.add((Component)new JLabel(), "Center");
        pnDummy.add((Component)pnFields, "North");
        panel.add((Component)pnDummy, "Center");
        panel.add((Component)new JPanel(), "South");
        this.tfNames[playerIndex].addCaretListener(this);
        this.tfNames[playerIndex].setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent comp) {
                if (NewGameDialog.this.systemCommand) {
                    return true;
                }
                if (NewGameDialog.this.isPlayerNameTypeChangeAllowed(playerIndex, false)) {
                    NewGameDialog.this.namesCopy[playerIndex] = NewGameDialog.this.tfNames[playerIndex].getText();
                    NewGameDialog.this.checkState();
                    return true;
                }
                NewGameDialog.this.tfNames[playerIndex].setText(NewGameDialog.this.namesCopy[playerIndex]);
                return true;
            }
        });
        this.cbTypes[playerIndex].addActionListener(this);
        return panel;
    }

    private PlayerTypeComboBox createPlayerTypeComboBox(int playerIndex, String playerTypeId, JComboBox<PlayerType> cbSupportedTypes) {
        PlayerTypeComboBox combobox = new PlayerTypeComboBox("player.type" + playerIndex, cbSupportedTypes);
        combobox.addActionListener(ev -> this.onPlayerTypeSelectionChanged(playerIndex));
        combobox.setRenderer(new PlayerTypeRenderer());
        combobox.setValue(playerTypeId);
        return combobox;
    }

    private void onPlayerTypeSelectionChanged(int playerIndex) {
        if (this.systemCommand || this.isSameTypeAsLastSelected(playerIndex)) {
            return;
        }
        PlayerTypeComboBox cbType = this.cbTypes[playerIndex];
        if (!this.isPlayerNameTypeChangeAllowed(playerIndex, true)) {
            cbType.setSelectedIndex(this.cbTypesLastSelected[playerIndex]);
            return;
        }
        if (this.isNetworkServer()) {
            if (this.netServer == null || this.clientStarted == null) {
                return;
            }
            this.stopNetworkClient(playerIndex);
            if (this.isNetworkTypeSelected(cbType)) {
                this.restartNetworkClient(playerIndex);
            }
        } else if (this.isNetworkTypeSelected(cbType)) {
            this.selectPreviousPlayerType(cbType);
        }
        this.cbTypesLastSelected[playerIndex] = cbType.getSelectedIndex();
    }

    private void stopNetworkClient(int playerIndex) {
        if (!this.clientStarted[playerIndex]) {
            return;
        }
        int clientIndex = this.getClientIndex(playerIndex);
        this.netServer.removeBestFitClient(clientIndex);
        this.refreshClientNames();
        this.clientStarted[playerIndex] = false;
        if (this.tfNames != null) {
            this.tfNames[playerIndex].setText(this.namesCopy[playerIndex]);
        }
        this.checkState();
    }

    private boolean isSameTypeAsLastSelected(int playerIndex) {
        return this.cbTypes[playerIndex].getSelectedIndex() == this.cbTypesLastSelected[playerIndex];
    }

    protected int getNumColumnsForPlayerList() {
        return 2;
    }

    protected void createNumberPlayersPanel(GameConfig config, JPanel pnPlayer) {
        int max;
        int min = config.getMinPlayers();
        if (min < (max = config.getMaxPlayers())) {
            JPanel pnNumber = new JPanel(new FlowLayout(2));
            pnNumber.setBorder(new EmptyBorder(0, 5, 0, 5));
            pnNumber.add(new JLabel(HGBaseText.getText("gameinfo.numplayers", new String[0])));
            JSlider sliderTemp = HGBaseGuiTools.createRangeSlider(min, max, 1, 70, (int)((double)this.cHeight * 1.5));
            this.sliderNumPlayers = new HGBaseConfigSlider("player.number", sliderTemp);
            this.sliderNumPlayers.addActionListener(this);
            this.sliderNumPlayers.setValue(config.getDefaultPlayers());
            pnNumber.add(this.sliderNumPlayers);
            pnPlayer.add((Component)pnNumber, "North");
            JPanel pnDummy = new JPanel();
            pnPlayer.add((Component)pnDummy, "Center");
        }
    }

    protected int getClientIndex(int index) {
        int numClient = 0;
        int numPlayers = this.getNumberOfPlayers();
        int i = 0;
        while (i < numPlayers && i < index) {
            if (this.isNetworkTypeSelected(this.cbTypes[i])) {
                ++numClient;
            }
            ++i;
        }
        return numClient;
    }

    private boolean isPlayerNameTypeChangeAllowed(int index, boolean typeChange) {
        if (this.profileAlreadyExists(index, typeChange)) {
            this.removeProfile[index] = false;
            String pName = this.tfNames[index].getValue();
            String pType = this.cbTypes[index].getValue();
            PlayerKey key = new PlayerKey(pName, pType);
            PlayerProfiles profiles = PlayerProfiles.getInstance();
            String title = HGBaseText.getText("dlg.profileexists", new String[0]);
            String profile = pName + " (" + HGBaseText.getText(pType, new String[0]) + ")";
            String message = HGBaseText.getText("dlg.askprofileoverwrite", profile);
            Object[] options = new String[]{HGBaseText.getText("dlg.overwrite", new String[0]), HGBaseText.getText("dlg.use", new String[0]), HGBaseText.getText("dlg.cancel", new String[0])};
            int ret = HGBaseDialog.showOptionDialog(this.getMainFrame(), (Object)message, title, 1, 2, null, options, 2);
            if (ret == 0) {
                this.removeProfile[index] = true;
            } else if (ret == 1) {
                int selColor;
                GamePlayer player = profiles.getPlayer(key);
                if (this.pvImage[index] != null) {
                    this.pvImage[index].changeImage(-1, player.getImage());
                }
                if (this.pvPieceColor[index] != null && (selColor = HGBaseTools.toInt(player.getPieceColor().replaceFirst(GameConfig.getInstance().getPlayerPieceColor(), ""))) != -2147483631) {
                    this.pvPieceColor[index].changeImage(selColor, null);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private int getNumberNetworkTypes() {
        int num = 0;
        int i = 0;
        while (this.cbTypes != null && i < this.cbTypes.length) {
            if (this.isNetworkTypeSelected(this.cbTypes[i])) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    private boolean isNetworkTypeSelected(JComboBox<PlayerType> cbType) {
        Object item = cbType.getSelectedItem();
        if (item instanceof PlayerType) {
            PlayerType pt = (PlayerType)item;
            return pt.isNetwork();
        }
        return false;
    }

    private boolean profileAlreadyExists(int index, boolean typeChange) {
        if (typeChange || !this.namesCopy[index].equals(this.tfNames[index].getText())) {
            String pName = this.tfNames[index].getValue();
            String pType = this.cbTypes[index].getValue();
            PlayerKey key = new PlayerKey(pName, pType);
            PlayerProfiles profiles = PlayerProfiles.getInstance();
            return profiles.existsPlayer(key);
        }
        return false;
    }

    public GamePlayer[] getProfilesToRemove() {
        PlayerProfiles profiles = PlayerProfiles.getInstance();
        PlayerManager manager = PlayerManager.getInstance();
        GamePlayer[] player = manager.getPlayers();
        ArrayList<GamePlayer> list = new ArrayList<GamePlayer>();
        int i = 0;
        while (this.removeProfile != null && i < this.removeProfile.length) {
            if (this.removeProfile[i] && profiles.existsPlayer(player[i])) {
                list.add(player[i]);
            }
            ++i;
        }
        return ArrayUtil.toGamePlayer(list);
    }

    private int getMaxImageHeight(PlayerType[] playerTypes) {
        int max = 0;
        int i = 0;
        while (i < playerTypes.length) {
            ImageIcon img = playerTypes[i].getImage();
            if (img != null && img.getIconHeight() > max) {
                max = img.getIconHeight();
            }
            ++i;
        }
        return max;
    }

    private void selectPreviousPlayerType(JComboBox<PlayerType> cbType) {
        this.systemCommand = true;
        int newIndex = cbType.getSelectedIndex() - 1;
        if (newIndex < 0) {
            newIndex = cbType.getItemCount() - 1;
        }
        cbType.setSelectedIndex(newIndex);
        if (this.isNetworkTypeSelected(cbType)) {
            this.selectPreviousPlayerType(cbType);
        }
        this.systemCommand = false;
    }

    private void restartNetworkClient(int index) {
        this.clientStarted[index] = true;
        this.checkState();
        this.netServer.addClient();
    }

    private void refreshClientNames() {
        int numClient = 0;
        int numPlayers = this.getNumberOfPlayers();
        int i = 0;
        while (i < numPlayers) {
            if (this.isNetworkTypeSelected(this.cbTypes[i])) {
                NetworkClient client = this.netServer.getClient(numClient);
                if (client != null && client.getState() == 1) {
                    this.tfNames[i].setText(client.getClientName());
                }
                ++numClient;
            }
            ++i;
        }
    }

    private abstract class AbstractPreviewConfiguration
    extends JLabel
    implements HGBaseConfigItem {
        private static final long serialVersionUID = -3513871818923403856L;
        private String option;
        private String value;
        private ImageIcon image;

        public AbstractPreviewConfiguration(String option, String value, ImageIcon img) {
            super(img);
            this.option = option;
            this.setValue(value);
            this.setImage(img);
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent ev) {
                    AbstractPreviewConfiguration.this.onMouseClicked(ev);
                }
            });
        }

        private void onMouseClicked(MouseEvent ev) {
            List<ImageIcon> imageList;
            if (((Component)ev.getSource()).isEnabled() && ev.getButton() == 1 && (imageList = this.getImageList()) != null && !imageList.isEmpty()) {
                ImageIcon newImg;
                ImageIcon[] images = imageList.toArray(new ImageIcon[imageList.size()]);
                ImageChooserDlg dlg = new ImageChooserDlg(NewGameDialog.this.getMainFrame(), images);
                if (dlg.show() && !ImageUtil.isEqualImage(newImg = dlg.getSelectedImage(), this.getImage())) {
                    this.changeImage(dlg.getSelectedIndex(), newImg);
                }
            }
        }

        protected abstract void changeImage(int var1, ImageIcon var2);

        protected abstract List<ImageIcon> getImageList();

        public ImageIcon getImage() {
            return this.image;
        }

        public void setImage(ImageIcon newImage) {
            this.image = newImage;
            ImageUtil.setImageOnLabel(this, this.image, 40, 40);
        }

        @Override
        public String getOption() {
            return this.option;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public void saveOption() {
            HGBaseConfig.set(this.getOption(), this.getValue());
        }
    }

    private class ConnectClientAction
    implements ActionListener {
        private ConnectClientAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (NewGameDialog.this.netClient != null && NewGameDialog.this.tfHostIp != null && NewGameDialog.this.tfNames != null && NewGameDialog.this.tfNames.length > 0) {
                if (NewGameDialog.this.netClient.getState() == 0) {
                    this.startNetworkConnection();
                } else {
                    NewGameDialog.this.stopNetwork(true);
                }
            }
            NewGameDialog.this.setConnectButtonText();
        }

        private void startNetworkConnection() {
            NewGameDialog.this.netClient.startClient(NewGameDialog.this.tfHostIp.getText(), NewGameDialog.this.tfNames[0].getText());
            Thread t = new Thread(){

                @Override
                public void run() {
                    if (((ConnectClientAction)ConnectClientAction.this).NewGameDialog.this.pnProgressHostIp != null) {
                        ((ConnectClientAction)ConnectClientAction.this).NewGameDialog.this.tfHostIp.setEnabled(false);
                        ((ConnectClientAction)ConnectClientAction.this).NewGameDialog.this.tfNames[0].setEnabled(false);
                        while (NewGameDialog.this.isNetworkClient() && ((ConnectClientAction)ConnectClientAction.this).NewGameDialog.this.netClient.getState() == 2) {
                            ((ConnectClientAction)ConnectClientAction.this).NewGameDialog.this.pnProgressHostIp.setState(1);
                            NetworkConnection.netWait();
                        }
                        NewGameDialog.this.setConnectButtonText();
                        NewGameDialog.this.checkState();
                        while (NewGameDialog.this.isNetworkClient() && ((ConnectClientAction)ConnectClientAction.this).NewGameDialog.this.netClient.getState() == 1) {
                            ((ConnectClientAction)ConnectClientAction.this).NewGameDialog.this.pnProgressHostIp.setState(2);
                            NetworkConnection.netWait();
                        }
                        ((ConnectClientAction)ConnectClientAction.this).NewGameDialog.this.pnProgressHostIp.setState(0);
                        ((ConnectClientAction)ConnectClientAction.this).NewGameDialog.this.tfHostIp.setEnabled(true);
                        ((ConnectClientAction)ConnectClientAction.this).NewGameDialog.this.tfNames[0].setEnabled(true);
                        NewGameDialog.this.setConnectButtonText();
                        NewGameDialog.this.checkState();
                    }
                }
            };
            t.start();
        }
    }

    private class ConnectServerThread
    extends Thread {
        private ConnectServerThread() {
        }

        @Override
        public void run() {
            while (NewGameDialog.this.netServer != null && NewGameDialog.this.isNetworkServer() && NewGameDialog.this.tfNames != null && NewGameDialog.this.cbTypes != null && NewGameDialog.this.pnProgressPlayer != null) {
                int numClient = 0;
                int numPlayers = NewGameDialog.this.getNumberOfPlayers();
                int playerIndex = 0;
                while (playerIndex < numPlayers) {
                    if (NewGameDialog.this.isNetworkTypeSelected(NewGameDialog.this.cbTypes[playerIndex])) {
                        this.handleNetworkPlayer(playerIndex, numClient);
                        ++numClient;
                    } else {
                        this.handleLocalPlayer(playerIndex);
                    }
                    ++playerIndex;
                }
                NetworkConnection.netWait();
            }
        }

        private void handleNetworkPlayer(int playerIndex, int numClient) {
            NewGameDialog.this.tfNames[playerIndex].setEnabled(false);
            NetworkClient client = NewGameDialog.this.netServer.getClient(numClient);
            if (client != null) {
                if (client.getState() == 1) {
                    if (NewGameDialog.this.pnProgressPlayer[playerIndex].getState() != 2) {
                        NewGameDialog.this.pnProgressPlayer[playerIndex].setState(2);
                        NewGameDialog.this.tfNames[playerIndex].setText(client.getClientName());
                        NewGameDialog.this.checkState();
                    }
                } else {
                    NewGameDialog.this.pnProgressPlayer[playerIndex].setState(1);
                }
            } else {
                NewGameDialog.this.pnProgressPlayer[playerIndex].setState(0);
                NewGameDialog.this.refreshClientNames();
                NewGameDialog.this.restartNetworkClient(playerIndex);
            }
        }

        private void handleLocalPlayer(int playerIndex) {
            NewGameDialog.this.pnProgressPlayer[playerIndex].setState(0);
            NewGameDialog.this.tfNames[playerIndex].setEnabled(true);
        }
    }

    private static class PlayerTypeComboBox
    extends HGBaseConfigComboBox<PlayerType> {
        public PlayerTypeComboBox(String option, JComboBox<PlayerType> box) {
            super(option, box);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            ListCellRenderer lcr = this.getRenderer();
            if (lcr instanceof PlayerTypeRenderer) {
                ((PlayerTypeRenderer)lcr).setEnabled(enabled);
            }
        }
    }

    private class PlayerTypeRenderer
    implements ListCellRenderer<PlayerType> {
        boolean enabled = true;

        private PlayerTypeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends PlayerType> list, PlayerType value, int index, boolean isSelected, boolean cellHasFocus) {
            PlayerType tp;
            JLabel lbEntry = new JLabel();
            if (!NewGameDialog.this.isNetworkServer() && (tp = value).isNetwork()) {
                return lbEntry;
            }
            lbEntry.setText(value.toString());
            lbEntry.setPreferredSize(new Dimension(150, NewGameDialog.this.cHeight));
            lbEntry.setBackground(HGBaseGuiTools.getFieldBackgroundColor());
            lbEntry.setOpaque(true);
            if (isSelected) {
                lbEntry.setBackground(HGBaseGuiTools.getSelectColor());
                lbEntry.setForeground(HGBaseGuiTools.getSelectTextColor());
            }
            int h = HGBaseGuiTools.getFieldHeight();
            ImageUtil.setImageOnLabel(lbEntry, value.getImage(), h, h);
            lbEntry.setEnabled(this.enabled);
            return lbEntry;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    private class PreviewImage
    extends AbstractPreviewConfiguration {
        private static final long serialVersionUID = 1560274326047668709L;

        public PreviewImage(String option, ImageIcon img) {
            super(option, "", img);
        }

        @Override
        public String getValue() {
            if (this.getImage() == null) {
                return super.getValue();
            }
            return HGBaseFileTools.getFileName(this.getImage().getDescription(), false);
        }

        @Override
        protected void changeImage(int selectedIndex, ImageIcon selectedImage) {
            int other = -1;
            int i = 0;
            while (i < NewGameDialog.this.pvImage.length && other == -1) {
                if (!this.equals(NewGameDialog.this.pvImage[i]) && ImageUtil.isEqualImage(selectedImage, NewGameDialog.this.pvImage[i].getImage())) {
                    other = i;
                }
                ++i;
            }
            if (other >= 0) {
                NewGameDialog.this.pvImage[other].setImage(this.getImage());
            }
            this.setImage(selectedImage);
        }

        @Override
        protected List<ImageIcon> getImageList() {
            boolean found = true;
            int index = 0;
            ArrayList<ImageIcon> imageList = new ArrayList<ImageIcon>();
            String imagePath = GameConfig.getInstance().getElementPath("player");
            String imageExtension = GameConfig.getInstance().getElementExtension("player");
            String imageName = GameConfig.getInstance().getPlayerImageName();
            while (found) {
                String img = imagePath + "/" + imageName + index + "." + imageExtension;
                ImageIcon newImg = HGBaseGuiTools.loadImage(img);
                if (newImg != null) {
                    imageList.add(newImg);
                } else {
                    found = false;
                }
                ++index;
            }
            return imageList;
        }
    }

    private class PreviewPieceColor
    extends AbstractPreviewConfiguration {
        private static final long serialVersionUID = -6458997019358218679L;

        public PreviewPieceColor(String option, String value) {
            super(option, value, null);
            this.setValue(value);
        }

        @Override
        public void setValue(String value) {
            super.setValue(value);
            this.setImage(this.getImage(value));
        }

        private ImageIcon getImage(String color) {
            Piece[] pieces = PartUtil.getPiecesWithColor(color);
            if (pieces.length > 0) {
                return pieces[0].getImage();
            }
            Card[] cards = PartUtil.getCardsWithColor(color);
            if (cards.length > 0) {
                return cards[0].getImage();
            }
            return null;
        }

        @Override
        protected void changeImage(int selectedIndex, ImageIcon selectedImage) {
            String newPieceColor = GameConfig.getInstance().getPlayerPieceColor() + selectedIndex;
            int other = -1;
            int i = 0;
            while (i < NewGameDialog.this.pvImage.length && other == -1) {
                if (!this.equals(NewGameDialog.this.pvPieceColor[i]) && newPieceColor.equals(NewGameDialog.this.pvPieceColor[i].getValue())) {
                    other = i;
                }
                ++i;
            }
            if (other >= 0) {
                NewGameDialog.this.pvPieceColor[other].setValue(this.getValue());
            }
            this.setValue(newPieceColor);
        }

        @Override
        protected List<ImageIcon> getImageList() {
            boolean found = true;
            int index = 0;
            ArrayList<ImageIcon> imageList = new ArrayList<ImageIcon>();
            String pieceColor = GameConfig.getInstance().getPlayerPieceColor();
            while (found) {
                ImageIcon newImg = this.getImage(pieceColor + index);
                if (newImg != null) {
                    imageList.add(newImg);
                } else {
                    found = false;
                }
                ++index;
            }
            return imageList;
        }
    }
}

