/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed;

import hgb.lib.HGBaseTools;
import java.awt.Color;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import tjger.game.completed.GameConfig;
import tjger.gui.completed.Background;
import tjger.gui.completed.Board;
import tjger.gui.completed.CardSet;
import tjger.gui.completed.Cover;
import tjger.gui.completed.Part;
import tjger.gui.completed.PartSet;
import tjger.gui.completed.PieceSet;

public class Arrangement
extends Part {
    private final String cover;
    private final String background;
    private final String board;
    private final String pieceSet;
    private final Map<String, String> mapCardSets = new LinkedHashMap<String, String>();
    private final Map<String, String> mapParts = new LinkedHashMap<String, String>();
    private final Map<String, String> mapPartSets = new LinkedHashMap<String, String>();
    private final Map<String, Color> mapColors = new LinkedHashMap<String, Color>();

    public Arrangement(String name, String defaultBack, String defaultBoard, String defaultPieceSet, String defaultCover, String cardSet) {
        super("game.arrangement", name, null, false);
        this.background = defaultBack;
        this.board = defaultBoard;
        this.pieceSet = defaultPieceSet;
        this.cover = defaultCover;
        if (HGBaseTools.hasContent(cardSet)) {
            this.setCardSet("game.cardset", cardSet);
        }
    }

    @Override
    public boolean equals(Object o2) {
        return HGBaseTools.equalClass(this, o2) && o2 != null && this.toString().equals(o2.toString());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.background, this.board, this.pieceSet, this.mapCardSets, this.mapParts, this.mapPartSets, this.mapColors);
    }

    public Background getBackground() {
        return GameConfig.getInstance().getBackground(this.background);
    }

    public Board getBoard() {
        return GameConfig.getInstance().getBoard(this.board);
    }

    public PieceSet getPieceSet() {
        return GameConfig.getInstance().getPieceSet(this.pieceSet);
    }

    public Cover getCover() {
        return GameConfig.getInstance().getCover(this.cover);
    }

    public CardSet getCardSet() {
        return GameConfig.getInstance().getCardSet("game.cardset");
    }

    public CardSet getCardSet(String type) {
        return GameConfig.getInstance().getCardSet(type, this.mapCardSets.get(type));
    }

    public void setCardSet(String type, String name) {
        this.mapCardSets.put(type, name);
    }

    public void setPart(String type, String name) {
        this.mapParts.put(type, name);
    }

    public Part getPart(String type) {
        return GameConfig.getInstance().getPart(type, this.mapParts.get(type));
    }

    public void setPartSet(String type, String name) {
        this.mapPartSets.put(type, name);
    }

    public PartSet getPartSet(String type) {
        return GameConfig.getInstance().getPartSet(type, this.mapPartSets.get(type));
    }

    public void setColor(String colorType, Color color) {
        this.mapColors.put(colorType, color);
    }

    public Color getColor(String colorType) {
        return this.mapColors.get(colorType);
    }

    public Set<String> getTypes() {
        HashSet<String> types = new HashSet<String>();
        types.add("game.background");
        types.add("game.board");
        types.add("game.pieceset");
        types.add("game.cover");
        types.addAll(this.mapCardSets.keySet());
        types.addAll(this.mapParts.keySet());
        types.addAll(this.mapPartSets.keySet());
        types.addAll(this.mapColors.keySet());
        return types;
    }
}

