/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tjger.gui.completed.Card;
import tjger.gui.completed.ColorValuePart;
import tjger.gui.completed.PartSet;
import tjger.lib.ArrayUtil;

public class CardSet
extends PartSet {
    public CardSet(String cardSetType, String name, boolean hidden) {
        super(cardSetType, name, hidden);
    }

    public void addCard(Card newCard) {
        super.addPart(newCard);
    }

    public Card[] getCards() {
        return this.toOrderedCardArray(this.transform(super.getParts()));
    }

    public Card[] getCards(String color) {
        return this.toOrderedCardArray(this.transform(super.getParts(color)));
    }

    public Card[] getCards(String color, int sequenceStart, int sequenceEnd) {
        return this.toOrderedCardArray(this.transform(super.getParts(color, sequenceStart, sequenceEnd)));
    }

    private List<Card> transform(List<ColorValuePart> listCvp) {
        ArrayList<Card> listCard = new ArrayList<Card>();
        for (ColorValuePart cvp : listCvp) {
            if (!(cvp instanceof Card)) continue;
            listCard.add((Card)cvp);
        }
        return listCard;
    }

    public Card getCard(String color, int sequence) {
        ColorValuePart c = super.getPart(color, sequence);
        if (c instanceof Card) {
            return (Card)c;
        }
        return null;
    }

    private Card[] toOrderedCardArray(List<Card> list) {
        Object[] cards = ArrayUtil.toCard(list);
        Arrays.sort(cards);
        return cards;
    }
}

