/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed;

import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import javax.swing.ImageIcon;
import tjger.game.completed.GameManager;
import tjger.gui.PartSorter;
import tjger.gui.completed.GameElement;
import tjger.gui.completed.Part;
import tjger.gui.completed.PartSet;

public class ColorValuePart
extends Part {
    protected PartSet partSet;
    private final String color;
    private final int sequence;
    private final int value;

    public ColorValuePart(PartSet partSet, String partType, String color, int sequence, int value, ImageIcon image) {
        super(partType, partSet.getName() + "." + color + "." + sequence, image, false);
        this.partSet = partSet;
        this.color = color;
        this.sequence = sequence;
        this.value = value;
    }

    public PartSet getPartSet() {
        return this.partSet;
    }

    public String getColor() {
        return this.color;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return HGBaseText.getText(this.getPartSet().getName(), new String[0]) + " " + this.getIntraId();
    }

    protected String getIntraId() {
        return this.getColor() + "-" + this.getSequence();
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 != null && o2.getClass().equals(this.getClass())) {
            String intraId2 = ((ColorValuePart)o2).getIntraId();
            return this.getIntraId().equals(intraId2);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getIntraId().hashCode();
    }

    @Override
    public int compareTo(GameElement p2) {
        if (p2 instanceof ColorValuePart) {
            ColorValuePart c2 = (ColorValuePart)p2;
            PartSorter sorter = GameManager.getInstance().getPartSorter(this.getType());
            if (sorter != null) {
                return sorter.compareParts(this, c2);
            }
            int orderMode = GameManager.getInstance().getGameConfig().getOrderby(this.getPartSet().getType());
            if (orderMode == 0) {
                return 0;
            }
            if (orderMode == 2) {
                return this.compareByValue(c2);
            }
            if (orderMode == 1) {
                return this.compareByColor(c2);
            }
            return -1;
        }
        return super.compareTo(p2);
    }

    private int compareByValue(ColorValuePart c2) {
        int compare = this.getPartSet().getName().compareToIgnoreCase(c2.getPartSet().getName());
        if (compare != 0) {
            return compare;
        }
        Object[] colors = this.getPartSet().getColors();
        compare = Integer.compare(this.getValue(), c2.getValue());
        if (compare != 0) {
            return compare;
        }
        compare = Integer.compare(this.getSequence(), c2.getSequence());
        if (compare != 0) {
            return compare;
        }
        return HGBaseTools.getIndexOf(colors, this.getColor()) - HGBaseTools.getIndexOf(colors, c2.getColor());
    }

    private int compareByColor(ColorValuePart c2) {
        int compare = this.getPartSet().getName().compareToIgnoreCase(c2.getPartSet().getName());
        if (compare != 0) {
            return compare;
        }
        Object[] colors = this.getPartSet().getColors();
        compare = HGBaseTools.getIndexOf(colors, this.getColor()) - HGBaseTools.getIndexOf(colors, c2.getColor());
        if (compare != 0) {
            return compare;
        }
        compare = Integer.compare(this.getValue(), c2.getValue());
        if (compare != 0) {
            return compare;
        }
        return Integer.compare(this.getSequence(), c2.getSequence());
    }
}

