/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed;

import hgb.lib.HGBaseTools;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.ImageIcon;
import tjger.gui.completed.ColorValuePart;
import tjger.gui.completed.Part;

public class PartSet
extends Part {
    private final Map<String, List<ColorValuePart>> partMap = new LinkedHashMap<String, List<ColorValuePart>>();

    public PartSet(String partType, String name, boolean hidden) {
        super(partType, name, null, hidden);
    }

    @Override
    public boolean equals(Object o2) {
        return HGBaseTools.equalClass(this, o2) && o2 != null && this.toString().equals(o2.toString());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.partMap.hashCode());
    }

    public void addPart(ColorValuePart newPart) {
        List<ColorValuePart> partList = this.partMap.get(newPart.getColor());
        if (partList == null) {
            partList = new ArrayList<ColorValuePart>();
            this.partMap.put(newPart.getColor(), partList);
        }
        partList.add(newPart);
    }

    public String[] getColors() {
        return HGBaseTools.toStringArray(this.partMap.keySet());
    }

    public List<ColorValuePart> getParts() {
        ArrayList<ColorValuePart> listAll = new ArrayList<ColorValuePart>();
        for (List<ColorValuePart> listColor : this.partMap.values()) {
            for (ColorValuePart part : listColor) {
                listAll.add(part);
            }
        }
        return listAll;
    }

    public List<ColorValuePart> getParts(String color) {
        ArrayList list = this.partMap.get(color);
        return list == null ? new ArrayList() : list;
    }

    public ColorValuePart getPart(String color, int sequence) {
        List<ColorValuePart> list = this.partMap.get(color);
        if (list != null) {
            int listSize = list.size();
            int i = 0;
            while (i < listSize) {
                ColorValuePart c = list.get(i);
                if (c.getSequence() == sequence) {
                    return c;
                }
                ++i;
            }
        }
        return null;
    }

    public List<ColorValuePart> getParts(String color, int sequenceStart, int sequenceEnd) {
        ArrayList<ColorValuePart> sequenceList = new ArrayList<ColorValuePart>();
        List<ColorValuePart> list = this.partMap.get(color);
        if (list != null) {
            for (ColorValuePart part : list) {
                int sequence = part.getSequence();
                if (sequence < sequenceStart || sequence > sequenceEnd) continue;
                sequenceList.add(part);
            }
        }
        return sequenceList;
    }

    public int getStartSequence(String color) {
        List<ColorValuePart> list = this.partMap.get(color);
        if (list != null && !list.isEmpty()) {
            return list.get(0).getSequence();
        }
        return -1;
    }

    public int getEndSequence(String color) {
        List<ColorValuePart> list = this.partMap.get(color);
        if (list != null && !list.isEmpty()) {
            return list.get(list.size() - 1).getSequence();
        }
        return -1;
    }

    @Override
    public ImageIcon getImage() {
        int distance = 20;
        List<ImageIcon> images = this.getSetImages();
        Dimension imageSize = this.calculateSetImageSize(images, distance);
        return this.createSetImage(imageSize, images, distance);
    }

    private List<ImageIcon> getSetImages() {
        return Arrays.stream(this.getColors()).map(color -> this.getParts((String)color).stream().sorted().findFirst().map(Part::getImage).orElse(null)).toList();
    }

    private Dimension calculateSetImageSize(List<ImageIcon> images, int hGap) {
        int sumDistance = images.stream().filter(Objects::nonNull).mapToInt(img -> hGap).sum();
        int width = images.stream().filter(Objects::nonNull).reduce((first, last) -> last).map(ImageIcon::getIconWidth).orElse(0) + sumDistance;
        int height = images.stream().filter(Objects::nonNull).mapToInt(ImageIcon::getIconHeight).max().orElse(width);
        return new Dimension(width, height);
    }

    private ImageIcon createSetImage(Dimension size, List<ImageIcon> images, int hGap) {
        BufferedImage imgBuf = new BufferedImage(size.width, size.height, 2);
        Graphics2D g2 = imgBuf.createGraphics();
        int[] xpos = new int[1];
        images.stream().filter(Objects::nonNull).forEach(img -> {
            g2.drawImage(img.getImage(), xpos[0], 0, img.getImageObserver());
            nArray[0] = xpos[0] + hGap;
        });
        g2.dispose();
        return new ImageIcon(imgBuf);
    }
}

