/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed;

import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBasePanel;
import hgb.gui.util.SpringUtilities;
import hgb.lib.HGBaseText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.LineBorder;
import tjger.game.GamePlayer;
import tjger.game.GameState;
import tjger.game.GameStateListener;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;
import tjger.lib.PlayerUtil;

public class PlayerStatePanel
extends HGBasePanel
implements GameStateListener {
    private static final long serialVersionUID = 854371075L;
    private final int numDataRows;
    private final HashMap<Info, JComponent> headerRowComponents;
    private final HashMap<Info, JComponent[]> dataRowComponents;
    private final JComponent[] headerRowGapComponents;
    private final JComponent[][] dataRowGapComponents;
    private final int rowHeight;
    private Color headerBackground;
    private Color rowBackground1;
    private Color rowBackground2;
    private Color currentRowBackground;

    public PlayerStatePanel(int infos) throws IllegalArgumentException {
        this(PlayerStatePanel.getInfoArray(infos));
    }

    public PlayerStatePanel(Info ... infos) throws IllegalArgumentException {
        this(false, infos);
    }

    public PlayerStatePanel(boolean showHeaderRow, Info ... infos) throws IllegalArgumentException {
        this(null, showHeaderRow, infos);
    }

    public PlayerStatePanel(Info stretchInfo, boolean showHeaderRow, Info ... infos) throws IllegalArgumentException {
        if (infos == null) {
            throw new IllegalArgumentException("infos must not be null");
        }
        if (infos.length == 0) {
            throw new IllegalArgumentException("infos must not be empty");
        }
        GameManager manager = GameManager.getInstance();
        GameConfig config = manager.getGameConfig();
        this.rowHeight = config.getPlayerFieldHeight();
        this.numDataRows = config.getMaxPlayers();
        this.headerRowGapComponents = new JComponent[infos.length + 1];
        this.headerRowComponents = new HashMap();
        this.dataRowGapComponents = new JComponent[this.numDataRows][infos.length + 1];
        this.dataRowComponents = new HashMap();
        Info[] infoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            Info info = infoArray[n2];
            this.dataRowComponents.put(info, new JComponent[this.numDataRows]);
            ++n2;
        }
        stretchInfo = this.checkStretchInfo(stretchInfo, infos);
        this.determineBackgroundColors();
        JPanel statePanel = this.createStatePanel(showHeaderRow, this.numDataRows, infos, stretchInfo, this.rowHeight, this.headerRowGapComponents, this.headerRowComponents, this.dataRowGapComponents, this.dataRowComponents);
        this.setLayout(new BorderLayout());
        this.add((Component)statePanel, "Center");
        this.actualizeLaf();
        this.actualizeText();
        manager.getGameEngine().addGameStateListener(this);
    }

    protected Info checkStretchInfo(Info info, Info[] infos) {
        List<Info> infoList = Arrays.asList(infos);
        if (info != null || infoList.contains((Object)info)) {
            return info;
        }
        if (infoList.contains((Object)Info.PLAYER_NAME)) {
            return Info.PLAYER_NAME;
        }
        if (infoList.contains((Object)Info.PLAYER_NAME_TYPE)) {
            return Info.PLAYER_NAME_TYPE;
        }
        return infos[infos.length - 1];
    }

    private static void addInfo(int infoFlags, int infoFlag, Info info, ArrayList<Info> infoList) {
        if ((infoFlags & infoFlag) == infoFlag) {
            infoList.add(info);
        }
    }

    private static Info[] getInfoArray(int infos) {
        ArrayList<Info> infoList = new ArrayList<Info>();
        PlayerStatePanel.addInfo(infos, 1, Info.PLAYER_TYPE, infoList);
        PlayerStatePanel.addInfo(infos, 2, Info.PLAYER_ICON, infoList);
        PlayerStatePanel.addInfo(infos, 256, Info.PLAYER_PIECE, infoList);
        PlayerStatePanel.addInfo(infos, 4, Info.PLAYER_NAME, infoList);
        PlayerStatePanel.addInfo(infos, 512, Info.PLAYER_NAME_TYPE, infoList);
        PlayerStatePanel.addInfo(infos, 8, Info.SCORE_TURN, infoList);
        PlayerStatePanel.addInfo(infos, 16, Info.SCORE_ROUND, infoList);
        PlayerStatePanel.addInfo(infos, 32, Info.SCORE_GAME, infoList);
        PlayerStatePanel.addInfo(infos, 64, Info.NUM_GAMES, infoList);
        PlayerStatePanel.addInfo(infos, 128, Info.NUM_GAMES_WON, infoList);
        return infoList.toArray(new Info[0]);
    }

    protected JComponent createGapComponent(int height) {
        JLabel label = new JLabel();
        label.setOpaque(true);
        label.setPreferredSize(new Dimension(this.getGapWidth(), height));
        return label;
    }

    protected int getGapWidth() {
        return 5;
    }

    protected JPanel createStatePanel(boolean showHeaderRow, int numDataRows, Info[] infos, Info stretchInfo, int rowHeight, JComponent[] headerRowGapComponents, HashMap<Info, JComponent> headerRowComponents, JComponent[][] dataRowGapComponents, HashMap<Info, JComponent[]> dataRowComponents) {
        JPanel panel = new JPanel(new SpringLayout());
        if (showHeaderRow) {
            this.createHeaderRow(panel, infos, rowHeight, headerRowGapComponents, headerRowComponents);
        }
        int rowIndex = 0;
        while (rowIndex < numDataRows) {
            this.createDataRow(panel, rowIndex, infos, stretchInfo, rowHeight, dataRowGapComponents, dataRowComponents);
            ++rowIndex;
        }
        this.arrangeLayout(panel, showHeaderRow, numDataRows, infos.length, infos.length + 1);
        return panel;
    }

    protected void createHeaderRow(JPanel panel, Info[] infos, int rowHeight, JComponent[] gapComponents, HashMap<Info, JComponent> componentsMap) {
        int gapCompIndex = 0;
        gapComponents[gapCompIndex++] = this.createGapComponent(rowHeight);
        this.setHeaderComponentBorder(gapComponents[gapCompIndex - 1]);
        panel.add(gapComponents[gapCompIndex - 1]);
        Info[] infoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            Info info = infoArray[n2];
            JComponent comp = this.createComponent(info, this.getHorizontalAlignment(info));
            this.setHeaderComponentBorder(comp);
            panel.add(comp);
            componentsMap.put(info, comp);
            gapComponents[gapCompIndex++] = this.createGapComponent(rowHeight);
            this.setHeaderComponentBorder(gapComponents[gapCompIndex - 1]);
            panel.add(gapComponents[gapCompIndex - 1]);
            ++n2;
        }
        this.setHeaderRowBackgroundColor(gapComponents, componentsMap);
    }

    protected void setHeaderComponentBorder(JComponent comp) {
        comp.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK));
    }

    protected void setHeaderRowBackgroundColor(JComponent[] gapComponents, HashMap<Info, JComponent> componentsMap) {
        this.setComponentsBackground(gapComponents, this.headerBackground);
        this.setComponentsBackground(componentsMap.values().toArray(new JComponent[0]), this.headerBackground);
    }

    protected void createDataRow(JPanel panel, int rowIndex, Info[] infos, Info stretchInfo, int rowHeight, JComponent[][] gapComponents, HashMap<Info, JComponent[]> componentsMap) {
        int gapCompIndex = 0;
        gapComponents[rowIndex][gapCompIndex++] = this.createGapComponent(rowHeight);
        panel.add(gapComponents[rowIndex][gapCompIndex - 1]);
        Info[] infoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            Info info = infoArray[n2];
            JComponent comp = this.createComponent(info, this.getHorizontalAlignment(info));
            if (info.equals((Object)stretchInfo)) {
                comp.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            }
            panel.add(comp);
            componentsMap.get((Object)((Object)info))[rowIndex] = comp;
            gapComponents[rowIndex][gapCompIndex++] = this.createGapComponent(rowHeight);
            panel.add(gapComponents[rowIndex][gapCompIndex - 1]);
            ++n2;
        }
        this.setRowBackground(rowIndex, gapComponents, componentsMap);
    }

    protected JComponent createComponent(Info info, int horizontalAligment) {
        JLabel label = new JLabel();
        label.setHorizontalAlignment(horizontalAligment);
        label.setOpaque(true);
        Dimension preferredSize = this.getInfoPreferredSize(info, this.rowHeight);
        if (preferredSize != null) {
            label.setPreferredSize(preferredSize);
        }
        return label;
    }

    protected Dimension getInfoPreferredSize(Info info, int rowHeight) {
        switch (info) {
            case PLAYER_TYPE: 
            case PLAYER_ICON: 
            case PLAYER_PIECE: {
                return new Dimension(HGBaseGuiTools.getFieldHeight() + 10, rowHeight);
            }
            case SCORE_TURN: 
            case SCORE_ROUND: 
            case SCORE_GAME: {
                return new Dimension(50, rowHeight);
            }
            case NUM_GAMES: 
            case NUM_GAMES_WON: {
                return new Dimension(32, rowHeight);
            }
        }
        return null;
    }

    protected void arrangeLayout(JPanel panel, boolean showHeaderRow, int numDataRows, int numDataCols, int numGaps) {
        int rows = numDataRows + (showHeaderRow ? 1 : 0);
        int cols = numDataCols + numGaps;
        int initialX = 0;
        int initialY = 0;
        int xPad = 0;
        int yPad = 0;
        SpringUtilities.makeCompactGrid(panel, rows, cols, initialX, initialY, xPad, yPad);
    }

    protected int getHorizontalAlignment(Info info) {
        return info.getHorizontalAlignment();
    }

    protected void determineBackgroundColors() {
        this.headerBackground = this.getHeaderBackgroundColor();
        this.rowBackground1 = this.getRowBackgroundColor1();
        this.rowBackground2 = this.getRowBackgroundColor2();
        this.currentRowBackground = this.getCurrentRowBackgroundColor();
    }

    protected Color getHeaderBackgroundColor() {
        return this.getRowBackgroundColor2();
    }

    protected Color getRowBackgroundColor1() {
        return HGBaseGuiTools.getBackgroundColor();
    }

    protected Color getRowBackgroundColor2() {
        return HGBaseGuiTools.getBackgroundColorDarker();
    }

    protected Color getCurrentRowBackgroundColor() {
        return this.getRowBackgroundColor1().darker();
    }

    @Override
    public void actualizeLaf() {
        super.actualizeLaf();
        this.determineBackgroundColors();
        this.setBorder(new LineBorder(this.rowBackground1.darker(), 1, false));
        this.setHeaderRowBackgroundColor(this.headerRowGapComponents, this.headerRowComponents);
        this.actualize(GameManager.getInstance().getGameEngine(), this.dataRowGapComponents, this.dataRowComponents);
    }

    @Override
    public void actualizeText() {
        super.actualizeText();
        this.actualizeTextHeaderRow(this.headerRowComponents);
        this.actualizeTextDataRows(this.dataRowComponents);
    }

    protected void actualizeTextHeaderRow(HashMap<Info, JComponent> componentsMap) {
        Set<Info> infos = componentsMap.keySet();
        for (Info info : infos) {
            this.renderInfoHeader(info, componentsMap.get((Object)info));
        }
    }

    protected void actualizeTextDataRows(HashMap<Info, JComponent[]> componentsMap) {
        Set<Info> infos = componentsMap.keySet();
        for (Info info : infos) {
            JComponent[] comps;
            JComponent[] jComponentArray = comps = componentsMap.get((Object)info);
            int n = comps.length;
            int n2 = 0;
            while (n2 < n) {
                JComponent comp = jComponentArray[n2];
                this.renderInfoToolTip(info, comp);
                ++n2;
            }
        }
    }

    protected void actualize(GameEngine engine, JComponent[][] gapComponents, HashMap<Info, JComponent[]> componentsMap) {
        GamePlayer[] players = engine.getActivePlayers();
        int numActivePlayers = players == null ? 0 : players.length;
        int rowIndex = 0;
        while (rowIndex < this.numDataRows) {
            boolean isCurrent;
            if (rowIndex >= numActivePlayers) {
                this.resetInformation(rowIndex, componentsMap);
            } else {
                this.setPlayerInfo(rowIndex, players[rowIndex], engine, componentsMap);
            }
            boolean bl = isCurrent = rowIndex < numActivePlayers && engine.isActiveRound() && players[rowIndex].equals(engine.getCurrentPlayer());
            if (isCurrent) {
                this.setRowBackground(rowIndex, gapComponents, componentsMap, this.currentRowBackground);
            } else {
                this.setRowBackground(rowIndex, gapComponents, componentsMap);
            }
            ++rowIndex;
        }
    }

    protected void resetInformation(HashMap<Info, JComponent[]> componentsMap) {
        int rowIndex = 0;
        while (rowIndex < this.numDataRows) {
            this.resetInformation(rowIndex, componentsMap);
            ++rowIndex;
        }
    }

    protected void resetInformation(int rowIndex, HashMap<Info, JComponent[]> componentsMap) {
        Set<Info> infos = componentsMap.keySet();
        for (Info info : infos) {
            this.renderInfo(info, componentsMap.get((Object)info)[rowIndex], null);
        }
    }

    protected void setPlayerInfo(int rowIndex, GamePlayer player, GameEngine engine, HashMap<Info, JComponent[]> componentsMap) {
        Set<Info> infos = componentsMap.keySet();
        for (Info info : infos) {
            this.renderInfo(info, componentsMap.get((Object)info)[rowIndex], this.getInfoData(info, player, engine));
        }
    }

    protected Object getInfoData(Info info, GamePlayer player, GameEngine engine) {
        switch (info) {
            case PLAYER_TYPE: {
                return player.getType().getImage();
            }
            case PLAYER_ICON: {
                return player.getImage();
            }
            case PLAYER_PIECE: {
                return PlayerUtil.getPlayerPieceImage(player);
            }
            case PLAYER_NAME: {
                return player.getName();
            }
            case PLAYER_NAME_TYPE: {
                return PlayerUtil.getPlayerNameType(player);
            }
            case SCORE_TURN: {
                return String.valueOf(player.getScore(1));
            }
            case SCORE_ROUND: {
                return String.valueOf(player.getScore(2));
            }
            case SCORE_GAME: {
                return String.valueOf(player.getScore(4));
            }
            case NUM_GAMES: {
                return String.valueOf(player.getGamesPlayed());
            }
            case NUM_GAMES_WON: {
                return String.valueOf(player.getGamesWon());
            }
        }
        return null;
    }

    protected void resetBackgrounds(JComponent[][] gapComponents, HashMap<Info, JComponent[]> componentsMap) {
        int rowIndex = 0;
        while (rowIndex < this.numDataRows) {
            this.setRowBackground(rowIndex, gapComponents, componentsMap);
            ++rowIndex;
        }
    }

    protected void setRowBackground(int rowIndex, JComponent[][] gapComponents, HashMap<Info, JComponent[]> componentsMap) {
        this.setRowBackground(rowIndex, gapComponents, componentsMap, rowIndex % 2 == 0 ? this.rowBackground1 : this.rowBackground2);
    }

    protected void setRowBackground(int rowIndex, JComponent[][] gapComponents, HashMap<Info, JComponent[]> componentsMap, Color backgroundColor) {
        this.setComponentsBackground(gapComponents[rowIndex], backgroundColor);
        this.setComponentsBackground(this.getDataRowComponents(rowIndex, componentsMap), backgroundColor);
    }

    protected void setComponentsBackground(JComponent[] comps, Color backgroundColor) {
        if (comps == null || backgroundColor == null) {
            return;
        }
        JComponent[] jComponentArray = comps;
        int n = comps.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent comp = jComponentArray[n2];
            if (comp != null) {
                comp.setBackground(backgroundColor);
            }
            ++n2;
        }
    }

    protected JComponent[] getDataRowComponents(int rowIndex, HashMap<Info, JComponent[]> componentsMap) {
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        Set<Info> infos = componentsMap.keySet();
        for (Info info : infos) {
            components.add(componentsMap.get((Object)info)[rowIndex]);
        }
        return components.toArray(new JComponent[0]);
    }

    protected void renderInfoHeader(Info info, JComponent comp) {
        if (comp instanceof JLabel) {
            ((JLabel)comp).setText(info.getTitle());
        }
    }

    protected void renderInfoToolTip(Info info, JComponent comp) {
        if (comp instanceof JLabel) {
            ((JLabel)comp).setToolTipText(info.getToolTipText());
        }
    }

    protected void renderInfo(Info info, JComponent comp, Object data) {
        if (comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            if (info.isImageInfo()) {
                label.setIcon((Icon)data);
            } else {
                String text = data == null ? "" : (String)data;
                label.setText(text);
                if (Info.PLAYER_NAME.equals((Object)info) || Info.PLAYER_NAME_TYPE.equals((Object)info)) {
                    label.setToolTipText(text);
                }
            }
        }
    }

    @Override
    public void newGameStarted(GameState state, GameEngine engine) {
    }

    @Override
    public void newRoundStarted(GameState state, GameEngine engine) {
    }

    @Override
    public void newTurnStarted(GameState state, GameEngine engine) {
    }

    @Override
    public void gameFinished(boolean normal) {
        if (normal) {
            this.resetBackgrounds(this.dataRowGapComponents, this.dataRowComponents);
        } else {
            this.resetInformation(this.dataRowComponents);
        }
    }

    @Override
    public void gameStateBeforeMove(GameState state, GameEngine engine) {
        this.actualize(engine, this.dataRowGapComponents, this.dataRowComponents);
    }

    @Override
    public void gameStateAfterMove(GameState state, GameEngine engine) {
        this.actualize(engine, this.dataRowGapComponents, this.dataRowComponents);
    }

    public static enum Info {
        PLAYER_TYPE,
        PLAYER_ICON,
        PLAYER_PIECE,
        PLAYER_NAME,
        PLAYER_NAME_TYPE,
        SCORE_TURN,
        SCORE_ROUND,
        SCORE_GAME,
        NUM_GAMES,
        NUM_GAMES_WON;


        public String getTitle() {
            String msgKey;
            switch (this) {
                case PLAYER_TYPE: {
                    msgKey = "info_title_player_type";
                    break;
                }
                case PLAYER_ICON: {
                    msgKey = "info_title_player_icon";
                    break;
                }
                case PLAYER_PIECE: {
                    msgKey = "info_title_player_piece";
                    break;
                }
                case PLAYER_NAME: {
                    msgKey = "info_title_player_name";
                    break;
                }
                case PLAYER_NAME_TYPE: {
                    msgKey = "info_title_player_name_type";
                    break;
                }
                case SCORE_TURN: {
                    msgKey = "info_title_score_turn";
                    break;
                }
                case SCORE_ROUND: {
                    msgKey = "info_title_score_round";
                    break;
                }
                case SCORE_GAME: {
                    msgKey = "info_title_score_game";
                    break;
                }
                case NUM_GAMES: {
                    msgKey = "info_title_num_games";
                    break;
                }
                case NUM_GAMES_WON: {
                    msgKey = "info_title_num_games_won";
                    break;
                }
                default: {
                    msgKey = "unknown_player_state_info";
                }
            }
            return HGBaseText.getText(msgKey, new String[0]);
        }

        public int getHorizontalAlignment() {
            switch (this) {
                case PLAYER_TYPE: 
                case PLAYER_ICON: 
                case PLAYER_PIECE: {
                    return 0;
                }
                case PLAYER_NAME: 
                case PLAYER_NAME_TYPE: {
                    return 10;
                }
                case SCORE_TURN: 
                case SCORE_ROUND: 
                case SCORE_GAME: 
                case NUM_GAMES: 
                case NUM_GAMES_WON: {
                    return 11;
                }
            }
            return 10;
        }

        public String getToolTipText() {
            String msgKey;
            switch (this) {
                case PLAYER_TYPE: 
                case PLAYER_ICON: 
                case PLAYER_PIECE: 
                case PLAYER_NAME: 
                case PLAYER_NAME_TYPE: {
                    msgKey = null;
                    break;
                }
                case SCORE_TURN: {
                    msgKey = "tooltip.scoreturn";
                    break;
                }
                case SCORE_ROUND: {
                    msgKey = "tooltip.scoreround";
                    break;
                }
                case SCORE_GAME: {
                    msgKey = "tooltip.scoregame";
                    break;
                }
                case NUM_GAMES: {
                    msgKey = "tooltip.gamesplayed";
                    break;
                }
                case NUM_GAMES_WON: {
                    msgKey = "tooltip.gameswon";
                    break;
                }
                default: {
                    msgKey = "unknown_player_state_info";
                }
            }
            return msgKey != null ? HGBaseText.getText(msgKey, new String[0]) : null;
        }

        public boolean isImageInfo() {
            switch (this) {
                case PLAYER_TYPE: 
                case PLAYER_ICON: 
                case PLAYER_PIECE: {
                    return true;
                }
            }
            return false;
        }
    }
}

