/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import tjger.game.completed.GameConfig;
import tjger.gui.completed.Sound;
import tjger.gui.completed.SoundSet;

public class SoundArrangement
extends Sound {
    private final Map<String, String> mapSounds = new LinkedHashMap<String, String>();
    private final Map<String, String> mapSoundSets = new LinkedHashMap<String, String>();

    public SoundArrangement(String name) {
        super("game.soundarrangement", name, null, false);
    }

    public void setSound(String type, String name) {
        this.mapSounds.put(type, name);
    }

    public void setSoundSet(String type, String name) {
        this.mapSoundSets.put(type, name);
    }

    public Sound getSound(String type) {
        return GameConfig.getInstance().getSound(type, this.mapSounds.get(type));
    }

    public SoundSet getSoundSet(String type) {
        return GameConfig.getInstance().getSoundSet(type, this.mapSoundSets.get(type));
    }

    public Set<String> getTypes() {
        HashSet<String> types = new HashSet<String>();
        types.addAll(this.mapSounds.keySet());
        types.addAll(this.mapSoundSets.keySet());
        return types;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SoundArrangement that = (SoundArrangement)other;
        return Objects.equals(this.mapSounds, that.mapSounds) && Objects.equals(this.mapSoundSets, that.mapSoundSets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mapSounds, this.mapSoundSets);
    }
}

